/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.xmsg.MessageLog;

public class TResAttr
extends RepositoryAccessor {
    private static final String QUERY_BY_RES = "select resource_id, resource_type, attribute_id, attribute_type,  exclude from t_res_attribute where resource_id = ? and resource_type = ? and attribute_type = ?";
    private static final String QUERY_BY_ATTR = "select resource_id, resource_type, attribute_id, attribute_type, exclude from t_res_attribute where attribute_type = ? and attribute_id = ? and resource_type = ?";
    private static final String QUERY_BY_ATTRS_PREFIX = "select resource_id, resource_type, attribute_id, attribute_type, exclude from t_res_attribute where attribute_type = ? and attribute_id in(";
    private static final String QUERY_BY_ATTRS_SUFFIX = ")";
    private static final String QUERY_BY_ATTR_TYPE = "select resource_id, resource_type, attribute_id, attribute_type, exclude from t_res_attribute where attribute_type = ?";
    private static final String DELETE_BY_RES = "delete from t_res_attribute where resource_id = ? and resource_type = ?";
    private static final String DELETE_BY_RESOURCE_ONLY = "delete from t_res_attribute where resource_id = ?";
    private static final String DELETE_BY_ATTR = "delete from t_res_attribute where attribute_id = ? and resource_id = ? and exclude = ?";
    private static final String DELETE_BY_ATTR_RES = "delete from t_res_attribute where attribute_id = ? and resource_id = ?";
    private static final String DELETE_BY_ATTR_ID_TYPE = "delete from t_res_attribute where attribute_id = ? and attribute_type = ?";
    private static final String JOIN_1 = "select d.creator, d.name, r.resource_id from t_res_attribute r, ";
    private static final String INSERT = "insert into t_res_attribute (attribute_id, attribute_type, resource_id, resource_type, exclude) values (?,?,?,?,?)";
    private static final String UPDATE = "update t_res_attribute set attribute_id = ?, exclude = ? where attribute_type = ? and resource_id = ?";
    private static final String QUERY_BY_ATTR_ID = "select resource_id from t_res_attribute where attribute_id = ";
    private static final String DELETE_BY_ATTR_ID = "delete from t_res_attribute where attribute_id = ";
    private static final String SELECT_AFFECTED_HOSTS_WITH_AGENT = "select distinct h.host_name from t_res_attribute r, t_res_host h where r.attribute_id = ? and r.attribute_type = 140 and (resource_type = 1 and r.resource_id = h.computer_id)";
    private static final String SELECT_AFFECTED_SMIS_ALIAS = "select distinct m.host_element_name from t_res_attribute r, t_res_masking_info m where r.attribute_id = ? and r.attribute_type = 140 and (resource_type = 1 and r.resource_id = m.masking_info_id)";

    public TResAttr(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TResAttr", (String)"dbc");
        }
        this.tableName = "t_res_attribute";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TResAttr");
        }
    }

    public void prepQueryByRes(boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepQueryByRes", (String)"sort");
        }
        String string = QUERY_BY_RES;
        if (bl) {
            string = String.valueOf(string) + " ORDER BY attribute_id, exclude DESC";
        }
        this.selectStmt = this.prepareStmt(string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepQueryByRes");
        }
    }

    public void prepQueryByRes() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepQueryByRes", (String)"");
        }
        this.prepQueryByRes(false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepQueryByRes");
        }
    }

    public void setQueryByRes(ResourceAttribute resourceAttribute) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setQueryByRes", (String)"resAttr");
        }
        try {
            this.colIndex = 1;
            this.setInt(this.selectStmt, resourceAttribute.raResourceID);
            this.setShort(this.selectStmt, resourceAttribute.raResourceType);
            this.setShort(this.selectStmt, resourceAttribute.raAttributeType);
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"setQueryByRes", (Throwable)sQLException);
            }
            this.cleanup();
            Object[] objectArray = new Object[]{"execute"};
            String string = SQLUtil.getSQLExceptionMsg("STS0010E", sQLException, objectArray);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"setQueryByRes");
            }
            throw new GeneralException(string);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setQueryByRes");
        }
    }

    public void prepAttrTypeQuery(short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepAttrTypeQuery", (String)"attrType");
        }
        this.selectStmt = this.prepareStmt(QUERY_BY_ATTR_TYPE);
        try {
            this.colIndex = 1;
            this.stmtPhase = 0;
            this.setShort(this.selectStmt, s);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"prepAttrTypeQuery", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepAttrTypeQuery");
        }
    }

    public void prepQueryByAttr() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepQueryByAttr", (String)"");
        }
        this.selectStmt = this.prepareStmt(QUERY_BY_ATTR);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepQueryByAttr");
        }
    }

    public void setQueryByAttr(ResourceAttribute resourceAttribute) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setQueryByAttr", (String)"resAttr");
        }
        try {
            this.colIndex = 1;
            this.setShort(this.selectStmt, resourceAttribute.raAttributeType);
            this.setInt(this.selectStmt, resourceAttribute.raAttributeID);
            this.setShort(this.selectStmt, resourceAttribute.raResourceType);
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"setQueryByAttr", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setQueryByAttr");
        }
    }

    public void prepQueryByAttrs(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)this.getClass().getName(), (String)"prepQueryByAttrs", (String)"");
        }
        if (n <= 0) {
            throw new GeneralException("SRV0605E", null);
        }
        StringBuffer stringBuffer = new StringBuffer(QUERY_BY_ATTRS_PREFIX);
        stringBuffer.append("?");
        int n2 = 1;
        while (n2 < n) {
            stringBuffer.append(",?");
            ++n2;
        }
        stringBuffer.append(QUERY_BY_ATTRS_SUFFIX);
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)this.getClass().getName(), (String)"prepQueryByAttrs");
        }
    }

    public void setQueryByAttrs(LinkedInteger linkedInteger, short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)this.getClass().getName(), (String)"setQueryByAttrs", (String)"attributeIDs attributeType resourceType");
        }
        try {
            this.colIndex = 1;
            this.setShort(this.selectStmt, s);
            LinkedInteger linkedInteger2 = linkedInteger;
            while (linkedInteger2 != null) {
                this.setInt(this.selectStmt, linkedInteger2.value);
                linkedInteger2 = linkedInteger2.next;
            }
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)this.getClass().getName(), (String)"setQueryByAttrs", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)this.getClass().getName(), (String)"setQueryByAttrs");
        }
    }

    public boolean fetch(ResourceAttribute resourceAttribute) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetch", (String)"resAttr");
        }
        try {
            if (!this.nextResult()) {
                this.closeResultSet();
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"fetch", (boolean)bl);
                }
                return bl;
            }
            this.colIndex = 1;
            resourceAttribute.raResourceID = this.getInt(this.resultSet);
            resourceAttribute.raResourceType = this.getShort(this.resultSet);
            resourceAttribute.raAttributeID = this.getInt(this.resultSet);
            resourceAttribute.raAttributeType = this.getShort(this.resultSet);
            resourceAttribute.raExclude = this.getBoolean(this.resultSet);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetch", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.stmtPhase = 1;
            this.sqlError(sQLException);
        }
        boolean bl = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetch", (boolean)bl);
        }
        return bl;
    }

    public void prepDelete() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepDelete", (String)"");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_RES);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepDelete");
        }
    }

    public void delete(ResourceAttribute resourceAttribute) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"delete", (String)"resAttr");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, resourceAttribute.raResourceID);
            this.setInt(this.deleteStmt, resourceAttribute.raResourceType);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"delete", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"delete");
        }
    }

    public void deleteByID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByID", (String)"resourceID");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_RESOURCE_ONLY);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, n);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteByID", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByID");
        }
    }

    public void deleteByTypes(int n, int[] nArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByTypes", (String)"resourceID, attrs");
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(DELETE_BY_RESOURCE_ONLY);
        SQLUtil.appendInClause(stringBuffer, "attribute_type", nArray, true, true);
        this.deleteStmt = this.prepareStmt(stringBuffer.toString());
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, n);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteByTypes", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByTypes");
        }
    }

    public void deleteByAttribute(int n, short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)this.getClass().getName(), (String)"deleteByAttribute", (String)"attributeID, attributeType");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_ATTR_ID_TYPE);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, n);
            this.setShort(this.deleteStmt, s);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
            this.closeDelete();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)this.getClass().getName(), (String)"deleteByAttribute", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)this.getClass().getName(), (String)"deleteByAttribute");
        }
    }

    public void prepDeleteByResAttr() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepDeleteByResAttr", (String)"");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_ATTR);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepDeleteByResAttr");
        }
    }

    public void delete(int n, int n2, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"delete", (String)"attributeID, resourceID, exclude");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.deleteStmt, n);
            this.setInt(this.deleteStmt, n2);
            SQLUtil.setBoolean(this.deleteStmt, this.colIndex++, bl);
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"delete", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"delete");
        }
    }

    public void delete(int n, int n2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"delete", (String)"attributeID, resourceID");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_ATTR_RES);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.deleteStmt, n);
            this.setInt(this.deleteStmt, n2);
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"delete", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"delete");
        }
    }

    public void prepInsert(int n, short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepInsert", (String)"attributeID, attributeType");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.insertStmt, n);
            this.setShort(this.insertStmt, s);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"prepInsert", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepInsert");
        }
    }

    public void insert(int n, short s, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"resourceID, resourceType, exclude");
        }
        this.stmtPhase = 0;
        this.colIndex = 3;
        try {
            this.setInt(this.insertStmt, n);
            this.setShort(this.insertStmt, s);
            this.setBoolean(this.insertStmt, bl);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    public void prepUpdate() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepUpdate", (String)"");
        }
        this.updateStmt = this.prepareStmt(UPDATE);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepUpdate");
        }
    }

    public int update(int n, int n2, short s, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"update", (String)"resourceID, attributeID, attributeType, exclude");
        }
        int n3 = 0;
        try {
            this.setPhase();
            this.setInt(this.updateStmt, n2);
            this.setBoolean(this.updateStmt, bl);
            this.setShort(this.updateStmt, s);
            this.setInt(this.updateStmt, n);
            n3 = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"update", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        int n4 = n3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"update", (int)n4);
        }
        return n4;
    }

    private boolean nextDependent() throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"nextDependent", (String)"");
        }
        this.stmtPhase = 2;
        boolean bl = this.resultSet.next();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"nextDependent", (boolean)bl);
        }
        return bl;
    }

    public NameList queryDependents(String string, String string2, int n, short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"queryDependents", (String)"dependentTable, idColumnName, parentID, resourceType");
        }
        NameList nameList = null;
        NameList nameList2 = null;
        StringBuffer stringBuffer = new StringBuffer(240);
        stringBuffer.append(JOIN_1);
        stringBuffer.append(string);
        stringBuffer.append(" d WHERE r.attribute_id = ");
        stringBuffer.append(n);
        stringBuffer.append(" AND d.");
        stringBuffer.append(string2);
        stringBuffer.append(" = r.resource_id AND r.resource_type = ");
        stringBuffer.append(s);
        stringBuffer.append(" ORDER BY d.creator, d.name");
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        this.stmtPhase = 3;
        try {
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextDependent()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                stringBuffer.setLength(0);
                if (s == 99) {
                    this.getString(this.resultSet);
                } else {
                    stringBuffer.append(this.getString(this.resultSet));
                    stringBuffer.append('.');
                }
                stringBuffer.append(this.getString(this.resultSet));
                NameList nameList3 = new NameList();
                nameList3.nlName = stringBuffer.toString();
                nameList3.nlID = this.getInt(this.resultSet);
                nameList3.nlInfo = s;
                if (nameList2 == null) {
                    nameList = nameList3;
                } else {
                    nameList2.nlNext = nameList3;
                }
                nameList2 = nameList3;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"queryDependents", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        NameList nameList4 = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"queryDependents", nameList4);
        }
        return nameList4;
    }

    public NameList getResAttr(ResourceAttribute resourceAttribute) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getResAttr", (String)"row");
        }
        NameList nameList = null;
        this.setQueryByAttr(resourceAttribute);
        while (this.fetch(resourceAttribute)) {
            NameList nameList2 = new NameList();
            nameList2.nlID = resourceAttribute.raResourceID;
            if (resourceAttribute.raExclude) {
                nameList2.nlState = (byte)(nameList2.nlState | 1);
            }
            nameList2.nlInfo = resourceAttribute.raResourceType;
            nameList2.nlNext = nameList;
            nameList = nameList2;
        }
        NameList nameList3 = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getResAttr", nameList3);
        }
        return nameList3;
    }

    public int[] getResourceIDs(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getResourceIDs", (String)"attributeID");
        }
        LinkedInteger linkedInteger = null;
        int n2 = 0;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(QUERY_BY_ATTR_ID + n);
            while (this.nextResult()) {
                this.getPhase();
                LinkedInteger linkedInteger2 = new LinkedInteger();
                linkedInteger2.value = this.getInt(this.resultSet);
                linkedInteger2.next = linkedInteger;
                linkedInteger = linkedInteger2;
                ++n2;
            }
            this.closeStaticStmt();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getResourceIDs", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        int[] nArray = new int[n2];
        while (linkedInteger != null) {
            nArray[--n2] = linkedInteger.value;
            linkedInteger = linkedInteger.next;
        }
        int[] nArray2 = nArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getResourceIDs", (Object)nArray2);
        }
        return nArray2;
    }

    public void deleteResourceIDs(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteResourceIDs", (String)"attributeID");
        }
        try {
            this.staticStmt = this.createStatement();
            this.staticStmt.executeUpdate(DELETE_BY_ATTR_ID + n);
            this.closeStaticStmt();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteResourceIDs", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteResourceIDs");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAffectedResources(int n, int[] nArray, short s, short s2) throws GeneralException {
        try {
            TResAttr tResAttr = new TResAttr(this.dbc);
            tResAttr.prepInsert(n, s2);
            int n2 = 0;
            while (true) {
                block4: {
                    if (n2 < nArray.length) break block4;
                    this.commit();
                    break;
                }
                tResAttr.insert(nArray[n2], s, false);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeInsert();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.closeInsert();
    }

    public String getAffectedHosts(int n) throws GeneralException {
        Class<?> clazz;
        String string;
        boolean bl;
        String string2;
        boolean bl2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"getAffectedHosts", (String)"alertID");
        }
        String string3 = "";
        StringBuffer stringBuffer = new StringBuffer(100);
        String string4 = this.getAffectedHosts(n, true);
        String string5 = this.getAffectedHosts(n, false);
        boolean bl3 = bl2 = !"".equals(string4);
        if (bl2) {
            String string6 = "ALR0074W";
            string2 = MessageLog.getMessageNoTS((String)string6, (Object[])new Object[]{string4});
            string2 = string2.substring(string6.length() + 1);
            stringBuffer.append("\n" + string2);
        }
        boolean bl4 = bl = !"".equals(string5);
        if (bl) {
            string2 = "ALR0075W";
            string = MessageLog.getMessageNoTS((String)string2, (Object[])new Object[]{string5});
            string = string.substring(string2.length() + 1);
            stringBuffer.append("\n" + string);
        }
        if (bl2 || bl) {
            string3 = stringBuffer.toString();
            string2 = "ALR0073W";
            string = MessageLog.getMessageNoTS((String)string2, (Object[])new Object[]{string3});
            string3 = string = "\n" + string.substring(string2.length() + 1);
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)clazz.getName(), (String)"getAffectedHosts", (Object)string3);
        return string3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getAffectedHosts(int n, boolean bl) throws GeneralException {
        Class<?> clazz;
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"getAffectedHosts", (String)"alertID agent");
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        try {
            try {
                this.selectStmt = bl ? this.prepareStmt(SELECT_AFFECTED_HOSTS_WITH_AGENT) : this.prepareStmt(SELECT_AFFECTED_SMIS_ALIAS);
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, n);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                string = null;
                while (this.resultSet.next()) {
                    string = this.resultSet.getString(1);
                    stringBuffer.append(string);
                    stringBuffer.append(" ");
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz3.getName(), (String)"getAffectedHosts", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeSelect();
            this.closeResultSet();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        this.closeSelect();
        this.closeResultSet();
        string = null;
        if (!"".equals(stringBuffer)) {
            string = stringBuffer.toString();
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertDefinition");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)clazz.getName(), (String)"getAffectedHosts", (Object)string);
        return string;
    }
}

