/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.EntityWWPN;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.HasID;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.repository.EnclosureAccessor;
import org.eclipse.aperi.repository.MissingAlertAccessible;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.QueryBySchedule;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResEntityWWPN;
import org.eclipse.aperi.repository.table.TResVendorModel;
import org.eclipse.aperi.server.guireq.AlertNameList;
import org.eclipse.aperi.xmsg.MessageLog;

public class TResDiskArray
extends RepositoryAccessor
implements MissingAlertAccessible,
NameListQueryable,
EnclosureAccessor {
    public static final String ID_COLUMN_NAME = "subsystem_id";
    private static final String JOIN_1 = "select  case when user_provided_name is not null  and user_provided_name <> ''  then user_provided_name else display_name end display_name  from t_res_storage_subsystem  where subsystem_id = ?";
    private static final String BIG_JOIN_PT_I = "select distinct a.attribute_id, d.subsystem_id, a.exclude from t_res_storage_subsystem d, t_res_attribute a where a.attribute_type = ? and d.subsystem_id";
    private static final String BIG_JOIN_PT_II = " and (a.resource_id = d.subsystem_id or a.resource_id = d.group_id or a.resource_type = " + Short.toString((short)13) + ") order by 1, 2, 3 desc";
    private static final String SELECT_SS_DETAIL = " select a.subsystem_id, a.vendor_id, a.model_id, a.code_level, a.serial_number, a.cache, a.nvs,  v.disk_capacity, v.disk_freespace, v.lun_capacity, a.last_probe_time, a.probe_status, a.group_id,  a.probing_host_id, a.vg_capacity, a.vg_freespace, a.dg_freespace, a.lgldisk_assigned_capacity,  a.lun_capacity_zos, a.os_type, v.n_disks, v.n_luns, a.name,  case when a.user_provided_name is not null  and a.user_provided_name <> ''  then a.user_provided_name else a.display_name end display_name  from t_res_storage_subsystem a, t_view_ss_aggrinfo v  where a.last_probe_time is not null and a.subsystem_id = v.subsystem_id and a.subsystem_id = ?  UNION  select a.subsystem_id, a.vendor_id, a.model_id, '', a.serial_number, -1, -1,  -1, -1, -1, (CAST (NULL AS TIMESTAMP)), (CAST (NULL AS CHAR)), a.group_id, a.probing_host_id, -1, -1, -1, -1, -1, a.os_type, -1, -1, a.name,  case when a.user_provided_name is not null  and a.user_provided_name <> ''  then a.user_provided_name else a.display_name end display_name  from t_res_storage_subsystem a where a.last_probe_time is null and a.subsystem_id = ?";
    private static final String SELECT_SVC = "select a.disk_array_id from t_res_storage_subsystem a where a.os_type = " + Short.toString((short)21);
    private static final String SELECT_DISK_ARRAY_ID = "select subsystem_id from t_res_storage_subsystem";
    private static final String INSERT = "insert into t_res_storage_subsystem (subsystem_id, vendor_id, model_id, code_level, cache, nvs, backend_storage_capacity, available_capacity, n_disks, n_luns, allocated_capacity, last_probe_time, probe_status, vg_capacity, vg_freespace, dg_freespace, group_id, probing_host_id, lgldisk_assigned_capacity, lun_capacity_zos) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?)";
    private static final String UPDATE = "update t_res_storage_subsystem set vendor_id = ?, model_id = ?, code_level = ?, cache = ?, nvs = ?, backend_storage_capacity = ?, available_capacity = ?, n_disks = ?, n_luns = ?, allocated_capacity = ?, last_probe_time = ?, probe_status = ?, vg_capacity = ?, vg_freespace = ?, dg_freespace = ?, lgldisk_assigned_capacity = ?, lun_capacity_zos = ? where subsystem_id = ?";
    private static final String UPDATE_LICENSED_ARRAY = "update t_res_storage_subsystem set probing_host_id = ?  where subsystem_id = ?";
    private static final String RESET_PROBING_COMPUTER = "update t_res_storage_subsystem set probing_host_id = 0 where probing_host_id = ";
    private static final String SELECT_NAMELIST = "select subsystem_id,  case when user_provided_name is not null  and user_provided_name <> ''  then user_provided_name else display_name end display_name,  os_type from t_res_storage_subsystem";
    private static final String SELECT_BY_ATTRIBUTE = "select d.subsystem_id,  case when d.user_provided_name is not null  and d.user_provided_name <> ''  then d.user_provided_name else d.display_name end display_name,  a.exclude from t_res_storage_subsystem d, t_res_attribute a where a.attribute_id = ? and  d.subsystem_id = a.resource_id order by 2, 3 desc";
    private static final String SELECT_BY_SCHEDULE = "select distinct d.subsystem_id, d.probing_host_id, a.exclude, d.os_type from t_res_storage_subsystem d, t_res_attribute a where a.attribute_id = ? and  (d.subsystem_id = a.resource_id or d.group_id = a.resource_id or a.resource_type = " + Short.toString((short)54) + ") order by 1, 3 desc";
    private static final String SELECT_LUN = "select sv.subsystem_id, man.vendor_name, mod.model_name, ss.name, sv.display_name, sv.name  from t_res_storage_subsystem ss, t_res_storage_volume sv, t_res_model mod, t_res_vendor man where sv.svid = ? and sv.subsystem_id = ss.subsystem_id and ss.vendor_id = man.vendor_id and ss.model_id = mod.model_id";
    private static final String GET_NUM_SS_LUNS = " select count(*) from t_res_storage_volume sv where sv.subsystem_id = ?";
    private static final String GET_NUM_POOL_LUNS = " select count(*) from t_res_storage_volume sv where sv.pool_id = ?";
    private static final String GET_NUM_SS_DISKS = " select count(*) from t_res_physical_volume pv where pv.subsystem_id = ?";
    private static final String GET_NUM_SVC_MDISKS = " select count(*) from t_res_storage_extent se where se.subsystem_id = ?";
    private static final String GET_NUM_POOL_DISKS = "\tselect max(t1.num) from\t (  (select count(*) as num from t_res_physical_volume pv, t_res_physicalvolume2extent pvte, t_res_storage_extent se\t\twhere pv.physical_volume_id = pvte.physical_volume_id and pvte.storage_extent_id = se.storage_extent_id\t\t\t\t  and se.pool_id = ?\t\t\t\t  UNION  \t\tselect count(*) as num from t_stat_disk sd where sd.volgroup_id = ?) as t1)";
    private static final String GET_NUM_POOL_DISKS_OLD = " WITH counts (num) as  (  (select count(*) from t_res_physical_volume pv, t_res_physicalvolume2extent pvte, t_res_storage_extent se     where pv.physical_volume_id = pvte.physical_volume_id and pvte.storage_extent_id = se.storage_extent_id           and se.pool_id = ?) UNION   (select count(*) from t_stat_disk sd where sd.volgroup_id = ?)  ) select max(num) from counts";
    private static final String GET_NUM_DISK_GROUP_DISKS = " select count(*)  from t_res_physical_volume pv,       t_res_physicalvolume2extent phv2e,      t_res_disk_group dg,       t_res_storage_extent se  where pv.disk_group_id = dg.disk_group_id and pv.physical_volume_id = phv2e.physical_volume_id  and phv2e.storage_extent_id = se.storage_extent_id  and dg.disk_group_id = ?";
    private static final String GET_NUM_ASSIGNED_SVC_MDISKS = "select sum(number_of_backend_volumes)  from t_res_storage_pool where primordial = 0 and subsystem_id = ?";
    private QueryBySchedule queryBySchedule;
    private TResVendorModel vmAccessor = null;

    public TResDiskArray(Connection connection) {
        super(connection);
        this.tableName = "t_res_storage_subsystem";
        this.vmAccessor = new TResVendorModel(connection);
    }

    public boolean getComputerStats(Computer computer, MutableBoolean mutableBoolean) throws GeneralException {
        return false;
    }

    public NasFiler getDiskArrays(int n) throws GeneralException {
        Object object;
        NasFiler nasFiler = null;
        try {
            this.selectStmt = this.prepareStmt(SELECT_SS_DETAIL);
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.setInt(this.selectStmt, n);
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            this.stmtPhase = 3;
            this.sqlError(sQLException);
        }
        while (this.nextResult()) {
            object = new Computer();
            this.fetchDiskArray((Computer)object);
            object.cmpNasFiler.nfNext = nasFiler;
            nasFiler = object.cmpNasFiler;
            nasFiler.nfComputer = object;
        }
        this.closeSelect();
        if (nasFiler == null && n > 0) {
            object = ResourceTypeManager.getName((short)78);
            String string = Integer.toString(n);
            String string2 = MessageLog.getMessage((String)"STS0092E", (Object)object, (Object)string);
            throw new GeneralException(string2);
        }
        return nasFiler;
    }

    private void fetchDiskArray(Computer computer) throws GeneralException {
        this.getPhase();
        try {
            int n;
            if (computer.cmpID > 0) {
                this.getInt(this.resultSet);
            } else {
                computer.cmpID = this.getInt(this.resultSet);
            }
            computer.cmpManufacturer = this.vmAccessor.getVendorName(this.getShort(this.resultSet));
            computer.cmpModel = this.vmAccessor.getModelName(this.getShort(this.resultSet));
            computer.cmpOSVersion = this.getString(this.resultSet);
            computer.cmpSerialNumber = this.getString(this.resultSet);
            long l = this.getLong(this.resultSet);
            computer.cmpRAM = l >= 0L ? (int)(l /= 0x100000L) : -1;
            long l2 = this.getLong(this.resultSet);
            computer.cmpSwapSpace = l2 >= 0L ? (int)(l2 /= 0x100000L) : -1;
            computer.cmpDiskCapacity = this.getLong(this.resultSet);
            computer.cmpDiskFreeSpace = this.getLong(this.resultSet);
            computer.cmpLogicalDiskCapacity = this.getLong(this.resultSet);
            computer.cmpLastProbeTime = this.getTimestamp(this.resultSet);
            computer.cmpProbeStatus = this.getByte(this.resultSet);
            computer.cmpGroupID = this.getInt(this.resultSet);
            computer.cmpProbingCompID = this.getInt(this.resultSet);
            computer.cmpVolGroupCapacity = this.getLong(this.resultSet);
            computer.cmpVolGroupFreespace = this.getLong(this.resultSet);
            computer.cmpDiskGroupFreeCap = this.getLong(this.resultSet);
            computer.cmpLogicalDiskAssignedCapacity = this.getLong(this.resultSet);
            computer.cmpZOSLogicalDiskCapacity = this.getLong(this.resultSet);
            computer.cmpOSType = this.getShort(this.resultSet);
            computer.cmpNDisks = (int)this.getLong(this.resultSet);
            computer.cmpNLogicalDisks = (int)this.getLong(this.resultSet);
            if (computer.cmpNasFiler == null) {
                computer.cmpNasFiler = new NasFiler();
                computer.cmpNasFiler.nfName = this.getString(this.resultSet);
                computer.cmpNasFiler.nfAlias = this.getString(this.resultSet);
            }
            if ((n = this.getNumOfAssignedMDisks(computer.cmpID)) > -1) {
                computer.cmpSwapSpace = n;
            }
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
    }

    public EntityWWPN getSVCNodeWWPNs() throws GeneralException {
        EntityWWPN entityWWPN = null;
        NasFiler nasFiler = null;
        nasFiler = this.getSVCIDs();
        if (nasFiler == null) {
            return entityWWPN;
        }
        TResEntityWWPN tResEntityWWPN = new TResEntityWWPN(this.dbc);
        NasFiler nasFiler2 = nasFiler;
        while (nasFiler2 != null) {
            entityWWPN = tResEntityWWPN.getEntityWWPNs(nasFiler2.nfComputer.cmpID);
            nasFiler2 = nasFiler2.nfNext;
        }
        return entityWWPN;
    }

    private NasFiler getSVCIDs() throws GeneralException {
        String string = SELECT_SVC;
        this.setSQLText(string);
        NasFiler nasFiler = null;
        this.staticStmt = this.createStatement();
        try {
            this.resultSet = this.staticStmt.executeQuery(string);
        }
        catch (SQLException sQLException) {
            this.stmtPhase = 3;
            this.sqlError(sQLException);
        }
        while (this.nextResult()) {
            this.getPhase();
            Computer computer = new Computer();
            try {
                computer.cmpID = this.getInt(this.resultSet);
                if (computer.cmpNasFiler == null) {
                    computer.cmpNasFiler = new NasFiler();
                }
                computer.cmpNasFiler.nfNext = nasFiler;
                nasFiler = computer.cmpNasFiler;
                nasFiler.nfComputer = computer;
            }
            catch (SQLException sQLException) {
                this.sqlError(sQLException);
            }
        }
        this.closeStaticStmt();
        return nasFiler;
    }

    public void prepFetchByID() throws GeneralException {
        this.selectStmt = this.prepareStmt(JOIN_1);
    }

    public boolean fetchByID(Share share) throws GeneralException {
        boolean bl = false;
        this.setPhase();
        try {
            this.setInt(this.selectStmt, share.shResourceID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                bl = true;
                this.getPhase();
                share.shPath = this.getString(this.resultSet);
            }
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.commit();
        this.closeResultSet();
        return bl;
    }

    public void initQueryByAttrType(short s, HasID hasID) throws GeneralException {
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append(BIG_JOIN_PT_I);
        SQLUtil.appendInClause(stringBuffer, hasID);
        stringBuffer.append(BIG_JOIN_PT_II);
        String string = stringBuffer.toString();
        stringBuffer = null;
        this.selectStmt = this.prepareStmt(string);
        this.setPhase();
        try {
            this.setShort(this.selectStmt, s);
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.queryBySchedule = new QueryBySchedule(this, null);
    }

    public boolean fetchQueryBySchedule(NameList nameList) throws GeneralException {
        return this.queryBySchedule.fetch(nameList);
    }

    public Lun getLunByID(int n) throws GeneralException {
        Lun lun = null;
        this.selectStmt = this.prepareStmt(SELECT_LUN);
        this.execQueryByID(n);
        try {
            if (this.nextResult()) {
                this.getPhase();
                lun = new Lun();
                lun.lunID = n;
                lun.lunDaID = this.getInt(this.resultSet);
                lun.lunDaManufacturer = this.getString(this.resultSet);
                lun.lunDaModel = this.getString(this.resultSet);
                lun.lunDaSerialNumber = lun.lunDaAlias = this.getString(this.resultSet);
                String string = this.getString(this.resultSet);
                if (Util.isEmpty((String)string)) {
                    lun.lunName = this.getString(this.resultSet);
                } else {
                    lun.lunWWN = this.getString(this.resultSet);
                    lun.lunName = string;
                }
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        return lun;
    }

    public void initQueryBySchedule(int n) {
    }

    public void resetProbingComputer(int n) throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_LICENSED_ARRAY);
        this.setPhase();
        try {
            this.setInt(this.updateStmt, 0);
            this.setInt(this.updateStmt, n);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        this.closeUpdate();
        this.commit();
    }

    public void resetAllProbingComputers(int n) throws GeneralException {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(RESET_PROBING_COMPUTER);
        stringBuffer.append(n);
        String string = stringBuffer.toString();
        stringBuffer = null;
        this.setSQLText(string);
        this.staticStmt = this.createStatement();
        this.stmtPhase = 3;
        try {
            this.staticStmt.execute(string);
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        this.closeStaticStmt();
        this.commit();
    }

    public void insert(Computer computer) throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT);
        this.setPhase();
        try {
            this.setInt(this.insertStmt, computer.cmpID);
            this.setAttributes(this.insertStmt, computer);
            this.setInt(this.insertStmt, computer.cmpGroupID);
            this.setInt(this.insertStmt, computer.cmpProbingCompID);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException sQLException) {
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        this.closeInsert();
        this.commit();
    }

    public boolean update(Computer computer) throws GeneralException {
        int n = 0;
        this.updateStmt = this.prepareStmt(UPDATE);
        this.setPhase();
        try {
            this.setAttributes(this.updateStmt, computer);
            this.setInt(this.updateStmt, computer.cmpID);
            n = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        this.closeUpdate();
        this.commit();
        return n > 0;
    }

    private void setAttributes(PreparedStatement preparedStatement, Computer computer) throws SQLException, GeneralException {
        short s = this.vmAccessor.getVendorID(computer.cmpManufacturer);
        this.setShort(preparedStatement, s);
        short s2 = this.vmAccessor.getModelID(computer.cmpModel);
        this.setShort(preparedStatement, s2);
        this.setString(preparedStatement, computer.cmpOSVersion);
        this.setInt(preparedStatement, computer.cmpRAM);
        this.setInt(preparedStatement, computer.cmpSwapSpace);
        this.setLong(preparedStatement, computer.cmpDiskCapacity);
        this.setLong(preparedStatement, computer.cmpDiskFreeSpace);
        this.setInt(preparedStatement, computer.cmpNDisks);
        this.setInt(preparedStatement, computer.cmpNLogicalDisks);
        this.setLong(preparedStatement, computer.cmpLogicalDiskCapacity);
        this.setTimestamp(preparedStatement, computer.cmpLastProbeTime);
        this.setByte(preparedStatement, computer.cmpProbeStatus);
        this.setLong(preparedStatement, computer.cmpVolGroupCapacity);
        this.setLong(preparedStatement, computer.cmpVolGroupFreespace);
        this.setLong(preparedStatement, computer.cmpDiskGroupFreeCap);
        this.setLong(preparedStatement, computer.cmpLogicalDiskAssignedCapacity);
        this.setLong(preparedStatement, computer.cmpZOSLogicalDiskCapacity);
    }

    public NameList selectNames(GuiListReq guiListReq) throws GeneralException {
        AlertNameList alertNameList = null;
        AlertNameList alertNameList2 = null;
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(SELECT_NAMELIST);
        if (guiListReq.groupID > 0) {
            stringBuffer.append(" where group_id = ");
            stringBuffer.append(Integer.toString(guiListReq.groupID));
        }
        stringBuffer.append(" order by 1");
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        this.stmtPhase = 3;
        try {
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                this.getPhase();
                AlertNameList alertNameList3 = new AlertNameList();
                alertNameList3.nlInfo = (short)78;
                alertNameList3.nlID = this.getInt(this.resultSet);
                alertNameList3.nlName = this.getString(this.resultSet);
                alertNameList3.nlID2 = this.getShort(this.resultSet);
                alertNameList3.nlProductID = (short)3;
                alertNameList3.nlSubProductID = 1;
                if (alertNameList2 != null) {
                    alertNameList2.nlNext = alertNameList3;
                } else {
                    alertNameList = alertNameList3;
                }
                alertNameList2 = alertNameList3;
            }
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        return alertNameList;
    }

    public NameList queryDependents(int n) throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_BY_ATTRIBUTE);
        this.stmtType = 0;
        this.setPhase();
        try {
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        NameList nameList = null;
        NameList nameList2 = null;
        this.stmtPhase = 1;
        while (this.nextResult()) {
            NameList nameList3 = new NameList();
            nameList3.nlInfo = (short)78;
            this.colIndex = 1;
            try {
                nameList3.nlID = this.getInt(this.resultSet);
                nameList3.nlName = this.getString(this.resultSet);
                if (this.getBoolean(this.resultSet)) {
                    nameList3.nlState = 1;
                }
            }
            catch (SQLException sQLException) {
                this.sqlError(sQLException);
            }
            if (nameList2 == null) {
                nameList = nameList3;
            } else {
                nameList2.nlNext = nameList3;
            }
            nameList2 = nameList3;
        }
        this.closeSelect();
        return nameList;
    }

    public NameList computersTiedTo(int n) throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_BY_SCHEDULE);
        this.stmtType = 0;
        this.setPhase();
        try {
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        int n2 = -3;
        AlertNameList alertNameList = null;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        while (this.nextResult()) {
            this.getPhase();
            try {
                n3 = this.getInt(this.resultSet);
                n4 = this.getInt(this.resultSet);
                bl = this.getBoolean(this.resultSet);
                n5 = this.getInt(this.resultSet);
            }
            catch (SQLException sQLException) {
                this.sqlError(sQLException);
            }
            if (n3 == n2) continue;
            n2 = n3;
            if (bl) continue;
            AlertNameList alertNameList2 = new AlertNameList();
            alertNameList2.nlID = n3;
            alertNameList2.nlInfo = (short)n5;
            alertNameList2.nlID2 = n4;
            alertNameList2.nlProductID = (short)3;
            alertNameList2.nlSubProductID = 1;
            alertNameList2.nlNext = alertNameList;
            alertNameList = alertNameList2;
        }
        this.closeSelect();
        return alertNameList;
    }

    public NameList getStorageSystems() throws GeneralException {
        try {
            this.selectStmt = this.prepareStmt(SELECT_DISK_ARRAY_ID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        NameList nameList = null;
        NameList nameList2 = null;
        this.stmtPhase = 1;
        while (this.nextResult()) {
            NameList nameList3 = new NameList();
            nameList3.nlInfo = (short)78;
            this.colIndex = 1;
            try {
                nameList3.nlID = this.getInt(this.resultSet);
            }
            catch (SQLException sQLException) {
                this.sqlError(sQLException);
            }
            if (nameList2 == null) {
                nameList = nameList3;
            } else {
                nameList2.nlNext = nameList3;
            }
            nameList2 = nameList3;
        }
        this.closeSelect();
        return nameList;
    }

    public int getNumOfAssignedMDisks(int n) throws GeneralException {
        int n2 = -1;
        TResComputer tResComputer = new TResComputer(this.dbc);
        short s = tResComputer.getStorageSubsystemType(n);
        if (s == 21) {
            n2 = this.getNum(GET_NUM_ASSIGNED_SVC_MDISKS, n, false);
        }
        return n2;
    }

    public int getNumOfStorageSystemDisks(int n) throws GeneralException {
        int n2 = -1;
        TResComputer tResComputer = new TResComputer(this.dbc);
        short s = tResComputer.getStorageSubsystemType(n);
        n2 = s == 21 ? this.getNum(GET_NUM_SVC_MDISKS, n, false) : this.getNum(GET_NUM_SS_DISKS, n, false);
        return n2;
    }

    public int getNumOfStorageSystemLUNs(int n) throws GeneralException {
        return this.getNum(GET_NUM_SS_LUNS, n, false);
    }

    public int getNumOfStoragePoolDisks(int n) throws GeneralException {
        if (SQLUtil.isDerby()) {
            return this.getNum(GET_NUM_POOL_DISKS, n, true);
        }
        return this.getNum(GET_NUM_POOL_DISKS_OLD, n, true);
    }

    public int getNumOfStoragePoolVolumes(int n) throws GeneralException {
        return this.getNum(GET_NUM_POOL_LUNS, n, false);
    }

    public int getNumOfDiskGroupDisks(int n) throws GeneralException {
        return this.getNum(GET_NUM_DISK_GROUP_DISKS, n, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getNum(String string, int n, boolean bl) throws GeneralException {
        int n2 = -1;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                preparedStatement = this.dbc.prepareStatement(string);
                preparedStatement.setInt(1, n);
                if (bl) {
                    preparedStatement.setInt(2, n);
                }
                if ((resultSet = preparedStatement.executeQuery()).next()) {
                    n2 = resultSet.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (SQLException sQLException) {
            return n2;
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return n2;
        resultSet.close();
        return n2;
    }
}

