/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.RespManNas;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.xmsg.MessageLog;

public class TResShare
extends StorageRepositoryAccessor {
    private boolean excludeRemoved;
    public static final String TABLE_NAME = "t_res_share";
    public static final String COMPUTER_COLUMN = "computer_id";
    public static final String RESOURCE_COLUMN = "resource_id";
    private static final long MILLIS_PER_DAY = 86400000L;
    private Timestamp scanTS = new Timestamp(0L);
    private Timestamp removeTS = new Timestamp(0L);
    private Share updateList;
    private static final String SELECT = "select computer_id, resource_id, resource_type, scan_time, removed_time, path, name from t_res_share";
    private static final String REMOVED_RESOURCES = " where computer_id = ? and resource_type = ? and scan_time <> ?";
    private static final String OTHER_COMPUTERS = " where resource_id = ? and resource_type = ? and computer_id <> ? order by removed_time";
    private static final String UNIQUE = " where computer_id = ? and resource_id = ?";
    private static final String INSERT_SHARE = "insert into t_res_share (computer_id, resource_id, resource_type, scan_time, removed_time, path, name) values (?,?,?,?,?,?,?)";
    private static final String UPDATE_SHARE = "update t_res_share set scan_time = ?, removed_time = ?, path = ?, name = ? where computer_id = ? and resource_id = ?";
    private static final String DELETE_SHARE = "delete from t_res_share where computer_id = ? and resource_id = ?";
    private static final String DELETE_INCLUDING_TYPE = "delete from t_res_share where computer_id = ? and resource_id = ? and resource_type = ?";
    private static final String SELECT_SHARE_COUNT = "select count(*) from t_res_share where resource_id = ? and resource_type = ?";
    private static final String WHERE_NOT_REMOVED = " and removed_time <= ?";
    private static final String WHERE_REMOVED = " and removed_time > ?";
    private static final String SELECT_MAN_NAS = "select c.host_name, c.network_name, s.computer_id,  s.resource_id, c.os_type, d.name, ' '  from t_res_share s, t_res_host c, t_res_domain d  where s.resource_type = 103 and s.resource_id = c.computer_id  and s.computer_id = d.domain_id  union all select cc.host_name, cc.network_name, ss.computer_id,  ss.resource_id, cc.os_type, ' ', cc2.host_name  from t_res_share ss, t_res_host cc, t_res_host cc2  where ss.resource_type = 103 and ss.resource_id = cc.computer_id  and ss.computer_id = cc2.computer_id  union all select ccc.host_name, ccc.network_name, sss.computer_id,  sss.resource_id, ccc.os_type, lll.name, ' '  from t_res_share sss, t_res_host ccc, t_res_ldap_tree lll  where sss.resource_type = 103 and sss.resource_id = ccc.computer_id  and sss.computer_id = lll.tree_id ";
    private static final String SELECT_WINDOWS_MAN_NAS_COUNT = "select count(*)  from t_res_share s, t_res_host c, t_res_domain d  where s.resource_type = 103 and s.resource_id = c.computer_id  and s.computer_id = d.domain_id  and s.resource_id = ?";
    private static final String SELECT_WINDOWS_MAN_NET_COUNT = "select count(*)  from t_res_share s, t_res_host c, t_res_ldap_tree l  where s.resource_type = 103 and s.resource_id = c.computer_id  and s.computer_id = l.tree_id  and s.resource_id = ?";
    private static final String SELECT_TREE_AGENTS = "select s.resource_id, s.computer_id, s.resource_type, l.name from t_res_share s, t_res_ldap_tree l where s.resource_type = 66 and s.resource_id = l.tree_id union all select ss.resource_id, ss.computer_id, ss.resource_type,";
    private static final String SELECT_TREE_AGENTS2 = " ' '";
    private static final String SELECT_TREE_AGENTS3 = " from t_res_share ss, t_res_host cc where ss.resource_type = 68 and ss.computer_id = cc.computer_id order by 1";
    private static final String SELECT_SHARING_COMPUTERS = "select computer_id from t_res_share where resource_type = ? and resource_id = ?";
    private static final String SELECT_ARRAY_SHARES = "select resource_id, computer_id from t_res_share  where resource_type = 78 order by resource_id desc, computer_id desc";
    private static final String SELECT_VS_SHARES = "select resource_id from t_res_share  where resource_type = 99";
    private static final String SHARE_EXISTS = "select count(*) from t_res_share  where computer_id = ? and resource_id = ? and resource_type = ?";

    public TResShare(Connection connection) {
        super(connection);
        this.tableName = TABLE_NAME;
    }

    public void prepGetAnotherComputer() throws GeneralException {
        this.selectStmt = this.prepareStmt("select computer_id, resource_id, resource_type, scan_time, removed_time, path, name from t_res_share where resource_id = ? and resource_type = ? and computer_id <> ? order by removed_time");
    }

    public Share getAnotherComputer(int n, short s, int n2) throws GeneralException {
        Share share = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.setShort(this.selectStmt, s);
            this.setInt(this.selectStmt, n2);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.nextResult()) {
                share = new Share();
                this.getAttributes(share);
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        return share;
    }

    public void prepGetShareCount() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_SHARE_COUNT);
    }

    public int getShareCount(int n, short s) throws GeneralException {
        int n2 = 0;
        try {
            this.setPhase();
            this.setInt(this.selectStmt, n);
            this.setShort(this.selectStmt, s);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                this.getPhase();
                n2 = this.getInt(this.resultSet);
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        return n2;
    }

    public void prepGetWindowsManShareCount(boolean bl) throws GeneralException {
        this.selectStmt = bl ? this.prepareStmt(SELECT_WINDOWS_MAN_NAS_COUNT) : this.prepareStmt(SELECT_WINDOWS_MAN_NET_COUNT);
    }

    public int getWindowsManShareCount(int n) throws GeneralException {
        int n2 = 0;
        try {
            this.setPhase();
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                this.getPhase();
                n2 = this.getInt(this.resultSet);
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        return n2;
    }

    public boolean getShareExists(int n, int n2, short s) throws GeneralException {
        int n3 = 0;
        try {
            this.selectStmt = this.prepareStmt(SHARE_EXISTS);
            this.setPhase();
            this.setInt(this.selectStmt, n);
            this.setInt(this.selectStmt, n2);
            this.setShort(this.selectStmt, s);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                this.getPhase();
                n3 = this.getInt(this.resultSet);
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        return n3 > 0;
    }

    public Share getRemovedResources(int n, short s, long l) throws GeneralException {
        return this.getRemovedResources(n, s, l, null);
    }

    public Share getRemovedResources(int n, short s, long l, Share share) throws GeneralException {
        this.selectStmt = this.prepareStmt("select computer_id, resource_id, resource_type, scan_time, removed_time, path, name from t_res_share where computer_id = ? and resource_type = ? and scan_time <> ?");
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.setShort(this.selectStmt, s);
            this.setTimestamp(this.selectStmt, l);
            share = this.getAllShares(share);
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        return share;
    }

    public Share setRemovedTime(Share share, long l, long l2) throws GeneralException {
        Share share2;
        long l3 = l - l2 * 86400000L;
        Share share3 = null;
        this.updateList = null;
        while (share != null) {
            share2 = share;
            share = share2.shNext;
            if (share2.shRemovedTime <= 86400000L) {
                share2.shRemovedTime = l;
            }
            if (share2.shRemovedTime < l3) {
                share2.shNext = share3;
                share3 = share2;
                continue;
            }
            if (share2.shRemovedTime != l) continue;
            share2.shNext = this.updateList;
            this.updateList = share2;
        }
        if (this.updateList != null) {
            this.prepUpdate();
            share2 = this.updateList;
            while (share2 != null) {
                this.updateShare(share2);
                share2 = share2.shNext;
            }
            this.closeUpdate();
        }
        return share3;
    }

    public Share getUpdateList() {
        return this.updateList;
    }

    public void prepGetUniqueShare() throws GeneralException {
        this.selectStmt = this.prepareStmt("select computer_id, resource_id, resource_type, scan_time, removed_time, path, name from t_res_share where computer_id = ? and resource_id = ?");
    }

    public void getUniqueShare(Share share) throws GeneralException {
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, share.shComputerID);
            this.setInt(this.selectStmt, share.shResourceID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.getAttributes(share);
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
    }

    private Share getAllShares(Share share) throws SQLException, GeneralException {
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        this.stmtPhase = 1;
        while (this.nextResult()) {
            Share share2 = new Share();
            this.getAttributes(share2);
            share2.shNext = share;
            share = share2;
        }
        return share;
    }

    private void getAttributes(Share share) throws SQLException {
        this.colIndex = 1;
        share.shComputerID = this.getInt(this.resultSet);
        share.shResourceID = this.getInt(this.resultSet);
        share.shResourceType = this.getShort(this.resultSet);
        share.shScanTime = this.getTimestamp(this.resultSet);
        share.shRemovedTime = this.getTimestamp(this.resultSet);
        share.shPath = this.getString(this.resultSet);
        share.shName = this.getString(this.resultSet);
    }

    public void prepSave() throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT_SHARE);
        this.updateStmt = this.prepareStmt(UPDATE_SHARE);
    }

    public void closeSave() throws GeneralException {
        this.closeInsert();
        this.closeUpdate();
    }

    public boolean saveShare(Share share, boolean bl) throws GeneralException {
        block5: {
            if (!bl || !this.insert(share, true)) break block5;
            return true;
        }
        try {
            if (this.update(share) == 0) {
                this.insert(share, false);
                return true;
            }
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        return false;
    }

    private boolean insert(Share share, boolean bl) throws SQLException {
        try {
            this.stmtType = 1;
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setIDs(this.insertStmt, share);
            this.setShort(this.insertStmt, share.shResourceType);
            this.setAttributes(this.insertStmt, share);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException sQLException) {
            if (bl && SQLUtil.isDuplicateKeyViolation(sQLException)) {
                Object[] objectArray = new Object[]{new Integer(share.shComputerID), new Integer(share.shResourceType), new Integer(share.shResourceID)};
                MessageLog.logException((String)"STS0171E", (Exception)sQLException, (Object[])objectArray);
                sQLException.printStackTrace(MessageLog.getThreadLog());
                return false;
            }
            throw sQLException;
        }
        return true;
    }

    private void setIDs(PreparedStatement preparedStatement, Share share) throws SQLException {
        this.setInt(preparedStatement, share.shComputerID);
        this.setInt(preparedStatement, share.shResourceID);
    }

    private void setAttributes(PreparedStatement preparedStatement, Share share) throws SQLException {
        this.setTimestamp(preparedStatement, share.shScanTime, this.scanTS);
        this.setTimestamp(preparedStatement, share.shRemovedTime, this.removeTS);
        this.setString(preparedStatement, share.shPath);
        this.setString(preparedStatement, share.shName);
    }

    private int update(Share share) throws SQLException {
        this.stmtType = 2;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setAttributes(this.updateStmt, share);
        this.setIDs(this.updateStmt, share);
        return this.executeUpdate(this.updateStmt);
    }

    public void prepUpdate() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_SHARE);
    }

    public void updateShare(Share share) throws GeneralException {
        try {
            this.update(share);
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
    }

    public void updateVSProbeTime(Share share) throws GeneralException {
        block2: {
            try {
                this.update(share);
                this.dbc.commit();
            }
            catch (SQLException sQLException) {
                if (SQLUtil.isRowNotFound(sQLException)) break block2;
                this.sqlError(sQLException);
            }
        }
    }

    public void prepDelete() throws GeneralException {
        this.deleteStmt = this.prepareStmt(DELETE_SHARE);
    }

    public void deleteShare(Share share) throws GeneralException {
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setIDs(this.deleteStmt, share);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
    }

    public void prepDeleteIncludingType() throws GeneralException {
        this.deleteStmt = this.prepareStmt(DELETE_INCLUDING_TYPE);
    }

    public void deleteIncludingType(Share share) throws GeneralException {
        this.setPhase();
        try {
            this.setIDs(this.deleteStmt, share);
            this.setShort(this.deleteStmt, share.shResourceType);
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException sQLException) {
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        this.commit();
    }

    public void deleteByCompAndResType(int n, int[] nArray) throws GeneralException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(" where computer_id = ");
        stringBuffer.append(n);
        stringBuffer.append(" and resource_type in (");
        int n2 = 0;
        while (n2 < nArray.length) {
            stringBuffer.append(nArray[n2]);
            stringBuffer.append(',');
            ++n2;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer.append(')');
        this.delete(TABLE_NAME, stringBuffer.toString(), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Share getByCompAndResType(int n, int[] nArray) throws GeneralException {
        Share share = null;
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(" where computer_id = ");
        stringBuffer.append(n);
        stringBuffer.append(" and resource_type in (");
        int n2 = 0;
        while (n2 < nArray.length) {
            stringBuffer.append(nArray[n2]);
            stringBuffer.append(',');
            ++n2;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer.append(')');
        this.selectStmt = this.prepareStmt(SELECT + stringBuffer.toString());
        try {
            try {
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.getPhase();
                while (this.nextResult()) {
                    Share share2 = new Share();
                    this.getAttributes(share2);
                    if (share == null) {
                        share = share2;
                        continue;
                    }
                    share2.shNext = share;
                    share = share2;
                }
            }
            catch (SQLException sQLException) {
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.closeSelect();
            throw throwable;
        }
        this.closeSelect();
        return share;
    }

    public NameList[] getTreeAgents() throws GeneralException {
        NameList nameList = null;
        NameList nameList2 = null;
        try {
            this.staticStmt = this.createStatement();
            String string = SELECT_TREE_AGENTS;
            string = String.valueOf(string) + SELECT_TREE_AGENTS2;
            string = String.valueOf(string) + SELECT_TREE_AGENTS3;
            this.resultSet = this.staticStmt.executeQuery(string);
            this.stmtPhase = 1;
            while (this.nextResult()) {
                NameList nameList3 = new NameList();
                this.colIndex = 1;
                nameList3.nlID = this.getInt(this.resultSet);
                nameList3.nlID2 = this.getInt(this.resultSet);
                nameList3.nlID3 = this.getInt(this.resultSet);
                nameList3.nlName = this.getString(this.resultSet);
                if (nameList2 != null) {
                    nameList2.nlNext = nameList3;
                } else {
                    nameList = nameList3;
                }
                nameList2 = nameList3;
            }
            this.closeStaticStmt();
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        return NameList.packList(nameList);
    }

    public RespManNas[] getManualNasEntries() throws GeneralException {
        RespManNas respManNas = null;
        RespManNas respManNas2 = null;
        try {
            this.staticStmt = this.createStatement();
            String string = SELECT_MAN_NAS;
            this.resultSet = this.staticStmt.executeQuery(string);
            this.getPhase();
            while (this.nextResult()) {
                RespManNas respManNas3 = new RespManNas();
                this.colIndex = 1;
                respManNas3.mnFiler = this.getString(this.resultSet);
                respManNas3.mnNetName = this.getString(this.resultSet);
                respManNas3.mnComputerID = this.getInt(this.resultSet);
                respManNas3.mnResourceID = this.getInt(this.resultSet);
                respManNas3.mnOsType = this.getShort(this.resultSet);
                respManNas3.mnDomain = this.getString(this.resultSet);
                respManNas3.mnUnixComp = this.getString(this.resultSet);
                if (respManNas2 != null) {
                    respManNas2.mnNext = respManNas3;
                } else {
                    respManNas = respManNas3;
                }
                respManNas2 = respManNas3;
            }
            this.closeStaticStmt();
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        return (RespManNas[])Packer.pack(respManNas);
    }

    public void prepSelectSharingComputers() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_SHARING_COMPUTERS);
    }

    public LinkedInteger fetchSharingComputers(short s, int n) throws GeneralException {
        LinkedInteger linkedInteger = null;
        this.setPhase();
        try {
            this.setShort(this.selectStmt, s);
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                this.getPhase();
                LinkedInteger linkedInteger2 = new LinkedInteger();
                linkedInteger2.value = this.getInt(this.resultSet);
                linkedInteger2.next = linkedInteger;
                linkedInteger = linkedInteger2;
            }
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        return linkedInteger;
    }

    public int[][] selectDiskArrayShares() throws GeneralException {
        int[][] nArray = null;
        int n = 0;
        DiskArray diskArray = null;
        DiskArray diskArray2 = null;
        DiskShare diskShare = null;
        this.selectStmt = this.prepareStmt(SELECT_ARRAY_SHARES);
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                this.getPhase();
                int n2 = this.getInt(this.resultSet);
                int n3 = this.getInt(this.resultSet);
                if (diskArray == null || diskArray.daDiskID != n2) {
                    diskArray2 = new DiskArray();
                    ++n;
                    diskArray2.daNext = diskArray;
                    diskArray = diskArray2;
                    diskArray2.daDiskID = n2;
                }
                diskShare = new DiskShare();
                diskShare.dsNext = diskArray2.daShare;
                diskArray2.daShare = diskShare;
                diskShare.dsCompID = n3;
                ++diskArray2.daShareCount;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.stmtPhase = 1;
            this.sqlError(sQLException);
        }
        if (n > 0) {
            nArray = new int[n][1];
            int n4 = 0;
            DiskArray diskArray3 = diskArray;
            while (diskArray3 != null) {
                nArray[n4] = new int[diskArray3.daShareCount + 1];
                nArray[n4][0] = diskArray3.daDiskID;
                int n5 = 1;
                DiskShare diskShare2 = diskArray3.daShare;
                while (diskShare2 != null) {
                    nArray[n4][n5] = diskShare2.dsCompID;
                    ++n5;
                    diskShare2 = diskShare2.dsNext;
                }
                ++n4;
                diskArray3 = diskArray3.daNext;
            }
        }
        return nArray;
    }

    public LinkedInteger getExpiredVSs() throws GeneralException {
        LinkedInteger linkedInteger = null;
        this.selectStmt = this.prepareStmt("select resource_id from t_res_share  where resource_type = 99 and removed_time > ?");
        try {
            this.setPhase();
            this.setTimestamp(this.selectStmt, 86400000L);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            int n = 0;
            while (this.nextResult()) {
                this.getPhase();
                if (linkedInteger == null) {
                    linkedInteger = new LinkedInteger(this.getInt(this.resultSet));
                } else {
                    LinkedInteger linkedInteger2 = linkedInteger;
                    linkedInteger = new LinkedInteger(this.getInt(this.resultSet));
                    linkedInteger.next = linkedInteger2;
                }
                ++n;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.stmtPhase = 1;
            this.sqlError(sQLException);
        }
        return linkedInteger;
    }

    private class DiskShare {
        DiskShare dsNext;
        int dsCompID;

        private DiskShare() {
        }
    }

    private class DiskArray {
        DiskArray daNext;
        int daDiskID;
        int daShareCount;
        DiskShare daShare;

        private DiskArray() {
        }
    }
}

