/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDiskArray;

public class TResVolGroup
extends StorageRepositoryAccessor
implements NameListQueryable {
    private Timestamp vgProbe = new Timestamp(0L);
    private Timestamp vgDisc = new Timestamp(0L);
    public TResComputer cmpAccessor = null;
    private boolean isStorageSubsystem = false;
    private static final String GET_VOLGROUPS = "select volgroup_id, name, computer_id, freespace, capacity,  -1, volgroup_type, lss, config, nbrvolumes, disk_group,  status, format, surf_lun_cap, unsurf_lun_cap,  nbrdisks, discovered_time, last_probe_time, rank_id, raid_id  from t_res_volgroup ";
    private static final String NOT_PRIMORDIAL_STORAGE_POOL = "primordial != 1";
    private static final String GET_STORAGE_POOLS = "select pool_id, display_name, subsystem_id, total_available_space,  capacity, extent_size,  vol_group_type, lss, config, number_of_storage_volumes,  '0', operational_status, format, surfaced_lun_cap, unsurfaced_lun_cap,  -1, discovered_time, update_timestamp, raid_level  from t_res_storage_pool where primordial != 1";
    private static final String GET_STORAGE_POOL_RESULTSET = " select pool_id, extent_size, raid_level from t_res_storage_pool where subsystem_id = ? and primordial != 1";
    private static final String GET_STORAGE_POOL_DISK_GROUP = "select dg.tag from t_res_disk_group dg, t_res_storage_extent se, t_res_storage_pool pool where pool.pool_id = se.pool_id and se.storage_extent_id = dg.storage_extent_id and pool.pool_id = ?";
    private static final String NAMELIST_SELECT_SP_IN_ARRAY_SITE = " select distinct pool.pool_id, pool.display_name, pool.subsystem_id, pool.vol_group_type from t_res_disk_group dg,      t_res_physical_volume phv,      t_res_physicalvolume2extent phv2e,      t_res_storage_extent se,      t_res_storage_pool pool where dg.disk_group_id = phv.disk_group_id  and phv.physical_volume_id = phv2e.physical_volume_id  and phv2e.storage_extent_id = se.storage_extent_id  and se.pool_id = pool.pool_id  and pool.subsystem_id = ?";
    private static final String GET_STORAGE_POOL_DISK_GROUP_WIDTH_RAID = "select dg.width, se.redundancy from t_res_disk_group dg, t_res_storage_extent se, t_res_storage_pool pool where pool.pool_id = se.pool_id and se.storage_extent_id = dg.storage_extent_id and pool.pool_id = ?";
    private static final String GET_STORAGE_POOL_DISK_GROUP_RAID = "select se.redundancy from t_res_disk_group dg, t_res_storage_extent se, t_res_storage_pool pool where pool.pool_id = se.pool_id and pool.pool_id = ?";
    private static final String GET_STORAGE_POOL_INFO = "select dg.width, se.redundancy, se.storage_extent_id from t_res_disk_group dg, t_res_storage_extent se, t_res_storage_pool pool where pool.pool_id = se.pool_id and se.storage_extent_id = dg.storage_extent_id and pool.pool_id = ?";
    private static final String GET_STORAGE_POOL_RAIDS = "select distinct sp.raid_level  from t_res_storage_pool sp  where sp.pool_id = ?";
    private static final String GET_VOLUME_RAIDS = "select distinct v.package_redundancy, v.data_redundancy  from t_res_storage_volume v, t_res_storage_pool pool  where v.pool_id = pool.pool_id and pool.pool_id = ?";
    private static final String COLLECT_ARRAY_SITES = "select distinct dg.disk_group_number from T_RES_DISK_GROUP dg, T_RES_STORAGE_SUBSYSTEM ss, T_RES_STORAGE_EXTENT se, T_RES_STORAGE_POOL sp where ss.subsystem_id = dg.subsystem_id and dg.storage_extent_id = se.storage_extent_id and se.subsystem_id = dg.subsystem_id and se.pool_id = sp.pool_id and sp.subsystem_id = se.subsystem_id and sp.pool_id = ? order by 1";
    private static final String COLLECT_RANKS = "select distinct se.rank_id from T_RES_STORAGE_EXTENT se, T_RES_STORAGE_SUBSYSTEM ss, T_RES_STORAGE_POOL sp where ss.subsystem_id = se.subsystem_id and se.pool_id = sp.pool_id and sp.subsystem_id = se.subsystem_id and sp.pool_id = ? order by 1";
    private static final String GET_NUM_RANKS = "select count(*) from T_RES_STORAGE_EXTENT se, T_RES_STORAGE_POOL sp where se.pool_id = sp.pool_id and sp.pool_id = ? ";
    private static final String INSERT_VOLGROUP = "insert into t_res_volgroup  (volgroup_id, name, computer_id, freespace, capacity,   volgroup_type, lss, config, nbrvolumes, disk_group,   status, format, surf_lun_cap, unsurf_lun_cap,   nbrdisks, discovered_time, last_probe_time, rank_id, raid_id )  values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
    private static final String INSERT_STORAGE_POOL = "insert into t_res_storage_pool  (pool_id, instance_id, subsystem_id, remaining_managed_space,  capacity,  vol_group_type, lss, config,  number_of_storage_volumes, disk_group, native_status, format,  surf_lun_cap, unsurf_lun_cap, number_of_backend_volumes,  discovered_time, update_timestamp, rank_id, raid_id )  values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
    private static final String DELETE_VOLGROUP = "delete from t_res_volgroup where volgroup_id = ?";
    private static final String DELETE_STORAGE_POOL = "delete from t_res_storage_pool where pool_id = ?";
    private static final String DELETE_STATS = "delete from t_stat_fs_hist where filesystem_id = ?";
    private static final String UPDATE_VOLGROUP = "update t_res_volgroup  set name = ?, computer_id = ?, freespace = ?, capacity = ?, volgroup_type = ?, lss = ?, config = ?, nbrvolumes = ?, disk_group = ?, status = ?, format = ?, surf_lun_cap = ?, unsurf_lun_cap = ?, nbrdisks = ?, last_probe_time = ?, rank_id = ?, raid_id = ?  where volgroup_id = ?";
    private static final String UPDATE_STORAGE_POOL = "update t_res_storage_pool  set instance_id = ?, subsystem_id = ?,  remaining_managed_space = ?, capacity = ?, vol_group_type = ?, lss = ?, config = ?, number_of_ storage_volumes = ?,  disk_group = ?, native_status = ?, format = ?, surf_lun_cap = ?,  unsurf_lun_cap = ?, number_of_backend_volumes = ?,  update_timestamp = ?, rank_id = ?, raid_id = ? where pool_id = ?";
    private static final String NAMELIST_SELECT = "select volgroup_id, name, computer_id, volgroup_type  from t_res_volgroup where computer_id = ? ";
    private static final String NAMELIST_SELECT_SP = "select pool_id, display_name, subsystem_id, vol_group_type  from t_res_storage_pool where primordial != 1 and subsystem_id = ? ";
    private static final String NAMELIST_SELECT_BY_VGID = "select volgroup_id, name, computer_id, volgroup_type  from t_res_volgroup where volgroup_id = ? ";
    private static final String NAMELIST_SELECT_BY_POOL_ID = "select pool_id, display_name, subsystem_id, vol_group_type  from t_res_storage_pool where primordial != 1 and pool_id = ? ";
    private static final String NAMELIST_ORDER = " order by 2";

    public TResVolGroup(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TResVolGroup", (String)"dbc");
        }
        this.tableName = "t_res_volgroup";
        this.cmpAccessor = new TResComputer(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TResVolGroup");
        }
    }

    public VolGroup getVolGroupByCmp(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getVolGroupByCmp", (String)"computerID");
        }
        VolGroup volGroup = null;
        String string = null;
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(n);
        string = this.isStorageSubsystem ? "select pool_id, display_name, subsystem_id, total_available_space,  capacity, extent_size,  vol_group_type, lss, config, number_of_storage_volumes,  '0', operational_status, format, surfaced_lun_cap, unsurfaced_lun_cap,  -1, discovered_time, update_timestamp, raid_level  from t_res_storage_pool where primordial != 1 and subsystem_id = ?" : "select volgroup_id, name, computer_id, freespace, capacity,  -1, volgroup_type, lss, config, nbrvolumes, disk_group,  status, format, surf_lun_cap, unsurf_lun_cap,  nbrdisks, discovered_time, last_probe_time, rank_id, raid_id  from t_res_volgroup  where computer_id = ?";
        this.selectStmt = this.prepareStmt(string);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            volGroup = this.getGroups();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getVolGroupByCmp", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        VolGroup volGroup2 = volGroup;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getVolGroupByCmp", (Object)volGroup2);
        }
        return volGroup2;
    }

    public VolGroup getVolGroupByID(int n, int n2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getVolGroupByID", (String)"groupID");
        }
        VolGroup volGroup = null;
        String string = null;
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(n2);
        string = this.isStorageSubsystem ? "select pool_id, display_name, subsystem_id, total_available_space,  capacity, extent_size,  vol_group_type, lss, config, number_of_storage_volumes,  '0', operational_status, format, surfaced_lun_cap, unsurfaced_lun_cap,  -1, discovered_time, update_timestamp, raid_level  from t_res_storage_pool where primordial != 1 and pool_id = ?" : "select volgroup_id, name, computer_id, freespace, capacity,  -1, volgroup_type, lss, config, nbrvolumes, disk_group,  status, format, surf_lun_cap, unsurf_lun_cap,  nbrdisks, discovered_time, last_probe_time, rank_id, raid_id  from t_res_volgroup  where volgroup_id = ?";
        this.selectStmt = this.prepareStmt(string);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            volGroup = this.getGroups();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getVolGroupByID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        VolGroup volGroup2 = volGroup;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getVolGroupByID", (Object)volGroup2);
        }
        return volGroup2;
    }

    private VolGroup getGroups() throws SQLException, GeneralException {
        VolGroup volGroup;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getGroups", (String)"");
        }
        VolGroup volGroup2 = null;
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        while ((volGroup = this.getVolGroup()) != null) {
            volGroup.vgNext = volGroup2;
            volGroup2 = volGroup;
        }
        this.closeSelect();
        VolGroup volGroup3 = volGroup2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getGroups", (Object)volGroup3);
        }
        return volGroup3;
    }

    private VolGroup getVolGroup() throws GeneralException {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getVolGroup", (String)"");
        }
        VolGroup volGroup = null;
        try {
            if (!this.nextResult()) {
                VolGroup volGroup2 = null;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getVolGroup", volGroup2);
                }
                return volGroup2;
            }
            this.stmtPhase = 1;
            this.colIndex = 1;
            volGroup = new VolGroup();
            volGroup.vgID = this.getInt(this.resultSet);
            volGroup.vgName = this.getString(this.resultSet);
            volGroup.vgComputerID = this.getInt(this.resultSet);
            volGroup.vgFreeSpace = this.getLong(this.resultSet);
            volGroup.vgTotalSpace = this.getLong(this.resultSet);
            volGroup.vgExtentSize = this.getInt(this.resultSet);
            volGroup.vgType = this.getShort(this.resultSet);
            volGroup.vgLSS = this.getString(this.resultSet);
            volGroup.vgConfig = this.getShort(this.resultSet);
            volGroup.vgVolumes = this.getInt(this.resultSet);
            volGroup.vgDiskGroup = this.getString(this.resultSet);
            volGroup.vgOperationalStatus = this.getInt(this.resultSet);
            volGroup.vgStatus = (short)volGroup.vgOperationalStatus;
            volGroup.vgFormat = this.getShort(this.resultSet);
            volGroup.vgSurfacedLunCap = this.getLong(this.resultSet);
            volGroup.vgUnSurfacedLunCap = this.getLong(this.resultSet);
            volGroup.vgDisks = this.getInt(this.resultSet);
            volGroup.vgDiscoveredTime = this.getTimestamp(this.resultSet);
            if (this.resultSet.wasNull()) {
                volGroup.vgDiscoveredTime = 86400000L;
            }
            volGroup.vgProbeTime = this.getTimestamp(this.resultSet);
            if (this.resultSet.wasNull()) {
                volGroup.vgProbeTime = 86400000L;
            }
            if (!this.isStorageSubsystem) {
                volGroup.vgRank = this.getString(this.resultSet);
                volGroup.vgRaidLevels = this.getString(this.resultSet);
            } else {
                object = new TResDiskArray(this.dbc);
                volGroup.vgDisks = ((TResDiskArray)object).getNumOfStoragePoolDisks(volGroup.vgID);
                volGroup.vgVolumes = ((TResDiskArray)object).getNumOfStoragePoolVolumes(volGroup.vgID);
                volGroup.vgType = this.setStoragePoolType(volGroup.vgComputerID);
                volGroup.vgConfigs = this.getStoragePoolRaidLevel(volGroup.vgID);
                if (volGroup.vgConfigs.length > 0) {
                    volGroup.vgConfig = volGroup.vgConfigs[0];
                    if (volGroup.vgConfigs.length > 1 && volGroup.vgType == 3) {
                        volGroup.vgType = (short)6;
                    }
                } else {
                    volGroup.vgConfig = (short)11;
                }
                if (volGroup.vgType == 5 || volGroup.vgType == 4) {
                    volGroup.vgArray = this.getArraySites(volGroup.vgID);
                    volGroup.vgRank = this.getRanks(volGroup.vgID);
                }
                volGroup.vgDiskGroup = this.getStoragePoolDiskGroup(volGroup.vgID);
                if (volGroup.vgDisks == 0) {
                    volGroup.vgDisks = 1;
                }
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getVolGroup", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        object = volGroup;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getVolGroup", (Object)object);
        }
        return object;
    }

    public void saveVolGroups(VolGroup volGroup, int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveVolGroups", (String)"vgList, identifierCount");
        }
        if (volGroup == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"saveVolGroups");
            }
            return;
        }
        VolGroup volGroup2 = null;
        int n2 = 0;
        try {
            if (n > 0) {
                n2 = TResVolGroup.getIdentifier(1, n, this.dbc);
            }
            volGroup2 = volGroup;
            while (volGroup2 != null) {
                if (volGroup2.vgID == -1) {
                    volGroup2.vgID = n2++;
                    this.insertVG(volGroup2);
                } else if (volGroup2.vgFlag == 2) {
                    this.updateVG(volGroup2);
                }
                this.dbc.commit();
                volGroup2 = volGroup2.vgNext;
            }
            this.closeSelect();
            this.closeInsert();
            this.closeUpdate();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"saveVolGroups", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveVolGroups");
        }
    }

    private void insertVG(VolGroup volGroup) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertVG", (String)"vg");
        }
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(volGroup.vgComputerID);
        this.insertStmt = this.isStorageSubsystem ? this.prepareStmt(INSERT_STORAGE_POOL) : this.prepareStmt(INSERT_VOLGROUP);
        this.stmtType = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.insertStmt, volGroup.vgID);
        this.setString(this.insertStmt, volGroup.vgName);
        this.setInt(this.insertStmt, volGroup.vgComputerID);
        this.setLong(this.insertStmt, volGroup.vgFreeSpace);
        this.setLong(this.insertStmt, volGroup.vgTotalSpace);
        this.setShort(this.insertStmt, volGroup.vgType);
        this.setString(this.insertStmt, volGroup.vgLSS);
        this.setShort(this.insertStmt, volGroup.vgConfig);
        this.setInt(this.insertStmt, volGroup.vgVolumes);
        if (volGroup.vgType == 4 || volGroup.vgType == 5) {
            this.setString(this.insertStmt, volGroup.getArraySitesforDB());
        } else {
            this.setString(this.insertStmt, volGroup.vgDiskGroup);
        }
        this.setInt(this.insertStmt, volGroup.vgOperationalStatus);
        this.setShort(this.insertStmt, volGroup.vgFormat);
        this.setLong(this.insertStmt, volGroup.vgSurfacedLunCap);
        this.setLong(this.insertStmt, volGroup.vgUnSurfacedLunCap);
        this.setInt(this.insertStmt, volGroup.vgDisks);
        this.setTimestamp(this.insertStmt, volGroup.vgDiscoveredTime, this.vgDisc);
        this.setTimestamp(this.insertStmt, volGroup.vgProbeTime, this.vgProbe);
        if (volGroup.vgType == 4 || volGroup.vgType == 5) {
            this.setString(this.insertStmt, volGroup.getRanks());
            this.setString(this.insertStmt, volGroup.getConfigs());
        } else if (volGroup.vgType == 6) {
            this.setString(this.insertStmt, null);
            this.setString(this.insertStmt, volGroup.getConfigs());
        } else {
            this.setString(this.insertStmt, null);
            this.setString(this.insertStmt, null);
        }
        this.executeUpdate(this.insertStmt);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertVG");
        }
    }

    public void deleteVGByComputer(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteVGByComputer", (String)"compID");
        }
        VolGroup volGroup = this.getVolGroupByCmp(n);
        this.deleteVolGroups(volGroup);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteVGByComputer");
        }
    }

    public void deleteVolGroups(VolGroup volGroup) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteVolGroups", (String)"vgList");
        }
        try {
            VolGroup volGroup2 = volGroup;
            while (volGroup2 != null) {
                this.deleteVG(volGroup2);
                volGroup2 = volGroup2.vgNext;
            }
            this.deleteStmt = this.prepareStmt(DELETE_STATS);
            volGroup2 = volGroup;
            while (volGroup2 != null) {
                this.deleteVG(volGroup2);
                volGroup2 = volGroup2.vgNext;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteVolGroups", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteVolGroups");
        }
    }

    private void deleteVG(VolGroup volGroup) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteVG", (String)"vg");
        }
        if (this.deleteStmt == null) {
            this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(volGroup.vgComputerID);
            this.deleteStmt = this.isStorageSubsystem ? this.prepareStmt(DELETE_STORAGE_POOL) : this.prepareStmt(DELETE_VOLGROUP);
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.deleteStmt, volGroup.vgID);
        this.executeUpdate(this.deleteStmt);
        this.dbc.commit();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteVG");
        }
    }

    public void prepUpdateVG() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_VOLGROUP);
    }

    public void updateVG(VolGroup volGroup) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateVG", (String)"vg");
        }
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(volGroup.vgComputerID);
        this.updateStmt = this.isStorageSubsystem ? this.prepareStmt(UPDATE_STORAGE_POOL) : this.prepareStmt(UPDATE_VOLGROUP);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setString(this.updateStmt, volGroup.vgName);
            this.setInt(this.updateStmt, volGroup.vgComputerID);
            this.setLong(this.updateStmt, volGroup.vgFreeSpace);
            this.setLong(this.updateStmt, volGroup.vgTotalSpace);
            this.setShort(this.updateStmt, volGroup.vgType);
            this.setString(this.updateStmt, volGroup.vgLSS);
            this.setShort(this.updateStmt, volGroup.vgConfig);
            this.setInt(this.updateStmt, volGroup.vgVolumes);
            if (volGroup.vgType == 4 || volGroup.vgType == 5) {
                this.setString(this.updateStmt, volGroup.getArraySitesforDB());
            } else {
                this.setString(this.updateStmt, volGroup.vgDiskGroup);
            }
            this.setInt(this.updateStmt, volGroup.vgOperationalStatus);
            this.setShort(this.updateStmt, volGroup.vgFormat);
            this.setLong(this.updateStmt, volGroup.vgSurfacedLunCap);
            this.setLong(this.updateStmt, volGroup.vgUnSurfacedLunCap);
            this.setInt(this.updateStmt, volGroup.vgDisks);
            this.setTimestamp(this.updateStmt, volGroup.vgProbeTime, this.vgProbe);
            if (volGroup.vgType == 4 || volGroup.vgType == 5) {
                this.setString(this.updateStmt, volGroup.getRanks());
                this.setString(this.updateStmt, volGroup.getConfigs());
            } else if (volGroup.vgType == 6) {
                this.setString(this.updateStmt, null);
                this.setString(this.updateStmt, volGroup.getConfigs());
            } else {
                this.setString(this.updateStmt, null);
                this.setString(this.updateStmt, null);
            }
            this.setInt(this.updateStmt, volGroup.vgID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateVG", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateVG");
        }
    }

    public NameList selectNames(GuiListReq guiListReq) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectNames", (String)"glr");
        }
        NameList nameList = null;
        NameList nameList2 = null;
        StringBuffer stringBuffer = new StringBuffer(500);
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(guiListReq.computerID);
        if (this.isStorageSubsystem) {
            if (guiListReq.groupID > 0) {
                stringBuffer.append(NAMELIST_SELECT_SP_IN_ARRAY_SITE);
                stringBuffer.append(" and dg.disk_group_id = " + guiListReq.groupID);
            } else {
                stringBuffer.append(NAMELIST_SELECT_SP);
            }
        } else {
            stringBuffer.append(NAMELIST_SELECT);
        }
        stringBuffer.append(NAMELIST_ORDER);
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, guiListReq.computerID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                NameList nameList3 = new NameList();
                nameList3.nlID = this.getInt(this.resultSet);
                nameList3.nlName = this.getString(this.resultSet);
                nameList3.nlID2 = this.getInt(this.resultSet);
                nameList3.nlID3 = this.getShort(this.resultSet);
                if (nameList2 != null) {
                    nameList2.nlNext = nameList3;
                } else {
                    nameList = nameList3;
                }
                nameList2 = nameList3;
            }
            this.closeStaticStmt();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectNames", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        NameList nameList4 = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectNames", nameList4);
        }
        return nameList4;
    }

    public NameList selectNamesByVGID(GuiListReq guiListReq) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectNameByVGID", (String)"glr");
        }
        NameList nameList = null;
        StringBuffer stringBuffer = new StringBuffer(500);
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(guiListReq.computerID);
        if (this.isStorageSubsystem) {
            stringBuffer.append(NAMELIST_SELECT_BY_POOL_ID);
        } else {
            stringBuffer.append(NAMELIST_SELECT_BY_VGID);
        }
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, guiListReq.vgID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.nextResult()) {
                this.colIndex = 1;
                nameList = new NameList();
                nameList.nlID = this.getInt(this.resultSet);
                nameList.nlName = this.getString(this.resultSet);
                nameList.nlID2 = this.getInt(this.resultSet);
                nameList.nlID3 = this.getShort(this.resultSet);
            }
            this.closeStaticStmt();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectNameByVGID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        NameList nameList2 = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectNameByVGID", nameList2);
        }
        return nameList2;
    }

    private short setStoragePoolType(int n) throws GeneralException {
        short s = -1;
        TResComputer tResComputer = new TResComputer(this.dbc);
        short s2 = tResComputer.getStorageSubsystemType(n);
        switch (s2) {
            case 12: {
                s = 2;
                break;
            }
            case 15: 
            case 18: {
                s = 3;
                break;
            }
            case 25: {
                s = 4;
                break;
            }
            case 27: {
                s = 5;
                break;
            }
            default: {
                s = 3;
            }
        }
        return s;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getStoragePoolDiskGroup(int n) throws GeneralException {
        String string = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                preparedStatement = this.dbc.prepareStatement(GET_STORAGE_POOL_DISK_GROUP);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string = resultSet.getString(1);
                }
            }
            catch (SQLException sQLException) {
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException sQLException) {
            return string;
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return string;
        resultSet.close();
        return string;
    }

    public short[] getStoragePoolRaidLevel(int n) throws GeneralException {
        VolGroup volGroup = new VolGroup();
        volGroup.vgID = n;
        this.getDSRaidLevels(volGroup);
        return volGroup.vgConfigs;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getDSRaidLevels(VolGroup var1_1) throws GeneralException {
        var1_1.vgConfigs = new short[1];
        var1_1.vgConfigs[0] = 11;
        var2_2 = null;
        var3_3 = null;
        try {
            try {
                var2_2 = this.dbc.prepareStatement("select distinct sp.raid_level  from t_res_storage_pool sp  where sp.pool_id = ?");
                var2_2.setInt(1, var1_1.vgID);
                var3_3 = var2_2.executeQuery();
                if (!var3_3.next()) ** GOTO lbl-1000
                var4_4 = var3_3.getString(1);
                if (var4_4 != null) {
                    var5_6 = Pattern.compile(" ");
                    var6_7 = var5_6.split(var4_4);
                    var1_1.vgConfigs = new short[var6_7.length];
                    var7_8 = 0;
                    block8: while (var7_8 < var6_7.length) {
                        var1_1.vgConfigs[var7_8] = 11;
                        var8_9 = 0;
                        while (true) {
                            if (var8_9 >= VolGroup.RAID_LEVELS.length) {
                                ++var7_8;
                                continue block8;
                            }
                            if (VolGroup.RAID_LEVELS[var8_9].equalsIgnoreCase(var6_7[var7_8].trim())) {
                                var1_1.vgConfigs[var7_8] = var8_9;
                            }
                            var8_9 = (short)(var8_9 + 1);
                        }
                    }
                } else {
                    var1_1.vgConfigs = this.getRaidLevels(var1_1);
                }
            }
            catch (SQLException var4_5) {
                this.sqlError(var4_5);
            }
        }
        catch (Throwable var10_10) {
            var9_11 = null;
            try {
                if (var2_2 != null) {
                    var2_2.close();
                }
                if (var3_3 == null) throw var10_10;
                var3_3.close();
                throw var10_10;
            }
            catch (SQLException v0) {}
            throw var10_10;
        }
lbl-1000:
        // 4 sources

        {
            var9_12 = null;
        }
        try {}
        catch (SQLException v1) {
            return;
        }
        if (var2_2 != null) {
            var2_2.close();
        }
        if (var3_3 == null) return;
        var3_3.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getArraySites(int n) throws GeneralException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        String string = new String();
        try {
            block12: {
                try {
                    preparedStatement = this.dbc.prepareStatement(COLLECT_ARRAY_SITES);
                    preparedStatement.setInt(1, n);
                    resultSet = preparedStatement.executeQuery();
                    this.dbc.commit();
                    while (true) {
                        if (!resultSet.next()) {
                            if (!bl) break;
                            string = string.substring(0, string.length() - 2);
                            break block12;
                        }
                        this.getPhase();
                        String string2 = Short.toString(this.getShort(resultSet));
                        string = string.concat(string2);
                        string = string.concat(", ");
                        bl = true;
                    }
                    string = " ";
                }
                catch (SQLException sQLException) {
                    this.sqlError(sQLException);
                }
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            return string;
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return string;
        resultSet.close();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRanks(int n) throws GeneralException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        String string = new String();
        try {
            block12: {
                try {
                    preparedStatement = this.dbc.prepareStatement(COLLECT_RANKS);
                    preparedStatement.setInt(1, n);
                    resultSet = preparedStatement.executeQuery();
                    this.dbc.commit();
                    while (true) {
                        if (!resultSet.next()) {
                            if (!bl) break;
                            string = string.substring(0, string.length() - 2);
                            break block12;
                        }
                        this.getPhase();
                        String string2 = Short.toString(this.getShort(resultSet));
                        string = string.concat(string2);
                        string = string.concat(", ");
                        bl = true;
                    }
                    string = " ";
                }
                catch (SQLException sQLException) {
                    this.sqlError(sQLException);
                }
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            return string;
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return string;
        resultSet.close();
        return string;
    }

    public ResultSet getStoragePoolDiskGroupWidthRaid(int n) throws GeneralException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.dbc.prepareStatement(GET_STORAGE_POOL_DISK_GROUP_WIDTH_RAID);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        return resultSet;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short getStoragePoolDiskGroupRaid(int n) throws GeneralException {
        short s = -1;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                preparedStatement = this.dbc.prepareStatement(GET_STORAGE_POOL_DISK_GROUP_RAID);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    s = resultSet.getShort(1);
                }
            }
            catch (SQLException sQLException) {
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException sQLException) {
            return s;
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return s;
        resultSet.close();
        return s;
    }

    public ResultSet getStoragePools(int n) throws GeneralException {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.dbc.prepareStatement(GET_STORAGE_POOL_RESULTSET);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        return resultSet;
    }

    public int getNumOfStoragePoolRanks(int n) throws GeneralException {
        return this.getNum(GET_NUM_RANKS, n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getNum(String string, int n) throws GeneralException {
        int n2 = -1;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                preparedStatement = this.dbc.prepareStatement(string);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n2 = resultSet.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (SQLException sQLException) {
            return n2;
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return n2;
        resultSet.close();
        return n2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private short[] getRaidLevels(VolGroup volGroup) throws GeneralException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            try {
                preparedStatement = this.dbc.prepareStatement(GET_VOLUME_RAIDS);
                preparedStatement.setInt(1, volGroup.vgID);
                resultSet = preparedStatement.executeQuery();
                this.dbc.commit();
                while (resultSet.next()) {
                    this.getPhase();
                    int n = 11;
                    short s = this.getShort(resultSet);
                    short s2 = this.getShort(resultSet);
                    if (s2 == 1 && s == 0) {
                        n = 3;
                    } else if (s2 == 1 && s == 1) {
                        n = 0;
                    } else if (s2 > 1 && s == 1) {
                        n = 1;
                    } else if (s2 > 1 && s > 1) {
                        n = 9;
                    } else if (s2 == 1 && s > 1) {
                        n = 8;
                    }
                    hashSet.add(Short.toString((short)n));
                }
            }
            catch (SQLException sQLException) {
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        {
            Object var8_14 = null;
        }
        try {}
        catch (SQLException sQLException) {}
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (hashSet.isEmpty()) return volGroup.vgConfigs;
        Iterator iterator = hashSet.iterator();
        volGroup.vgConfigs = new short[hashSet.size()];
        int n = 0;
        while (true) {
            if (!iterator.hasNext()) {
                volGroup.vgConfig = volGroup.vgConfigs[0];
                return volGroup.vgConfigs;
            }
            String string = (String)iterator.next();
            volGroup.vgConfigs[n] = Short.parseShort(string);
            ++n;
        }
    }

    public ResultSet getPoolRankInfo(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getPoolRanks", (String)"pool_id");
        }
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.dbc.prepareStatement(GET_STORAGE_POOL_INFO);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getPoolRanks", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getPoolRanks", (Object)resultSet);
        }
        return resultSet;
    }

    public void closeInsert() throws GeneralException {
        super.closeInsert();
    }

    public void closeDelete() throws GeneralException {
        super.closeDelete();
    }

    public void closeSelect() throws GeneralException {
        super.closeSelect();
    }
}

