/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;

public class TSnmpCommunity
extends RepositoryAccessor {
    private static final String SELECT = "select community_id, snmp_community from t_snmp_community";
    private static final String INSERT = "insert into t_snmp_community (community_id, snmp_community) values (?,?)";
    private static final String DELETE = "delete from t_snmp_community where community_id = ?";

    public TSnmpCommunity(Connection connection) {
        super(connection);
        this.tableName = "t_snmp_community";
    }

    public NameList getCommunities() throws GeneralException {
        NameList nameList = null;
        this.selectStmt = this.prepareStmt(SELECT);
        try {
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                NameList nameList2 = new NameList();
                this.getPhase();
                nameList2.nlID = this.getInt(this.resultSet);
                nameList2.nlName = this.getString(this.resultSet);
                nameList2.nlNext = nameList;
                nameList = nameList2;
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        return nameList;
    }

    public void insert(NameList nameList, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TSnmpCommunity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"rows, doCommit");
        }
        int n = 0;
        NameList nameList2 = nameList;
        while (nameList2 != null) {
            ++n;
            nameList2 = nameList2.nlNext;
        }
        try {
            n = SQLUtil.getIdentifier(1, n, this.dbc);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TSnmpCommunity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        this.insertStmt = this.prepareStmt(INSERT);
        nameList2 = nameList;
        while (nameList2 != null) {
            nameList2.nlID = n++;
            this.stmtPhase = 0;
            this.colIndex = 1;
            try {
                this.setInt(this.insertStmt, nameList2.nlID);
                this.setString(this.insertStmt, nameList2.nlName);
                this.executeUpdate(this.insertStmt);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TSnmpCommunity");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
                }
                this.stmtType = 1;
                this.sqlError(sQLException);
            }
            nameList2 = nameList2.nlNext;
        }
        if (bl) {
            this.commit();
        }
        this.closeInsert();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TSnmpCommunity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    public void delete(Iterator iterator) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TSnmpCommunity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"delete", (String)"iterator");
        }
        this.deleteStmt = this.prepareStmt(DELETE);
        while (iterator.hasNext()) {
            NameList nameList = (NameList)iterator.next();
            this.stmtPhase = 0;
            this.colIndex = 1;
            try {
                this.setInt(this.deleteStmt, nameList.nlID);
                this.executeUpdate(this.deleteStmt);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TSnmpCommunity");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"delete", (Throwable)sQLException);
                }
                this.stmtType = 3;
                this.sqlError(sQLException);
            }
        }
        this.commit();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TSnmpCommunity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"delete");
        }
    }
}

