/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TStatDisk
extends StorageRepositoryAccessor {
    private static final String GET_DISK_BY_ID = "select heads, cylinders, rpm, sector_size, sectors_avg_track, sectors_outr_track, sectors_innr_track, logical_block_size, minutes_powered_on, write_protected, write_cache_enable, read_cache_disable, auto_write_realloc, auto_read_realloc, no_error_recovery, failure_predicted, capacity, spare_blocks, volgroup_id, desired_awre, desired_arre, desired_noerrrcvry from t_stat_disk where disk_id = ?";
    private static final String SELECT_HOST_LUNS_PREAMBLE = "select v.serial_number, s.disk_id, s.logical_disk_id from t_stat_disk s, t_res_physical_volume v where s.disk_id = v.physical_volume_id and ";
    private static final String SELECT_PATHS_FOR_HOST_DISK = "select c.host_name, c.host_url, c.os_type, a.path from t_res_host c, t_res_dev_access a, t_res_controller n, t_stat_disk d where c.computer_id = n.computer_id and n.controller_id = a.controller_id and a.device_id = d.disk_id and d.disk_id = ?";
    private static final String SELECT_PATHS_FOR_SUBSYSTEM_DISK = "select ss.name, ss.name, ss.os_type, pv.device_id from t_res_storage_subsystem ss, t_res_physical_volume pv where ss.subsystem_id = pv.subsystem_id and pv.physical_volume_id = ?";
    private static final String SELECT_PATHS_FOR_SVC_MDISK = "select ss.name, ss.name, ss.os_type, se.element_name from t_res_storage_subsystem ss, t_res_storage_extent se where ss.subsystem_id = se.subsystem_id and se.storage_extent_id = ?";
    private static final String SELECT_LUN_DEFINITION_GIVEN_DISK = "select svid from t_res_view_ssluncmp where physical_volume_id = ?";
    private static final String INSERT_DISK = "insert into t_stat_disk (disk_id, heads, cylinders, rpm, sector_size, sectors_avg_track, sectors_outr_track, sectors_innr_track, logical_block_size, minutes_powered_on, write_protected, write_cache_enable, read_cache_disable, auto_write_realloc, auto_read_realloc, no_error_recovery, failure_predicted, capacity, spare_blocks, volgroup_id, desired_awre, desired_arre, desired_noerrrcvry, logical_disk_id, disk_identity) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,-1,?)";
    private static final String UPDATE_DISK = "update t_stat_disk set sector_size = ?, sectors_avg_track = ?, sectors_outr_track = ?, sectors_innr_track = ?, logical_block_size=?, minutes_powered_on = ?, write_protected = ?, write_cache_enable = ?, read_cache_disable = ?, auto_write_realloc = ?, auto_read_realloc=?, no_error_recovery = ?, failure_predicted = ?, capacity = ?, spare_blocks = ?, volgroup_id = ?, desired_awre = ?, desired_arre = ?, desired_noerrrcvry = ?, disk_identity = ? where disk_id = ?";
    private static final String UPDATE_DISK_DESIRED_SETTINGS = "update t_stat_disk set desired_awre = ?, desired_arre = ?, desired_noerrrcvry = ? where disk_id = ?";
    private static final String GET_LOGICAL_DISK_ID = "select logical_disk_id from t_stat_disk where disk_id = ?";
    private static final String UPDATE_LOGICAL_DISK_ID = "update t_stat_disk set logical_disk_id = ? where disk_id = ?";
    private static final String UPDATE_VOLGROUP_ID = "update t_stat_disk set volgroup_id = ? where disk_id = ?";
    private static final String UPDATE_SVC_DISK_IDENTITY = "update t_stat_disk set disk_identity = ? where disk_id in (select device_id from t_res_dev_access where controller_id = ?)";
    private static final String DELETE_DISK = "delete from t_stat_disk where disk_id = ?";
    private static final String INSERT_SS_DISK_DATA = "insert into t_stat_disk (DISK_ID, HEADS, CYLINDERS, RPM, SECTOR_SIZE, SECTORS_AVG_TRACK, SECTORS_OUTR_TRACK, SECTORS_INNR_TRACK, LOGICAL_BLOCK_SIZE, MINUTES_POWERED_ON, WRITE_PROTECTED, WRITE_CACHE_ENABLE, READ_CACHE_DISABLE, AUTO_WRITE_REALLOC, AUTO_READ_REALLOC, NO_ERROR_RECOVERY, FAILURE_PREDICTED, CAPACITY, SPARE_BLOCKS, VOLGROUP_ID, DESIRED_AWRE, DESIRED_ARRE, DESIRED_NOERRRCVRY, LOGICAL_DISK_ID, DISK_IDENTITY) select pv.PHYSICAL_VOLUME_ID, -1, -1, -1, 512, -1, -1, -1, 512, -1, '0', '0', '0', '0', '0', '0', '0', CASE WHEN pv.capacity  IS NULL  THEN 0  ELSE pv.capacity  END, -1, 0, '0', '0', '0', -1, '0' from t_res_physical_volume pv where pv.physical_volume_id NOT IN (select disk_id from t_stat_disk) and ";
    private static final String INSERT_SVC_MDISK_DATA = "insert into t_stat_disk (DISK_ID, HEADS, CYLINDERS, RPM, SECTOR_SIZE, SECTORS_AVG_TRACK, SECTORS_OUTR_TRACK, SECTORS_INNR_TRACK, LOGICAL_BLOCK_SIZE, MINUTES_POWERED_ON, WRITE_PROTECTED, WRITE_CACHE_ENABLE, READ_CACHE_DISABLE, AUTO_WRITE_REALLOC, AUTO_READ_REALLOC, NO_ERROR_RECOVERY, FAILURE_PREDICTED, CAPACITY, SPARE_BLOCKS, VOLGROUP_ID, DESIRED_AWRE, DESIRED_ARRE, DESIRED_NOERRRCVRY, LOGICAL_DISK_ID, DISK_IDENTITY) select se.STORAGE_EXTENT_ID, -1, -1, -1, 512, -1, -1, -1, 512, -1, '0', '0', '0', '0', '0', '0', '0', CASE WHEN se.total_capacity  IS NULL  THEN 0  ELSE se.total_capacity  END, -1, 0, '0', '0', '0', -1, '0'  from t_res_storage_extent se where  se.storage_extent_id NOT IN (select disk_id from t_stat_disk) and ";
    private static final String SELECT_SS_DISKS = "select disk_id from t_stat_disk stat, t_res_physical_volume pv where stat.disk_id = pv.physical_volume_id and ";
    private static final String SELECT_SVC_DISKS = "select disk_id from t_stat_disk stat, t_res_storage_extent se where stat.disk_id = se.storage_extent_id and ";
    private static final String UPDATE_SS_DISK_DATA = "update t_stat_disk set SECTOR_SIZE = 512, SECTORS_AVG_TRACK = -1, SECTORS_OUTR_TRACK = -1, SECTORS_INNR_TRACK = -1, LOGICAL_BLOCK_SIZE = 512, MINUTES_POWERED_ON = -1, WRITE_PROTECTED = cast (0 as char), WRITE_CACHE_ENABLE = cast (0 as char), READ_CACHE_DISABLE = cast (0 as char), AUTO_WRITE_REALLOC = cast (0 as char), AUTO_READ_REALLOC = cast (0 as char), NO_ERROR_RECOVERY = cast (0 as char), FAILURE_PREDICTED = cast (0 as char), CAPACITY = (select (CASE WHEN pv.capacity  IS NULL  THEN 0  ELSE pv.capacity  END) from t_res_physical_volume pv, t_stat_disk sdisk where pv.physical_volume_id = sdisk.disk_id and pv.physical_volume_id = ?), SPARE_BLOCKS = -1, VOLGROUP_ID = 0, DESIRED_AWRE = cast (0 as char), DESIRED_ARRE = cast (0 as char), DESIRED_NOERRRCVRY = cast (0 as char), DISK_IDENTITY = cast (0 as char) where disk_id = ?";
    private static final String UPDATE_SVC_MDISK_DATA = "update t_stat_disk set   SECTOR_SIZE = 512,     SECTORS_AVG_TRACK = -1,    SECTORS_OUTR_TRACK = -1,     SECTORS_INNR_TRACK = -1,      LOGICAL_BLOCK_SIZE = 512,      MINUTES_POWERED_ON = -1,     WRITE_PROTECTED = '0',       WRITE_CACHE_ENABLE = '0',     READ_CACHE_DISABLE = '0',      AUTO_WRITE_REALLOC = '0',    AUTO_READ_REALLOC = '0',      NO_ERROR_RECOVERY = '0',      FAILURE_PREDICTED = '0',      CAPACITY = (SELECT CASE WHEN se.total_capacity  IS NULL  THEN 0  ELSE se.total_capacity  END    from t_res_storage_extent se,    t_stat_disk sdisk    \t where se.storage_extent_id = sdisk.disk_id and  \t se.storage_extent_id = ?),      SPARE_BLOCKS = -1,      VOLGROUP_ID = 0,    \tDESIRED_AWRE = '0',    \tDESIRED_ARRE = '0',    \tDESIRED_NOERRRCVRY = '0',  \tDISK_IDENTITY = '0' where disk_id = ?";

    public TStatDisk(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TStatDisk", (String)"dbc");
        }
        this.tableName = "t_stat_disk";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TStatDisk");
        }
    }

    public int updateSSandSVCDisks(int[] nArray, int[] nArray2) throws GeneralException {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        int n = 0;
        if (nArray.length > 0) {
            stringBuffer2 = new StringBuffer();
            stringBuffer2.append(SELECT_SVC_DISKS);
            SQLUtil.appendInClause(stringBuffer2, "se.subsystem_id", nArray);
            stringBuffer = new StringBuffer();
            stringBuffer.append(UPDATE_SVC_MDISK_DATA);
            n += this.executeUpdateDisks(stringBuffer2.toString(), stringBuffer.toString(), nArray);
        }
        if (nArray2.length > 0) {
            stringBuffer2 = new StringBuffer();
            stringBuffer2.append(SELECT_SS_DISKS);
            SQLUtil.appendInClause(stringBuffer2, "pv.subsystem_id", nArray2);
            stringBuffer = new StringBuffer();
            stringBuffer.append(UPDATE_SS_DISK_DATA);
            n += this.executeUpdateDisks(stringBuffer2.toString(), stringBuffer.toString(), nArray2);
        }
        return n;
    }

    private int executeUpdateDisks(String string, String string2, int[] nArray) throws GeneralException {
        int n = 0;
        try {
            Statement statement = this.dbc.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            PreparedStatement preparedStatement = this.dbc.prepareStatement(string2);
            int n2 = 0;
            int n3 = -1;
            while (resultSet.next()) {
                n3 = resultSet.getInt(1);
                preparedStatement.setInt(1, n3);
                preparedStatement.setInt(2, n3);
                ++n2;
                n += preparedStatement.executeUpdate();
            }
            preparedStatement.close();
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        return n;
    }

    public int insertSSandSVCDisks(int[] nArray, int[] nArray2) throws GeneralException {
        StringBuffer stringBuffer;
        int n = 0;
        if (nArray.length > 0) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(INSERT_SVC_MDISK_DATA);
            SQLUtil.appendInClause(stringBuffer, "se.subsystem_id", nArray);
            n += this.executeInsertDisks(stringBuffer.toString());
        }
        if (nArray2.length > 0) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(INSERT_SS_DISK_DATA);
            SQLUtil.appendInClause(stringBuffer, "pv.subsystem_id", nArray2);
            n += this.executeInsertDisks(stringBuffer.toString());
        }
        return n;
    }

    private int executeInsertDisks(String string) throws GeneralException {
        int n = 0;
        try {
            Statement statement = this.dbc.createStatement();
            n = statement.executeUpdate(string);
            statement.close();
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        return n;
    }

    public Device getDiskByID(Device device) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDiskByID", (String)"devListIn");
        }
        Device device2 = null;
        try {
            Device device3;
            this.selectStmt = this.prepareStmt(GET_DISK_BY_ID);
            while ((device3 = device) != null) {
                device = device3.devNext;
                if (device3.isFixedDisk()) {
                    this.stmtPhase = 0;
                    this.colIndex = 1;
                    this.setInt(this.selectStmt, device3.devID);
                    this.stmtPhase = 3;
                    this.resultSet = this.selectStmt.executeQuery();
                    if (!this.getDisk((Disk)device3)) continue;
                }
                device3.devNext = device2;
                device2 = device3;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getDiskByID", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        Device device4 = device2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getDiskByID", device4);
        }
        return device4;
    }

    private boolean getDisk(Disk disk) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDisk", (String)"disk");
        }
        this.stmtPhase = 0;
        if (!this.nextResult()) {
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getDisk", (boolean)bl);
            }
            return bl;
        }
        this.colIndex = 1;
        disk.dskHeads = this.getInt(this.resultSet);
        disk.dskCylinders = this.getInt(this.resultSet);
        disk.dskRPM = this.getInt(this.resultSet);
        disk.dskSectorSize = this.getInt(this.resultSet);
        disk.dskSectorsPerAvgTrack = this.getInt(this.resultSet);
        disk.dskSectorsPerOuterTrack = this.getInt(this.resultSet);
        disk.dskSectorsPerInnerTrack = this.getInt(this.resultSet);
        disk.dskLogicalBlockSize = this.getInt(this.resultSet);
        disk.dskMinutesPoweredOn = this.getInt(this.resultSet);
        disk.dskWriteProtected = this.getBoolean(this.resultSet);
        disk.dskWriteCacheEnabled = this.getBoolean(this.resultSet);
        disk.dskReadCacheDisabled = this.getBoolean(this.resultSet);
        disk.dskAutoWriteRealloc = this.getBoolean(this.resultSet);
        disk.dskAutoReadRealloc = this.getBoolean(this.resultSet);
        disk.dskNoErrorRecovery = this.getBoolean(this.resultSet);
        disk.dskFailurePredicted = this.getBoolean(this.resultSet);
        disk.dskCapacity = this.getLong(this.resultSet);
        disk.dskSpareBlocks = this.getInt(this.resultSet);
        disk.dskVolgroupID = this.getInt(this.resultSet);
        disk.dskDesiredAWRE = this.getByte(this.resultSet);
        disk.dskDesiredARRE = this.getByte(this.resultSet);
        disk.dskDesiredNoErrRcvry = this.getByte(this.resultSet);
        boolean bl = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getDisk", (boolean)bl);
        }
        return bl;
    }

    public NameList selectHostLUNs(Computer computer) throws GeneralException {
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectHostLUNs", (String)"computer");
        }
        int n = 0;
        NameList nameList = null;
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(SELECT_HOST_LUNS_PREAMBLE);
        stringBuffer.append("v.storage_system_type = " + computer.cmpOSType);
        if (computer.cmpOSType == 18) {
            stringBuffer.append(" and v.serial_number = ?");
            string = stringBuffer.toString();
            stringBuffer = null;
            this.setSQLText(string);
            try {
                this.selectStmt = this.prepareStmt(string);
                LogicalDisk logicalDisk = computer.cmpLogicalDisk;
                while (logicalDisk != null) {
                    String string2;
                    this.setPhase();
                    if (computer.cmpOSType == 14) {
                        string2 = logicalDisk.ldPath.substring(9, 16);
                        string2 = String.valueOf(string2) + "/";
                        string2 = String.valueOf(string2) + logicalDisk.ldPath.substring(16);
                    } else {
                        string2 = logicalDisk.ldPath;
                    }
                    this.setString(this.selectStmt, string2);
                    this.stmtPhase = 3;
                    this.resultSet = this.selectStmt.executeQuery();
                    if (this.nextResult()) {
                        NameList nameList2 = new NameList();
                        this.getPhase();
                        nameList2.nlName = this.getString(this.resultSet);
                        if (computer.cmpOSType == 14) {
                            nameList2.nlName = nameList2.nlName.substring(8);
                        }
                        nameList2.nlID = this.getInt(this.resultSet);
                        nameList2.nlID2 = this.getInt(this.resultSet);
                        nameList2.nlNext = nameList;
                        nameList = nameList2;
                    }
                    logicalDisk = logicalDisk.ldNext;
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"selectHostLUNs", (Throwable)sQLException);
                }
                this.sqlError(sQLException);
            }
            this.closeSelect();
        } else {
            stringBuffer.append(" and v.serial_number like '");
            if (computer.cmpOSType == 12 || computer.cmpOSType == 25 || computer.cmpOSType == 27) {
                int n2 = computer.cmpNasFiler.nfName.indexOf(".");
                if (n2 > 0) {
                    stringBuffer.append(computer.cmpNasFiler.nfName.substring(n2 + 1));
                    n = computer.cmpNasFiler.nfName.length() - n2;
                } else {
                    stringBuffer.append("-1");
                }
            } else if (computer.cmpOSType == 21) {
                if (computer.cmpNasFiler.nfNetworkName != null) {
                    stringBuffer.append(computer.cmpNasFiler.nfNetworkName);
                    n = computer.cmpNasFiler.nfNetworkName.length() + 1;
                }
            } else if (computer.cmpOSType == 14) {
                if (computer.cmpNasFiler.nfManufacturer != null && computer.cmpNasFiler.nfManufacturer.length() > 1) {
                    if (computer.cmpNasFiler.nfManufacturer.toUpperCase().startsWith("HEWLETT")) {
                        stringBuffer.append(computer.cmpNasFiler.nfName);
                        n = computer.cmpNasFiler.nfName.length() + 1;
                    }
                } else {
                    int n3 = computer.cmpNasFiler.nfName.indexOf(".");
                    if (n3 > 0) {
                        String string3 = computer.cmpNasFiler.nfName.substring(n3 + 1);
                        if (string3.length() > 5) {
                            stringBuffer.append(string3.substring(4));
                        } else {
                            stringBuffer.append(Util.charToHex((String)string3, (int)4));
                        }
                        n = 5;
                    } else {
                        stringBuffer.append("-1");
                    }
                }
            } else {
                stringBuffer.append(computer.cmpNasFiler.nfName);
                n = computer.cmpNasFiler.nfName.length() + 1;
            }
            stringBuffer.append("/%'");
            string = stringBuffer.toString();
            stringBuffer = null;
            this.setSQLText(string);
            this.staticStmt = this.createStatement();
            this.stmtPhase = 3;
            try {
                this.resultSet = this.staticStmt.executeQuery(string);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"selectHostLUNs", (Throwable)sQLException);
                }
                this.sqlError(sQLException);
            }
            while (this.nextResult()) {
                this.getPhase();
                NameList nameList3 = new NameList();
                try {
                    nameList3.nlName = this.getString(this.resultSet);
                    nameList3.nlID = this.getInt(this.resultSet);
                    nameList3.nlID2 = this.getInt(this.resultSet);
                }
                catch (SQLException sQLException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"selectHostLUNs", (Throwable)sQLException);
                    }
                    this.sqlError(sQLException);
                }
                nameList3.nlName = nameList3.nlName.substring(n);
                nameList3.nlNext = nameList;
                nameList = nameList3;
            }
        }
        this.closeStaticStmt();
        string = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectHostLUNs", (Object)string);
        }
        return string;
    }

    public void getLogicalDiskID(Disk disk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getLogicalDiskID", (String)"disk");
        }
        disk.dskLogicalDiskID = -1;
        this.selectStmt = this.prepareStmt(SELECT_LUN_DEFINITION_GIVEN_DISK);
        this.execQueryByID(disk.devID);
        try {
            if (this.nextResult()) {
                this.getPhase();
                disk.dskLogicalDiskID = this.getInt(this.resultSet);
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getLogicalDiskID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getLogicalDiskID");
        }
    }

    public Share selectHostPaths(int n, boolean bl, boolean bl2) throws GeneralException {
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectHostPaths", (String)"logicalDiskID");
        }
        this.selectStmt = bl ? this.prepareStmt(SELECT_PATHS_FOR_SUBSYSTEM_DISK) : (bl2 ? this.prepareStmt(SELECT_PATHS_FOR_SVC_MDISK) : this.prepareStmt(SELECT_PATHS_FOR_HOST_DISK));
        try {
            this.setPhase();
            this.setInt(this.selectStmt, n);
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectHostPaths", (Throwable)sQLException);
            }
            this.stmtPhase = 3;
            this.sqlError(sQLException);
        }
        String string2 = null;
        while (this.nextResult()) {
            this.getPhase();
            try {
                string = this.getString(this.resultSet);
                String string3 = this.getString(this.resultSet);
                Share share = new Share();
                share.shResourceType = this.getShort(this.resultSet);
                share.shComputerName = Constants.isDiskArray((short)share.shResourceType) ? string3 : string;
                share.shPath = this.getString(this.resultSet);
                share.shNext = string2;
                string2 = share;
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"selectHostPaths", (Throwable)sQLException);
                }
                this.sqlError(sQLException);
            }
        }
        this.closeResultSet();
        this.closeSelect();
        string = string2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectHostPaths", (Object)string);
        }
        return string;
    }

    public void prepSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSave", (String)"");
        }
        this.insertStmt = this.prepareStmt(INSERT_DISK);
        this.updateStmt = this.prepareStmt(UPDATE_DISK);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSave");
        }
    }

    public void closeSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeSave", (String)"");
        }
        this.closeInsert();
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeSave");
        }
    }

    public void saveDisk(Disk disk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveDisk", (String)"disk");
        }
        try {
            if ((disk.devFlags & 4) == 0) {
                this.updateDisk(disk);
            } else {
                this.insertDisk(disk);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"saveDisk", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveDisk");
        }
    }

    private void insertDisk(Disk disk) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertDisk", (String)"disk");
        }
        this.stmtType = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.insertStmt, disk.devID);
        this.setInt(this.insertStmt, disk.dskHeads);
        this.setInt(this.insertStmt, disk.dskCylinders);
        this.setInt(this.insertStmt, disk.dskRPM);
        this.setDiskAttrs(this.insertStmt, disk);
        this.setByte(this.insertStmt, disk.dskIdentity);
        this.executeUpdate(this.insertStmt);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertDisk");
        }
    }

    private void setDiskAttrs(PreparedStatement preparedStatement, Disk disk) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setDiskAttrs", (String)"stmt, disk");
        }
        this.setInt(preparedStatement, disk.dskSectorSize);
        this.setInt(preparedStatement, disk.dskSectorsPerAvgTrack);
        this.setInt(preparedStatement, disk.dskSectorsPerOuterTrack);
        this.setInt(preparedStatement, disk.dskSectorsPerInnerTrack);
        this.setInt(preparedStatement, disk.dskLogicalBlockSize);
        this.setInt(preparedStatement, disk.dskMinutesPoweredOn);
        this.setBoolean(preparedStatement, disk.dskWriteProtected);
        this.setBoolean(preparedStatement, disk.dskWriteCacheEnabled);
        this.setBoolean(preparedStatement, disk.dskReadCacheDisabled);
        this.setBoolean(preparedStatement, disk.dskAutoWriteRealloc);
        this.setBoolean(preparedStatement, disk.dskAutoReadRealloc);
        this.setBoolean(preparedStatement, disk.dskNoErrorRecovery);
        this.setBoolean(preparedStatement, disk.dskFailurePredicted);
        this.setLong(preparedStatement, disk.dskCapacity);
        this.setInt(preparedStatement, disk.dskSpareBlocks);
        this.setInt(preparedStatement, disk.dskVolgroupID);
        this.setDiskDesired(preparedStatement, disk);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setDiskAttrs");
        }
    }

    private void setDiskDesired(PreparedStatement preparedStatement, Disk disk) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setDiskDesired", (String)"stmt, disk");
        }
        this.setByte(preparedStatement, disk.dskDesiredAWRE);
        this.setByte(preparedStatement, disk.dskDesiredARRE);
        this.setByte(preparedStatement, disk.dskDesiredNoErrRcvry);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setDiskDesired");
        }
    }

    private void updateDisk(Disk disk) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateDisk", (String)"disk");
        }
        this.stmtType = 2;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setDiskAttrs(this.updateStmt, disk);
        this.setByte(this.updateStmt, disk.dskIdentity);
        this.setInt(this.updateStmt, disk.devID);
        this.executeUpdate(this.updateStmt);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateDisk");
        }
    }

    public void updateDiskDesiredSettings(Disk disk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateDiskDesiredSettings", (String)"disk");
        }
        try {
            this.updateStmt = this.prepareStmt(UPDATE_DISK_DESIRED_SETTINGS);
            this.stmtType = 2;
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setDiskDesired(this.updateStmt, disk);
            this.setInt(this.updateStmt, disk.devID);
            this.executeUpdate(this.updateStmt);
            this.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateDiskDesiredSettings", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateDiskDesiredSettings");
        }
    }

    public void prepUpdateLogicalDiskID() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_LOGICAL_DISK_ID);
    }

    public int updateLogicalDiskID(int n, int n2, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateLogicalDiskID", (String)"diskID, logicalDiskID, doCommit");
        }
        int n3 = -1;
        this.setPhase();
        try {
            this.setInt(this.updateStmt, n2);
            this.setInt(this.updateStmt, n);
            n3 = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateLogicalDiskID", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (bl) {
            this.commit();
        }
        int n4 = n3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateLogicalDiskID", (int)n4);
        }
        return n4;
    }

    public void prepUpdateVolGroupID() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_VOLGROUP_ID);
    }

    public int updateVolGroupID(int n, int n2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateVolGroupID", (String)"diskID, VolGroupID");
        }
        int n3 = -1;
        this.setPhase();
        try {
            this.setInt(this.updateStmt, n2);
            this.setInt(this.updateStmt, n);
            n3 = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateVolGroupID", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        this.commit();
        int n4 = n3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateVolGroupID", (int)n4);
        }
        return n4;
    }

    public int updateSVCDiskIdentity(int n, byte by) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateSVCDiskIdentity", (String)"entityID, diskIdentity");
        }
        int n2 = -1;
        this.updateStmt = this.prepareStmt(UPDATE_SVC_DISK_IDENTITY);
        this.setPhase();
        try {
            this.setByte(this.updateStmt, by);
            this.setInt(this.updateStmt, n);
            n2 = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateSVCDiskIdentity", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        this.commit();
        int n3 = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateDiskIdentity", (int)n3);
        }
        return n3;
    }

    public void prepDelete() throws GeneralException {
        this.deleteStmt = this.prepareStmt(DELETE_DISK);
    }

    public void deleteDisk(Device device) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteDisk", (String)"device");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, device.devID);
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteDisk", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteDisk");
        }
    }
}

