/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.aperi.TStorm.common.PingHist;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TStormSettings;

public class TStatPingHist
extends StorageRepositoryAccessor {
    private Timestamp tsStart = new Timestamp(0L);
    private Timestamp tsEnd = new Timestamp(0L);
    Settings settings;
    PingHist accumulator;
    GregorianCalendar calendar;
    Date currentTime;
    private static final String SELECT_UNIQUE_ACCUMULATOR = "select computer_id, statistic_type, monitor_start, monitor_end, transmitted, received, damaged, min_transit_time, max_transit_time, avg_transit_time from t_stat_ping_hist where computer_id = ? and statistic_type = ?";
    private static final String SELECT_ACCUMULATOR = "select computer_id, statistic_type, monitor_start, monitor_end, transmitted, received, damaged, min_transit_time, max_transit_time, avg_transit_time from t_stat_ping_hist where statistic_type = ?";
    private static final String INSERT = "insert into t_stat_ping_hist (computer_id, statistic_type, monitor_start, monitor_end, transmitted, received, damaged, min_transit_time, max_transit_time, avg_transit_time) values (?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_ACCUMULATOR = "update t_stat_ping_hist set monitor_start = ?, monitor_end = ?, transmitted = ?, received = ?, damaged = ?, min_transit_time = ?, max_transit_time = ?, avg_transit_time = ? where computer_id = ? and statistic_type = ?";
    private static final String AGE_OFF_HIST = "delete from t_stat_ping_hist where monitor_end < ? and computer_id = ? and statistic_type = ?";

    public TStatPingHist(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TStatPingHist", (String)"dbc");
        }
        this.tableName = "t_stat_ping_hist";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TStatPingHist");
        }
    }

    public void prepSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSave", (String)"");
        }
        if (this.accumulator == null) {
            this.accumulator = new PingHist();
        }
        if (this.calendar == null) {
            this.calendar = new GregorianCalendar();
            this.currentTime = new Date();
        }
        TStormSettings tStormSettings = new TStormSettings(this.dbc);
        this.settings = tStormSettings.getSettings();
        tStormSettings.closeSelect();
        this.insertStmt = this.prepareStmt(INSERT);
        this.updateStmt = this.prepareStmt(UPDATE_ACCUMULATOR);
        this.selectStmt = this.prepareStmt(SELECT_UNIQUE_ACCUMULATOR);
        this.deleteStmt = this.prepareStmt(AGE_OFF_HIST);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSave");
        }
    }

    public void closeSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeSave", (String)"");
        }
        this.closeInsert();
        this.closeUpdate();
        this.closeSelect();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeSave");
        }
    }

    public void save(PingHist pingHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"save", (String)"pingHist");
        }
        if (pingHist.pngTransmitted > 0) {
            if (this.settings.sePingDailyHist > 0) {
                pingHist.pngStatisticType = 0;
                long l = pingHist.pngAvgTransitTime;
                if (pingHist.pngReceived > 0) {
                    pingHist.pngAvgTransitTime /= (long)pingHist.pngReceived;
                }
                this.insert(pingHist);
                pingHist.pngAvgTransitTime = l;
            }
            if (this.settings.sePingWeeklyHist > 0) {
                pingHist.pngStatisticType = (byte)3;
                this.updateAccumulator(pingHist);
            }
            if (this.settings.sePingMonthlyHist > 0) {
                pingHist.pngStatisticType = (byte)4;
                this.updateAccumulator(pingHist);
            }
            this.commit();
        }
        this.ageHist(pingHist);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"save");
        }
    }

    public void insert(PingHist pingHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"pingHist");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setKey(pingHist, this.insertStmt);
            this.setStats(pingHist, this.insertStmt);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    private void setStats(PingHist pingHist, PreparedStatement preparedStatement) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setStats", (String)"pingHist, stmt");
        }
        this.setTimestamp(preparedStatement, pingHist.pngMonitorStart, this.tsStart);
        this.setTimestamp(preparedStatement, pingHist.pngMonitorEnd, this.tsEnd);
        this.setInt(preparedStatement, pingHist.pngTransmitted);
        this.setInt(preparedStatement, pingHist.pngReceived);
        this.setInt(preparedStatement, pingHist.pngDamaged);
        this.setInt(preparedStatement, pingHist.pngMinTransitTime);
        this.setInt(preparedStatement, pingHist.pngMaxTransitTime);
        this.setLong(preparedStatement, pingHist.pngAvgTransitTime);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setStats");
        }
    }

    private void updateAccumulator(PingHist pingHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateAccumulator", (String)"pingHist");
        }
        boolean bl = false;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setKey(pingHist, this.selectStmt);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            bl = this.fetch(this.accumulator);
            this.closeResultSet(this.resultSet);
            if (bl) {
                this.accumulator.pngTransmitted += pingHist.pngTransmitted;
                this.accumulator.pngReceived += pingHist.pngReceived;
                this.accumulator.pngDamaged += pingHist.pngDamaged;
                this.accumulator.pngAvgTransitTime += pingHist.pngAvgTransitTime;
                if (this.accumulator.pngMinTransitTime > pingHist.pngMinTransitTime) {
                    this.accumulator.pngMinTransitTime = pingHist.pngMinTransitTime;
                }
                if (this.accumulator.pngMaxTransitTime < pingHist.pngMaxTransitTime) {
                    this.accumulator.pngMaxTransitTime = pingHist.pngMaxTransitTime;
                }
                if (this.accumulator.pngMonitorStart <= 86400000L) {
                    this.accumulator.pngMonitorStart = pingHist.pngMonitorStart;
                }
                this.accumulator.pngMonitorEnd = pingHist.pngMonitorEnd;
                this.update(this.accumulator);
            } else {
                this.insert(pingHist);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateAccumulator", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateAccumulator");
        }
    }

    private void setKey(PingHist pingHist, PreparedStatement preparedStatement) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setKey", (String)"pingHist, stmt");
        }
        this.setInt(preparedStatement, pingHist.pngComputerID);
        this.setByte(preparedStatement, pingHist.pngStatisticType);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setKey");
        }
    }

    public void update(PingHist pingHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"update", (String)"accumulator");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setStats(pingHist, this.updateStmt);
            this.setKey(pingHist, this.updateStmt);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"update", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"update");
        }
    }

    public boolean fetch(PingHist pingHist) throws GeneralException {
        block14: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"fetch", (String)"pingHist");
            }
            try {
                if (!this.nextResult(this.resultSet)) break block14;
                this.stmtPhase = 1;
                this.colIndex = 1;
                pingHist.pngComputerID = this.getInt(this.resultSet);
                pingHist.pngStatisticType = this.getByte(this.resultSet);
                pingHist.pngMonitorStart = this.getTimestamp(this.resultSet);
                pingHist.pngMonitorEnd = this.getTimestamp(this.resultSet);
                pingHist.pngTransmitted = this.getInt(this.resultSet);
                pingHist.pngReceived = this.getInt(this.resultSet);
                pingHist.pngDamaged = this.getInt(this.resultSet);
                pingHist.pngMinTransitTime = this.getInt(this.resultSet);
                pingHist.pngMaxTransitTime = this.getInt(this.resultSet);
                pingHist.pngAvgTransitTime = this.getLong(this.resultSet);
                boolean bl = true;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"fetch", (boolean)bl);
                }
                return bl;
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"fetch", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        boolean bl = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetch", (boolean)bl);
        }
        return bl;
    }

    private void ageHist(PingHist pingHist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ageHist", (String)"pingHist");
        }
        this.currentTime.setTime(pingHist.pngMonitorEnd);
        try {
            if (this.settings.sePingDailyHist != 0) {
                pingHist.pngStatisticType = 0;
                this.ageOff(pingHist, this.settings.sePingDailyHist, 5);
            }
            if (this.settings.sePingWeeklyHist != 0) {
                pingHist.pngStatisticType = 1;
                this.ageOff(pingHist, this.settings.sePingWeeklyHist * 7, 5);
            }
            if (this.settings.sePingMonthlyHist != 0) {
                pingHist.pngStatisticType = (byte)2;
                this.ageOff(pingHist, this.settings.sePingMonthlyHist, 2);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"ageHist", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ageHist");
        }
    }

    private void ageOff(PingHist pingHist, int n, int n2) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ageOff", (String)"pingHist, retention, calendarUnit");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.calendar.setTime(this.currentTime);
        this.calendar.add(n2, -n);
        this.setTimestamp(this.deleteStmt, this.calendar.getTime().getTime());
        this.setKey(pingHist, this.deleteStmt);
        this.executeUpdate(this.deleteStmt);
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ageOff");
        }
    }

    public void prepAverages(byte by) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepAverages", (String)"statisticType");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.updateStmt = this.prepareStmt(UPDATE_ACCUMULATOR);
        this.selectStmt = this.prepareStmt(SELECT_ACCUMULATOR);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setByte(this.selectStmt, by);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"prepAverages", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepAverages");
        }
    }

    public void closeAverages() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeAverages", (String)"");
        }
        this.closeInsert();
        this.closeUpdate();
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatPingHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeAverages");
        }
    }
}

