/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.agent.req.RunReq;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.backend.WindowsScript;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.JobUtils;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.SchRunNode;
import org.eclipse.aperi.scheduler.SchScheduleNode;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.scheduler.ScheduleRunning;
import org.eclipse.aperi.scheduler.ScheduleSubmitted;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.ScriptSubmitter;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.VMTransceiver;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.server.svp.SchedulerSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScheduleSubmit
extends TSThread {
    public ScheduleSubmit next;
    public boolean initialized;
    Connection connection;
    PreparedStatement runStmt;
    PreparedStatement nameStmt;
    public static PrintWriter logWriter;
    JobRun agentJobRun;
    Request agentRequest;
    Request scriptRequest;
    Response response;
    RunScriptReq scriptRun;
    AgentManager agentRoutine;
    ScheduleRunning runningRoutine;
    ScheduleSubmitted submittedRoutine;
    SchRunNode runPtr;
    SchScheduleNode schedulePtr;
    long delayLimit;
    long limitMillis;
    boolean checkingAgent;
    Object[] args = new Object[]{"update", "t_run_jobs", "ScheduleSubmit.run"};
    Object[] args2 = new Object[5];
    private String space = " ";

    public ScheduleSubmit(ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ScheduleSubmit", (String)"group, name");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ScheduleSubmit");
        }
    }

    public void run() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"");
        }
        logWriter = MessageLog.getThreadLog();
        MessageLog.setThreadLog((PrintWriter)logWriter);
        this.connection = Server.getConnection();
        this.delayLimit = SchCommon.delayLimit;
        if (this.connection == null) {
            MessageLog.logMessage((String)"JSS0006E", (Object[])this.args);
            SchCommon.stopped = true;
        } else {
            this.agentRoutine = Server.getAgentManager();
            this.runningRoutine = SchCommon.runningRoutine;
            this.submittedRoutine = SchCommon.submittedRoutine;
            try {
                this.runStmt = this.connection.prepareStatement("update t_run_jobs                                                                   set    submit_status  = -1                                                          where  job_run_number = ?");
                this.nameStmt = this.connection.prepareStatement("update t_run_jobs                                                                   set    log_file_name  = ?                                                           where  job_run_number = ?");
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"run", (Throwable)sQLException);
                }
                String string = SQLUtil.getSQLExceptionMsg("JSS0007E", sQLException, this.args);
                logWriter.println(string);
                SchCommon.stopped = true;
            }
            this.initialized = true;
            this.agentJobRun = new JobRun();
            this.agentRequest = new Request();
            this.agentRequest.typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
            this.agentRequest.subType = "org.eclipse.aperi.agent.handler.job.JavaJobHandler";
            this.agentRequest.serviceName = RequestTypeManager.getInternalName((String)"org.eclipse.aperi.agent.svp.AgentSvp");
            this.agentRequest.requestData = this.agentJobRun;
            this.scriptRun = new RunScriptReq();
            this.scriptRequest = new Request();
            this.scriptRequest.typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
            this.scriptRequest.subType = "org.eclipse.aperi.agent.handler.script.ScriptHandlerFactory";
            this.scriptRequest.serviceName = RequestTypeManager.getInternalName((String)"org.eclipse.aperi.agent.svp.AgentSvp");
            this.scriptRequest.requestData = this.scriptRun;
            this.args[0] = "insert";
            this.args[2] = "ScheduleSubmit.insertRun";
            while (!SchCommon.stopped) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                this.runPtr = null;
                while (this.runPtr == null && !SchCommon.stopped) {
                    this.runPtr = this.submittedRoutine.getNext(this.connection);
                    if (this.runPtr != null) continue;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) continue;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"run", (Throwable)interruptedException);
                    }
                }
                if (SchCommon.stopped) continue;
                this.schedulePtr = this.runPtr.back;
                boolean bl = ScheduleQueue.isInternal(this.schedulePtr.SID);
                boolean bl2 = bl ? true : this.insertRun();
                if (!bl2) {
                    this.cancelRun("JSS0011E");
                    continue;
                }
                try {
                    this.limitMillis = SQLUtil.getTimestamp(this.connection).getTime() - this.delayLimit;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"run", (Throwable)exception);
                    }
                    return;
                }
                if (this.runPtr.submitMillis < this.limitMillis && this.runPtr.submitMillis > 0L) {
                    this.runPtr.returnCode = 20;
                    this.cancelRun("JSS0012E");
                    continue;
                }
                this.checkingAgent = true;
                ConfigSettings configSettings = Server.getSettings();
                if (this.schedulePtr.jobType == 67) {
                    object4 = Server.agentMgr.getAgent(this.runPtr.CID);
                    if (object4 == null) {
                        this.runPtr.returnCode = 34;
                        this.cancelRun("JSS0046E");
                    } else {
                        this.scriptRun.setComputerID(this.runPtr.CID);
                        this.scriptRun.setRunNumber(this.runPtr.runNumber);
                        this.scriptRun.setSchedCreator(this.schedulePtr.creator);
                        this.scriptRun.setSchedName(this.schedulePtr.getTrueName());
                        this.scriptRun.setSchedRunNumber(this.schedulePtr.runNumber);
                        this.scriptRun.setJobName("script");
                        this.scriptRun.setRetention(configSettings.csRetainCopies);
                        this.scriptRun.setRetainDays(configSettings.csRetainDays);
                        this.scriptRun.scrArgv = new String[1];
                        this.scriptRun.scrArgv[0] = this.schedulePtr.scriptName;
                        object3 = new StringBuffer(120);
                        object2 = null;
                        if (Constants.isWindows((short)((AgentManager.AgentAddress)object4).osType)) {
                            object = JobUtil.resolveWindowsScript((String)this.schedulePtr.scriptName, (StringBuffer)object3);
                            if (object != null) {
                                if (((StringBuffer)object3).length() > 0) {
                                    this.scriptRun.scrExtension = ((StringBuffer)object3).toString();
                                }
                                ((StringBuffer)object3).setLength(0);
                                ((StringBuffer)object3).append(JobUtil.scriptsDir);
                                ((StringBuffer)object3).append(File.separatorChar);
                                ((StringBuffer)object3).append(((WindowsScript)object).wsResolvedName);
                                object2 = ((StringBuffer)object3).toString();
                            }
                        } else {
                            ((StringBuffer)object3).append(JobUtil.scriptsDir);
                            ((StringBuffer)object3).append(File.separatorChar);
                            if (JobUtil.resolveUnixScript((String)this.schedulePtr.scriptName, (StringBuffer)object3) != null) {
                                object2 = ((StringBuffer)object3).toString();
                            }
                        }
                        this.scriptRun.scrData = new byte[1][];
                        object = new MutableBoolean(true);
                        if (object2 != null) {
                            this.scriptRun.scrData[0] = ScriptSubmitter.loadFile((String)object2, (MutableBoolean)object);
                        }
                        if (!((MutableBoolean)object).value) {
                            this.cancelRun("JSS0073E");
                        } else {
                            this.response = Server.agentMgr.transmitToAgent(this.scriptRequest, null, this.runPtr.CID, false);
                            if (this.response != null && this.response.status <= 4) {
                                this.runPtr.logFileName = JobUtils.generateLogFileName((RunReq)this.scriptRun, null);
                                SchCommon.completeHdr.process(this.runPtr, null);
                                this.checkingAgent = false;
                            }
                        }
                    }
                } else {
                    this.runningRoutine.addRun(this.runPtr);
                    object4 = ResourceTypeManager.getAgentJobRunName((short)this.schedulePtr.jobType);
                    if (object4 != null && this.runPtr.CID != -999999998 && this.runPtr.CID != -999999997 && this.runPtr.CID != -999999999) {
                        this.agentRequest.subType = "org.eclipse.aperi.agent.handler.job.JavaJobHandler";
                        this.agentJobRun.setRunNumber(this.runPtr.runNumber);
                        this.agentJobRun.setRetention(configSettings.csRetainCopies);
                        this.agentJobRun.setRetainDays(configSettings.csRetainDays);
                        this.agentJobRun.setSchedCreator(this.schedulePtr.creator);
                        this.agentJobRun.setSchedName(this.schedulePtr.getTrueName());
                        this.agentJobRun.setSchedID(this.schedulePtr.SID);
                        this.agentJobRun.setSchedRunNumber(this.schedulePtr.runNumber);
                        this.agentJobRun.setJobName((String)object4);
                        this.agentJobRun.setCommandLine(ResourceTypeManager.getAgentJobRunCommand((short)this.schedulePtr.jobType));
                        if (this.runPtr.globalJob) {
                            this.agentJobRun.setDesiredStartTime(0L);
                        } else {
                            this.agentJobRun.setDesiredStartTime(this.runPtr.submitMillis);
                        }
                        this.response = this.agentRoutine.transmitToAgent(this.agentRequest, null, this.runPtr.CID, false);
                    } else {
                        object3 = this.schedulePtr.request;
                        if (object3 == null) {
                            object2 = new JobRun();
                            object2.setComputerList(this.schedulePtr.pingList);
                            object2.setRunNumber(this.runPtr.runNumber);
                            object2.setRetention(configSettings.csRetainCopies);
                            object2.setRetainDays(configSettings.csRetainDays);
                            object2.setSchedCreator(this.schedulePtr.creator);
                            object2.setSchedName(this.schedulePtr.getTrueName());
                            object2.setSchedID(this.schedulePtr.SID);
                            object2.setSchedRunNumber(this.schedulePtr.runNumber);
                            object3 = new Request();
                            ((Request)object3).typeCode = ResourceTypeManager.getServerJobRunRequestCode((short)this.schedulePtr.jobType);
                            ((Request)object3).subType = ResourceTypeManager.getServerJobRunHandlerCode((short)this.schedulePtr.jobType);
                            ((Request)object3).serviceName = RequestTypeManager.getInternalName((String)((Request)object3).typeCode);
                            ((Request)object3).requestData = object2;
                            if (this.schedulePtr.jobType == 16) {
                                if (this.runPtr.CID == -999999998) {
                                    object2.setJobName("probe_fabric");
                                    object2.setCommandLine("org.eclipse.aperi.server.jobs.ExecProbeFabric");
                                } else if (this.runPtr.CID == -999999997) {
                                    object2.setJobName("probe_tape");
                                    object2.setCommandLine("org.eclipse.aperi.server.jobs.ExecProbeTape");
                                } else {
                                    object2.setJobName("probe_ss");
                                    object2.setCommandLine("org.eclipse.aperi.server.jobs.ExecProbeSS");
                                }
                            } else {
                                object2.setJobName(ResourceTypeManager.getServerJobRunName((short)this.schedulePtr.jobType));
                                object = ResourceTypeManager.getServerJobRunCommand((short)this.schedulePtr.jobType);
                                object = String.valueOf(object) + this.space + this.schedulePtr.arguments;
                                if (this.schedulePtr.jobType == 17) {
                                    object = String.valueOf(object) + this.space + Integer.toString(this.schedulePtr.alertID);
                                }
                                object2.setCommandLine((String)object);
                            }
                        }
                        if ((((Request)object3).flags & 2) == 0) {
                            object2 = null;
                        } else {
                            object2 = ((Request)object3).requestData;
                            ((Request)object3).requestData = null;
                        }
                        object = new VMTransceiver();
                        this.response = object.transmitRequest((Request)object3, object2);
                        object.close();
                    }
                }
                if (!this.checkingAgent) continue;
                if (this.response == null) {
                    this.runPtr.returnCode = 16;
                    this.cancelRun("JSS0013E");
                } else if (this.response.status > 4) {
                    switch (this.response.status) {
                        case 28: {
                            this.runPtr.returnCode = 28;
                            break;
                        }
                        case 32: {
                            this.runPtr.returnCode = 32;
                            break;
                        }
                        case 34: {
                            this.runPtr.returnCode = 34;
                            break;
                        }
                        case 36: {
                            this.runPtr.returnCode = 36;
                            break;
                        }
                        default: {
                            this.runPtr.returnCode = 12;
                        }
                    }
                    this.cancelRun("JSS0046E");
                } else if (this.response.responseData != null && !bl) {
                    this.updateRow();
                }
                this.response = null;
            }
        }
        this.close();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run");
        }
    }

    private void cancelRun(String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"cancelRun", (String)"message");
        }
        this.checkingAgent = false;
        this.runningRoutine.getRun(this.runPtr.runNumber);
        this.args2[0] = Integer.toString(this.runPtr.runNumber);
        String string2 = null;
        if (this.runPtr.CID > 0) {
            string2 = this.agentRoutine.getAgentHostAddress(this.runPtr.CID);
        }
        if (string2 == null) {
            string2 = Integer.toString(this.runPtr.CID);
        }
        this.args2[1] = string2;
        this.args2[2] = Integer.toString(this.schedulePtr.runNumber);
        this.args2[3] = ResourceTypeManager.getJobName((short)this.schedulePtr.jobType);
        this.args2[4] = String.valueOf(this.schedulePtr.creator) + "." + this.schedulePtr.getName();
        MessageLog.logMessage((String)string, (Object[])this.args2);
        SchCommon.completeHdr.process(this.runPtr, null);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cancelRun");
        }
    }

    private boolean insertRun() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertRun", (String)"");
        }
        boolean bl = true;
        try {
            this.runStmt.setInt(1, this.runPtr.runNumber);
            this.runStmt.executeUpdate();
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insertRun", (Throwable)sQLException);
            }
            if (SchedulerSvp.connectBad(this.connection)) {
                SchCommon.stopped = true;
                SchCommon.bounceNeeded = true;
            }
            String string = SQLUtil.getSQLExceptionMsg("JSS0008E", sQLException, this.args);
            logWriter.println(string);
            bl = false;
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertRun", (boolean)bl2);
        }
        return bl2;
    }

    private void updateRow() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateRow", (String)"");
        }
        boolean bl = false;
        try {
            this.nameStmt.setString(1, this.response.responseData.toString());
            this.nameStmt.setInt(2, this.runPtr.runNumber);
            this.nameStmt.executeUpdate();
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateRow", (Throwable)sQLException);
            }
            bl = true;
        }
        if (!bl && this.schedulePtr.alertLogID > 0) {
            int n = this.schedulePtr.alertLogID;
            this.schedulePtr.alertLogID = -1;
            String string = JobUtils.generateLogFileName((RunReq)this.agentJobRun, null);
            TAlertLog tAlertLog = new TAlertLog(this.connection);
            try {
                tAlertLog.updateJobLogFile(n, string);
            }
            catch (GeneralException generalException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"updateRow", (Throwable)generalException);
                }
                bl = true;
            }
        }
        if (bl && SchedulerSvp.connectBad(this.connection)) {
            SchCommon.stopped = true;
            SchCommon.bounceNeeded = true;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateRow");
        }
    }

    private void close() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"close", (String)"");
        }
        if (this.runStmt != null) {
            block17: {
                try {
                    this.runStmt.close();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block17;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)sQLException);
                }
            }
            this.runStmt = null;
        }
        if (this.nameStmt != null) {
            block18: {
                try {
                    this.nameStmt.close();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block18;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)sQLException);
                }
            }
            this.nameStmt = null;
        }
        if (this.connection != null) {
            Server.returnConnection(this.connection);
            this.connection = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"close");
        }
    }

    protected void finalize() throws Throwable {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"finalize", (String)"");
        }
        this.close();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"finalize");
        }
    }
}

