/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StreamTokenizer;
import java.util.Properties;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.Transform;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ConfigParser {
    private final String CONTROLLER_SECTION = "controller";
    private final String REPOSITORY_SECTION = "repository";
    private final String LOGGING_SECTION = "logging";
    private final String HARDWARE_SECTION = "hardware";
    public static final String DELETE_DUPCOMPINFO = "delete";
    public static final String KEEP_DUPCOMPINFO = "keep";
    private String configFile;
    private String passwordFile;
    private String currentSection;
    private BufferedReader reader = null;
    private StreamTokenizer tokenizer;
    public String name;
    public String hostAlias;
    public String repositoryDriver;
    public String repositoryURL;
    public HardwareID hardwareID;
    public int connectionPoolSize = 5;
    public int listenerPort = 3123;
    public int agentErrorLimit = 0;
    public int messagesPerLog = 1000000;
    public int logsKept = 5;
    public short maxConnections = (short)200;
    public short routerThreads = 1;
    public short serviceThreads = (short)2;
    public String adminGroup = null;
    public boolean commEncrypted = false;
    public String dupCompInfo = "";
    public Properties repositoryProperties = new Properties();
    public boolean multipleMaintenance = false;

    public ConfigParser(String string, String string2) {
        this.configFile = string;
        this.passwordFile = string2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parse() {
        block20: {
            if (TraceLogger.enableTrace) {
                try {
                    v0 = Class.forName("org.eclipse.aperi.server.ConfigParser");
                }
                catch (ClassNotFoundException v1) {
                    throw new NoClassDefFoundError(v1.getMessage());
                }
                TraceLogger.entry((String)v0.getName(), (String)"parse", (String)"");
            }
            var1_1 = false;
            try {
                try {
                    this.initializeTokenizer();
                    this.tokenize();
                    var1_1 = true;
                }
                catch (Exception var2_2) {
                    if (TraceLogger.enableTrace) {
                        try {
                            v2 = Class.forName("org.eclipse.aperi.server.ConfigParser");
                        }
                        catch (ClassNotFoundException v3) {
                            throw new NoClassDefFoundError(v3.getMessage());
                        }
                        TraceLogger.exception((String)v2.getName(), (String)"parse", (Throwable)var2_2);
                    }
                    MessageLog.logException((String)"SRV0004E", (Exception)var2_2, (Object)this.configFile);
                }
            }
            catch (Throwable var4_3) {
                var3_4 = null;
                if (this.reader == null) throw var4_3;
                try {
                    this.reader.close();
                    throw var4_3;
                }
                catch (Exception var5_6) {
                    if (TraceLogger.enableTrace == false) throw var4_3;
                    try {
                        v4 = Class.forName("org.eclipse.aperi.server.ConfigParser");
                    }
                    catch (ClassNotFoundException v5) {
                        throw new NoClassDefFoundError(v5.getMessage());
                    }
                    TraceLogger.exception((String)v4.getName(), (String)"parse", (Throwable)var5_6);
                }
                throw var4_3;
            }
            {
                var3_5 = null;
                if (this.reader == null) break block20;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 116->126)] { 
lbl45:
            // 1 sources

            this.reader.close();
            break block20;
lbl47:
            // 1 sources

            catch (Exception var5_7) {
                if (!TraceLogger.enableTrace) break block20;
                try {}
                catch (ClassNotFoundException v6) {
                    throw new NoClassDefFoundError(v6.getMessage());
                }
                TraceLogger.exception((String)Class.forName("org.eclipse.aperi.server.ConfigParser").getName(), (String)"parse", (Throwable)var5_7);
            }
        }
        if (TraceLogger.enableTrace == false) return var1_1;
        try {
            v7 = Class.forName("org.eclipse.aperi.server.ConfigParser");
        }
        catch (ClassNotFoundException v8) {
            throw new NoClassDefFoundError(v8.getMessage());
        }
        TraceLogger.exit((String)v7.getName(), (String)"parse", (boolean)var1_1);
        return var1_1;
    }

    private void initializeTokenizer() throws Exception {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initializeTokenizer", (String)"");
        }
        this.reader = new BufferedReader(new FileReader(this.configFile));
        this.tokenizer = new StreamTokenizer(this.reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(47, 47);
        this.tokenizer.wordChars(92, 92);
        this.tokenizer.wordChars(46, 46);
        this.tokenizer.wordChars(95, 95);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(34);
        this.tokenizer.quoteChar(39);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.lowerCaseMode(false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initializeTokenizer");
        }
    }

    private void tokenize() throws Exception {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"tokenize", (String)"");
        }
        while (this.nextToken(false, 91) != -1) {
            this.nextToken(true, -3);
            String string = this.tokenizer.sval;
            this.nextToken(true, 93);
            if (string.equalsIgnoreCase("controller")) {
                this.currentSection = "controller";
                this.controllerSection();
                continue;
            }
            if (string.equalsIgnoreCase("logging")) {
                this.currentSection = "logging";
                this.loggingSection();
                continue;
            }
            if (string.equalsIgnoreCase("repository")) {
                this.currentSection = "repository";
                this.repositorySection();
                continue;
            }
            if (string.equalsIgnoreCase("hardware")) {
                this.currentSection = "hardware";
                this.hardwareSection();
                continue;
            }
            this.throwException("SRV0010E", string, null);
        }
        if (this.repositoryDriver == null || this.repositoryDriver.length() == 0) {
            this.throwException("SRV0003E", "repository", "driver");
        }
        if (this.repositoryURL == null || this.repositoryURL.length() == 0) {
            this.throwException("SRV0003E", "repository", "url");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"tokenize");
        }
    }

    private int nextToken(boolean bl, int n) throws Exception {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"nextToken", (String)"tokenRequired, expectedTokenType");
        }
        if (this.tokenizer.ttype != -1) {
            this.tokenizer.nextToken();
        }
        if (this.tokenizer.ttype == -1) {
            if (bl) {
                this.throwException("SRV0007E", null, null);
            }
        } else {
            if (this.tokenizer.ttype == 34 || this.tokenizer.ttype == 39) {
                this.tokenizer.ttype = -3;
            }
            if (n != 0 && n != this.tokenizer.ttype) {
                this.throwException("SRV0006E", this.tokenizer.toString(), null);
            }
        }
        int n2 = this.tokenizer.ttype;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"nextToken", (int)n2);
        }
        return n2;
    }

    private void controllerSection() throws Exception {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"controllerSection", (String)"");
        }
        String[] stringArray = new String[2];
        while (this.getKeyValuePair(stringArray)) {
            if (stringArray[0].equalsIgnoreCase("name")) {
                this.name = stringArray[1];
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("hostalias")) {
                this.hostAlias = stringArray[1];
                if (this.hostAlias == null) continue;
                this.hostAlias = this.hostAlias.toLowerCase();
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("port")) {
                this.listenerPort = this.stringToInt(stringArray);
                if (this.listenerPort >= 1) continue;
                this.throwException("SRV0008E", "controller", "port");
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("maxconnections")) {
                this.maxConnections = (short)this.stringToInt(stringArray);
                if (this.maxConnections >= 20) continue;
                this.throwException("SRV0008E", "controller", "maxConnections");
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("routerthreads")) {
                this.routerThreads = (short)this.stringToInt(stringArray);
                if (this.routerThreads >= 1) continue;
                this.throwException("SRV0008E", "controller", "routerThreads");
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("servicethreads")) {
                this.serviceThreads = (short)this.stringToInt(stringArray);
                if (this.serviceThreads >= 1) continue;
                this.throwException("SRV0008E", "controller", "serviceThreads");
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("agenterrorlimit")) {
                this.agentErrorLimit = this.stringToInt(stringArray);
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("admingroup")) {
                this.adminGroup = stringArray[1];
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("commencrypted")) {
                this.commEncrypted = this.stringToInt(stringArray) == 1;
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("dupCompInfo")) {
                this.dupCompInfo = stringArray[1];
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("multiplemaintenance")) {
                this.multipleMaintenance = true;
                continue;
            }
            this.throwException("SRV0009E", "controller", stringArray[0]);
        }
        if (this.name == null || this.name.length() == 0) {
            this.throwException("SRV0003E", "controller", "name");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"controllerSection");
        }
    }

    private void loggingSection() throws Exception {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"loggingSection", (String)"");
        }
        String[] stringArray = new String[2];
        while (this.getKeyValuePair(stringArray)) {
            if (stringArray[0].equalsIgnoreCase("logskept")) {
                this.logsKept = this.stringToInt(stringArray);
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("messagesperlog")) {
                this.messagesPerLog = this.stringToInt(stringArray);
                continue;
            }
            this.throwException("SRV0009E", "logging", stringArray[0]);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"loggingSection");
        }
    }

    private void repositorySection() throws Exception {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"repositorySection", (String)"");
        }
        String[] stringArray = new String[2];
        while (this.getKeyValuePair(stringArray)) {
            if (stringArray[0].equalsIgnoreCase("driver")) {
                this.repositoryDriver = stringArray[1];
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("url")) {
                this.repositoryURL = stringArray[1];
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("connectionpool")) {
                this.connectionPoolSize = this.stringToInt(stringArray);
                this.repositoryProperties.put(stringArray[0], stringArray[1]);
                if (this.connectionPoolSize >= 0) continue;
                this.throwException("SRV0008E", "repository", "connectionPool");
                continue;
            }
            this.repositoryProperties.put(stringArray[0], stringArray[1]);
        }
        if (this.passwordFile != null) {
            String string = Transform.getTransformed((String)this.passwordFile);
            if (string == null) {
                this.throwException("SRV0067E", this.passwordFile, null);
            }
            this.repositoryProperties.put("password", string);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"repositorySection");
        }
    }

    private void hardwareSection() throws Exception {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"hardwareSection", (String)"");
        }
        String string = null;
        String string2 = null;
        String[] stringArray = new String[2];
        while (this.getKeyValuePair(stringArray)) {
            if (stringArray[0].equalsIgnoreCase("manufacturer")) {
                string2 = stringArray[1];
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("hardwareid")) {
                string = stringArray[1];
                continue;
            }
            this.throwException("SRV0009E", "hardware", stringArray[0]);
        }
        if (string2 == null || string2.length() == 0) {
            this.throwException("SRV0003E", "hardware", "manufacturer");
        }
        if (string == null || string.length() == 0) {
            this.throwException("SRV0003E", "hardware", "hardwareid");
        }
        try {
            this.hardwareID = new HardwareID(string.getBytes(), string2);
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"hardwareSection", (Throwable)localizableException);
            }
            localizableException.print();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"hardwareSection");
            }
            throw new Exception();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"hardwareSection");
        }
    }

    private boolean getKeyValuePair(String[] stringArray) throws Exception {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getKeyValuePair", (String)"keyValuePair");
        }
        if (this.nextToken(false, 0) == -1) {
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getKeyValuePair", (boolean)bl);
            }
            return bl;
        }
        if (this.tokenizer.ttype == 91) {
            this.tokenizer.pushBack();
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getKeyValuePair", (boolean)bl);
            }
            return bl;
        }
        if (this.tokenizer.ttype != -3) {
            this.throwException("SRV0006E", this.tokenizer.toString(), null);
        }
        stringArray[0] = this.tokenizer.sval.toLowerCase();
        this.nextToken(true, 61);
        this.nextToken(true, -3);
        stringArray[1] = this.tokenizer.sval;
        boolean bl = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getKeyValuePair", (boolean)bl);
        }
        return bl;
    }

    private int stringToInt(String[] stringArray) throws Exception {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"stringToInt", (String)"keyValuePair");
        }
        try {
            int n = Integer.parseInt(stringArray[1]);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"stringToInt", (int)n);
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"stringToInt", (Throwable)numberFormatException);
            }
            this.throwException("SRV0008E", this.currentSection, stringArray[0]);
            int n = -1;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"stringToInt", (int)n);
            }
            return n;
        }
    }

    private void throwException(String string, String string2, String string3) throws Exception {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"throwException", (String)"msgId, parm1, parm2");
        }
        Object[] objectArray = new Object[]{string2, string3};
        String string4 = MessageLog.getMessage((String)string, (Object[])objectArray);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.ConfigParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"throwException");
        }
        throw new Exception(string4.substring("                         ".length()));
    }
}

