/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.alerts;

import java.sql.Connection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.server.alerts.StormAlerter;
import org.eclipse.aperi.server.guireq.AlertDefinition;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeAlerter
extends StormAlerter {
    private Computer oldComputer;
    private Computer computer;
    private Share missingDevList;
    private Share missingFSList;
    private Share missingVSList;
    private boolean isDiskArray;
    private short attributeType;
    private short computerType;
    private short groupType;
    private short clusterGroupType;
    private byte subProduct;

    public ProbeAlerter(Connection connection, Computer computer, Computer computer2, Share share, Share share2) {
        super(connection, computer2.cmpID);
        this.oldComputer = computer;
        this.computer = computer2;
        this.missingDevList = share;
        this.missingFSList = share2;
        this.isDiskArray = Constants.isDiskArray((short)computer2.cmpOSType);
        if (this.isDiskArray) {
            this.attributeType = (short)81;
            this.computerType = (short)78;
            this.groupType = (short)77;
            this.subProduct = 1;
            this.computerID = computer2.cmpID;
            this.hostName = computer2.cmpNasFiler.nfAlias;
        } else {
            this.attributeType = (short)26;
            this.computerType = 1;
            this.groupType = 0;
            this.clusterGroupType = (short)-1;
            this.subProduct = 0;
        }
    }

    public ProbeAlerter(Connection connection, int n) {
        super(connection, n);
        this.attributeType = (short)26;
        this.computerType = 1;
        this.groupType = 0;
        this.subProduct = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void alertVSRemoved(int n, Share share) throws GeneralException {
        block16: {
            block15: {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.entry((String)clazz.getName(), (String)"alertVSRemoved", (String)"clusterID, missingVSList");
                }
                this.clusterGroupType = (short)99;
                int n2 = n;
                this.missingVSList = share;
                try {
                    this.initAlertAccessor();
                    AlertDefinition[] alertDefinitionArray = this.alertAccessor.getByResource(this.computerType, -1, this.groupType, -1, this.clusterGroupType, n2, this.attributeType);
                    if (alertDefinitionArray == null) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz.getName(), (String)"alertVSRemoved");
                        }
                        Object var6_5 = null;
                        break block15;
                    }
                    int n3 = 0;
                    while (n3 < alertDefinitionArray.length) {
                        this.alertDef = alertDefinitionArray[n3];
                        if (this.alertDef.aldCondition == 74) {
                            this.checkVS_removed(n);
                        }
                        ++n3;
                    }
                    break block16;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.close();
                    throw throwable;
                }
            }
            this.close();
            return;
        }
        Object var6_7 = null;
        this.close();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"alertVSRemoved");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void alert() throws StorageException {
        block29: {
            block28: {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.entry((String)clazz.getName(), (String)"alert", (String)"");
                }
                try {
                    AlertDefinition[] alertDefinitionArray;
                    if (this.isDiskArray) {
                        this.initAlertAccessor();
                    } else {
                        this.dealWithFilesystems();
                    }
                    int n = this.oldComputer != null ? this.oldComputer.cmpGroupID : (this.isDiskArray ? 8 : 4);
                    int n2 = -1;
                    if (this.computer.cmpCluster != null) {
                        this.clusterGroupType = (short)99;
                        n2 = this.computer.cmpCluster.clusterID;
                    }
                    if ((alertDefinitionArray = this.alertAccessor.getByResource(this.computerType, this.computerID, this.groupType, n, this.clusterGroupType, n2, this.attributeType)) == null) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz.getName(), (String)"alert");
                        }
                        Object var5_4 = null;
                        break block28;
                    }
                    int n3 = 0;
                    while (n3 < alertDefinitionArray.length) {
                        this.alertDef = alertDefinitionArray[n3];
                        switch (this.alertDef.aldCondition) {
                            case 1: 
                            case 2: 
                            case 67: 
                            case 68: {
                                this.checkRAM();
                                break;
                            }
                            case 3: 
                            case 4: {
                                this.checkMemory();
                                break;
                            }
                            case 5: {
                                this.checkNewDisk();
                                break;
                            }
                            case 6: {
                                this.checkMissingDisk();
                                break;
                            }
                            case 7: 
                            case 24: {
                                this.checkDiskDefect();
                                break;
                            }
                            case 8: {
                                this.checkDiskFailure();
                                break;
                            }
                            case 9: {
                                this.checkNewFS();
                                break;
                            }
                            case 73: {
                                this.checkVS_added();
                                break;
                            }
                            case 75: {
                                this.checkVS_moved();
                                break;
                            }
                        }
                        ++n3;
                    }
                    break block29;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.close();
                    throw throwable;
                }
            }
            this.close();
            return;
        }
        Object var5_6 = null;
        this.close();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"alert");
        }
    }

    @Override
    protected boolean processFilesystemAlert(Filesystem filesystem) {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"processFilesystemAlert", (String)"fs");
        }
        if (!(bl = super.processFilesystemAlert(filesystem)) && this.alertDef.aldCondition == 10) {
            this.checkFSConfig(filesystem);
            bl = true;
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"processFilesystemAlert", (boolean)bl2);
        }
        return bl2;
    }

    private static Filesystem extractFromSorter(Map<MutableInteger, Filesystem> map) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"extractFromSorter", (String)"sorter");
        }
        Filesystem filesystem = null;
        for (Filesystem filesystem2 : map.values()) {
            filesystem2.fsNext = filesystem;
            filesystem = filesystem2;
        }
        Filesystem filesystem3 = filesystem;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"extractFromSorter", (Object)filesystem3);
        }
        return filesystem3;
    }

    private void dealWithFilesystems() throws StorageException {
        MutableInteger mutableInteger;
        Filesystem filesystem;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"dealWithFilesystems", (String)"");
        }
        TreeMap<MutableInteger, Filesystem> treeMap = new TreeMap<MutableInteger, Filesystem>();
        LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            filesystem = logicalDisk.ldFilesystem;
            if (filesystem != null) {
                mutableInteger = new MutableInteger(-filesystem.fsID);
                treeMap.put(mutableInteger, filesystem);
            }
            logicalDisk = logicalDisk.ldNext;
        }
        logicalDisk = ProbeAlerter.extractFromSorter(treeMap);
        treeMap.clear();
        Share share = this.missingFSList;
        Share share2 = this.missingFSList;
        while (share != null) {
            filesystem = (Filesystem)share.shResource;
            if (filesystem != null) {
                mutableInteger = new MutableInteger(-filesystem.fsID);
                treeMap.put(mutableInteger, filesystem);
            }
            share = share.shNext;
        }
        filesystem = ProbeAlerter.extractFromSorter(treeMap);
        treeMap = null;
        if (share2 != null && filesystem != null && share2.shComputerID != filesystem.fsComputerID) {
            TStatComputer tStatComputer = new TStatComputer(this.dbc);
            if (tStatComputer.isVirtualServer(share2.shComputerID)) {
                filesystem.fsComputerID = share2.shComputerID;
            }
            share2 = null;
        }
        this.initAlertAccessor();
        this.processFilesystemAlerts((Filesystem)logicalDisk, filesystem);
        if (this.alertAccessor != null) {
            this.alertAccessor.closeSelect();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"dealWithFilesystems");
        }
    }

    private void checkRAM() {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkRAM", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"checkRAM");
            }
            return;
        }
        boolean bl2 = bl = this.alertDef.aldCondition == 1 || this.alertDef.aldCondition == 67;
        if (this.computer.cmpRAM < this.oldComputer.cmpRAM && !bl || this.computer.cmpRAM > this.oldComputer.cmpRAM && bl) {
            this.initParms();
            this.setHostName();
            this.alertParms[1] = this.hostName;
            this.setNumParm(3, this.computer.cmpRAM, "MB");
            this.setNumParm(4, this.oldComputer.cmpRAM, "MB");
            this.setParmFromMsg(11, "STS0054I");
            this.setParmFromMsg(10, "ALR1055W");
            this.genAlert(this.computerID, this.computerType, 1, this.computer.cmpRAM, this.oldComputer.cmpRAM, this.subProduct, -1);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkRAM");
        }
    }

    private void checkMemory() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkMemory", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"checkMemory");
            }
            return;
        }
        int n = this.computer.cmpRAM + this.computer.cmpSwapSpace;
        int n2 = this.oldComputer.cmpRAM + this.oldComputer.cmpSwapSpace;
        if (n < n2 && this.alertDef.aldCondition == 4 || n > n2 && this.alertDef.aldCondition == 3) {
            this.initParms();
            this.setHostName();
            this.alertParms[1] = this.hostName;
            this.setNumParm(3, n, "MB");
            this.setNumParm(4, n2, "MB");
            this.setParmFromMsg(11, "STS0054I");
            this.setParmFromMsg(10, "ALR1056W");
            this.genAlert(this.computerID, (short)1, 2, n, n2);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkMemory");
        }
    }

    private void checkNewDisk() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkNewDisk", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"checkNewDisk");
            }
            return;
        }
        Device device = this.computer.cmpDevice;
        while (device != null) {
            if (device.devType == 0 && (device.devFlags & 4) != 0) {
                this.initParms();
                this.setHostName();
                if (this.isDiskArray && this.computer.cmpNasFiler.nfAlias != null) {
                    this.alertParms[20] = this.hostName;
                }
                this.alertParms[1] = this.getDiskName(device);
                this.setParmFromMsg(11, "STS0066I");
                this.setParmFromMsg(10, "ALR1057W");
                this.genAlert(device.devID, (short)10, 3, -1, -1, this.subProduct, -1);
            }
            device = device.devNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkNewDisk");
        }
    }

    private void checkMissingDisk() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkMissingDisk", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"checkMissingDisk");
            }
            return;
        }
        Share share = this.missingDevList;
        while (share != null) {
            if (share.shResource != null) {
                Device device = (Device)share.shResource;
                this.initParms();
                this.setHostName();
                if (this.isDiskArray && this.computer.cmpNasFiler.nfAlias != null) {
                    this.alertParms[20] = this.hostName;
                }
                this.alertParms[1] = this.getDiskName(device);
                this.setParmFromMsg(11, "STS0066I");
                this.setParmFromMsg(10, "ALR1058W");
                this.genAlert(device.devID, (short)10, 4, -1, -1, this.subProduct, -1);
            }
            share = share.shNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkMissingDisk");
        }
    }

    private void checkDiskDefect() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkDiskDefect", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"checkDiskDefect");
            }
            return;
        }
        Device device = this.computer.cmpDevice;
        while (device != null) {
            if (device.devType == 0) {
                Disk disk = (Disk)device;
                DiskHistory diskHistory = disk.dskHistory;
                if (diskHistory != null && diskHistory.dkhGrownDefects > diskHistory.dkhOldGrownDefects && (this.alertDef.aldCondition != 24 || diskHistory.dkhGrownDefects > this.alertDef.aldThresholdValue)) {
                    this.initParms();
                    this.setHostName();
                    if (this.alertDef.aldCondition == 24) {
                        this.setNumParm(2, this.alertDef.aldThresholdValue, (String)null);
                    }
                    this.setNumParm(3, diskHistory.dkhGrownDefects, (String)null);
                    this.setNumParm(4, diskHistory.dkhOldGrownDefects, (String)null);
                    this.alertParms[1] = this.getDiskName(device);
                    this.setParmFromMsg(11, "STS0066I");
                    this.setParmFromMsg(10, "ALR1059W");
                    this.genAlert(device.devID, (short)10, 5, diskHistory.dkhGrownDefects, diskHistory.dkhOldGrownDefects);
                }
            }
            device = device.devNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkDiskDefect");
        }
    }

    private void checkDiskFailure() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkDiskFailure", (String)"");
        }
        Device device = this.computer.cmpDevice;
        while (device != null) {
            if (device.devType == 0) {
                Disk disk = (Disk)device;
                if (disk.dskFailurePredicted) {
                    this.initParms();
                    this.setHostName();
                    this.alertParms[1] = this.getDiskName(device);
                    this.setParmFromMsg(11, "STS0066I");
                    this.setParmFromMsg(10, "ALR1060W");
                    this.genAlert(device.devID, (short)10, 6, -1, -1);
                }
            }
            device = device.devNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkDiskFailure");
        }
    }

    private void checkNewFS() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkNewFS", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"checkNewFS");
            }
            return;
        }
        LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            if (logicalDisk.ldFilesystem != null && logicalDisk.ldFilesystem.fsNewFilesystem) {
                Filesystem filesystem = logicalDisk.ldFilesystem;
                this.initParms();
                this.setHostName();
                this.alertParms[1] = filesystem.fsMountPoint;
                this.alertParms[11] = "filesystem";
                this.setParmFromMsg(10, "ALR1061W");
                this.genAlert(filesystem.fsID, (short)3, 7, -1, -1);
            }
            logicalDisk = logicalDisk.ldNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkNewFS");
        }
    }

    private void checkFSConfig(Filesystem filesystem) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkFSConfig", (String)"fs");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"checkFSConfig");
            }
            return;
        }
        if (!filesystem.fsLogicalDisk.ldNewLogicalDisk || filesystem.fsNewFilesystem) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"checkFSConfig");
            }
            return;
        }
        this.initParms();
        this.setHostName();
        this.alertParms[1] = filesystem.fsMountPoint;
        this.alertParms[11] = "filesystem";
        this.setParmFromMsg(10, "ALR1063W");
        this.genAlert(filesystem.fsID, (short)3, 9, -1, -1);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkFSConfig");
        }
    }

    private void checkVS_added() throws StorageException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkVS_added", (String)"");
        }
        if (Constants.isVirtualServer((int)this.computer.cmpOSType) && this.computer.cmpNewVS) {
            this.processVirtualServerAlerts(this.computer, this.oldComputer);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkVS_added");
        }
    }

    private void checkVS_moved() throws StorageException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkVS_moved", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"checkVS_moved");
            }
            return;
        }
        if (Constants.isVirtualServer((int)this.computer.cmpOSType) && this.computer.cmpClusterID == this.oldComputer.cmpClusterID && this.computer.cmpNodeHostedID != this.oldComputer.cmpNodeHostedID) {
            this.processVirtualServerAlerts(this.computer, this.oldComputer);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkVS_moved");
        }
    }

    private void checkVS_removed(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkVS_removed", (String)"clusterID");
        }
        this.processVirtualServerRemovedAlert(this.missingVSList.shResourceID, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.ProbeAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkVS_removed");
        }
    }

    private String getDiskName(Device device) {
        return new StringBuffer(String.valueOf(device.devManufacturer)).append('/').append(device.devSerialNumber).toString();
    }
}

