/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.req.CimomManagedDeviceReq;
import org.eclipse.aperi.xmsg.MessageLog;

public class CimomManagedDeviceHndlr
implements RequestHandler,
ThreadSafe {
    Connection dbc = null;

    public Response handle(Request request, Transceiver transceiver) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.CimomManagedDeviceHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, comm");
        }
        Response response = Response.getResponse((short)0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.server.req.CimomManagedDeviceReq");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.CimomManagedDeviceHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"handle", (Object)response);
            }
            return response;
        }
        CimomManagedDeviceReq cimomManagedDeviceReq = (CimomManagedDeviceReq)request.requestData;
        this.dbc = Server.getConnection();
        if (this.dbc == null) {
            Server.setResponseError(response, "GEN0050E");
        } else {
            try {
                cimomManagedDeviceReq.list = this.getCimomManagedDevices(cimomManagedDeviceReq.cimomID);
                response.responseData = cimomManagedDeviceReq;
            }
            catch (SQLException sQLException) {
                Server.setResponseError(response, "SRV0712E", sQLException);
            }
            Server.returnConnection(this.dbc);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.CimomManagedDeviceHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz4.getName(), (String)"handle", (Object)response);
        }
        return response;
    }

    private ArrayList getCimomManagedDevices(String string) throws SQLException {
        ArrayList<CimomManagedDeviceReq.CimomManagedDevice> arrayList = new ArrayList<CimomManagedDeviceReq.CimomManagedDevice>();
        PreparedStatement preparedStatement = null;
        String string2 = null;
        try {
            CimomManagedDeviceReq.CimomManagedDevice cimomManagedDevice;
            int n;
            string2 = "select SYS.DISPLAY_NAME, SYS.TYPE, SYS.IP_ADDRESS from T_RES_CIMOM2NAMESPACE as C2N, T_RES_REGISTERED_CIMOM as RC, T_RES_CIMKEY_SUBSYSTEM as CKS, T_RES_STORAGE_SUBSYSTEM as SYS where C2N.CIMOM_ID = RC.REG_CIMOM_ID and C2N.CIM_NAMESPACE_ID = CKS.CIM_NAMESPACE_ID and CKS.SUBSYSTEM_ID = SYS.SUBSYSTEM_ID and RC.REG_CIMOM_ID = ?";
            preparedStatement = this.dbc.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.execute();
            ResultSet resultSet = preparedStatement.getResultSet();
            while (resultSet.next()) {
                n = 1;
                cimomManagedDevice = new CimomManagedDeviceReq.CimomManagedDevice(new CimomManagedDeviceReq());
                cimomManagedDevice.display_name = resultSet.getString(n++);
                cimomManagedDevice.ss_type = resultSet.getString(n++);
                cimomManagedDevice.ip_address = resultSet.getString(n);
                arrayList.add(cimomManagedDevice);
            }
            string2 = "select SW.DISPLAY_NAME, SW.IP_ADDRESS, SW.LOGICAL_NAME, SW.SWITCH_WWN from T_RES_CIMOM2NAMESPACE as C2N, T_RES_REGISTERED_CIMOM as RC, T_RES_CIMKEY_SWITCH as CKS, T_RES_SWITCH as SW where C2N.CIMOM_ID = RC.REG_CIMOM_ID and C2N.CIM_NAMESPACE_ID = CKS.CIM_NAMESPACE_ID and CKS.SWITCH_WWN = SW.SWITCH_WWN and RC.REG_CIMOM_ID = ?";
            preparedStatement = this.dbc.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.execute();
            resultSet = preparedStatement.getResultSet();
            while (resultSet.next()) {
                n = 1;
                cimomManagedDevice = new CimomManagedDeviceReq.CimomManagedDevice(new CimomManagedDeviceReq());
                cimomManagedDevice.display_name = resultSet.getString(n++);
                cimomManagedDevice.ip_address = resultSet.getString(n++);
                cimomManagedDevice.logical_name = resultSet.getString(n++);
                cimomManagedDevice.wwn = resultSet.getString(n);
                cimomManagedDevice.ss_type = "Switch";
                arrayList.add(cimomManagedDevice);
            }
            string2 = "select TL.DISPLAY_NAME from T_RES_CIMOM2NAMESPACE as C2N, T_RES_REGISTERED_CIMOM as RC, T_RES_CIMKEY_TAPE_LIBRARY as CKT, T_RES_TAPE_LIBRARY as TL where C2N.CIMOM_ID = RC.REG_CIMOM_ID and C2N.CIM_NAMESPACE_ID = CKT.CIM_NAMESPACE_ID and CKT.TAPE_LIBRARY_ID = TL.TAPE_LIBRARY_ID and RC.REG_CIMOM_ID = ?";
            preparedStatement = this.dbc.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.execute();
            resultSet = preparedStatement.getResultSet();
            while (resultSet.next()) {
                CimomManagedDeviceReq.CimomManagedDevice cimomManagedDevice2 = new CimomManagedDeviceReq.CimomManagedDevice(new CimomManagedDeviceReq());
                cimomManagedDevice2.display_name = resultSet.getString(1);
                cimomManagedDevice2.ss_type = "Tape Library";
                arrayList.add(cimomManagedDevice2);
            }
        }
        catch (SQLException sQLException) {
            Object[] objectArray = new String[]{string2, "(" + string + ")"};
            MessageLog.logMessage((String)"DBA0140I", (Object[])objectArray);
            sQLException.printStackTrace(MessageLog.getThreadLog());
            throw sQLException;
        }
        preparedStatement.close();
        return arrayList;
    }
}

