/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TBatchReport;
import org.eclipse.aperi.repository.table.TChartSettings;
import org.eclipse.aperi.repository.table.TSchedule;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.gui.GuiBatchReportHndlr;

public class ReportDeleteHndlr
implements RequestHandler,
ThrowAway {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.ReportDeleteHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, transceiver");
        }
        Response response2 = Response.getResponse((short)0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.common.NameList");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (RequestChecker.isDesiredType(clazz, (Request)request, (Response)response2)) {
            response = (NameList)request.requestData;
            int n = response.nlID;
            Connection connection = Server.getConnection();
            if (connection == null) {
                Server.setResponseError(response2, "GEN0050E");
            } else {
                String string = Integer.toString(n);
                try {
                    try {
                        LockManager.lock((short)0, (String)"REPORT", (String)string, (byte)1, (boolean)true);
                        TBatchReport tBatchReport = new TBatchReport(connection);
                        tBatchReport.delete(n, false);
                        TChartSettings tChartSettings = new TChartSettings(connection);
                        tChartSettings.delete_batch(n);
                        TSchedule tSchedule = new TSchedule(connection);
                        ScheduleHeader scheduleHeader = new ScheduleHeader();
                        scheduleHeader.ID = n;
                        tSchedule.retrieve(scheduleHeader, GuiBatchReportHndlr.JOB_TYPE_LABEL);
                        if (scheduleHeader.alertID > 0) {
                            Alerter.deleteAlert(connection, scheduleHeader.alertID, false);
                        }
                        tSchedule.deleteByID(n, GuiBatchReportHndlr.JOB_TYPE_LABEL, true);
                        tSchedule.commit();
                    }
                    catch (GeneralException generalException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz3;
                            try {
                                clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.ReportDeleteHndlr");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz3.getName(), (String)"handle", (Throwable)generalException);
                        }
                        Server.setResponseError(response2, (Exception)((Object)generalException));
                    }
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    LockManager.unLock((short)0, (String)"REPORT", (String)string);
                    Server.returnConnection(connection);
                    throw throwable;
                }
                {
                    Object var12_15 = null;
                }
                LockManager.unLock((short)0, (String)"REPORT", (String)string);
                Server.returnConnection(connection);
                ScheduleQueue.routine.addDelete(n);
            }
        }
        response = response2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.ReportDeleteHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz4.getName(), (String)"handle", (Object)response);
        }
        return response;
    }
}

