/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.nas;

import java.sql.Connection;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.agentreq.ManNasReq;
import org.eclipse.aperi.TStorm.server.guireq.RespManNas;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.FilerSaver;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResLdapTree;
import org.eclipse.aperi.repository.table.TResPwd;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.repository.table.TSnmpCommunity;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.agent.DiscoveryHndlr;
import org.eclipse.aperi.server.handler.gui.GuiListHndlr;
import org.eclipse.aperi.server.svp.AgentSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class NasGuiManEntryHndlr
implements RequestHandler,
ThrowAway {
    private Response response;
    private Connection dbc;
    private ManNasReq manNasReq;
    private NameList communities;
    private TSnmpCommunity snmpAccessor;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"NasGuiManEntryHndlr", (String)"handle", (String)"request, transceiver");
        }
        this.response = Response.getResponse((short)12, null);
        this.dbc = Server.getConnection();
        if (this.dbc == null) {
            Server.setResponseError(this.response, "GEN0050E");
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)"NasGuiManEntryHndlr", (String)"handle", (Object)this.response);
            }
            return this.response;
        }
        try {
            try {
                if (request.requestData instanceof RespManNas) {
                    this.delMan(request);
                } else {
                    this.addMan(request);
                }
                if (this.response.status <= 4) {
                    GuiListHndlr.getManNasList(this.dbc, this.response);
                }
            }
            catch (GeneralException generalException) {
                try {
                    this.dbc.rollback();
                }
                catch (Exception exception) {}
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)"NasGuiManEntryHndlr", (String)"handle", (Throwable)generalException);
                }
                Server.setResponseError(this.response, (Exception)((Object)generalException));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Server.returnConnection(this.dbc);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        Server.returnConnection(this.dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"NasGuiManEntryHndlr", (String)"handle", (Object)this.response);
        }
        return this.response;
    }

    private void delMan(Request request) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"NasGuiManEntryHndlr", (String)"delMan", (String)"request");
        }
        RespManNas respManNas = (RespManNas)request.requestData;
        Share share = new Share();
        share.shComputerID = respManNas.mnComputerID;
        share.shResourceID = respManNas.mnResourceID;
        share.shResourceType = (short)103;
        FilerSaver filerSaver = new FilerSaver(this.dbc, respManNas.mnComputerID);
        filerSaver.removeFilers(share, false);
        this.response.status = 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"NasGuiManEntryHndlr", (String)"delMan");
        }
    }

    private void addMan(Request request) throws GeneralException {
        TResLdapTree tResLdapTree;
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"NasGuiManEntryHndlr", (String)"addMan", (String)"request");
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.TStorm.server.agentreq.ManNasReq");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)this.response)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)"NasGuiManEntryHndlr", (String)"addMan");
            }
            return;
        }
        this.manNasReq = (ManNasReq)request.requestData;
        boolean bl = this.manNasReq.mnRejectNonRoot = !AgentSvp.saveNonRootExports;
        if (this.manNasReq.mnAddNas) {
            this.snmpAccessor = new TSnmpCommunity(this.dbc);
            this.communities = this.snmpAccessor.getCommunities();
            if (Util.isEmpty((String)this.manNasReq.mnCommunityName)) {
                this.manNasReq.mnCommunities = this.communities;
            } else {
                this.manNasReq.mnCommunities = new NameList();
                this.manNasReq.mnCommunities.nlName = this.manNasReq.mnCommunityName;
            }
            this.manNasReq.mnNasVendors = DiscoveryHndlr.getNasConfigFile();
        } else {
            tResLdapTree = new TResLdapTree(this.dbc);
            tResLdapTree.prepGetByName();
            this.manNasReq.mnLdapTree = tResLdapTree.getByName(this.manNasReq.mnTreeName);
        }
        this.manNasReq.pack();
        tResLdapTree = new Request();
        ((Request)tResLdapTree).typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
        ((Request)tResLdapTree).subType = "org.eclipse.aperi.agent.handler.nas.ManNasConfigHandler";
        ((Request)tResLdapTree).serviceName = RequestTypeManager.getInternalName((String)((Request)tResLdapTree).typeCode);
        ((Request)tResLdapTree).userName = request.userName;
        ((Request)tResLdapTree).flags = 0;
        ((Request)tResLdapTree).requestData = this.manNasReq;
        AgentManager agentManager = Server.getAgentManager();
        Response response = agentManager.transmitToAgent((Request)tResLdapTree, null, this.manNasReq.mnAgentID, false, 7200);
        if (response == null) {
            Server.setResponseError(this.response, "NAS0003E", agentManager.getAgentName(this.manNasReq.mnAgentID));
        } else if (response.status > 4) {
            this.response = response;
        } else {
            this.response = response;
            this.manNasReq = (ManNasReq)response.responseData;
            this.manNasReq.unpack();
            short s = this.response.status;
            this.response.status = (short)12;
            this.saveFiler();
            this.response.status = s;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"NasGuiManEntryHndlr", (String)"addMan");
        }
    }

    private void saveFiler() throws GeneralException {
        int n;
        Object object;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"NasGuiManEntryHndlr", (String)"saveFiler", (String)"");
        }
        NasFiler nasFiler = this.manNasReq.mnFiler;
        if (this.manNasReq.mnAddNas) {
            nasFiler.nfName = nasFiler.nfName.toLowerCase();
            if (this.manNasReq.mnIsWindows) {
                object = new TResDomain(this.dbc);
                ((TResDomain)object).getIDs(nasFiler.nfComputer.cmpDomain);
                n = nasFiler.nfComputer.cmpDomain.domID;
                if (this.checkDup(nasFiler)) {
                    throw new GeneralException(MessageLog.getMessage((String)"NAS0023E", (Object)this.manNasReq.mnNetworkName));
                }
            } else {
                n = this.manNasReq.mnAgentID;
            }
        } else {
            n = this.manNasReq.mnLdapTree.ltTreeID;
            if (this.checkDup(nasFiler)) {
                throw new GeneralException(MessageLog.getMessage((String)"NAS0024E", (Object)this.manNasReq.mnNetworkName));
            }
        }
        object = new FilerSaver(this.dbc, n, 103, false, null, "Not Used");
        ((FilerSaver)object).saveDiscoveryData(nasFiler);
        if (!Util.isEmpty((String)this.manNasReq.mnCommunityName)) {
            NameList nameList = this.communities;
            while (nameList != null) {
                if (nameList.nlName.equalsIgnoreCase(this.manNasReq.mnCommunityName)) break;
                nameList = nameList.nlNext;
            }
            if (nameList == null) {
                this.snmpAccessor.insert(this.manNasReq.mnCommunities, false);
                this.snmpAccessor.closeInsert();
            }
        }
        if (this.manNasReq.mnAddNas && this.manNasReq.mnIsWindows) {
            this.savePassword(nasFiler);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"NasGuiManEntryHndlr", (String)"saveFiler");
        }
    }

    private boolean checkDup(NasFiler nasFiler) throws GeneralException {
        int n = 0;
        TResComputer tResComputer = new TResComputer(this.dbc);
        int n2 = tResComputer.selectCID(nasFiler.nfName);
        tResComputer.closeSelect();
        if (n2 > 0) {
            TResShare tResShare = new TResShare(this.dbc);
            tResShare.prepGetWindowsManShareCount(this.manNasReq.mnAddNas);
            n = tResShare.getWindowsManShareCount(n2);
            tResShare.closeSelect();
        }
        return n > 0;
    }

    private void savePassword(NasFiler nasFiler) throws GeneralException {
        TResPwd tResPwd = new TResPwd(this.dbc);
        tResPwd.prepLoginUpdate();
        tResPwd.updateLogin(nasFiler.nfComputerID, this.manNasReq.mnUserid, this.manNasReq.mnPassword, true);
        tResPwd.closeLoginUpdate();
    }
}

