/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.tape;

import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.gui.tape.common.model.GUICartridge;
import org.eclipse.aperi.gui.tape.common.model.GUIDrive;
import org.eclipse.aperi.gui.tape.common.model.GUIException;
import org.eclipse.aperi.gui.tape.common.model.GUIFrame;
import org.eclipse.aperi.gui.tape.common.model.GUIIOPort;
import org.eclipse.aperi.gui.tape.common.model.GUILibrary;
import org.eclipse.aperi.gui.tape.common.model.GUIMediaChanger;
import org.eclipse.aperi.gui.tape.common.model.TapeLibraryDBHelper;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.tape.api.ITapeReportingService;

public class GUIEntityFactory {
    private static final String[] CARTRIDGE_DB_ATTRIBUTES = new String[]{"PHYSICAL_LABEL", "CAPACITY", "MEDIA_TYPE", "CLEANER_MEDIA", "DUAL_SIDED", "LOCATION_ID", "MEDIA_DESCRIPTION"};
    private static final String[] DRIVE_DB_ATTRIBUTES = new String[]{"DISPLAY_NAME", "CONSOLIDATED_STATUS", "NEEDS_CLEANING", "MOUNT_COUNT", "FIRMWARE_VERSION", "DETECTABLE"};
    private static final String[] FRAME_DB_ATTRIBUTES = new String[]{"MODEL_ID", "VENDOR_ID", "SERIAL_NUMBER", "LOCK_PRESENT", "IS_LOCKED", "SECURITY_BREACH"};
    private static final String[] IO_PORT_DB_ATTRIBUTES = new String[]{"DEVICE_ID", "ELEMENT_NAME", "DESCRIPTION", "EXTENDED"};
    private static final String[] LIBRARY_DB_ATTRIBUTES = new String[]{"TAPE_LIBRARY_ID", "DISPLAY_NAME", "USER_PROVIDED_NAME", "CONSOLIDATED_STATUS", "DESCRIPTION", "MAX_CARTRIDGES", "PRIMARY_OWNER_NAME", "PRIMARY_OWNER_CONTACT", "FIRMWARE_VERSION", "ACCESS_INFO", "USER_ATTRIB1", "USER_ATTRIB2", "USER_ATTRIB3", "DETECTABLE"};
    private static final String[] MEDIA_CHANGER_DB_ATTRIBUTES = new String[]{"ELEMENT_NAME", "CONSOLIDATED_STATUS", "MEDIA_FLIP_SUPPORTED", "NODE_ID", "FIRMWARE_VERSION", "DETECTABLE"};
    private static GUIEntityFactory factory = null;

    private static GUICartridge createCartridgeInstance(HashMap hashMap, String string) {
        GUICartridge gUICartridge = new GUICartridge();
        GUIEntityFactory.populateCartridgeInstance(gUICartridge, hashMap, string);
        return gUICartridge;
    }

    private static void populateCartridgeInstance(GUICartridge gUICartridge, HashMap hashMap, String string) {
        Object object;
        String string2 = String.valueOf(hashMap.get("PHYSICAL_LABEL"));
        long l = (Long)hashMap.get("CAPACITY");
        String string3 = String.valueOf(hashMap.get("MEDIA_TYPE"));
        boolean bl = ((Short)hashMap.get("CLEANER_MEDIA")).intValue() != 0;
        boolean bl2 = ((Short)hashMap.get("DUAL_SIDED")).intValue() != 0;
        String string4 = String.valueOf(hashMap.get("MEDIA_DESCRIPTION"));
        String[] stringArray = null;
        String[] stringArray2 = new String[]{"LOCATION_COORDINATES"};
        HashMap[] hashMapArray = null;
        try {
            Class<?> clazz;
            object = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(object);
            try {
                clazz = Class.forName("org.eclipse.aperi.tape.api.ITapeReportingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            ITapeReportingService iTapeReportingService = (ITapeReportingService)ConnectorClient.getService((String)object.deviceServerHost, (int)object.deviceServerPort, clazz, (String)"TapeManagerService");
            stringArray = iTapeReportingService.getComponentLocation(4, new String[]{string});
            hashMapArray = iTapeReportingService.getComponentAttributes(6, stringArray, stringArray2);
        }
        catch (RemoteException remoteException) {}
        object = "" + hashMapArray[0].get("LOCATION_COORDINATES");
        gUICartridge.setId(string);
        gUICartridge.setLabel(string2);
        gUICartridge.setCapacity(l);
        gUICartridge.setType(string3);
        gUICartridge.setCleanerMedia(bl);
        gUICartridge.setDualSided(bl2);
        gUICartridge.setLocation((String)object);
        gUICartridge.setDescription(string4);
    }

    private static GUIDrive createDriveInstance(HashMap hashMap, String string) {
        GUIDrive gUIDrive = new GUIDrive();
        GUIEntityFactory.populateDriveInstance(gUIDrive, hashMap, string);
        return gUIDrive;
    }

    private static void populateDriveInstance(GUIDrive gUIDrive, HashMap hashMap, String string) {
        String string2 = String.valueOf(hashMap.get("DISPLAY_NAME"));
        short s = (Short)hashMap.get("CONSOLIDATED_STATUS");
        boolean bl = ((Short)hashMap.get("NEEDS_CLEANING")).intValue() != 0;
        long l = (Long)hashMap.get("MOUNT_COUNT");
        String string3 = (String)hashMap.get("FIRMWARE_VERSION");
        boolean bl2 = (Short)hashMap.get("DETECTABLE") != 0;
        try {
            String string4;
            Class<?> clazz;
            DeviceRequest deviceRequest = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.tape.api.ITapeReportingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            ITapeReportingService iTapeReportingService = (ITapeReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"TapeManagerService");
            String[] stringArray = new String[]{"NAME"};
            String[] stringArray2 = iTapeReportingService.getComponentNodes(1, new String[]{string});
            HashMap[] hashMapArray = iTapeReportingService.getComponentAttributes(9, stringArray2, stringArray);
            String string5 = hashMapArray[0].get("NAME").toString();
            String[] stringArray3 = new String[]{"LOCATION_COORDINATES", "MEDIATYPESSUPPORTED", "LOCATION_ID"};
            String[] stringArray4 = iTapeReportingService.getComponentLocation(1, new String[]{string});
            HashMap[] hashMapArray2 = iTapeReportingService.getComponentAttributes(6, stringArray4, stringArray3);
            String string6 = hashMapArray2[0].get("LOCATION_COORDINATES").toString();
            String string7 = ((Integer)hashMapArray2[0].get("LOCATION_ID")).toString();
            String string8 = hashMapArray2[0].get("MEDIATYPESSUPPORTED").toString();
            String string9 = DBConstants.getValueFromKey((String)"TAPE_MEDIA_TYPE_SUPPORTED", (String)string8);
            String[] stringArray5 = new String[]{"PHYSICAL_LABEL"};
            String string10 = string4 = iTapeReportingService.getCartrigeAttrByLocationID(string7, stringArray5);
            gUIDrive.setId(string);
            gUIDrive.setName(string2);
            gUIDrive.setState((int)s);
            gUIDrive.setNeedsCleaning(bl);
            gUIDrive.setMounts(l);
            gUIDrive.setWwpn(string5);
            gUIDrive.setVersion(string3);
            gUIDrive.setLocation(string6);
            gUIDrive.setDetectable(bl2);
            gUIDrive.setMediaTypeSupported(string9);
            gUIDrive.setCartridge_Label(string10);
        }
        catch (RemoteException remoteException) {}
    }

    private static GUIFrame createFrameInstance(HashMap hashMap, String string) {
        GUIFrame gUIFrame = new GUIFrame();
        GUIEntityFactory.populateFrameInstance(gUIFrame, hashMap, string);
        return gUIFrame;
    }

    private static void populateFrameInstance(GUIFrame gUIFrame, HashMap hashMap, String string) {
        String string2 = (String)hashMap.get("MODEL_ID");
        String string3 = (String)hashMap.get("VENDOR_ID");
        String string4 = (String)hashMap.get("SERIAL_NUMBER");
        boolean bl = (Short)hashMap.get("LOCK_PRESENT") != 0;
        boolean bl2 = (Short)hashMap.get("IS_LOCKED") != 0;
        String string5 = (String)hashMap.get("SECURITY_BREACH");
        gUIFrame.setId(string);
        gUIFrame.setType(string2);
        gUIFrame.setVendor(string3);
        gUIFrame.setSerialNumber(string4);
        gUIFrame.setLocked(bl2);
        gUIFrame.setLockPresent(bl);
        gUIFrame.setSecurity(string5);
    }

    private static GUIIOPort createIOPortInstance(HashMap hashMap, String string) {
        GUIIOPort gUIIOPort = new GUIIOPort();
        GUIEntityFactory.populateIOPortInstance(gUIIOPort, hashMap, string);
        return gUIIOPort;
    }

    private static void populateIOPortInstance(GUIIOPort gUIIOPort, HashMap hashMap, String string) {
        String string2 = String.valueOf(hashMap.get("DEVICE_ID"));
        String string3 = String.valueOf(hashMap.get("ELEMENT_NAME"));
        boolean bl = ((Short)hashMap.get("EXTENDED")).intValue() != 0;
        String string4 = String.valueOf(hashMap.get("DESCRIPTION"));
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        try {
            String string9;
            Class<?> clazz;
            DeviceRequest deviceRequest = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.tape.api.ITapeReportingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            ITapeReportingService iTapeReportingService = (ITapeReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"TapeManagerService");
            String[] stringArray = new String[]{"LOCATION_COORDINATES", "MEDIATYPESSUPPORTED", "LOCATION_ID"};
            String[] stringArray2 = iTapeReportingService.getComponentLocation(3, new String[]{string});
            HashMap[] hashMapArray = iTapeReportingService.getComponentAttributes(6, stringArray2, stringArray);
            string5 = hashMapArray[0].get("LOCATION_COORDINATES").toString();
            String string10 = ((Integer)hashMapArray[0].get("LOCATION_ID")).toString();
            string6 = hashMapArray[0].get("MEDIATYPESSUPPORTED").toString();
            string7 = DBConstants.getValueFromKey((String)"TAPE_MEDIA_TYPE_SUPPORTED", (String)string6);
            String[] stringArray3 = new String[]{"PHYSICAL_LABEL"};
            string8 = string9 = iTapeReportingService.getCartrigeAttrByLocationID(string10, stringArray3);
        }
        catch (RemoteException remoteException) {}
        gUIIOPort.setId(string2);
        gUIIOPort.setName(string3);
        gUIIOPort.setDescription(string4);
        gUIIOPort.setExtended(bl);
        gUIIOPort.setLocation(string5);
        gUIIOPort.setMediaTypeSupported(string7);
        gUIIOPort.setCartridge_Label(string8);
    }

    private static GUILibrary createLibraryInstance(HashMap hashMap, String string) {
        GUILibrary gUILibrary = new GUILibrary();
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        HashMap hashMap5 = new HashMap();
        int n5 = (Integer)hashMap.get("TAPE_LIBRARY_ID");
        String string2 = (String)hashMap.get("DISPLAY_NAME");
        String string3 = (String)hashMap.get("USER_PROVIDED_NAME");
        short s = (Short)hashMap.get("CONSOLIDATED_STATUS");
        int n6 = (Integer)hashMap.get("MAX_CARTRIDGES");
        String string4 = (String)hashMap.get("DESCRIPTION");
        String string5 = (String)hashMap.get("PRIMARY_OWNER_NAME");
        String string6 = (String)hashMap.get("PRIMARY_OWNER_CONTACT");
        String string7 = (String)hashMap.get("FIRMWARE_VERSION");
        String string8 = (String)hashMap.get("ACCESS_INFO");
        String string9 = (String)hashMap.get("USER_ATTRIB1");
        String string10 = (String)hashMap.get("USER_ATTRIB2");
        String string11 = (String)hashMap.get("USER_ATTRIB3");
        boolean bl = (Short)hashMap.get("DETECTABLE") != 0;
        try {
            Class<?> clazz;
            DeviceRequest deviceRequest = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.tape.api.ITapeReportingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            ITapeReportingService iTapeReportingService = (ITapeReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"TapeManagerService");
            stringArray = iTapeReportingService.getComponents(1, string, hashMap2);
            n = stringArray.length;
            stringArray3 = iTapeReportingService.getComponents(4, string, hashMap4);
            n3 = stringArray3.length;
            stringArray2 = iTapeReportingService.getComponents(2, string, hashMap3);
            n2 = stringArray2.length;
            stringArray4 = iTapeReportingService.getComponents(3, string, hashMap5);
            n4 = stringArray4.length;
        }
        catch (RemoteException remoteException) {}
        int n7 = 1;
        gUILibrary.setId(string);
        gUILibrary.setDisplayName(string2);
        gUILibrary.setState((int)s);
        gUILibrary.setDrives(n);
        gUILibrary.setCatridges(n3);
        gUILibrary.setCatridgeCapacity(n6);
        gUILibrary.setType(n7);
        gUILibrary.setDescription(string4);
        gUILibrary.setOwnerName(string5);
        gUILibrary.setOwnerContact(string6);
        gUILibrary.setMediaChangers(n2);
        gUILibrary.setIoPorts(n4);
        gUILibrary.setVersion(string7);
        gUILibrary.setElementManager(string8);
        gUILibrary.setDetectable(bl);
        gUILibrary.setUserProvidedName(string3);
        gUILibrary.setUserAttrib1(string9);
        gUILibrary.setUserAttrib2(string10);
        gUILibrary.setUserAttrib3(string11);
        gUILibrary.setInternalId(n5);
        return gUILibrary;
    }

    private static GUIMediaChanger createMediaChangerInstance(HashMap hashMap, String string) {
        GUIMediaChanger gUIMediaChanger = new GUIMediaChanger();
        GUIEntityFactory.populateMediaChangerInstance(gUIMediaChanger, hashMap, string);
        return gUIMediaChanger;
    }

    private static void populateMediaChangerInstance(GUIMediaChanger gUIMediaChanger, HashMap hashMap, String string) {
        String string2 = String.valueOf(hashMap.get("ELEMENT_NAME"));
        short s = (Short)hashMap.get("CONSOLIDATED_STATUS");
        boolean bl = ((Short)hashMap.get("MEDIA_FLIP_SUPPORTED")).intValue() != 0;
        Integer cfr_ignored_0 = (Integer)hashMap.get("NODE_ID");
        String string3 = (String)hashMap.get("FIRMWARE_VERSION");
        boolean bl2 = (Short)hashMap.get("DETECTABLE") != 0;
        String string4 = null;
        try {
            ITapeReportingService iTapeReportingService = GUIEntityFactory.getTapeReportingService();
            String[] stringArray = new String[]{"NAME"};
            String[] stringArray2 = iTapeReportingService.getComponentNodes(2, new String[]{string});
            HashMap[] hashMapArray = iTapeReportingService.getComponentAttributes(9, stringArray2, stringArray);
            string4 = hashMapArray[0].get("NAME").toString();
        }
        catch (RemoteException remoteException) {}
        gUIMediaChanger.setId(string);
        gUIMediaChanger.setName(string2);
        gUIMediaChanger.setState((int)s);
        gUIMediaChanger.setMediaFlipSupported(bl);
        gUIMediaChanger.setWwpn(string4);
        gUIMediaChanger.setVersion(string3);
        gUIMediaChanger.setDetectable(bl2);
    }

    public static GUIEntityFactory getInstance() {
        if (factory == null) {
            factory = new GUIEntityFactory();
        }
        return factory;
    }

    protected static ITapeReportingService getTapeReportingService() {
        Class<?> clazz;
        DeviceRequest deviceRequest = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
        try {
            clazz = Class.forName("org.eclipse.aperi.tape.api.ITapeReportingService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ITapeReportingService iTapeReportingService = (ITapeReportingService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"TapeManagerService");
        return iTapeReportingService;
    }

    public HashMap getAllTapeLibraries() throws GUIException {
        HashMap hashMap = null;
        try {
            ITapeReportingService iTapeReportingService = GUIEntityFactory.getTapeReportingService();
            String[] stringArray = iTapeReportingService.getTapeLibraries();
            hashMap = this.getTapeLibraries(stringArray);
        }
        catch (RemoteException remoteException) {}
        return hashMap;
    }

    public HashMap getTapeLibraries(String[] stringArray) throws GUIException {
        HashMap<String, GUILibrary> hashMap;
        block4: {
            ITapeReportingService iTapeReportingService = GUIEntityFactory.getTapeReportingService();
            hashMap = new HashMap<String, GUILibrary>();
            try {
                HashMap[] hashMapArray;
                if (stringArray == null || stringArray.length <= 0 || (hashMapArray = iTapeReportingService.getTapeLibraryAttributes(stringArray, LIBRARY_DB_ATTRIBUTES)) == null || hashMapArray.length <= 0) break block4;
                if (hashMapArray.length == stringArray.length) {
                    int n = 0;
                    while (n < hashMapArray.length) {
                        HashMap hashMap2 = hashMapArray[n];
                        GUILibrary gUILibrary = GUIEntityFactory.createLibraryInstance(hashMap2, stringArray[n]);
                        hashMap.put(gUILibrary.getId(), gUILibrary);
                        ++n;
                    }
                    break block4;
                }
                throw new RuntimeException("Tape Libraries mismatch error!");
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    public HashMap getLibraryDetails(String string) throws GUIException {
        String[] stringArray = this.getFrameIdsByLibrary(string);
        return this.getFrames(string, stringArray);
    }

    public int deleteTapeLibrary(String string) throws GUIException {
        TapeLibraryDBHelper tapeLibraryDBHelper = new TapeLibraryDBHelper();
        return tapeLibraryDBHelper.deleteLibrary(string);
    }

    public int setLibraryAttributes(String string, Hashtable hashtable) throws Exception {
        TapeLibraryDBHelper tapeLibraryDBHelper = new TapeLibraryDBHelper();
        return tapeLibraryDBHelper.saveProperties(string, hashtable);
    }

    public String[] getDriveIdsByLibrary(String string) throws GUIException {
        ITapeReportingService iTapeReportingService = GUIEntityFactory.getTapeReportingService();
        String[] stringArray = null;
        try {
            HashMap hashMap = new HashMap();
            stringArray = iTapeReportingService.getComponents(1, string, hashMap);
        }
        catch (RemoteException remoteException) {}
        return stringArray;
    }

    public HashMap getDrives(String string, String[] stringArray) throws GUIException {
        ITapeReportingService iTapeReportingService = GUIEntityFactory.getTapeReportingService();
        HashMap<String, GUIDrive> hashMap = new HashMap<String, GUIDrive>();
        try {
            if (stringArray != null && stringArray.length > 0) {
                HashMap[] hashMapArray = null;
                hashMapArray = iTapeReportingService.getComponentAttributes(1, stringArray, DRIVE_DB_ATTRIBUTES);
                if (hashMapArray != null && hashMapArray.length > 0 && hashMapArray.length == stringArray.length) {
                    int n = 0;
                    while (n < hashMapArray.length) {
                        HashMap hashMap2 = hashMapArray[n];
                        GUIDrive gUIDrive = GUIEntityFactory.createDriveInstance(hashMap2, stringArray[n]);
                        hashMap.put(gUIDrive.getId(), gUIDrive);
                        ++n;
                    }
                }
            }
        }
        catch (RemoteException remoteException) {}
        return hashMap;
    }

    public HashMap getDrivesByLibrary(String string) throws GUIException {
        String[] stringArray = this.getDriveIdsByLibrary(string);
        return this.getDrives(string, stringArray);
    }

    public String[] getMediaChangersIdsByLibrary(String string) throws GUIException {
        ITapeReportingService iTapeReportingService = GUIEntityFactory.getTapeReportingService();
        String[] stringArray = null;
        try {
            HashMap hashMap = new HashMap();
            stringArray = iTapeReportingService.getComponents(2, string, hashMap);
        }
        catch (RemoteException remoteException) {}
        return stringArray;
    }

    public HashMap getMediaChangers(String string, String[] stringArray) throws GUIException {
        ITapeReportingService iTapeReportingService = GUIEntityFactory.getTapeReportingService();
        HashMap<String, GUIMediaChanger> hashMap = new HashMap<String, GUIMediaChanger>();
        try {
            HashMap[] hashMapArray;
            if (stringArray != null && stringArray.length > 0 && (hashMapArray = iTapeReportingService.getComponentAttributes(2, stringArray, MEDIA_CHANGER_DB_ATTRIBUTES)) != null && hashMapArray.length > 0 && hashMapArray.length == stringArray.length) {
                int n = 0;
                while (n < hashMapArray.length) {
                    HashMap hashMap2 = hashMapArray[n];
                    GUIMediaChanger gUIMediaChanger = GUIEntityFactory.createMediaChangerInstance(hashMap2, stringArray[n]);
                    hashMap.put(gUIMediaChanger.getId(), gUIMediaChanger);
                    ++n;
                }
            }
        }
        catch (RemoteException remoteException) {}
        return hashMap;
    }

    public HashMap getMediaChangersByLibrary(String string) throws GUIException {
        String[] stringArray = this.getMediaChangersIdsByLibrary(string);
        return this.getMediaChangers(string, stringArray);
    }

    public String[] getIoPortIdsByLibrary(String string) throws GUIException {
        ITapeReportingService iTapeReportingService = GUIEntityFactory.getTapeReportingService();
        String[] stringArray = null;
        try {
            HashMap hashMap = new HashMap();
            stringArray = iTapeReportingService.getComponents(3, string, hashMap);
        }
        catch (RemoteException remoteException) {}
        return stringArray;
    }

    public HashMap getIoPorts(String string, String[] stringArray) throws GUIException {
        ITapeReportingService iTapeReportingService = GUIEntityFactory.getTapeReportingService();
        HashMap<String, GUIIOPort> hashMap = new HashMap<String, GUIIOPort>();
        try {
            HashMap[] hashMapArray;
            if (stringArray != null && stringArray.length > 0 && (hashMapArray = iTapeReportingService.getComponentAttributes(3, stringArray, IO_PORT_DB_ATTRIBUTES)) != null && hashMapArray.length > 0 && hashMapArray.length == stringArray.length) {
                int n = 0;
                while (n < hashMapArray.length) {
                    HashMap hashMap2 = hashMapArray[n];
                    GUIIOPort gUIIOPort = GUIEntityFactory.createIOPortInstance(hashMap2, stringArray[n]);
                    hashMap.put(gUIIOPort.getId(), gUIIOPort);
                    ++n;
                }
            }
        }
        catch (RemoteException remoteException) {}
        return hashMap;
    }

    public HashMap getIoPortsByLibrary(String string) throws GUIException {
        String[] stringArray = this.getIoPortIdsByLibrary(string);
        return this.getIoPorts(string, stringArray);
    }

    public String[] getCartridgesIdsByLibrary(String string) throws GUIException {
        ITapeReportingService iTapeReportingService = GUIEntityFactory.getTapeReportingService();
        String[] stringArray = null;
        try {
            HashMap hashMap = new HashMap();
            stringArray = iTapeReportingService.getComponents(4, string, hashMap);
        }
        catch (RemoteException remoteException) {}
        return stringArray;
    }

    public HashMap getCartridges(String string, String[] stringArray) throws GUIException {
        ITapeReportingService iTapeReportingService = GUIEntityFactory.getTapeReportingService();
        HashMap<String, GUICartridge> hashMap = new HashMap<String, GUICartridge>();
        try {
            HashMap[] hashMapArray;
            if (stringArray != null && stringArray.length > 0 && (hashMapArray = iTapeReportingService.getComponentAttributes(4, stringArray, CARTRIDGE_DB_ATTRIBUTES)) != null && hashMapArray.length > 0 && hashMapArray.length == stringArray.length) {
                int n = 0;
                while (n < hashMapArray.length) {
                    HashMap hashMap2 = hashMapArray[n];
                    GUICartridge gUICartridge = GUIEntityFactory.createCartridgeInstance(hashMap2, stringArray[n]);
                    hashMap.put(gUICartridge.getId(), gUICartridge);
                    ++n;
                }
            }
        }
        catch (RemoteException remoteException) {}
        return hashMap;
    }

    public HashMap getCartridgesByLibrary(String string) throws GUIException {
        String[] stringArray = this.getCartridgesIdsByLibrary(string);
        return this.getCartridges(string, stringArray);
    }

    public String[] getFrameIdsByLibrary(String string) throws GUIException {
        ITapeReportingService iTapeReportingService = GUIEntityFactory.getTapeReportingService();
        String[] stringArray = null;
        try {
            HashMap hashMap = new HashMap();
            stringArray = iTapeReportingService.getComponents(5, string, hashMap);
        }
        catch (RemoteException remoteException) {}
        return stringArray;
    }

    public HashMap getFrames(String string, String[] stringArray) throws GUIException {
        ITapeReportingService iTapeReportingService = GUIEntityFactory.getTapeReportingService();
        HashMap<String, GUIFrame> hashMap = new HashMap<String, GUIFrame>();
        try {
            HashMap[] hashMapArray;
            if (stringArray != null && stringArray.length > 0 && (hashMapArray = iTapeReportingService.getComponentAttributes(5, stringArray, FRAME_DB_ATTRIBUTES)) != null && hashMapArray.length > 0 && hashMapArray.length == stringArray.length) {
                int n = 0;
                while (n < hashMapArray.length) {
                    HashMap hashMap2 = hashMapArray[n];
                    GUIFrame gUIFrame = GUIEntityFactory.createFrameInstance(hashMap2, stringArray[n]);
                    hashMap.put(gUIFrame.getId(), gUIFrame);
                    ++n;
                }
            }
        }
        catch (RemoteException remoteException) {}
        return hashMap;
    }

    public HashMap getFramesByLibrary(String string) throws GUIException {
        String[] stringArray = this.getFrameIdsByLibrary(string);
        return this.getFrames(string, stringArray);
    }
}

