/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import java.util.Hashtable;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.discovery.RemoveMissingProcessor;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TResFabric;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;
import org.eclipse.aperi.xmsg.MessageLog;

public class ExecProbeFabric
implements ServerJob {
    private JobRun jobRun;
    private Connection dbc;

    public ExecProbeFabric(Connection connection) {
        this.initialize(connection);
    }

    public ExecProbeFabric() {
    }

    public void initialize(Connection connection) {
        this.dbc = connection;
    }

    public int run(VMJobResults vMJobResults, String[] stringArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.ExecProbeFabric");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"job, parms");
        }
        this.jobRun = vMJobResults.getJobRun();
        String[] stringArray2 = this.getAllFabricBySchedID(this.jobRun.getSchedID());
        int n = this.probeFabric(stringArray2);
        if (n == 0) {
            MessageLog.logMessage((String)"GEN0401I");
        } else if (n == 4) {
            MessageLog.logMessage((String)"GEN0402W");
        } else {
            MessageLog.logMessage((String)"GEN0400E");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.ExecProbeFabric");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run", (int)n);
        }
        return n;
    }

    private int probeFabric(String[] stringArray) {
        AsyncResult asyncResult;
        String string;
        Class<?> clazz;
        Class<?> clazz2;
        DeviceRequest deviceRequest = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
        try {
            clazz2 = Class.forName("org.eclipse.aperi.common.api.IJobMgmtService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IJobMgmtService iJobMgmtService = (IJobMgmtService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz2, (String)"FabricManagerService");
        if (iJobMgmtService == null) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.common.api.IJobMgmtService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            MessageLog.logMessage((String)"SRV0450E", (Object)clazz3.getName());
            return 8;
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.interfaces.IDiscover");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IDiscover iDiscover = (IDiscover)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"DiscoverService");
        if (iDiscover == null) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.interfaces.IDiscover");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            MessageLog.logMessage((String)"SRV0450E", (Object)clazz4.getName());
            return 8;
        }
        String string2 = "probeFabric";
        try {
            Class<?> clazz5;
            String string3 = this.jobRun.getSchedCreator();
            string = this.jobRun.getSchedName();
            String string4 = this.jobRun.getFormattedRunNumberSchedID();
            String string5 = this.jobRun.getJobName();
            try {
                clazz5 = Class.forName("org.eclipse.aperi.fabric.api.IFabricManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            asyncResult = (AsyncResult)iDiscover.invoke(string3, string, string4, string5, "FabricManagerService", clazz5.getName(), "probeFabrics", new Object[]{stringArray});
        }
        catch (Exception exception) {
            MessageLog.logException((String)"SRV0451E", (Exception)exception, (Object)string2);
            exception.printStackTrace();
            return 8;
        }
        catch (Throwable throwable) {
            MessageLog.logException((String)"SRV0451E", (Exception)new Exception(throwable), (Object)string2);
            throwable.printStackTrace();
            return 8;
        }
        int n = DeviceJobHndlr.completeDeviceJob(iJobMgmtService, asyncResult, string2, this.jobRun.getSchedID(), this.jobRun.getSchedRunNumber(), deviceRequest.deviceServerID);
        string = new RemoveMissingProcessor();
        string.performScheduledFabricDeletion();
        return n;
    }

    private String[] getAllFabricBySchedID(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.ExecProbeFabric");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"probeFabric", (String)"scheduleID");
        }
        TResFabric tResFabric = new TResFabric();
        String[] stringArray = null;
        try {
            NameList nameList;
            GuiListReq guiListReq = new GuiListReq();
            NameList nameList2 = tResFabric.getFabricTiedTo(n);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            int n2 = 0;
            while (nameList2 != null) {
                if (nameList2.nlInfo == 114) {
                    if (hashtable.put(nameList2.nlName, "FABRICID") == null) {
                        ++n2;
                    }
                } else {
                    guiListReq.groupID = nameList2.nlID;
                    nameList = tResFabric.selectNames(guiListReq);
                    while (nameList != null) {
                        if (hashtable.put(nameList.nlName, "FABRICID") == null) {
                            ++n2;
                        }
                        nameList = nameList.nlNext;
                    }
                }
                nameList2 = nameList2.nlNext;
            }
            stringArray = new String[n2];
            nameList = hashtable.keys();
            int n3 = 0;
            while (nameList.hasMoreElements()) {
                stringArray[n3++] = (String)nameList.nextElement();
            }
        }
        catch (GeneralException generalException) {
            MessageLog.logException((String)"SRV0451E", (Exception)((Object)generalException), (Object)"probeFabric");
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.ExecProbeFabric");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"probeFabric", (Object)"scheduleID");
            }
            return null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.ExecProbeFabric");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"probeFabric", (String)"scheduleID");
        }
        return stringArray;
    }
}

