/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util.smtp;

import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class BadRecipientException
extends LocalizableException {
    static final long serialVersionUID = -6615727983018837436L;
    public String[] recipientList;
    public String[] reasonList;

    public BadRecipientException(String string, String[] stringArray, String[] stringArray2, boolean bl) {
        super(bl ? "GEN0109W" : "GEN0109E", new Object[]{string});
        this.recipientList = stringArray;
        this.reasonList = stringArray2;
    }

    public void print() {
        MessageLog.getThreadLog().println(this.getMessage());
    }

    public String getMessage() {
        return this.getMessageBuffer().toString();
    }

    protected StringBuffer getMessageBuffer() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.BadRecipientException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getMessageBuffer", (String)"");
        }
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append(super.getMessage());
        int n = 0;
        while (n < this.recipientList.length) {
            if (this.recipientList[n] == null) break;
            this.append(stringBuffer, this.recipientList[n]);
            this.append(stringBuffer, this.reasonList[n]);
            ++n;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.BadRecipientException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getMessageBuffer", (Object)stringBuffer);
        }
        return stringBuffer;
    }

    private void append(StringBuffer stringBuffer, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.BadRecipientException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"append", (String)"buffer, s");
        }
        stringBuffer.append('\n');
        stringBuffer.append("                         ");
        stringBuffer.append(string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.util.smtp.BadRecipientException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"append");
        }
    }
}

