/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import com.ibm.icu.math.BigDecimal;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.PDFRenderContext;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;

public class HTMLActionHandler
implements IHTMLActionHandler {
    protected Logger log = Logger.getLogger(HTMLActionHandler.class.getName());
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getURL(IAction actionDefn, IReportContext context) {
        Object renderContext = this.getRenderContext(context);
        return this.getURL(actionDefn, renderContext);
    }

    public String getURL(IAction actionDefn, Object context) {
        if (actionDefn == null) {
            return null;
        }
        String url = null;
        switch (actionDefn.getType()) {
            case 2: {
                if (actionDefn.getActionString() == null) break;
                url = "#" + actionDefn.getActionString();
                break;
            }
            case 1: {
                url = actionDefn.getActionString();
                break;
            }
            case 3: {
                url = this.buildDrillAction(actionDefn, context);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        return url;
    }

    protected String buildDrillAction(IAction action, Object context) {
        String baseURL = null;
        if (context != null) {
            if (context instanceof HTMLRenderContext) {
                baseURL = ((HTMLRenderContext)context).getBaseURL();
            }
            if (context instanceof PDFRenderContext) {
                baseURL = ((PDFRenderContext)context).getBaseURL();
            }
        }
        if (baseURL == null) {
            baseURL = "run";
        }
        StringBuffer link = new StringBuffer();
        String reportName = this.getReportName(action);
        if (reportName != null && !reportName.equals("")) {
            String format = action.getFormat();
            if (!"html".equalsIgnoreCase(format)) {
                link.append(baseURL.replaceFirst("frameset", "run"));
            } else {
                link.append(baseURL);
            }
            link.append(reportName.toLowerCase().endsWith(".rptdocument") ? "?__document=" : "?__report=");
            try {
                link.append(URLEncoder.encode(reportName, "UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                // empty catch block
            }
            if (format != null && format.length() > 0) {
                link.append("&__format=" + format);
            }
            if (action.getParameterBindings() != null) {
                Iterator paramsIte = action.getParameterBindings().entrySet().iterator();
                while (paramsIte.hasNext()) {
                    Map.Entry entry = paramsIte.next();
                    try {
                        String key = (String)entry.getKey();
                        Object valueObj = entry.getValue();
                        if (valueObj == null) continue;
                        String value = this.getDisplayValue(valueObj);
                        link.append("&" + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {}
                }
            }
            link.append("&__overwrite=true");
            if (action.getBookmark() != null) {
                try {
                    if (baseURL.lastIndexOf("run") > 0) {
                        link.append("#");
                    } else {
                        link.append("&__bookmark=");
                    }
                    link.append(URLEncoder.encode(action.getBookmark(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
        return link.toString();
    }

    protected void appendReportDesignName(StringBuffer buffer, String reportName) {
        buffer.append("?__report=");
        try {
            buffer.append(URLEncoder.encode(reportName, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected void appendFormat(StringBuffer buffer, String format) {
        if (format != null && format.length() > 0) {
            buffer.append("&__format=" + format);
        }
    }

    protected void appendParamter(StringBuffer buffer, String key, Object valueObj) {
        if (valueObj != null) {
            try {
                key = URLEncoder.encode(key, "UTF-8");
                String value = valueObj.toString();
                value = URLEncoder.encode(value, "UTF-8");
                buffer.append("&");
                buffer.append(key);
                buffer.append("=");
                buffer.append(value);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
    }

    protected void appendBookmarkAsParamter(StringBuffer buffer, String bookmark) {
        try {
            if (bookmark != null && bookmark.length() != 0) {
                bookmark = URLEncoder.encode(bookmark, "UTF-8");
                buffer.append("&__bookmark=");
                buffer.append(bookmark);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected void appendBookmark(StringBuffer buffer, String bookmark) {
        try {
            if (bookmark != null && bookmark.length() != 0) {
                bookmark = URLEncoder.encode(bookmark, "UTF-8");
                buffer.append("#");
                buffer.append(bookmark);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    String getReportName(IAction action) {
        String systemId = action.getSystemId();
        String reportName = action.getReportName();
        if (systemId == null) {
            return reportName;
        }
        try {
            URL url = new URL(reportName);
            if ("file".equals(url.getProtocol())) {
                return url.getFile();
            }
            return url.toExternalForm();
        }
        catch (MalformedURLException ex) {
            try {
                URL root = new URL(systemId);
                URL url = new URL(root, reportName);
                if ("file".equals(url.getProtocol())) {
                    return url.getFile();
                }
                return url.toExternalForm();
            }
            catch (MalformedURLException ex2) {
                File file = new File(reportName);
                if (file.isAbsolute()) {
                    return reportName;
                }
                try {
                    URL root = new File(systemId).toURL();
                    URL url = new URL(root, reportName);
                    if (!$assertionsDisabled && !"file".equals(url.getProtocol())) {
                        throw new AssertionError();
                    }
                    return url.getFile();
                }
                catch (MalformedURLException ex3) {
                    return reportName;
                }
            }
        }
    }

    protected Object getRenderContext(IReportContext context) {
        Map appContext = context.getAppContext();
        if (appContext != null) {
            String renderContextKey = "HTML_RENDER_CONTEXT";
            String format = context.getOutputFormat();
            if ("pdf".equalsIgnoreCase(format)) {
                renderContextKey = "PDF_RENDER_CONTEXT";
            }
            return appContext.get(renderContextKey);
        }
        return null;
    }

    String getDisplayValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
            return value.toString();
        }
        return ParameterValidationUtil.getDisplayValue((Object)value);
    }

    static {
        $assertionsDisabled = !HTMLActionHandler.class.desiredAssertionStatus();
    }
}

