/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ParameterAttribute;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentReader;
import org.eclipse.birt.report.engine.api.impl.ScriptedDesignVisitor;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.LayoutEngineFactory;
import org.eclipse.birt.report.engine.script.internal.ReportContextImpl;
import org.eclipse.birt.report.engine.script.internal.ReportScriptExecutor;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IncludeScriptHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;

public abstract class EngineTask
implements IEngineTask {
    protected static Logger log;
    protected final int RUNNING_STATUS_START = 0;
    protected final int RUNNING_STATUS_RUNNING = 1;
    protected final int RUNNING_STATUS_STOP = 2;
    protected static int id;
    protected boolean cancelFlag;
    protected int runningStatus;
    protected Map appContext;
    protected IReportEngine engine;
    protected Locale locale = Locale.getDefault();
    protected ExecutionContext executionContext;
    protected int taskID;
    protected IReportRunnable runnable;
    protected IRenderOption renderOptions;
    protected boolean parameterChanged = true;
    protected HashMap inputValues = new HashMap();
    protected HashMap runValues = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    protected EngineTask(IReportEngine engine, IReportRunnable runnable) {
        this.taskID = id++;
        this.executionContext = new ExecutionContext(engine, this.taskID);
        this.executionContext.setReportContext(new ReportContextImpl(this.executionContext));
        this.setReportEngine(engine);
        this.setReportRunnable(runnable);
        this.setAppContext(new HashMap());
        this.cancelFlag = false;
        this.runningStatus = 0;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ULocale getULocale() {
        return ULocale.forLocale((Locale)this.locale);
    }

    public void setLocale(Locale locale) {
        log.log(Level.FINE, "EngineTask.setLocale: locale={0}", locale == null ? null : locale.getDisplayName());
        this.doSetLocale(locale);
    }

    private void doSetLocale(Locale locale) {
        this.locale = locale;
        this.executionContext.setLocale(locale);
        EngineException.setULocale(ULocale.forLocale((Locale)locale));
    }

    public void setLocale(ULocale uLocale) {
        log.log(Level.FINE, "EngineTask.setLocale: uLocale={0}", uLocale == null ? null : uLocale.getDisplayName());
        this.doSetLocale(uLocale.toLocale());
    }

    public void setAppContext(Map context) {
        this.appContext = context;
        this.executionContext.setAppContext(context);
        String logStr = null;
        if (log.isLoggable(Level.FINE)) {
            logStr = new String();
        }
        if (!context.isEmpty()) {
            Set entries = context.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (entry.getKey() instanceof String) {
                    this.addScriptableJavaObject((String)entry.getKey(), entry.getValue());
                    if (logStr == null) continue;
                    logStr = logStr + entry.getKey();
                    logStr = logStr + "=";
                    logStr = logStr + entry.getValue();
                    logStr = logStr + ";";
                    continue;
                }
                log.log(Level.WARNING, "Map entry {0} is invalid and ignored, because its key is a not string.", entry.getKey().toString());
            }
        }
        if (logStr != null) {
            log.log(Level.FINE, "EngineTask.setAppContext: context={0}", logStr);
        }
    }

    public Map getAppContext() {
        return this.appContext;
    }

    protected void setReportEngine(IReportEngine engine) {
        this.engine = engine;
    }

    public IReportEngine getEngine() {
        return this.engine;
    }

    public void setReportRunnable(IReportRunnable runnable) {
        if (runnable != null) {
            this.runnable = runnable;
            this.executionContext.setRunnable(runnable);
            this.executionContext.registerBeans(System.getProperties());
            this.executionContext.registerBeans(runnable.getTestConfig());
            this.executionContext.getConfigs().putAll(System.getProperties());
            this.executionContext.getConfigs().putAll(runnable.getTestConfig());
        }
    }

    public IReportRunnable getReportRunnable() {
        return this.runnable;
    }

    public void setRenderOption(IRenderOption options) {
        String format;
        if (options != null && ((format = options.getOutputFormat()) == null || format.length() == 0)) {
            options.setOutputFormat("html");
        }
        this.renderOptions = options;
        this.executionContext.setRenderOption(this.renderOptions);
    }

    public IRenderOption getRenderOption() {
        return this.renderOptions;
    }

    public DataEngine getDataEngine() {
        return this.executionContext.getDataEngine().getDataEngine();
    }

    public void addScriptableJavaObject(String jsName, Object obj) {
        this.executionContext.registerBean(jsName, obj);
    }

    public int getID() {
        return this.taskID;
    }

    protected Object convertToType(Object value, String type) {
        try {
            if ("boolean".equals(type)) {
                return DataTypeUtil.toBoolean((Object)value);
            }
            if ("dateTime".equals(type)) {
                return DataTypeUtil.toDate((Object)value);
            }
            if ("decimal".equals(type)) {
                return DataTypeUtil.toBigDecimal((Object)value);
            }
            if ("float".equals(type)) {
                return DataTypeUtil.toDouble((Object)value);
            }
            if ("string".equals(type)) {
                return DataTypeUtil.toString((Object)value);
            }
            return value;
        }
        catch (BirtException e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public boolean validateParameters() {
        if (this.runnable == null) {
            return false;
        }
        this.usingParameterValues();
        return new ParameterVisitor(){

            boolean visitScalarParameter(ScalarParameterHandle param, Object value) {
                return EngineTask.this.validateScalarParameter(param);
            }

            boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
                return this.visitParametersInGroup(group, value);
            }
        }.visit((ReportDesignHandle)this.runnable.getDesignHandle(), null);
    }

    private boolean validateScalarParameter(ScalarParameterHandle paramHandle) {
        String paramName = paramHandle.getName();
        Object paramValue = this.runValues.get(paramName);
        String type = paramHandle.getDataType();
        if (paramValue == null) {
            if (paramHandle.allowNull()) {
                return true;
            }
            log.log(Level.SEVERE, "Parameter {0} doesn't allow a null value.", paramName);
            return false;
        }
        if ("decimal".equals(type) || "float".equals(type)) {
            if (paramValue instanceof Number) {
                return true;
            }
            log.log(Level.SEVERE, "The supplied value {0} for parameter {1} is not a number.", new String[]{paramValue.toString(), paramName});
            return false;
        }
        if ("dateTime".equals(type)) {
            if (paramValue instanceof Date) {
                return true;
            }
            log.log(Level.SEVERE, "The supplied value {0} for parameter {1} is not a valid date.", new String[]{paramValue.toString(), paramName});
            return false;
        }
        if ("string".equals(type)) {
            String value = paramValue.toString().trim();
            if (value.equals("") && !paramHandle.allowBlank()) {
                log.log(Level.SEVERE, "parameter {0} can't be blank.", paramName);
                return false;
            }
            return true;
        }
        if ("boolean".equals(type)) {
            if (paramValue instanceof Boolean) {
                return true;
            }
            log.log(Level.SEVERE, "The supplied value {0} for parameter {1} is not a boolean.", new String[]{paramValue.toString(), paramName});
            return false;
        }
        return true;
    }

    public void setParameterValues(Map params) {
        Iterator iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            this.setParameterValue(name, value);
        }
    }

    public void setParameterValue(String name, Object value) {
        log.log(Level.FINE, "EngineTask.setParameterValue: {0}={1} [{2}]", new Object[]{name, value, value == null ? null : value.getClass().getName()});
        this.parameterChanged = true;
        Object parameter = this.inputValues.get(name);
        if (parameter != null) {
            if (!$assertionsDisabled && !(parameter instanceof ParameterAttribute)) {
                throw new AssertionError();
            }
            ((ParameterAttribute)parameter).setValue(value);
        } else {
            this.inputValues.put(name, new ParameterAttribute(value, null));
        }
    }

    public void setValue(String name, Object value) {
        this.setParameterValue(name, value);
    }

    public HashMap getParameterValues() {
        HashMap result = new HashMap();
        Iterator iterator = this.inputValues.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ParameterAttribute parameter = (ParameterAttribute)entry.getValue();
            result.put(entry.getKey(), parameter.getValue());
        }
        return result;
    }

    public Object getParameterValue(String name) {
        Object parameter = this.inputValues.get(name);
        if (parameter == null) {
            return null;
        }
        if (!$assertionsDisabled && !(parameter instanceof ParameterAttribute)) {
            throw new AssertionError();
        }
        return ((ParameterAttribute)parameter).getValue();
    }

    public void setParameter(String name, Object value, String displayText) {
        this.parameterChanged = true;
        this.inputValues.put(name, new ParameterAttribute(value, displayText));
    }

    public String getParameterDisplayText(String name) {
        Object parameter = this.inputValues.get(name);
        if (parameter != null) {
            if (!$assertionsDisabled && !(parameter instanceof ParameterAttribute)) {
                throw new AssertionError();
            }
            return ((ParameterAttribute)parameter).getDisplayText();
        }
        return null;
    }

    public void setParameterDisplayTexts(Map params) {
        Iterator iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            String text = (String)entry.getValue();
            this.setParameterDisplayText(name, text);
        }
    }

    public void setParameterDisplayText(String name, String displayText) {
        this.parameterChanged = true;
        Object parameter = this.inputValues.get(name);
        if (parameter != null) {
            if (!$assertionsDisabled && !(parameter instanceof ParameterAttribute)) {
                throw new AssertionError();
            }
            ((ParameterAttribute)parameter).setDisplayText(displayText);
        } else {
            this.inputValues.put(name, new ParameterAttribute(null, displayText));
        }
    }

    public void cancel() {
        this.cancelFlag = true;
        this.executionContext.cancel();
    }

    public void cancel(Object signal) {
        if (signal == null) {
            throw new IllegalArgumentException("signal can't be null");
        }
        this.cancelFlag = true;
        long waitingTime = 0L;
        do {
            waitingTime += 100L;
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.runningStatus == 1) continue;
            return;
        } while (waitingTime < 5000L);
    }

    public boolean getCancelFlag() {
        return this.cancelFlag;
    }

    protected IQueryResults executeDataSet(DataSetHandle hDataSet, HashMap parameters) {
        return null;
    }

    protected void usingParameterValues() {
        if (!this.parameterChanged) {
            return;
        }
        this.parameterChanged = false;
        this.executionContext.clearParameters();
        this.runValues.clear();
        Iterator iterator = this.inputValues.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            ParameterAttribute attribute = (ParameterAttribute)entry.getValue();
            this.runValues.put(key, attribute.getValue());
            this.executionContext.setParameter((String)key, attribute.getValue(), attribute.getDisplayText());
        }
        if (this.runnable == null) {
            return;
        }
        new ParameterVisitor(){

            boolean visitScalarParameter(ScalarParameterHandle param, Object userData) {
                String name = param.getName();
                if (!EngineTask.this.inputValues.containsKey(name)) {
                    Object value = EngineTask.this.convertToType(param.getDefaultValue(), param.getDataType());
                    EngineTask.this.executionContext.setParameterValue(name, value);
                    EngineTask.this.runValues.put(name, value);
                }
                return true;
            }

            boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
                return this.visitParametersInGroup(group, value);
            }
        }.visit((ReportDesignHandle)this.runnable.getDesignHandle());
    }

    public void close() {
        this.executionContext.close();
    }

    protected IReportLayoutEngine createReportLayoutEngine(String format, IRenderOption options) {
        IReportLayoutEngine layoutEngine = LayoutEngineFactory.createLayoutEngine(format);
        if (options != null) {
            Object pagebreakOnly;
            Object fitToPage = this.renderOptions.getOutputSetting().get("fitToPage");
            if (fitToPage != null) {
                layoutEngine.setOption("fitToPage", fitToPage);
            }
            if ((pagebreakOnly = this.renderOptions.getOutputSetting().get("pagebreakPaginationOnly")) != null) {
                layoutEngine.setOption("pagebreakPaginationOnly", pagebreakOnly);
            }
        }
        return layoutEngine;
    }

    protected void loadDesign() {
        if (this.runnable != null) {
            ReportDesignHandle reportDesign = this.executionContext.getDesign();
            Iterator iter = reportDesign.includeScriptsIterator();
            while (iter.hasNext()) {
                IncludeScriptHandle includeScript = (IncludeScriptHandle)iter.next();
                String fileName = includeScript.getFileName();
                this.executionContext.loadScript(fileName);
            }
            ReportScriptExecutor.handleInitialize(reportDesign, this.executionContext);
        }
    }

    protected void prepareDesign() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ScriptedDesignVisitor visitor = new ScriptedDesignVisitor(reportDesign, this.executionContext);
        visitor.apply((DesignElementHandle)reportDesign.getRoot());
        this.runnable.setDesignHandle(reportDesign);
    }

    protected void startFactory() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ReportScriptExecutor.handleBeforeFactory(reportDesign, this.executionContext);
    }

    protected void closeFactory() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ReportScriptExecutor.handleAfterFactory(reportDesign, this.executionContext);
    }

    protected void startRender() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ReportScriptExecutor.handleBeforeRender(reportDesign, this.executionContext);
    }

    protected void closeRender() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ReportScriptExecutor.handleAfterRender(reportDesign, this.executionContext);
    }

    public void setDataSource(IDocArchiveReader dataSource) {
        try {
            ReportDocumentReader document = new ReportDocumentReader(this.engine, dataSource);
            Map values = document.getParameterValues();
            Map texts = document.getParameterDisplayTexts();
            this.setParameterValues(values);
            this.setParameterDisplayTexts(texts);
            document.close();
        }
        catch (EngineException ex) {
            log.log(Level.WARNING, "failed to load the paremters in the data source", (Throwable)((Object)ex));
        }
        this.executionContext.setDataSource(dataSource);
    }

    public int getStatus() {
        switch (this.runningStatus) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                if (this.cancelFlag) {
                    return 4;
                }
                if (this.executionContext.hasErrors()) {
                    return 3;
                }
                return 2;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    public List getErrors() {
        return this.executionContext.getErrors();
    }

    public IReportContext getReportContext() {
        return this.executionContext.getReportContext();
    }

    static {
        $assertionsDisabled = !EngineTask.class.desiredAssertionStatus();
        log = Logger.getLogger(EngineTask.class.getName());
        id = 0;
    }

    static abstract class ParameterVisitor {
        ParameterVisitor() {
        }

        boolean visitParametersInGroup(ParameterGroupHandle group, Object value) {
            SlotHandle parameters = group.getParameters();
            Iterator iter = parameters.iterator();
            while (iter.hasNext()) {
                Object param = iter.next();
                if (!(param instanceof CascadingParameterGroupHandle ? !this.visitCascadingParamterGroup((CascadingParameterGroupHandle)param, value) : (param instanceof ParameterGroupHandle ? !this.visitParameterGroup((ParameterGroupHandle)param, value) : param instanceof ScalarParameterHandle && !this.visitScalarParameter((ScalarParameterHandle)param, value)))) continue;
                return false;
            }
            return true;
        }

        boolean visitCascadingParamterGroup(CascadingParameterGroupHandle group, Object value) {
            return this.visitParameterGroup((ParameterGroupHandle)group, value);
        }

        boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
            return false;
        }

        boolean visitScalarParameter(ScalarParameterHandle param, Object value) {
            return false;
        }

        boolean visit(ReportDesignHandle report) {
            return this.visit(report, null);
        }

        boolean visit(ReportDesignHandle report, Object value) {
            SlotHandle parameters = report.getParameters();
            Iterator iter = parameters.iterator();
            while (iter.hasNext()) {
                Object param = iter.next();
                if (!(param instanceof CascadingParameterGroupHandle ? !this.visitCascadingParamterGroup((CascadingParameterGroupHandle)param, value) : (param instanceof ParameterGroupHandle ? !this.visitParameterGroup((ParameterGroupHandle)param, value) : param instanceof ScalarParameterHandle && !this.visitScalarParameter((ScalarParameterHandle)param, value)))) continue;
                return false;
            }
            return true;
        }
    }
}

