/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.emitter.DOMBuilderEmitter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.toc.TOCTree;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ReportExecutor
implements IReportExecutor {
    protected static Logger logger = Logger.getLogger(ReportExecutor.class.getName());
    private ExecutionContext context;
    private ExecutorManager manager;
    private IContentEmitter emitter;
    private Report report;
    private ReportContent reportContent;
    int currentItem;

    public ReportExecutor(ExecutionContext context, Report report, IContentEmitter emitter) {
        this.context = context;
        this.manager = new ExecutorManager(context, emitter);
        this.report = report;
        this.emitter = emitter;
    }

    public IReportContent execute() {
        this.reportContent = new ReportContent(this.report);
        this.context.setReportContent(this.reportContent);
        TOCTree tocTree = new TOCTree();
        this.reportContent.setTOCTree(tocTree);
        TOCBuilder tocBuilder = new TOCBuilder(tocTree);
        this.context.setTOCBuilder(tocBuilder);
        this.context.getDataEngine().prepare(this.report, this.context.getAppContext());
        if (this.emitter != null) {
            this.emitter.start(this.reportContent);
        }
        this.currentItem = 0;
        return this.reportContent;
    }

    public void close() {
        if (this.emitter != null) {
            this.emitter.end(this.reportContent);
        }
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            ReportItemDesign design = this.report.getContent(this.currentItem++);
            ReportItemExecutor executor = this.manager.createExecutor(null, design);
            return executor;
        }
        return null;
    }

    public boolean hasNextChild() {
        return this.currentItem < this.report.getContentCount();
    }

    public void execute(ReportDesignHandle report, IContentEmitter emitter) {
        this.execute();
        while (this.hasNextChild() && !this.context.isCanceled()) {
            ReportItemExecutor executor = (ReportItemExecutor)this.getNextChild();
            ReportItemDesign design = executor.getDesign();
            executor.execute(design, emitter);
        }
        this.close();
    }

    public IPageContent executeMasterPage(int pageNo, MasterPageDesign masterPage) {
        IReportContent reportContent = this.context.getReportContent();
        IPageContent pageContent = reportContent.createPageContent();
        pageContent.setGenerateBy(masterPage);
        pageContent.setPageNumber(pageNo);
        this.context.setPageNumber(pageNo);
        if (masterPage instanceof SimpleMasterPageDesign) {
            TOCBuilder tocBuilder = this.context.getTOCBuilder();
            this.context.setTOCBuilder(null);
            this.context.setExecutingMasterPage(true);
            SimpleMasterPageDesign pageDesign = (SimpleMasterPageDesign)masterPage;
            InstanceID iid = new InstanceID(null, pageDesign.getID(), null);
            pageContent.setInstanceID(iid);
            IContainerContent header = reportContent.createContainerContent();
            header.setStyleClass(masterPage.getStyleName());
            pageContent.setPageHeader(header);
            header.setParent(pageContent);
            DOMBuilderEmitter domEmitter = new DOMBuilderEmitter(header);
            ExecutorManager manager = new ExecutorManager(this.context, domEmitter);
            for (int i = 0; i < pageDesign.getHeaderCount(); ++i) {
                ReportItemDesign design = pageDesign.getHeader(i);
                ReportItemExecutor executor = manager.createExecutor(null, design);
                executor.execute(design, domEmitter);
            }
            IContainerContent body = reportContent.createContainerContent();
            body.setStyleClass(masterPage.getBodyStyleName());
            pageContent.setPageBody(body);
            body.setParent(pageContent);
            IContainerContent footer = reportContent.createContainerContent();
            footer.setStyleClass(masterPage.getStyleName());
            pageContent.setPageFooter(footer);
            footer.setParent(pageContent);
            domEmitter = new DOMBuilderEmitter(footer);
            manager = new ExecutorManager(this.context, domEmitter);
            for (int i = 0; i < pageDesign.getFooterCount(); ++i) {
                ReportItemDesign design = pageDesign.getFooter(i);
                ReportItemExecutor executor = manager.createExecutor(null, design);
                executor.execute(design, domEmitter);
            }
            this.context.setExecutingMasterPage(false);
            this.context.setTOCBuilder(tocBuilder);
        }
        return pageContent;
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    public ExecutorManager getManager() {
        return this.manager;
    }

    public IPageContent createPage(long pageNumber, MasterPageDesign masterDesign) {
        return this.executeMasterPage((int)pageNumber, masterDesign);
    }
}

