/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import org.eclipse.birt.report.engine.internal.executor.doc.Segment;

public class Fragment {
    long offset;
    Segment segment = new Segment();
    Fragment next;
    Fragment child;
    static final /* synthetic */ boolean $assertionsDisabled;

    Fragment getFragment(long offset) {
        Fragment frag = this.child;
        while (frag != null) {
            if (frag.offset == offset) {
                return frag;
            }
            frag = frag.next;
        }
        return null;
    }

    public Fragment getNextFragment(long offset) {
        Fragment frag = this.child;
        while (frag != null) {
            if (frag.offset > offset) {
                return frag;
            }
            frag = frag.next;
        }
        return null;
    }

    public Fragment() {
        this.offset = -1L;
    }

    Fragment(long offset) {
        this.offset = offset;
    }

    public void addFragment(long[] leftEdges, long[] rightEdges) {
        Fragment leftEdge = this;
        for (int i = 0; i < leftEdges.length; ++i) {
            leftEdge.segment.startSegment(leftEdges[i]);
            leftEdge = this.addFragment(leftEdge, leftEdges[i]);
        }
        leftEdge.segment.startSegment(Long.MIN_VALUE);
        Fragment rightEdge = this;
        for (int i = 0; i < rightEdges.length; ++i) {
            rightEdge.segment.endSegment(rightEdges[i]);
            rightEdge = this.addFragment(rightEdge, rightEdges[i]);
        }
        rightEdge.segment.endSegment(Long.MIN_VALUE);
        this.segment.normalize();
    }

    private Fragment addFragment(Fragment parent, long offset) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        Fragment prev = null;
        Fragment frag = parent.child;
        while (frag != null) {
            if (frag.offset == offset) {
                return frag;
            }
            if (frag.offset > offset) break;
            prev = frag;
            frag = frag.next;
        }
        frag = new Fragment(offset);
        if (prev != null) {
            if (prev.next != null) {
                frag.next = prev.next.next;
            }
            prev.next = frag;
        } else if (parent != null) {
            frag.next = parent.child;
            parent.child = frag;
        }
        return frag;
    }

    public boolean inFragment(long offset) {
        return this.segment.inSegment(offset);
    }

    static {
        $assertionsDisabled = !Fragment.class.desiredAssertionStatus();
    }
}

