/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.executor.doc.AbstractReportReader;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.executor.doc.ReportItemReaderManager;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;

public class ReportItemReader
implements IReportItemExecutor {
    protected ReportItemReaderManager manager;
    protected AbstractReportReader reader;
    protected ReportItemReader parent;
    protected Fragment fragment;
    long offset;
    IContent content;
    long child;
    IResultSet rset;
    static final /* synthetic */ boolean $assertionsDisabled;

    ReportItemReader(ReportItemReaderManager manager) {
        this.manager = manager;
    }

    void initialize(AbstractReportReader reader, ReportItemReader parent, long offset, Fragment frag) {
        if (!$assertionsDisabled && reader == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && offset == -1L) {
            throw new AssertionError();
        }
        this.reader = reader;
        this.parent = parent;
        this.offset = offset;
        this.content = null;
        this.child = -1L;
        this.rset = null;
        this.fragment = frag;
    }

    public void close() {
        this.unloadContent();
        this.manager.releaseExecutor(this);
    }

    public IContent execute() {
        this.loadContent();
        this.initializeContent();
        return this.content;
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            Fragment childFrag = this.fragment == null ? null : this.fragment.getFragment(this.child);
            ReportItemReader childReader = this.manager.createExecutor(this, this.child, childFrag);
            this.child = childReader.findNextSibling();
            if (this.child != -1L && this.fragment != null && !this.fragment.inFragment(this.child)) {
                Fragment nextFragment = this.fragment.getNextFragment(this.child);
                this.child = nextFragment != null ? nextFragment.offset : -1L;
            }
            return childReader;
        }
        return null;
    }

    public boolean hasNextChild() {
        return this.child != -1L;
    }

    protected long findFirstChild() {
        this.loadContent();
        if (this.content != null) {
            DocumentExtension docExt = (DocumentExtension)this.content.getExtension(0);
            long firstChild = docExt.getFirstChild();
            if (firstChild != -1L && this.fragment != null && !this.fragment.inFragment(firstChild)) {
                Fragment childFragment = this.fragment.getNextFragment(-1L);
                if (childFragment != null) {
                    return childFragment.offset;
                }
                return -1L;
            }
            return firstChild;
        }
        return -1L;
    }

    protected long findNextSibling() {
        this.loadContent();
        if (this.content != null) {
            DocumentExtension docExt = (DocumentExtension)this.content.getExtension(0);
            return docExt.getNext();
        }
        return -1L;
    }

    protected IResultSet getResultSet() {
        if (this.rset == null && this.parent != null) {
            return this.parent.getResultSet();
        }
        return this.rset;
    }

    protected void loadContent() {
        if (this.content == null) {
            this.content = this.reader.loadContent(this.offset);
            if (this.content != null) {
                DocumentExtension docExt = (DocumentExtension)this.content.getExtension(0);
                this.child = docExt.getFirstChild();
                if (this.child != -1L && this.fragment != null && !this.fragment.inFragment(this.child)) {
                    Fragment childFragment = this.fragment.getNextFragment(-1L);
                    this.child = childFragment != null ? childFragment.offset : -1L;
                }
            }
        }
    }

    private void initializeContent() {
        if (!$assertionsDisabled && this.content == null) {
            throw new AssertionError();
        }
        this.reader.initializeContent(this.content);
        if (this.fragment != null && this.hasNextChild()) {
            Object genBy = this.content.getGenerateBy();
            if (this.content instanceof ITableContent) {
                if (genBy instanceof TableItemDesign) {
                    TableItemDesign tableDesign = (TableItemDesign)genBy;
                    if (((ITableContent)this.content).isHeaderRepeat() && tableDesign.getHeader() != null) {
                        this.addHeaderToFragment(this.content);
                    }
                }
            } else if (this.content instanceof IGroupContent) {
                if (genBy instanceof GroupDesign) {
                    GroupDesign groupDesign = (GroupDesign)genBy;
                    if (((IGroupContent)this.content).isHeaderRepeat() && groupDesign.getHeader() != null) {
                        this.addHeaderToFragment(this.content);
                    }
                }
            } else if (this.content instanceof IListContent && genBy instanceof ListItemDesign) {
                ListItemDesign listDesign = (ListItemDesign)genBy;
                if (((IListContent)this.content).isHeaderRepeat() && listDesign.getHeader() != null) {
                    this.addHeaderToFragment(this.content);
                }
            }
        }
        IResultSet prset = this.parent == null ? null : this.parent.getResultSet();
        this.reader.context.setResultSet(prset);
        this.rset = this.reader.openQuery(prset, this.content);
        if (this.rset == prset) {
            this.rset = null;
        }
        this.reader.initalizeContentVisitor.visit(this.content, null);
    }

    private void addHeaderToFragment(IContent content) {
        long headerOffset;
        if (!$assertionsDisabled && this.fragment == null) {
            throw new AssertionError();
        }
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        if (docExt != null && (headerOffset = docExt.getFirstChild()) != -1L) {
            this.fragment.addFragment(new long[]{headerOffset}, new long[]{headerOffset});
            Fragment headerFrag = this.fragment.getFragment(headerOffset);
            headerFrag.addFragment(new long[0], new long[]{Long.MAX_VALUE});
            this.child = headerOffset;
        }
    }

    protected void unloadContent() {
        if (this.rset != null) {
            this.reader.closeQuery(this.rset);
        }
        this.reader.unloadContent(this.offset);
    }

    static {
        $assertionsDisabled = !ReportItemReader.class.desiredAssertionStatus();
    }
}

