/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v2.PageHintReaderV2;
import org.eclipse.birt.report.engine.internal.document.v3.CachedReportContentReaderV3;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.executor.doc.PageReader;
import org.eclipse.birt.report.engine.internal.executor.doc.ReportItemReader;
import org.eclipse.birt.report.engine.internal.executor.doc.ReportReader;
import org.eclipse.birt.report.engine.presentation.IPageHint;

public class ReportPageReader
extends ReportReader {
    ArrayList outputPages = new ArrayList();
    ArrayList pageHints = new ArrayList();
    Fragment fragment = new Fragment();
    int paginationType;
    PageHintReaderV2 hintReader;
    CachedReportContentReaderV3 pageReader;
    private int curPageRange = -1;
    private long nextPage = -1L;
    private long nextElement = -1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReportPageReader(ExecutionContext context, long pageNumber, int paginationType) {
        super(context);
        this.outputPages.add(new long[]{pageNumber, pageNumber});
        this.paginationType = paginationType;
    }

    public ReportPageReader(ExecutionContext context, List pages, int paginationType) {
        super(context);
        this.outputPages.addAll(pages);
        this.paginationType = paginationType;
        if (paginationType == 2) {
            this.nextPage = 1L;
        }
    }

    protected void openReaders() throws IOException {
        super.openReaders();
        this.hintReader = new PageHintReaderV2(this.reportDoc);
        this.hintReader.open();
        IDocArchiveReader archive = this.reportDoc.getArchive();
        RAInputStream in = archive.getStream("/content/page.dat");
        this.pageReader = new CachedReportContentReaderV3(this.reportContent, in);
    }

    protected void closeReaders() {
        super.closeReaders();
        if (this.hintReader != null) {
            this.hintReader.close();
            this.hintReader = null;
        }
        if (this.pageReader != null) {
            this.pageReader.close();
            this.pageReader = null;
        }
        this.outputPages.clear();
    }

    protected IPageHint loadPageHint(long pageNumber) {
        try {
            IPageHint hint = this.hintReader.getPageHint(pageNumber);
            return hint;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Failed to load page hint" + pageNumber, ex);
            return null;
        }
    }

    protected void loadPageHints() {
        for (int m = 0; m < this.outputPages.size(); ++m) {
            long[] ps = (long[])this.outputPages.get(m);
            for (long pageNumber = ps[0]; pageNumber <= ps[1]; ++pageNumber) {
                IPageHint pageHint = this.loadPageHint(pageNumber);
                if (pageHint == null) continue;
                int sectCount = pageHint.getSectionCount();
                for (int i = 0; i < sectCount; ++i) {
                    try {
                        long left = pageHint.getSectionStart(i);
                        long right = pageHint.getSectionEnd(i);
                        long[] leftEdges = this.createEdges(left);
                        long[] rightEdges = this.createEdges(right);
                        this.fragment.addFragment(leftEdges, rightEdges);
                        continue;
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, "Can't load the page hints", ex);
                    }
                }
            }
        }
    }

    protected long[] createEdges(long offset) throws IOException {
        LinkedList<Long> parents = new LinkedList<Long>();
        for (IContent content = this.reader.loadContent(offset); content != null; content = (IContent)content.getParent()) {
            DocumentExtension ext = (DocumentExtension)content.getExtension(0);
            if (ext == null) continue;
            parents.addFirst(new Long(ext.getIndex()));
        }
        long[] edges = new long[parents.size()];
        Iterator iter = parents.iterator();
        int length = 0;
        while (iter.hasNext()) {
            Long value = (Long)iter.next();
            edges[length++] = value;
        }
        return edges;
    }

    public IReportContent execute() {
        IReportContent content = super.execute();
        if (this.paginationType == 0) {
            this.loadPageHints();
            this.nextElement = this.getFirstElementOffset();
        }
        return content;
    }

    public IReportItemExecutor getNextChild() {
        if (this.paginationType == 1 || this.paginationType == 2) {
            return this.getNextPage();
        }
        return this.getNextElement();
    }

    public boolean hasNextChild() {
        if (this.paginationType == 1 || this.paginationType == 2) {
            return this.hasNextPage();
        }
        return this.hasNextElement();
    }

    private boolean hasNextPage() {
        if (this.nextPage == -1L) {
            this.nextPage = this.getNextPageNumber();
        }
        return this.nextPage != -1L;
    }

    private IReportItemExecutor getNextPage() {
        if (this.hasNextPage()) {
            if (!$assertionsDisabled && this.nextPage == -1L) {
                throw new AssertionError();
            }
            if (this.paginationType == 2) {
                this.loadPageHints();
                PageReader pageExecutor = new PageReader(this, 1L, this.fragment);
                this.nextPage = -1L;
                return pageExecutor;
            }
            PageReader pageExecutor = new PageReader(this, this.nextPage, this.loadPageFragment(this.nextPage));
            this.nextPage = this.getNextPageNumber();
            return pageExecutor;
        }
        return null;
    }

    private long getNextPageNumber() {
        if (this.paginationType == 2) {
            return -1L;
        }
        if (this.curPageRange == -1) {
            if (this.outputPages.size() > 0) {
                this.curPageRange = 0;
                long[] pageRange = (long[])this.outputPages.get(this.curPageRange);
                return pageRange[0];
            }
            return -1L;
        }
        if (this.curPageRange < this.outputPages.size()) {
            long pageNumber = this.nextPage + 1L;
            long[] pageRange = (long[])this.outputPages.get(this.curPageRange);
            if (pageRange[0] <= pageNumber && pageRange[1] >= pageNumber) {
                return pageNumber;
            }
            ++this.curPageRange;
            if (this.curPageRange < this.outputPages.size()) {
                pageRange = (long[])this.outputPages.get(this.curPageRange);
                return pageRange[0];
            }
        }
        return -1L;
    }

    IPageContent loadPageContent(long pageNumber) {
        IPageHint pageHint = this.loadPageHint(pageNumber);
        if (pageHint != null) {
            long offset = pageHint.getOffset();
            try {
                IContent pageContent = this.pageReader.loadContent(offset);
                this.initializeContent(pageContent);
                this.loadFullContent(this.pageReader, pageContent, null);
                this.pageReader.unloadContent(offset);
                return (IPageContent)pageContent;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Can't load the page content", ex);
            }
        }
        return null;
    }

    private void loadFullContent(CachedReportContentReaderV3 reader, IContent parent, IResultSet prset) throws IOException {
        DocumentExtension docExt = (DocumentExtension)parent.getExtension(0);
        long offset = docExt.getFirstChild();
        while (offset != -1L) {
            IContent content = reader.loadContent(offset);
            this.initializeContent(content);
            IResultSet rset = this.openQuery(prset, content);
            this.initalizeContentVisitor.visit(content, null);
            parent.getChildren().add(content);
            this.loadFullContent(reader, content, rset == null ? prset : rset);
            if (rset != null) {
                this.closeQuery(rset);
            }
            reader.unloadContent(offset);
            docExt = (DocumentExtension)content.getExtension(0);
            offset = docExt.getNext();
        }
    }

    Fragment loadPageFragment(long pageNumber) {
        Fragment fragment = new Fragment();
        IPageHint pageHint = this.loadPageHint(pageNumber);
        if (pageHint != null) {
            int sectionCount = pageHint.getSectionCount();
            for (int i = 0; i < sectionCount; ++i) {
                try {
                    long left = pageHint.getSectionStart(i);
                    long right = pageHint.getSectionEnd(i);
                    long[] leftEdges = this.createEdges(left);
                    long[] rightEdges = this.createEdges(right);
                    fragment.addFragment(leftEdges, rightEdges);
                    continue;
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Can't load the page hints", ex);
                }
            }
        }
        return fragment;
    }

    IReportItemExecutor getNextElement() {
        if (this.hasNextElement()) {
            if (!$assertionsDisabled && this.nextElement == -1L) {
                throw new AssertionError();
            }
            Fragment nextFrag = this.fragment.getFragment(this.nextElement);
            ReportItemReader reader = this.manager.createExecutor(null, this.nextElement, nextFrag);
            long nextOffset = reader.findNextSibling();
            if (nextOffset != -1L && !this.fragment.inFragment(nextOffset)) {
                nextFrag = this.fragment.getNextFragment(nextOffset);
                nextOffset = nextFrag != null ? nextFrag.offset : -1L;
            }
            this.nextElement = nextOffset;
            return reader;
        }
        return null;
    }

    boolean hasNextElement() {
        return this.nextElement != -1L;
    }

    long getFirstElementOffset() {
        Fragment fstFrag = this.fragment.getNextFragment(-1L);
        if (fstFrag != null) {
            return fstFrag.offset;
        }
        return -1L;
    }

    static {
        $assertionsDisabled = !ReportPageReader.class.desiredAssertionStatus();
    }
}

