/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.BufferedReportEmitter;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.executor.buffermgr.Cell;
import org.eclipse.birt.report.engine.executor.buffermgr.Row;
import org.eclipse.birt.report.engine.executor.buffermgr.TableContentLayout;
import org.eclipse.birt.report.engine.internal.content.wrap.CellContentWrapper;

public abstract class HTMLTableLayoutEmitter
extends ContentEmitterAdapter {
    static final Logger logger = Logger.getLogger(HTMLTableLayoutEmitter.class.getName());
    protected IContentEmitter emitter;
    protected TableContentLayout layout;
    protected Stack layoutEvents;
    protected IContentEmitter cellEmitter;
    protected Stack groupStack = new Stack();
    boolean hasDropCell = false;

    public HTMLTableLayoutEmitter(IContentEmitter emitter) {
        this.emitter = emitter;
    }

    public void end(IReportContent report) {
        this.emitter.end(report);
    }

    public String getOutputFormat() {
        return this.emitter.getOutputFormat();
    }

    public void initialize(IEmitterServices service) {
        this.emitter.initialize(service);
    }

    public void start(IReportContent report) {
        this.emitter.start(report);
    }

    protected int getGroupLevel() {
        if (!this.groupStack.isEmpty()) {
            return (Integer)this.groupStack.peek();
        }
        return -1;
    }

    public void startContent(IContent content) {
        if (this.cellEmitter != null) {
            ContentEmitterUtil.startContent(content, this.cellEmitter);
        } else {
            ContentEmitterUtil.startContent(content, this.emitter);
        }
    }

    public void endContent(IContent content) {
        if (this.cellEmitter != null) {
            ContentEmitterUtil.endContent(content, this.cellEmitter);
        } else {
            ContentEmitterUtil.endContent(content, this.emitter);
        }
    }

    public void resetLayout() {
        this.layout.reset();
        this.layoutEvents.clear();
        this.hasDropCell = false;
    }

    public void initLayout(ITableContent table) {
        this.layout = new TableContentLayout(table, "viewer");
        this.layoutEvents = new Stack();
    }

    protected boolean hasDropCell() {
        return this.hasDropCell;
    }

    public void createCell(int colId, int rowSpan, int colSpan, Cell.Content cellContent) {
        this.layout.createCell(colId, rowSpan, colSpan, cellContent);
        if (rowSpan < 0) {
            this.hasDropCell = true;
        }
    }

    protected int createDropID(int groupIndex, String dropType) {
        int dropId = -10 * (groupIndex + 1);
        if ("all".equals(dropType)) {
            --dropId;
        }
        return dropId;
    }

    public void resolveAll() {
        if (this.hasDropCell) {
            this.layout.resolveDropCells();
            this.hasDropCell = this.layout.hasDropCell();
        }
    }

    public void resolveCellsOfDrop(int groupLevel, boolean dropAll) {
        if (this.hasDropCell) {
            if (dropAll) {
                this.layout.resolveDropCells(this.createDropID(groupLevel, "all"));
            } else {
                this.layout.resolveDropCells(this.createDropID(groupLevel, "detail"));
            }
            this.hasDropCell = this.layout.hasDropCell();
        }
    }

    public void flush() {
        if (this.hasDropCell()) {
            return;
        }
        Iterator iter = this.layoutEvents.iterator();
        while (iter.hasNext()) {
            LayoutEvent event = (LayoutEvent)iter.next();
            switch (event.eventType) {
                case 0: 
                case 1: {
                    ContentEmitterUtil.startContent((IContent)event.value, this.emitter);
                    break;
                }
                case 2: 
                case 3: {
                    ContentEmitterUtil.endContent((IContent)event.value, this.emitter);
                    break;
                }
                case 4: {
                    this.flushRow((Integer)event.value, true);
                    break;
                }
                case 5: {
                    this.flushRow((Integer)event.value, false);
                }
            }
        }
        this.resetLayout();
    }

    protected void flushRow(int rowId, boolean withStart) {
        int colCount = this.layout.getColCount();
        Row row = this.layout.getRow(rowId);
        IRowContent rowContent = (IRowContent)row.getContent();
        if (withStart) {
            this.emitter.startRow(rowContent);
        }
        for (int j = 0; j < colCount; ++j) {
            Cell cell = row.getCell(j);
            if (cell.getStatus() == 1) {
                CellContent content = (CellContent)cell.getContent();
                CellContentWrapper tempCell = new CellContentWrapper(content.cell);
                tempCell.setColumn(cell.getColId());
                tempCell.setRowSpan(cell.getRowSpan());
                tempCell.setColSpan(cell.getColSpan());
                if (content.buffer != null) {
                    this.emitter.startCell(tempCell);
                    content.buffer.flush();
                    this.emitter.endCell(tempCell);
                }
            }
            if (cell.getStatus() != 0) continue;
            IReportContent report = rowContent.getReportContent();
            ICellContent cellContent = report.createCellContent();
            cellContent.setParent(rowContent);
            cellContent.setColumn(cell.getColId() + 1);
            cellContent.setRowSpan(cell.getRowSpan());
            cellContent.setColSpan(cell.getColSpan());
            this.emitter.startCell(cellContent);
            this.emitter.endCell(cellContent);
        }
        this.emitter.endRow(rowContent);
    }

    protected class CellContent
    implements Cell.Content {
        protected ICellContent cell;
        protected BufferedReportEmitter buffer;

        protected CellContent(ICellContent cell, BufferedReportEmitter buffer) {
            this.cell = cell;
            this.buffer = buffer;
        }

        public boolean isEmpty() {
            return this.buffer == null || this.buffer.isEmpty();
        }

        public void reset() {
            this.buffer = null;
        }
    }

    protected static class LayoutEvent {
        static final int START_GROUP = 0;
        static final int START_BAND = 1;
        static final int END_GROUP = 2;
        static final int END_BAND = 3;
        static final int ON_ROW = 4;
        static final int ON_FIRST_DROP_CELL = 5;
        int eventType;
        Object value;

        LayoutEvent(int type, Object value) {
            this.eventType = type;
            this.value = value;
        }
    }
}

