/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.data.Counter;
import org.eclipse.aperi.snmp.data.Counter64;
import org.eclipse.aperi.snmp.data.FullCounter64;
import org.eclipse.aperi.snmp.data.Gauge;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.Null;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.SpecialValue;
import org.eclipse.aperi.snmp.data.TimeTicks;
import org.eclipse.aperi.snmp.utils.InstrumentationMapper;

public abstract class SnmpMetaPDU
implements Serializable {
    public int version;
    public OctetString communityString;
    public Vector varBindList;
    public IPAddress senderAddr = null;
    public int senderPort = -1;
    protected static Null nullInstance = new Null();
    public static final int INTEGER_TYPE = -1;
    public static final int COUNTER_TYPE = -2;
    public static final int COUNTER64_TYPE = -3;
    public static final int GAUGE_TYPE = -4;
    public static final int TIMETICKS_TYPE = -5;
    public static final int IPADDRESS_TYPE = -6;
    public static final int OID_TYPE = -7;
    public static final int OCTET_TYPE = -8;
    public static final int IMPLEN_OCTET_TYPE = -9;

    protected SnmpMetaPDU() {
        this.version = 0;
        this.communityString = null;
        this.varBindList = new Vector();
    }

    protected SnmpMetaPDU(int n, String string, Vector vector) {
        this.version = n;
        this.communityString = new OctetString(string, true);
        this.varBindList = vector;
    }

    protected SnmpMetaPDU(Vector vector) {
        this.version = 0;
        this.communityString = null;
        this.varBindList = vector;
    }

    protected SnmpMetaPDU(SnmpMetaPDU snmpMetaPDU) {
        this.version = snmpMetaPDU.version;
        if (snmpMetaPDU.communityString != null) {
            this.communityString = new OctetString(snmpMetaPDU.communityString);
        }
        this.varBindList = new Vector();
        int n = 0;
        while (n < snmpMetaPDU.varBindListSize()) {
            SnmpVarBind snmpVarBind = new SnmpVarBind(snmpMetaPDU.varBindAt(n));
            this.varBindList.addElement(snmpVarBind);
            ++n;
        }
    }

    public boolean equals(SnmpMetaPDU snmpMetaPDU) {
        boolean bl = true;
        if (this.version != snmpMetaPDU.version) {
            return false;
        }
        if (!this.communityString.equals(snmpMetaPDU.communityString)) {
            return false;
        }
        if (this.varBindList.size() != snmpMetaPDU.varBindListSize()) {
            return false;
        }
        int n = 0;
        while (n < this.varBindList.size() && bl) {
            bl = ((SnmpVarBind)this.varBindList.elementAt(n)).equals(snmpMetaPDU.varBindAt(n));
            ++n;
        }
        return bl;
    }

    public String varBindListToString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        if (!this.varBindList.isEmpty()) {
            int n = 0;
            while (n < this.varBindList.size()) {
                if (n == 0) {
                    stringBuffer.append(this.varBindList.elementAt(n).toString());
                } else {
                    stringBuffer.append(", " + this.varBindList.elementAt(n).toString());
                }
                ++n;
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void trim() {
        this.varBindList.removeElementAt(this.varBindList.size() - 1);
    }

    public void delete_vb(int n) throws ArrayIndexOutOfBoundsException {
        this.varBindList.removeElementAt(n);
    }

    public Vector get_vblist() {
        return this.varBindList;
    }

    public void set_vblist(Vector vector) {
        this.varBindList = vector;
    }

    public SnmpVarBind get_vb(int n) throws ArrayIndexOutOfBoundsException {
        return (SnmpVarBind)this.varBindList.elementAt(n);
    }

    public void get_vb(SnmpVarBind snmpVarBind, int n) throws ArrayIndexOutOfBoundsException {
        this.varBindList.insertElementAt(snmpVarBind, n);
    }

    public int get_vb_count() {
        return this.varBindList.size();
    }

    public void deleteVarBindList() {
        this.varBindList = new Vector();
    }

    public SnmpVarBind firstVarBind() {
        return (SnmpVarBind)this.varBindList.firstElement();
    }

    public int varBindListSize() {
        return this.varBindList.size();
    }

    public SnmpVarBind varBindAt(int n) {
        if (this.varBindList.size() > n) {
            return (SnmpVarBind)this.varBindList.elementAt(n);
        }
        return null;
    }

    public Vector varBindList() {
        return this.varBindList;
    }

    public void addVarBind(SnmpVarBind snmpVarBind) {
        this.varBindList.addElement(snmpVarBind);
    }

    public int addVarBindReturnIndex(SnmpVarBind snmpVarBind) {
        this.varBindList.addElement(snmpVarBind);
        return this.varBindList.size();
    }

    public void insertVarBindAt(SnmpVarBind snmpVarBind, int n) {
        this.varBindList.insertElementAt(snmpVarBind, n);
    }

    public void insertVarBindAt(String string, Serializable serializable, int n) {
        OID oID = new OID(string);
        SnmpVarBind snmpVarBind = new SnmpVarBind(oID, serializable);
        this.varBindList.insertElementAt(snmpVarBind, n);
    }

    public void addVarBind(String string, Serializable serializable) {
        OID oID = new OID(string);
        this.addVarBind(oID, serializable);
    }

    public void addVarBind(OID oID, Serializable serializable) {
        SnmpVarBind snmpVarBind = new SnmpVarBind(oID, serializable);
        this.varBindList.addElement(snmpVarBind);
    }

    public void addVarBind(String string) {
        OID oID = new OID(string);
        this.addVarBind(oID);
    }

    public void addVarBind(OID oID) {
        SnmpVarBind snmpVarBind = new SnmpVarBind(oID);
        this.varBindList.addElement(snmpVarBind);
    }

    public void removeVarBindAt(int n) {
        this.varBindList.removeElementAt(n);
    }

    public void removeVarBind(Object object) {
        this.varBindList.removeElement(object);
    }

    public void setVarBindList(Vector vector) {
        this.varBindList = vector;
    }

    public static int[] getIndex(Serializable[] serializableArray, int[] nArray) {
        return SnmpMetaPDU.getIndex(serializableArray, nArray, null, null);
    }

    public static int[] getIndex(Serializable[] serializableArray, int[] nArray, int[] nArray2, Object[] objectArray) {
        int n;
        int n2;
        Serializable[] serializableArray2;
        Vector<Serializable> vector = new Vector<Serializable>();
        Serializable[] serializableArray3 = new Serializable[8];
        int n3 = 0;
        if (serializableArray.length < nArray.length) {
            serializableArray2 = new Serializable[nArray.length];
            n2 = 0;
            while (n2 < nArray.length) {
                serializableArray2[n2] = n2 < serializableArray.length ? serializableArray[n2] : null;
                ++n2;
            }
        } else {
            serializableArray2 = serializableArray;
        }
        if (nArray2 != null) {
            n2 = 0;
            while (n2 < nArray.length) {
                if (objectArray[n2] == null) {
                    serializableArray3[n3++] = serializableArray2[n2];
                } else if (serializableArray2[n2] != null) {
                    Serializable[] serializableArray4 = ((InstrumentationMapper)objectArray[n2]).toInstr(serializableArray2[n2]);
                    int n4 = 0;
                    while (n4 < serializableArray4.length) {
                        serializableArray3[n3++] = serializableArray4[n4];
                        ++n4;
                    }
                } else {
                    int n5 = 0;
                    while (n5 < nArray2[n2]) {
                        serializableArray3[n3++] = null;
                        ++n5;
                    }
                }
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < nArray.length) {
                serializableArray3[n2] = serializableArray2[n2];
                ++n2;
            }
        }
        n2 = 0;
        int n6 = 0;
        while (n6 < nArray.length) {
            if (serializableArray3[n6] == null || serializableArray3[n6] instanceof Null) {
                n2 = 1;
            } else {
                if (n2 != 0) {
                    RuntimeException runtimeException = new RuntimeException("SnmpMetaPDU: getIndex received a null index that preceeded non-null indexes");
                    throw runtimeException;
                }
                if (serializableArray3[n6] instanceof Integer) {
                    vector.addElement(serializableArray3[n6]);
                } else if (serializableArray3[n6] instanceof OctetString || serializableArray3[n6] instanceof String) {
                    if (serializableArray3[n6] instanceof String) {
                        serializableArray3[n6] = new OctetString((String)((Object)serializableArray3[n6]), true);
                    }
                    if (nArray[n6] == -8) {
                        vector.addElement(new Integer(((OctetString)serializableArray3[n6]).value.length));
                    }
                    int n7 = 0;
                    while (n7 < ((OctetString)serializableArray3[n6]).value.length) {
                        n = 0xFF & ((OctetString)serializableArray3[n6]).value[n7];
                        vector.addElement(new Integer(n));
                        ++n7;
                    }
                } else if (serializableArray3[n6] instanceof IPAddress) {
                    byte[] byArray = ((IPAddress)serializableArray3[n6]).getBytes();
                    vector.addElement(new Integer(0xFF & byArray[0]));
                    vector.addElement(new Integer(0xFF & byArray[1]));
                    vector.addElement(new Integer(0xFF & byArray[2]));
                    vector.addElement(new Integer(0xFF & byArray[3]));
                } else if (serializableArray3[n6] instanceof OID) {
                    long[] lArray = ((OID)serializableArray3[n6]).value;
                    vector.addElement(new Long(lArray.length));
                    n = 0;
                    while (n < lArray.length) {
                        vector.addElement(new Long(lArray[n]));
                        ++n;
                    }
                } else if (serializableArray3[n6] instanceof Counter) {
                    vector.addElement(new Integer((int)((Counter)serializableArray3[n6]).value));
                } else if (serializableArray3[n6] instanceof Counter64) {
                    vector.addElement(new Integer((int)((Counter64)serializableArray3[n6]).value));
                } else if (serializableArray3[n6] instanceof Gauge) {
                    vector.addElement(new Integer((int)((Gauge)serializableArray3[n6]).value));
                } else if (serializableArray3[n6] instanceof TimeTicks) {
                    vector.addElement(new Integer((int)((TimeTicks)serializableArray3[n6]).value));
                } else if (serializableArray3[n6] instanceof FullCounter64) {
                    vector.addElement(new Integer(((FullCounter64)serializableArray3[n6]).value.intValue()));
                } else {
                    if (serializableArray3[n6] instanceof SpecialValue) {
                        vector.removeAllElements();
                        break;
                    }
                    System.out.println("SnmpMetaPDU: getIndex received bad type " + serializableArray3[n6].getClass());
                    vector.removeAllElements();
                    break;
                }
            }
            ++n6;
        }
        n6 = vector.size();
        if (n6 == 0) {
            return null;
        }
        int[] nArray3 = new int[n6];
        n = 0;
        while (n < n6) {
            nArray3[n] = (Integer)vector.elementAt(n);
            ++n;
        }
        return nArray3;
    }

    public static OID getPreviousOID(OID oID) {
        OID oID2 = null;
        int n = oID.value.length - 1;
        if (oID.value[n] < 1L) {
            --n;
            while (oID.value[n] == 0L) {
                --n;
            }
            long[] lArray = new long[n + 1];
            int n2 = n;
            while (n2 >= 0) {
                lArray[n2] = oID.value[n2];
                oID2 = new OID(lArray, true);
                --n2;
            }
        } else {
            oID2 = new OID(oID);
            oID2.value[n] = oID.value[n] - 1L;
        }
        return oID2;
    }
}

