/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.aperi.snmp.SnmpAsn1;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpUnknownHostException;
import org.eclipse.aperi.snmp.SnmpV1API;

public class SnmpTarget {
    protected InetAddress destination;
    protected int port;
    protected boolean canReplayMessages;
    int useCount = 0;

    protected SnmpTarget() {
    }

    protected SnmpTarget(String string, int n) throws SnmpUnknownHostException {
        try {
            this.destination = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new SnmpUnknownHostException();
        }
        this.port = n;
        this.useCount = 1;
    }

    public void close() {
        --this.useCount;
        SnmpV1API.terminateTraps();
    }

    public static void send(SnmpTrap snmpTrap, String string, int n) throws SnmpUnknownHostException, IOException {
        InetAddress inetAddress;
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("==> Sending Trap \n" + snmpTrap.toString());
        }
        if (SnmpV1API.trapSocket != null) {
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (Exception exception) {
                throw new SnmpUnknownHostException();
            }
        } else {
            throw new SnmpSocketException("SnmpV1API traps not available");
        }
        byte[] byArray = SnmpAsn1.encode(snmpTrap, null);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        SnmpV1API.trapSocket.send(datagramPacket);
    }

    public static void send(SnmpTrap snmpTrap, String string) throws SnmpUnknownHostException, IOException {
        SnmpTarget.send(snmpTrap, string, 162);
    }

    public void send(SnmpTrap snmpTrap) throws IOException {
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("==> Sending Trap \n" + snmpTrap.toString());
        }
        if (SnmpV1API.trapSocket == null) {
            throw new SnmpSocketException("SnmpV1API traps not available");
        }
        byte[] byArray = SnmpAsn1.encode(snmpTrap, null);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.destination, this.port);
        SnmpV1API.trapSocket.send(datagramPacket);
    }
}

