/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.Serializable;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpV1API;

public class SnmpV2PDU
extends SnmpPDU
implements Serializable {
    public int nonRepeaters;
    public int maxRepetitions;

    protected SnmpV2PDU() {
        this.version = 1;
    }

    protected SnmpV2PDU(SnmpV2PDU snmpV2PDU) {
        super(snmpV2PDU);
        this.version = 1;
    }

    public SnmpV2PDU clone(SnmpV2PDU snmpV2PDU) {
        return new SnmpV2PDU(snmpV2PDU);
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer("Message :");
            stringBuffer.append(" version=" + this.version);
            if (SnmpV1API.exposeSecurityInfo) {
                if (this.communityString != null) {
                    stringBuffer.append(" communityString=" + this.communityString.toDisplayString());
                } else {
                    stringBuffer.append(" communityString=<value for V2 Session>");
                }
            }
            if (this.operation != 4) {
                if (this.errorStatus >= 0 && this.errorStatus < errorStatusString.length) {
                    stringBuffer.append("\n          errorStatus=" + errorStatusString[this.errorStatus]);
                } else if (this.errorStatus == 100) {
                    stringBuffer.append("\n          errorStatus=Timeout");
                } else if (this.errorStatus == 101) {
                    stringBuffer.append("\n          errorStatus=SendError");
                } else if (this.errorStatus == 102) {
                    stringBuffer.append("\n          errorStatus=Session Terminated");
                } else if (this.errorStatus == 103) {
                    stringBuffer.append("\n          errorStatus=Decode Error");
                } else {
                    stringBuffer.append("\n          errorStatus=" + this.errorStatus);
                }
                if (this.errorStatus != 0) {
                    stringBuffer.append(" errorIndex=" + this.errorIndex);
                }
            } else {
                stringBuffer.append("\n          nonRepeaters=" + this.nonRepeaters);
                stringBuffer.append(" maxRepetitions=" + this.maxRepetitions);
            }
            stringBuffer.append("\n          operation=" + operationString[this.operation]);
            stringBuffer.append(" requestId=" + this.requestId);
            stringBuffer.append(" correlator=" + this.correlator);
            stringBuffer.append("       ");
            stringBuffer.append(this.varBindListToString());
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "V2 Message cannot be formatted";
        }
    }
}

