/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.utils;

import org.eclipse.aperi.snmp.utils.DispatchMessage;
import org.eclipse.aperi.snmp.utils.Orderable;
import org.eclipse.aperi.snmp.utils.OrderedQueue;

public class DispatchQueue
extends Thread {
    private static int instanceCount = 0;
    OrderedQueue q = new OrderedQueue(true);
    boolean alive = true;

    private static synchronized int incrementInstanceCount() {
        return ++instanceCount;
    }

    public DispatchQueue() {
        super("DispatchQueue " + DispatchQueue.incrementInstanceCount());
        this.start();
    }

    public void run() {
        while (this.alive) {
            DispMsgContainer dispMsgContainer = (DispMsgContainer)this.q.dequeue();
            try {
                dispMsgContainer.msg.dispatch();
            }
            catch (Throwable throwable) {
                System.out.println("Recovered from the following exception:");
                throwable.printStackTrace();
            }
        }
    }

    public static synchronized int getInstanceCount() {
        return instanceCount;
    }

    public synchronized void post(DispatchMessage dispatchMessage) {
        DispMsgContainer dispMsgContainer = new DispMsgContainer(dispatchMessage);
        this.q.enqueue(dispMsgContainer);
    }

    public synchronized void dispose() {
        this.alive = false;
    }

    private class DispMsgContainer
    implements Orderable {
        protected DispatchMessage msg;

        public DispMsgContainer(DispatchMessage dispatchMessage) {
            this.msg = dispatchMessage;
        }

        public int compare(Orderable orderable) {
            if (orderable instanceof DispMsgContainer) {
                DispMsgContainer dispMsgContainer = (DispMsgContainer)orderable;
                if (this.msg.getPriority() == dispMsgContainer.msg.getPriority()) {
                    return 1;
                }
                if (this.msg.getPriority() < dispMsgContainer.msg.getPriority()) {
                    return 2;
                }
                return 0;
            }
            return 1;
        }
    }
}

