/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.impl;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.ModelPackage;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ExtendedProperty;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.Interactivity;
import org.eclipse.birt.chart.model.attribute.StyleMap;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.InteractivityImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.model.layout.impl.BlockImpl;
import org.eclipse.birt.chart.model.layout.impl.LegendImpl;
import org.eclipse.birt.chart.model.layout.impl.PlotImpl;
import org.eclipse.birt.chart.model.layout.impl.TitleBlockImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ChartImpl
extends EObjectImpl
implements Chart {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/model.impl");
    protected static final String VERSION_EDEFAULT = "1.0.0";
    protected String version = "1.0.0";
    protected boolean versionESet = false;
    protected static final String TYPE_EDEFAULT = null;
    protected String type = TYPE_EDEFAULT;
    protected static final String SUB_TYPE_EDEFAULT = null;
    protected String subType = SUB_TYPE_EDEFAULT;
    protected Text description = null;
    protected Block block = null;
    protected static final ChartDimension DIMENSION_EDEFAULT = ChartDimension.TWO_DIMENSIONAL_LITERAL;
    protected ChartDimension dimension = DIMENSION_EDEFAULT;
    protected boolean dimensionESet = false;
    protected static final String SCRIPT_EDEFAULT = null;
    protected String script = SCRIPT_EDEFAULT;
    protected static final String UNITS_EDEFAULT = null;
    protected String units = UNITS_EDEFAULT;
    protected static final double SERIES_THICKNESS_EDEFAULT = 0.0;
    protected double seriesThickness = 0.0;
    protected boolean seriesThicknessESet = false;
    protected static final int GRID_COLUMN_COUNT_EDEFAULT = 0;
    protected int gridColumnCount = 0;
    protected boolean gridColumnCountESet = false;
    protected EList extendedProperties = null;
    protected SampleData sampleData = null;
    protected EList styles = null;
    protected Interactivity interactivity = null;

    protected ChartImpl() {
    }

    protected EClass eStaticClass() {
        return ModelPackage.Literals.CHART;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        boolean oldVersionESet = this.versionESet;
        this.versionESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldVersion, (Object)this.version, !oldVersionESet));
        }
    }

    public void unsetVersion() {
        String oldVersion = this.version;
        boolean oldVersionESet = this.versionESet;
        this.version = VERSION_EDEFAULT;
        this.versionESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 0, (Object)oldVersion, (Object)VERSION_EDEFAULT, oldVersionESet));
        }
    }

    public boolean isSetVersion() {
        return this.versionESet;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String newType) {
        String oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldType, (Object)this.type));
        }
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String newSubType) {
        String oldSubType = this.subType;
        this.subType = newSubType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldSubType, (Object)this.subType));
        }
    }

    public Text getDescription() {
        return this.description;
    }

    public NotificationChain basicSetDescription(Text newDescription, NotificationChain msgs) {
        Text oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldDescription, (Object)newDescription);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setDescription(Text newDescription) {
        if (newDescription != this.description) {
            NotificationChain msgs = null;
            if (this.description != null) {
                msgs = ((InternalEObject)this.description).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newDescription != null) {
                msgs = ((InternalEObject)newDescription).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetDescription(newDescription, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newDescription, (Object)newDescription));
        }
    }

    public Block getBlock() {
        return this.block;
    }

    public NotificationChain basicSetBlock(Block newBlock, NotificationChain msgs) {
        Block oldBlock = this.block;
        this.block = newBlock;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldBlock, (Object)newBlock);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setBlock(Block newBlock) {
        if (newBlock != this.block) {
            NotificationChain msgs = null;
            if (this.block != null) {
                msgs = ((InternalEObject)this.block).eInverseRemove((InternalEObject)this, -5, null, msgs);
            }
            if (newBlock != null) {
                msgs = ((InternalEObject)newBlock).eInverseAdd((InternalEObject)this, -5, null, msgs);
            }
            if ((msgs = this.basicSetBlock(newBlock, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newBlock, (Object)newBlock));
        }
    }

    public ChartDimension getDimension() {
        return this.dimension;
    }

    public void setDimension(ChartDimension newDimension) {
        ChartDimension oldDimension = this.dimension;
        this.dimension = newDimension == null ? DIMENSION_EDEFAULT : newDimension;
        boolean oldDimensionESet = this.dimensionESet;
        this.dimensionESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldDimension, (Object)this.dimension, !oldDimensionESet));
        }
    }

    public void unsetDimension() {
        ChartDimension oldDimension = this.dimension;
        boolean oldDimensionESet = this.dimensionESet;
        this.dimension = DIMENSION_EDEFAULT;
        this.dimensionESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 5, (Object)oldDimension, (Object)DIMENSION_EDEFAULT, oldDimensionESet));
        }
    }

    public boolean isSetDimension() {
        return this.dimensionESet;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String newScript) {
        String oldScript = this.script;
        this.script = newScript;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldScript, (Object)this.script));
        }
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String newUnits) {
        String oldUnits = this.units;
        this.units = newUnits;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldUnits, (Object)this.units));
        }
    }

    public double getSeriesThickness() {
        return this.seriesThickness;
    }

    public void setSeriesThickness(double newSeriesThickness) {
        double oldSeriesThickness = this.seriesThickness;
        this.seriesThickness = newSeriesThickness;
        boolean oldSeriesThicknessESet = this.seriesThicknessESet;
        this.seriesThicknessESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldSeriesThickness, this.seriesThickness, !oldSeriesThicknessESet));
        }
    }

    public void unsetSeriesThickness() {
        double oldSeriesThickness = this.seriesThickness;
        boolean oldSeriesThicknessESet = this.seriesThicknessESet;
        this.seriesThickness = 0.0;
        this.seriesThicknessESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 8, oldSeriesThickness, 0.0, oldSeriesThicknessESet));
        }
    }

    public boolean isSetSeriesThickness() {
        return this.seriesThicknessESet;
    }

    public int getGridColumnCount() {
        return this.gridColumnCount;
    }

    public void setGridColumnCount(int newGridColumnCount) {
        int oldGridColumnCount = this.gridColumnCount;
        this.gridColumnCount = newGridColumnCount;
        boolean oldGridColumnCountESet = this.gridColumnCountESet;
        this.gridColumnCountESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldGridColumnCount, this.gridColumnCount, !oldGridColumnCountESet));
        }
    }

    public void unsetGridColumnCount() {
        int oldGridColumnCount = this.gridColumnCount;
        boolean oldGridColumnCountESet = this.gridColumnCountESet;
        this.gridColumnCount = 0;
        this.gridColumnCountESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 9, oldGridColumnCount, 0, oldGridColumnCountESet));
        }
    }

    public boolean isSetGridColumnCount() {
        return this.gridColumnCountESet;
    }

    public EList getExtendedProperties() {
        if (this.extendedProperties == null) {
            this.extendedProperties = new EObjectContainmentEList(ExtendedProperty.class, (InternalEObject)this, 10);
        }
        return this.extendedProperties;
    }

    public SampleData getSampleData() {
        return this.sampleData;
    }

    public NotificationChain basicSetSampleData(SampleData newSampleData, NotificationChain msgs) {
        SampleData oldSampleData = this.sampleData;
        this.sampleData = newSampleData;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldSampleData, (Object)newSampleData);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setSampleData(SampleData newSampleData) {
        if (newSampleData != this.sampleData) {
            NotificationChain msgs = null;
            if (this.sampleData != null) {
                msgs = ((InternalEObject)this.sampleData).eInverseRemove((InternalEObject)this, -12, null, msgs);
            }
            if (newSampleData != null) {
                msgs = ((InternalEObject)newSampleData).eInverseAdd((InternalEObject)this, -12, null, msgs);
            }
            if ((msgs = this.basicSetSampleData(newSampleData, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)newSampleData, (Object)newSampleData));
        }
    }

    public EList getStyles() {
        if (this.styles == null) {
            this.styles = new EObjectContainmentEList(StyleMap.class, (InternalEObject)this, 12);
        }
        return this.styles;
    }

    public Interactivity getInteractivity() {
        return this.interactivity;
    }

    public NotificationChain basicSetInteractivity(Interactivity newInteractivity, NotificationChain msgs) {
        Interactivity oldInteractivity = this.interactivity;
        this.interactivity = newInteractivity;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldInteractivity, (Object)newInteractivity);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setInteractivity(Interactivity newInteractivity) {
        if (newInteractivity != this.interactivity) {
            NotificationChain msgs = null;
            if (this.interactivity != null) {
                msgs = ((InternalEObject)this.interactivity).eInverseRemove((InternalEObject)this, -14, null, msgs);
            }
            if (newInteractivity != null) {
                msgs = ((InternalEObject)newInteractivity).eInverseAdd((InternalEObject)this, -14, null, msgs);
            }
            if ((msgs = this.basicSetInteractivity(newInteractivity, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)newInteractivity, (Object)newInteractivity));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetDescription(null, msgs);
            }
            case 4: {
                return this.basicSetBlock(null, msgs);
            }
            case 10: {
                return ((InternalEList)this.getExtendedProperties()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return this.basicSetSampleData(null, msgs);
            }
            case 12: {
                return ((InternalEList)this.getStyles()).basicRemove((Object)otherEnd, msgs);
            }
            case 13: {
                return this.basicSetInteractivity(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getVersion();
            }
            case 1: {
                return this.getType();
            }
            case 2: {
                return this.getSubType();
            }
            case 3: {
                return this.getDescription();
            }
            case 4: {
                return this.getBlock();
            }
            case 5: {
                return this.getDimension();
            }
            case 6: {
                return this.getScript();
            }
            case 7: {
                return this.getUnits();
            }
            case 8: {
                return new Double(this.getSeriesThickness());
            }
            case 9: {
                return new Integer(this.getGridColumnCount());
            }
            case 10: {
                return this.getExtendedProperties();
            }
            case 11: {
                return this.getSampleData();
            }
            case 12: {
                return this.getStyles();
            }
            case 13: {
                return this.getInteractivity();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setVersion((String)newValue);
                return;
            }
            case 1: {
                this.setType((String)newValue);
                return;
            }
            case 2: {
                this.setSubType((String)newValue);
                return;
            }
            case 3: {
                this.setDescription((Text)newValue);
                return;
            }
            case 4: {
                this.setBlock((Block)newValue);
                return;
            }
            case 5: {
                this.setDimension((ChartDimension)((Object)newValue));
                return;
            }
            case 6: {
                this.setScript((String)newValue);
                return;
            }
            case 7: {
                this.setUnits((String)newValue);
                return;
            }
            case 8: {
                this.setSeriesThickness((Double)newValue);
                return;
            }
            case 9: {
                this.setGridColumnCount((Integer)newValue);
                return;
            }
            case 10: {
                this.getExtendedProperties().clear();
                this.getExtendedProperties().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setSampleData((SampleData)newValue);
                return;
            }
            case 12: {
                this.getStyles().clear();
                this.getStyles().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.setInteractivity((Interactivity)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.unsetVersion();
                return;
            }
            case 1: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
            case 2: {
                this.setSubType(SUB_TYPE_EDEFAULT);
                return;
            }
            case 3: {
                this.setDescription(null);
                return;
            }
            case 4: {
                this.setBlock(null);
                return;
            }
            case 5: {
                this.unsetDimension();
                return;
            }
            case 6: {
                this.setScript(SCRIPT_EDEFAULT);
                return;
            }
            case 7: {
                this.setUnits(UNITS_EDEFAULT);
                return;
            }
            case 8: {
                this.unsetSeriesThickness();
                return;
            }
            case 9: {
                this.unsetGridColumnCount();
                return;
            }
            case 10: {
                this.getExtendedProperties().clear();
                return;
            }
            case 11: {
                this.setSampleData(null);
                return;
            }
            case 12: {
                this.getStyles().clear();
                return;
            }
            case 13: {
                this.setInteractivity(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.isSetVersion();
            }
            case 1: {
                return TYPE_EDEFAULT == null ? this.type != null : !TYPE_EDEFAULT.equals(this.type);
            }
            case 2: {
                return SUB_TYPE_EDEFAULT == null ? this.subType != null : !SUB_TYPE_EDEFAULT.equals(this.subType);
            }
            case 3: {
                return this.description != null;
            }
            case 4: {
                return this.block != null;
            }
            case 5: {
                return this.isSetDimension();
            }
            case 6: {
                return SCRIPT_EDEFAULT == null ? this.script != null : !SCRIPT_EDEFAULT.equals(this.script);
            }
            case 7: {
                return UNITS_EDEFAULT == null ? this.units != null : !UNITS_EDEFAULT.equals(this.units);
            }
            case 8: {
                return this.isSetSeriesThickness();
            }
            case 9: {
                return this.isSetGridColumnCount();
            }
            case 10: {
                return this.extendedProperties != null && !this.extendedProperties.isEmpty();
            }
            case 11: {
                return this.sampleData != null;
            }
            case 12: {
                return this.styles != null && !this.styles.isEmpty();
            }
            case 13: {
                return this.interactivity != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (version: ");
        if (this.versionESet) {
            result.append(this.version);
        } else {
            result.append("<unset>");
        }
        result.append(", type: ");
        result.append(this.type);
        result.append(", subType: ");
        result.append(this.subType);
        result.append(", dimension: ");
        if (this.dimensionESet) {
            result.append((Object)this.dimension);
        } else {
            result.append("<unset>");
        }
        result.append(", script: ");
        result.append(this.script);
        result.append(", units: ");
        result.append(this.units);
        result.append(", seriesThickness: ");
        if (this.seriesThicknessESet) {
            result.append(this.seriesThickness);
        } else {
            result.append("<unset>");
        }
        result.append(", gridColumnCount: ");
        if (this.gridColumnCountESet) {
            result.append(this.gridColumnCount);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public final Legend getLegend() {
        return (Legend)ChartImpl.find(this.block, LegendImpl.class);
    }

    public final Plot getPlot() {
        return (Plot)ChartImpl.find(this.block, PlotImpl.class);
    }

    public final TitleBlock getTitle() {
        return (TitleBlock)ChartImpl.find(this.block, TitleBlockImpl.class);
    }

    private static final Block find(Block bl, Class c) {
        if (c.isInstance(bl)) {
            return bl;
        }
        Block blFound = null;
        EList el = bl.getChildren();
        for (int iC = 0; iC < el.size(); ++iC) {
            blFound = ChartImpl.find((BlockImpl)el.get(iC), c);
            if (blFound == null) continue;
            return blFound;
        }
        return null;
    }

    protected void initialize() {
        this.block = BlockImpl.create();
        this.block.setBackground(ColorDefinitionImpl.WHITE());
        TitleBlock tb = (TitleBlock)TitleBlockImpl.create();
        Plot pl = (Plot)PlotImpl.create();
        Legend lg = (Legend)LegendImpl.create();
        this.block.add(tb);
        this.block.add(pl);
        this.block.add(lg);
        Text txtChartTitle = tb.getLabel().getCaption();
        txtChartTitle.setValue("Chart Title");
        txtChartTitle.getFont().setSize(16.0f);
        txtChartTitle.getFont().setBold(true);
        TextAlignment taTitle = TextAlignmentImpl.create();
        taTitle.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
        taTitle.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
        txtChartTitle.getFont().setAlignment(taTitle);
        this.setDimension(ChartDimension.TWO_DIMENSIONAL_LITERAL);
        this.setSeriesThickness(10.0);
        this.setInteractivity(InteractivityImpl.create());
    }

    public SeriesDefinition[] getSeriesForLegend() {
        return null;
    }

    public void clearSections(int iSectionType) {
    }

    public final void createSampleRuntimeSeries() {
        ChartImpl chart = this;
        SampleData sd = chart.getSampleData();
        if (sd == null || sd.getBaseSampleData().size() == 0 || sd.getOrthogonalSampleData().size() == 0) {
            return;
        }
        try {
            SeriesDefinition sdZ;
            Series seriesBaseRuntime = (Series)EcoreUtil.copy((EObject)this.getBaseSeriesDefinitionForProcessing().getDesignTimeSeries());
            seriesBaseRuntime.setDataSet(null);
            chart.clearSections(3);
            seriesBaseRuntime.setDataSet(PluginSettings.instance().getDataSetProcessor(this.getBaseSeriesDefinitionForProcessing().getDesignTimeSeries().getClass()).fromString(((BaseSampleData)sd.getBaseSampleData().get(0)).getDataSetRepresentation(), seriesBaseRuntime.getDataSet()));
            this.getBaseSeriesDefinitionForProcessing().getSeries().add((Object)seriesBaseRuntime);
            seriesBaseRuntime.setSeriesIdentifier("Category");
            Vector vOSD = this.getOrthogonalSeriesDefinitions();
            int[] iOSD = new int[vOSD.size()];
            SeriesDefinition sdTmp = null;
            Series seriesOrthogonalRuntime = null;
            for (int i = 0; i < iOSD.length; ++i) {
                iOSD[i] = 0;
                sdTmp = (SeriesDefinition)vOSD.get(i);
            }
            for (int iO = 0; iO < sd.getOrthogonalSampleData().size(); ++iO) {
                OrthogonalSampleData osd = (OrthogonalSampleData)sd.getOrthogonalSampleData().get(iO);
                int iSDIndex = osd.getSeriesDefinitionIndex();
                if (iSDIndex > vOSD.size() - 1) {
                    sd.getOrthogonalSampleData().remove(iO);
                    --iO;
                    continue;
                }
                sdTmp = (SeriesDefinition)vOSD.get(iSDIndex);
                seriesOrthogonalRuntime = (Series)EcoreUtil.copy((EObject)sdTmp.getDesignTimeSeries());
                seriesOrthogonalRuntime.setDataSet(null);
                seriesOrthogonalRuntime.setDataSet(PluginSettings.instance().getDataSetProcessor(sdTmp.getDesignTimeSeries().getClass()).fromString(osd.getDataSetRepresentation(), seriesOrthogonalRuntime.getDataSet()));
                seriesOrthogonalRuntime.setSeriesIdentifier(sdTmp.getDesignTimeSeries().getSeriesIdentifier());
                sdTmp.getSeries().add((Object)seriesOrthogonalRuntime);
            }
            if (chart.getDimension() == ChartDimension.THREE_DIMENSIONAL_LITERAL && (sdZ = this.getAncillaryBaseSeriesDefinitionForProcessing()) != null && sd.getAncillarySampleData().size() > 0) {
                Series seriesZRuntime = (Series)EcoreUtil.copy((EObject)sdZ.getDesignTimeSeries());
                seriesZRuntime.setDataSet(null);
                seriesZRuntime.setDataSet(PluginSettings.instance().getDataSetProcessor(sdZ.getDesignTimeSeries().getClass()).fromString(((BaseSampleData)sd.getAncillarySampleData().get(0)).getDataSetRepresentation(), seriesZRuntime.getDataSet()));
                sdZ.getSeries().add((Object)seriesZRuntime);
                seriesZRuntime.setSeriesIdentifier("Series");
            }
        }
        catch (Exception e1) {
            logger.log(e1);
        }
    }

    private SeriesDefinition getBaseSeriesDefinitionForProcessing() {
        ChartImpl chart = this;
        if (chart instanceof ChartWithAxes) {
            return (SeriesDefinition)((Axis)((ChartWithAxes)((Object)chart)).getAxes().get(0)).getSeriesDefinitions().get(0);
        }
        return (SeriesDefinition)((ChartWithoutAxes)((Object)chart)).getSeriesDefinitions().get(0);
    }

    private SeriesDefinition getAncillaryBaseSeriesDefinitionForProcessing() {
        Axis baseAxis;
        ChartImpl chart = this;
        if (chart instanceof ChartWithAxes && (baseAxis = (Axis)((ChartWithAxes)((Object)chart)).getAxes().get(0)).getAncillaryAxes().size() > 0) {
            return (SeriesDefinition)((Axis)baseAxis.getAncillaryAxes().get(0)).getSeriesDefinitions().get(0);
        }
        return null;
    }

    private Vector getOrthogonalSeriesDefinitions() {
        ChartImpl chart = this;
        Vector<Object> vTmp = new Vector<Object>();
        if (chart instanceof ChartWithAxes) {
            Axis axisBase = null;
            Object[] oSD = null;
            for (int iC = 0; iC < ((ChartWithAxes)((Object)chart)).getAxes().size(); ++iC) {
                axisBase = (Axis)((ChartWithAxes)((Object)chart)).getAxes().get(iC);
                for (int iAC = 0; iAC < axisBase.getAssociatedAxes().size(); ++iAC) {
                    oSD = ((Axis)axisBase.getAssociatedAxes().get(iAC)).getSeriesDefinitions().toArray();
                    for (int iA = 0; iA < oSD.length; ++iA) {
                        vTmp.add(oSD[iA]);
                    }
                }
            }
            return vTmp;
        }
        Object[] oSD = null;
        for (int iC = 0; iC < ((ChartWithoutAxes)((Object)chart)).getSeriesDefinitions().size(); ++iC) {
            oSD = ((SeriesDefinition)((ChartWithoutAxes)((Object)chart)).getSeriesDefinitions().get(iC)).getSeriesDefinitions().toArray();
            for (int iA = 0; iA < oSD.length; ++iA) {
                vTmp.add(oSD[iA]);
            }
        }
        return vTmp;
    }
}

