/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.eclipse.birt.report.model.activity.AbstractElementRecord;
import org.eclipse.birt.report.model.activity.ActivityRecord;
import org.eclipse.birt.report.model.activity.FilterEventsCompoundRecord;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.activity.ValidationRecordTask;
import org.eclipse.birt.report.model.api.activity.IEventFilter;
import org.eclipse.birt.report.model.api.activity.TransactionOption;

public class CompoundRecord
extends ActivityRecord {
    private List recordList = new ArrayList();
    protected TransactionOption options = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CompoundRecord(String text) {
        this.label = text;
    }

    public CompoundRecord(String text, boolean isPersistent) {
        this.label = text;
        this.isPersistent = isPersistent;
    }

    public List getRecords() {
        return this.recordList;
    }

    public void execute() {
        if (!$assertionsDisabled && !this.checkState(1)) {
            throw new AssertionError();
        }
    }

    public void undo() {
        Stack<CompoundRecord> stack = new Stack<CompoundRecord>();
        stack.push(this);
        for (int i = this.recordList.size() - 1; i >= 0; --i) {
            ActivityRecord record = (ActivityRecord)this.recordList.get(i);
            if (!$assertionsDisabled && record.getState() != 1 && record.getState() != 3) {
                throw new AssertionError();
            }
            record.undo();
            record.setState(2);
            record.performPostTasks(stack);
        }
    }

    public void redo() {
        Stack<CompoundRecord> stack = new Stack<CompoundRecord>();
        stack.push(this);
        for (int i = 0; i < this.recordList.size(); ++i) {
            ActivityRecord record = (ActivityRecord)this.recordList.get(i);
            if (!$assertionsDisabled && record.getState() != 2) {
                throw new AssertionError();
            }
            record.redo();
            record.setState(3);
            record.performPostTasks(stack);
        }
    }

    private boolean checkState(int state) {
        Iterator iter = this.recordList.iterator();
        while (iter.hasNext()) {
            ActivityRecord cmd = (ActivityRecord)iter.next();
            if (cmd.getState() == state) continue;
            return false;
        }
        return true;
    }

    public boolean canUndo() {
        ListIterator records = this.recordList.listIterator();
        while (records.hasNext()) {
            ActivityRecord record = (ActivityRecord)records.next();
            if (record.canUndo()) continue;
            return false;
        }
        return true;
    }

    public boolean canRedo() {
        ListIterator records = this.recordList.listIterator();
        while (records.hasNext()) {
            ActivityRecord record = (ActivityRecord)records.next();
            if (record.canRedo()) continue;
            return false;
        }
        return true;
    }

    public void append(ActivityRecord record) {
        if (!$assertionsDisabled && record == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && record.getState() != 1) {
            throw new AssertionError();
        }
        this.recordList.add(record);
    }

    public boolean isEmpty() {
        return this.recordList.isEmpty();
    }

    public int getCount() {
        return this.recordList.size();
    }

    public ActivityRecord pop() {
        if (this.recordList.isEmpty()) {
            return null;
        }
        return (ActivityRecord)this.recordList.remove(this.recordList.size() - 1);
    }

    public List getValidators() {
        ArrayList list = new ArrayList();
        Iterator iter = this.recordList.iterator();
        while (iter.hasNext()) {
            ActivityRecord record = (ActivityRecord)iter.next();
            list.addAll(record.getValidators());
        }
        return list;
    }

    public void rollback() {
        Stack<CompoundRecord> stack = new Stack<CompoundRecord>();
        stack.push(this);
        for (int i = this.recordList.size() - 1; i >= 0; --i) {
            ActivityRecord record = (ActivityRecord)this.recordList.get(i);
            if (record.isPersistent()) continue;
            record.rollback();
            record.performPostTasks(stack);
        }
    }

    protected List getPostTasks() {
        ArrayList retList = new ArrayList();
        for (int i = this.recordList.size() - 1; i >= 0; --i) {
            ActivityRecord record = (ActivityRecord)this.recordList.get(i);
            retList.addAll(record.getPostTasks());
        }
        return retList;
    }

    protected void performPostTasks(Stack transStack) {
        List simpleTasks = this.getPostTasks();
        ArrayList<RecordTask> validationTasks = new ArrayList<RecordTask>();
        for (int i = 0; i < simpleTasks.size(); ++i) {
            RecordTask task = (RecordTask)simpleTasks.get(i);
            if (!(task instanceof ValidationRecordTask)) continue;
            validationTasks.add(task);
        }
        if (this instanceof FilterEventsCompoundRecord && transStack.isEmpty()) {
            if (!$assertionsDisabled && this.options == null) {
                throw new AssertionError();
            }
            IEventFilter filter = this.options.getEventFilter();
            if (!$assertionsDisabled && filter == null) {
                throw new AssertionError();
            }
            this.doTasks(transStack, filter.filter(this.getNotificationTask(this.getPostTasks())));
        } else if (this.options != null && this.options.getSendTime() != 0) {
            this.doTasks(transStack, this.getFilterNotificationTask());
        }
        if (!validationTasks.isEmpty()) {
            ((RecordTask)validationTasks.get(0)).doTask(this, transStack);
        }
    }

    private List getFilterNotificationTask() {
        IEventFilter filter;
        List events = new ArrayList();
        for (int i = 0; i < this.recordList.size(); ++i) {
            CompoundRecord cr;
            TransactionOption options;
            ActivityRecord record = (ActivityRecord)this.recordList.get(i);
            if (record instanceof AbstractElementRecord) {
                events.addAll(this.getNotificationTask(record.getPostTasks()));
                continue;
            }
            if (!(record instanceof CompoundRecord) || (options = (cr = (CompoundRecord)record).getOptions()) == null || options.getSendTime() != 2) continue;
            events.addAll(cr.getFilterNotificationTask());
        }
        if (this.options != null && (filter = this.options.getEventFilter()) != null) {
            events = filter.filter(events);
        }
        return events;
    }

    private List getNotificationTask(List tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<RecordTask> events = new ArrayList<RecordTask>();
        for (int i = 0; i < tasks.size(); ++i) {
            RecordTask task = (RecordTask)tasks.get(i);
            if (!(task instanceof NotificationRecordTask)) continue;
            events.add(task);
        }
        return events;
    }

    protected void doTasks(Stack transStack, List tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        for (int i = 0; i < tasks.size(); ++i) {
            RecordTask task = (RecordTask)tasks.get(i);
            task.doTask(this, transStack);
        }
    }

    public TransactionOption getOptions() {
        return this.options;
    }

    public void setOptions(TransactionOption options) {
        this.options = options;
    }

    static {
        $assertionsDisabled = !CompoundRecord.class.desiredAssertionStatus();
    }
}

