/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class SimpleGroupElementHandle
extends GroupElementHandle {
    protected final Module module;
    protected List elements = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SimpleGroupElementHandle(ModuleHandle moduleHandle, List elements) {
        if (!$assertionsDisabled && moduleHandle == null) {
            throw new AssertionError();
        }
        this.module = moduleHandle.getModule();
        if (!$assertionsDisabled && elements == null) {
            throw new AssertionError();
        }
        this.elements = elements;
    }

    public List getElements() {
        return this.elements;
    }

    public Module getModule() {
        return this.module;
    }

    public ModuleHandle getModuleHandle() {
        return (ModuleHandle)this.module.getHandle(this.module);
    }

    public List getCommonProperties() {
        List minProps = this.getMinPropDefns();
        ArrayList commonProps = new ArrayList(minProps);
        Iterator iter = minProps.iterator();
        block0: while (iter.hasNext()) {
            PropertyDefn propDefn = (PropertyDefn)iter.next();
            for (int i = 0; i < this.elements.size(); ++i) {
                if (((DesignElementHandle)this.elements.get(i)).getElement().getPropertyDefns().contains(propDefn)) continue;
                commonProps.remove(propDefn);
                continue block0;
            }
        }
        return Collections.unmodifiableList(commonProps);
    }

    private List getMinPropDefns() {
        int min = Integer.MAX_VALUE;
        List rtnPropDefns = Collections.EMPTY_LIST;
        for (int j = 0; j < this.elements.size(); ++j) {
            Object item = this.elements.get(j);
            if (!(item instanceof DesignElementHandle)) {
                return Collections.EMPTY_LIST;
            }
            List propDefns = ((DesignElementHandle)item).getElement().getPropertyDefns();
            if (propDefns.size() >= min) continue;
            min = propDefns.size();
            rtnPropDefns = propDefns;
        }
        return rtnPropDefns;
    }

    public boolean isSameType() {
        if (this.elements.size() == 0) {
            return false;
        }
        IElementDefn baseDefn = null;
        for (int i = 0; i < this.elements.size(); ++i) {
            Object item = this.elements.get(i);
            if (!(item instanceof DesignElementHandle)) {
                return false;
            }
            IElementDefn elemDefn = ((DesignElementHandle)item).getDefn();
            if (baseDefn == null) {
                baseDefn = elemDefn;
            }
            if (elemDefn == baseDefn) continue;
            return false;
        }
        return true;
    }

    public Iterator visiblePropertyIterator() {
        List list = this.getCommonProperties();
        ArrayList<IElementPropertyDefn> visibleList = new ArrayList<IElementPropertyDefn>();
        for (int i = 0; i < list.size(); ++i) {
            IElementPropertyDefn propDefn = (IElementPropertyDefn)list.get(i);
            if (!this.isPropertyVisible(propDefn.getName())) continue;
            visibleList.add(propDefn);
        }
        return new GroupElementHandle.GroupPropertyIterator(visibleList);
    }

    protected boolean isPropertyVisible(String propName) {
        List elements = this.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            PropertyHandle propertyHandle = ((DesignElementHandle)elements.get(i)).getPropertyHandle(propName);
            if ((propertyHandle == null || propertyHandle.isVisible()) && propertyHandle != null) continue;
            return false;
        }
        return !this.needHide(propName);
    }

    public void clearLocalProperties() throws SemanticException {
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans();
        try {
            Iterator iter = this.propertyIterator();
            while (iter.hasNext()) {
                Object localValue;
                GroupPropertyHandle propHandle = (GroupPropertyHandle)iter.next();
                String propName = propHandle.getPropertyDefn().getName();
                if ("extends".equals(propName) || "name".equals(propName) || "extensionName".equals(propName) || (localValue = propHandle.getLocalValue()) == null) continue;
                propHandle.clearValue();
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public boolean isExtendedElements() {
        if (this.elements.isEmpty()) {
            return false;
        }
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (!(next instanceof DesignElementHandle)) {
                return false;
            }
            DesignElementHandle designHandle = (DesignElementHandle)next;
            if (designHandle.getExtends() != null) continue;
            return false;
        }
        return true;
    }

    protected boolean allExtendedElements() {
        if (this.elements.isEmpty()) {
            return false;
        }
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (!(next instanceof DesignElementHandle)) {
                return false;
            }
            DesignElementHandle elementHandle = (DesignElementHandle)next;
            if (elementHandle.getExtends() != null || elementHandle.getElement().getBaseId() > 0L) continue;
            return false;
        }
        return true;
    }

    protected boolean isPropertyReadOnly(String propName) {
        for (int i = 0; i < this.elements.size(); ++i) {
            PropertyHandle propertyHandle = ((DesignElementHandle)this.elements.get(i)).getPropertyHandle(propName);
            if ((propertyHandle == null || !propertyHandle.isReadOnly()) && propertyHandle != null) continue;
            return true;
        }
        return this.needHide(propName);
    }

    private boolean needHide(String propName) {
        if (!("bookmark".equals(propName) || "toc".equals(propName) || "pageBreakAfter".equals(propName) || "pageBreakBefore".equals(propName) || "drop".equals(propName))) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            DesignElementHandle container;
            DesignElementHandle current = (DesignElementHandle)this.elements.get(i);
            if ("drop".equals(propName)) {
                if (!(current instanceof CellHandle) || container == null || container.getContainer() instanceof GroupHandle) continue;
                return true;
            }
            for (container = current.getContainer(); container != null; container = container.getContainer()) {
                if (!(container instanceof MasterPageHandle)) continue;
                return true;
            }
        }
        return false;
    }

    public GroupPropertyHandle getPropertyHandle(String propName) {
        List commProps = this.getCommonProperties();
        for (int i = 0; i < commProps.size(); ++i) {
            ElementPropertyDefn propDefn = (ElementPropertyDefn)commProps.get(i);
            if (!propDefn.getName().equalsIgnoreCase(propName)) continue;
            return new GroupPropertyHandle(this, propDefn);
        }
        return null;
    }

    protected boolean isInGroup(DesignElementHandle element) {
        return this.elements.contains(element);
    }

    static {
        $assertionsDisabled = !SimpleGroupElementHandle.class.desiredAssertionStatus();
    }
}

