/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.activity.ReadOnlyActivityStack;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ResourceChangeEvent;
import org.eclipse.birt.report.model.api.core.AttributeEvent;
import org.eclipse.birt.report.model.api.core.DisposeEvent;
import org.eclipse.birt.report.model.api.core.IAttributeListener;
import org.eclipse.birt.report.model.api.core.IDisposeListener;
import org.eclipse.birt.report.model.api.core.IModuleModel;
import org.eclipse.birt.report.model.api.core.INameManager;
import org.eclipse.birt.report.model.api.core.IResourceChangeListener;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.birt.report.model.core.BundleHelper;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.NameManager;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.namespace.IModuleNameScope;
import org.eclipse.birt.report.model.core.namespace.ModuleNameScopeFactory;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.elements.TranslationTable;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.LibraryReader;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;
import org.eclipse.birt.report.model.util.StructureRefUtil;
import org.eclipse.birt.report.model.util.VersionControlMgr;
import org.eclipse.birt.report.model.validators.ValidationExecutor;
import org.eclipse.birt.report.model.writer.ModuleWriter;

public abstract class Module
extends DesignElement
implements IModuleModel {
    public static final int STYLE_NAME_SPACE = 0;
    public static final int ELEMENT_NAME_SPACE = 1;
    public static final int PARAMETER_NAME_SPACE = 2;
    public static final int DATA_SOURCE_NAME_SPACE = 3;
    public static final int DATA_SET_NAME_SPACE = 4;
    public static final int PAGE_NAME_SPACE = 5;
    public static final int THEME_NAME_SPACE = 6;
    public static final int TEMPLATE_PARAMETER_NAME_SPACE = 7;
    public static final int NAME_SPACE_COUNT = 8;
    protected DesignSession session;
    protected long elementIDCounter = 1L;
    protected HashMap idMap = new HashMap();
    protected ActivityStack activityStack = new ActivityStack();
    protected int saveState = 0;
    protected NameSpace[] nameSpaces = new NameSpace[8];
    protected IModuleNameScope[] moduleNameSpaces = new IModuleNameScope[8];
    protected TranslationTable translations = new TranslationTable();
    private HashMap referencableProperties = null;
    protected List allExceptions = new ArrayList();
    protected ValidationExecutor validationExecutor = new ValidationExecutor(this);
    private List validationListeners = null;
    protected String fileName = null;
    protected URL systemId = null;
    protected String signature = null;
    protected String units = null;
    private List libraries = null;
    private List attributeListeners = null;
    private List disposeListeners = null;
    private List resourceChangeListeners = null;
    private ElementRefValue theme = null;
    protected Exception fatalException;
    protected INameManager nameManager = null;
    protected VersionControlMgr versionMgr = null;
    protected ModuleOption options = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Module(DesignSession theSession) {
        this.session = theSession;
        for (int i = 0; i < 8; ++i) {
            this.nameSpaces[i] = new NameSpace();
            this.moduleNameSpaces[i] = ModuleNameScopeFactory.createElementNameSpace(this, i);
        }
        this.setID(this.getNextID());
        this.addElementID(this);
        this.nameManager = new NameManager(this);
        this.versionMgr = new VersionControlMgr();
    }

    public DesignSession getSession() {
        return this.session;
    }

    public StyleElement findNativeStyle(String name) {
        return (StyleElement)this.nameSpaces[0].getElement(name);
    }

    public StyleElement findStyle(String name) {
        ElementRefValue refValue = this.moduleNameSpaces[0].resolve(name, null);
        return (StyleElement)refValue.getElement();
    }

    public DesignElement findElement(String name) {
        return this.resolveNativeElement(name, 1);
    }

    public DesignElement findDataSource(String name) {
        return this.resolveElement(name, 3, null);
    }

    public DesignElement findDataSet(String name) {
        return this.resolveElement(name, 4, null);
    }

    public DesignElement findPage(String name) {
        return this.resolveNativeElement(name, 5);
    }

    public DesignElement findParameter(String name) {
        return this.resolveNativeElement(name, 2);
    }

    public NameSpace getNameSpace(int ns) {
        if (!($assertionsDisabled || ns >= 0 && ns < 8)) {
            throw new AssertionError();
        }
        return this.nameSpaces[ns];
    }

    public IModuleNameScope getModuleNameSpace(int nameSpace) {
        if (!($assertionsDisabled || nameSpace >= 0 && nameSpace < 8)) {
            throw new AssertionError();
        }
        return this.moduleNameSpaces[nameSpace];
    }

    public long getNextID() {
        return this.elementIDCounter++;
    }

    public void addElementID(DesignElement element) {
        if (!$assertionsDisabled && this.idMap == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && element.getID() <= 0L) {
            throw new AssertionError();
        }
        Long idObj = new Long(element.getID());
        if (!$assertionsDisabled && this.idMap.containsKey(idObj)) {
            throw new AssertionError();
        }
        this.idMap.put(idObj, element);
        long id = element.getID();
        if (this.elementIDCounter <= id) {
            this.elementIDCounter = id + 1L;
        }
    }

    public void dropElementID(DesignElement element) {
        if (this.idMap == null) {
            return;
        }
        if (!$assertionsDisabled && element.getID() <= 0L) {
            throw new AssertionError();
        }
        Long idObj = new Long(element.getID());
        if (!$assertionsDisabled && !this.idMap.containsKey(idObj)) {
            throw new AssertionError();
        }
        this.idMap.remove(idObj);
    }

    public DesignElement getElementByID(long id) {
        if (this.idMap == null) {
            return null;
        }
        return (DesignElement)this.idMap.get(new Long(id));
    }

    public ActivityStack getActivityStack() {
        return this.activityStack;
    }

    public void prepareToSave() {
    }

    public void onSave() {
        this.saveState = this.activityStack.getCurrentTransNo();
        this.nameManager.clear();
    }

    public boolean isDirty() {
        return this.saveState != this.activityStack.getCurrentTransNo();
    }

    public void setSaveState(int saveState) {
        this.saveState = saveState;
    }

    protected void onCreate() {
        this.saveState = 0;
    }

    public void close() {
        this.isValid = false;
        if (!this.isReadOnly()) {
            this.saveState = this.activityStack.getCurrentTransNo();
            this.session.drop(this);
        }
    }

    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        int i;
        Module module = (Module)super.doClone(policy);
        module.activityStack = new ActivityStack();
        module.allExceptions = null;
        module.attributeListeners = null;
        module.disposeListeners = null;
        module.resourceChangeListeners = null;
        module.elementIDCounter = 1L;
        module.fatalException = null;
        module.idMap = new HashMap();
        module.moduleNameSpaces = new IModuleNameScope[8];
        module.nameSpaces = new NameSpace[8];
        module.nameManager = new NameManager(module);
        module.referencableProperties = null;
        module.saveState = 0;
        module.systemId = null;
        module.translations = (TranslationTable)this.translations.clone();
        module.validationExecutor = new ValidationExecutor(module);
        module.validationListeners = null;
        if (!$assertionsDisabled && module.getID() <= 0L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && module.getElementByID(module.getID()) != null) {
            throw new AssertionError();
        }
        module.addElementID(module);
        for (i = 0; i < 8; ++i) {
            module.nameSpaces[i] = new NameSpace();
            module.moduleNameSpaces[i] = ModuleNameScopeFactory.createElementNameSpace(module, i);
        }
        module.theme = this.theme != null ? new ElementRefValue(this.theme.getLibraryNamespace(), this.theme.getName()) : null;
        if (this.libraries != null) {
            for (i = 0; i < this.libraries.size(); ++i) {
                module.libraries = new ArrayList();
                Library lib = (Library)((Library)this.libraries.get(i)).doClone(policy);
                lib.setHost(module);
                module.libraries.add(lib);
            }
        } else {
            module.libraries = null;
        }
        IElementDefn defn = module.getDefn();
        for (int i2 = 0; i2 < defn.getSlotCount(); ++i2) {
            ContainerSlot slot = module.getSlot(i2);
            if (slot == null) continue;
            for (int pos = 0; pos < slot.getCount(); ++pos) {
                DesignElement innerElement = slot.getContent(pos);
                this.buildNameSpaceAndIDMap(module, innerElement);
            }
        }
        module.semanticCheck(module);
        return module;
    }

    private void buildNameSpaceAndIDMap(Module module, DesignElement element) {
        TemplateParameterDefinition templateParam;
        if (module == null || element == null) {
            return;
        }
        if (!$assertionsDisabled && element instanceof Module) {
            throw new AssertionError();
        }
        if (element instanceof TemplateElement && (templateParam = element.getTemplateParameterElement(module)) != null && templateParam.getRoot() != module) {
            element.setProperty("refTemplateParameter", (Object)new ElementRefValue(null, templateParam.getName()));
        }
        ElementDefn defn = (ElementDefn)element.getDefn();
        if (!$assertionsDisabled && module.getElementByID(element.getID()) != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && element.getID() <= 0L) {
            throw new AssertionError();
        }
        module.addElementID(element);
        String name = element.getName();
        if (!$assertionsDisabled && StringUtil.isBlank(name) && defn.getNameOption() == 2) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && element.getContainer() == null) {
            throw new AssertionError();
        }
        int id = defn.getNameSpaceID();
        if (name != null && id != -1 && element.isManagedByNameSpace()) {
            NameSpace ns = module.getNameSpace(id);
            if (!$assertionsDisabled && ns.contains(name)) {
                throw new AssertionError();
            }
            ns.insert(element);
        }
        for (int i = 0; i < defn.getSlotCount(); ++i) {
            ContainerSlot slot = element.getSlot(i);
            if (!$assertionsDisabled && slot == null) {
                throw new AssertionError();
            }
            for (int pos = 0; pos < slot.getCount(); ++pos) {
                DesignElement innerElement = slot.getContent(pos);
                this.buildNameSpaceAndIDMap(module, innerElement);
            }
        }
    }

    public void addTranslation(Translation translation) {
        this.translations.add(translation);
    }

    public boolean dropTranslation(Translation translation) {
        return this.translations.remove(translation);
    }

    public Translation findTranslation(String resourceKey, String locale) {
        return this.translations.findTranslation(resourceKey, locale);
    }

    public boolean contains(Translation trans) {
        return this.translations.contains(trans);
    }

    public List getTranslations() {
        return this.translations.getTranslations();
    }

    public List getTranslations(String resourceKey) {
        return this.translations.getTranslations(resourceKey);
    }

    public String[] getTranslationResourceKeys() {
        return this.translations.getResourceKeys();
    }

    public String getMessage(String resourceKey) {
        return this.getMessage(resourceKey, ThreadResources.getLocale());
    }

    public String getMessage(String resourceKey, ULocale locale) {
        String msg;
        if (StringUtil.isBlank(resourceKey)) {
            return null;
        }
        if (locale == null) {
            locale = ThreadResources.getLocale();
        }
        if ((msg = this.translations.getMessage(resourceKey, locale)) != null) {
            return msg;
        }
        String baseName = this.getStringProperty(this, "includeResource");
        if (baseName == null) {
            return null;
        }
        msg = BundleHelper.getHelper(this, baseName).getMessage(resourceKey, locale);
        return msg;
    }

    private File getModuleFolder() {
        if (this.systemId == null) {
            return null;
        }
        return new File(this.systemId.getFile());
    }

    public CustomColor findColor(String colorName) {
        StructureDefn defn = (StructureDefn)MetaDataDictionary.getInstance().getStructure("CustomColor");
        return (CustomColor)StructureRefUtil.findStructure(this, defn, colorName);
    }

    public ConfigVariable findConfigVariabel(String variableName) {
        StructureDefn defn = (StructureDefn)MetaDataDictionary.getInstance().getStructure("ConfigVar");
        return (ConfigVariable)StructureRefUtil.findStructure(this, defn, variableName);
    }

    public EmbeddedImage findImage(String imageName) {
        StructureDefn defn = (StructureDefn)MetaDataDictionary.getInstance().getStructure("EmbeddedImage");
        return (EmbeddedImage)StructureRefUtil.findStructure(this, defn, imageName);
    }

    public ElementPropertyDefn getReferencablePropertyDefn(String structureName) {
        if (this.referencableProperties == null) {
            this.referencableProperties = new HashMap();
            this.referencableProperties.put("ConfigVar", this.getPropertyDefn("configVars"));
            this.referencableProperties.put("EmbeddedImage", this.getPropertyDefn("images"));
            this.referencableProperties.put("CustomColor", this.getPropertyDefn("colorPalette"));
        }
        return (ElementPropertyDefn)this.referencableProperties.get(structureName);
    }

    public List getAllErrors() {
        return ErrorDetail.convertExceptionList(this.allExceptions);
    }

    public List getAllExceptions() {
        return this.allExceptions;
    }

    public ValidationExecutor getValidationExecutor() {
        return this.validationExecutor;
    }

    public void addValidationListener(IValidationListener listener) {
        if (this.validationListeners == null) {
            this.validationListeners = new ArrayList();
        }
        if (!this.validationListeners.contains(listener)) {
            this.validationListeners.add(listener);
        }
    }

    public boolean removeValidationListener(IValidationListener listener) {
        if (this.validationListeners == null) {
            return false;
        }
        return this.validationListeners.remove(listener);
    }

    public void broadcastValidationEvent(DesignElement element, ValidationEvent event) {
        if (this.validationListeners != null) {
            Iterator iter = this.validationListeners.iterator();
            while (iter.hasNext()) {
                IValidationListener listener = (IValidationListener)iter.next();
                listener.elementValidated(element.getHandle(this), event);
            }
        }
    }

    public void makeUniqueName(DesignElement element) {
        this.nameManager.makeUniqueName(element);
    }

    public String getUniqueName(DesignElement element) {
        return this.nameManager.getUniqueName(element);
    }

    public INameManager getNameManager() {
        return this.nameManager;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String newName) {
        this.fileName = newName;
    }

    public void setUTFSignature(String signature) {
        this.signature = signature;
    }

    public String getUTFSignature() {
        return this.signature;
    }

    protected abstract int getSlotCount();

    public ContainerSlot getSlot(int slot) {
        if (!($assertionsDisabled || slot >= 0 && slot < this.getSlotCount())) {
            throw new AssertionError();
        }
        return this.slots[slot];
    }

    public void semanticError(SemanticException ex) {
        if (this.allExceptions == null) {
            this.allExceptions = new ArrayList();
        }
        this.allExceptions.add(ex);
    }

    public List getErrorList() {
        List allErrors = this.getAllErrors();
        List list = ErrorDetail.getSemanticErrors(allErrors, "Error.DesignFileException.SEMANTIC_ERROR");
        list.addAll(ErrorDetail.getSemanticErrors(allErrors, "Error.DesignFileException.SYNTAX_ERROR"));
        return list;
    }

    public List getWarningList() {
        List allErrors = this.getAllErrors();
        return ErrorDetail.getSemanticErrors(allErrors, "Error.DesignFileException.SEMANTIC_WARNING");
    }

    public final void semanticCheck(Module module) {
        this.allExceptions = this.validateWithContents(module);
        if (module instanceof ReportDesign) {
            ContainerSlot slot = module.getSlot(8);
            if (!$assertionsDisabled && slot == null) {
                throw new AssertionError();
            }
            for (int i = slot.getCount() - 1; i >= 0; --i) {
                TemplateParameterDefinition templateParam = (TemplateParameterDefinition)slot.getContent(i);
                if (!templateParam.getClientList().isEmpty()) continue;
                slot.remove(templateParam);
                module.manageId(templateParam, false);
                templateParam.setContainer(null, -1);
            }
        }
        this.nameManager.clear();
    }

    public DesignElement resolveElement(String elementName, int nameSpace, PropertyDefn propDefn) {
        ElementRefValue refValue = this.moduleNameSpaces[nameSpace].resolve(elementName, propDefn);
        return refValue.getElement();
    }

    public DesignElement resolveElement(DesignElement element, int nameSpace, PropertyDefn propDefn) {
        ElementRefValue refValue = this.moduleNameSpaces[nameSpace].resolve(element, propDefn);
        return refValue.getElement();
    }

    private DesignElement resolveNativeElement(String elementName, int nameSpace) {
        NameSpace namespace = this.nameSpaces[nameSpace];
        return namespace.getElement(elementName);
    }

    protected void setAllExceptions(List allExceptions) {
        this.allExceptions = allExceptions;
    }

    public URL findResource(String fileName, int fileType) {
        URL url = this.getSession().getResourceLocator().findResource((ModuleHandle)this.getHandle(this), fileName, fileType);
        return url;
    }

    public Library loadLibrary(String libraryFileName, String namespace) throws DesignFileException {
        URL url;
        if (this.libraries == null) {
            this.libraries = new ArrayList();
        }
        if ((url = this.findResource(libraryFileName, 2)) == null) {
            DesignParserException ex = new DesignParserException(new String[]{libraryFileName}, "Error.DesignParserException.FILE_NOT_FOUND");
            ArrayList<DesignParserException> exceptionList = new ArrayList<DesignParserException>();
            exceptionList.add(ex);
            throw new DesignFileException(libraryFileName, exceptionList);
        }
        try {
            Library library = LibraryReader.getInstance().read(this.session, this, url.toString(), namespace, url.openStream(), null);
            if (StringUtil.isBlank(namespace)) {
                library.setNamespace(StringUtil.extractFileName(libraryFileName));
            }
            return library;
        }
        catch (IOException e) {
            DesignParserException ex = new DesignParserException(new String[]{libraryFileName}, "Error.DesignParserException.FILE_NOT_FOUND");
            ArrayList<DesignParserException> exceptionList = new ArrayList<DesignParserException>();
            exceptionList.add(ex);
            throw new DesignFileException(libraryFileName, exceptionList);
        }
    }

    public void loadLibrarySilently(IncludedLibrary includeLibrary) {
        try {
            Library library = this.loadLibrary(includeLibrary.getFileName(), includeLibrary.getNamespace());
            library.setReadOnly();
            this.libraries.add(library);
        }
        catch (DesignFileException e) {
            Exception fatalException = ModelUtil.getFirstFatalException(e.getExceptionList());
            Library library = new Library(this.session, this);
            library.setFatalException(fatalException);
            library.setFileName(includeLibrary.getFileName());
            library.setNamespace(includeLibrary.getNamespace());
            library.setValid(false);
            library.setAllExceptions(e.getExceptionList());
            this.libraries.add(library);
        }
    }

    public List getAllLibraries() {
        return this.getLibraries(Integer.MAX_VALUE);
    }

    public List getLibraries(int level) {
        if (level <= 0 || this.libraries == null) {
            return Collections.EMPTY_LIST;
        }
        int newLevel = level - 1;
        if (newLevel == 0) {
            return Collections.unmodifiableList(this.libraries);
        }
        ArrayList allLibraries = new ArrayList(this.libraries);
        Iterator iter = new ArrayList(allLibraries).iterator();
        while (iter.hasNext()) {
            Library library = (Library)iter.next();
            allLibraries.addAll(library.getLibraries(newLevel));
        }
        return allLibraries;
    }

    public List getLibraries() {
        return this.getLibraries(1);
    }

    public void insertLibrary(Library library, int posn) {
        if (this.libraries == null) {
            this.libraries = new ArrayList();
        }
        if (!($assertionsDisabled || posn >= 0 && posn <= this.libraries.size())) {
            throw new AssertionError();
        }
        this.libraries.add(posn, library);
    }

    public void addLibrary(Library library) {
        if (this.libraries == null) {
            this.libraries = new ArrayList();
        }
        this.libraries.add(library);
    }

    public int dropLibrary(Library library) {
        if (!$assertionsDisabled && this.libraries == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.libraries.contains(library)) {
            throw new AssertionError();
        }
        int posn = this.libraries.indexOf(library);
        this.libraries.remove(library);
        return posn;
    }

    public Library getLibraryWithNamespace(String namespace) {
        return this.getLibraryWithNamespace(namespace, Integer.MAX_VALUE);
    }

    public Library getLibraryWithNamespace(String namespace, int level) {
        if (this.libraries == null) {
            return null;
        }
        List list = this.getLibraries(level);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Library library = (Library)iter.next();
            if (!library.getNamespace().equals(namespace)) continue;
            return library;
        }
        return null;
    }

    public boolean isReadOnly() {
        return this.activityStack instanceof ReadOnlyActivityStack;
    }

    public void addAttributeListener(IAttributeListener listener) {
        if (this.attributeListeners == null) {
            this.attributeListeners = new ArrayList();
        }
        if (!this.attributeListeners.contains(listener)) {
            this.attributeListeners.add(listener);
        }
    }

    public boolean removeAttributeListener(IAttributeListener listener) {
        if (this.attributeListeners == null) {
            return false;
        }
        return this.attributeListeners.remove(listener);
    }

    public void broadcastFileNameEvent(AttributeEvent event) {
        if (this.attributeListeners != null) {
            Iterator iter = this.attributeListeners.iterator();
            while (iter.hasNext()) {
                IAttributeListener listener = (IAttributeListener)iter.next();
                listener.fileNameChanged((ModuleHandle)this.getHandle(this), event);
            }
        }
    }

    public void addDisposeListener(IDisposeListener listener) {
        if (this.disposeListeners == null) {
            this.disposeListeners = new ArrayList();
        }
        if (!this.disposeListeners.contains(listener)) {
            this.disposeListeners.add(listener);
        }
    }

    public void addResourceChangeListener(IResourceChangeListener listener) {
        if (this.resourceChangeListeners == null) {
            this.resourceChangeListeners = new ArrayList();
        }
        if (!this.resourceChangeListeners.contains(listener)) {
            this.resourceChangeListeners.add(listener);
        }
    }

    public boolean removeDisposeListener(IDisposeListener listener) {
        if (this.disposeListeners == null) {
            return false;
        }
        return this.disposeListeners.remove(listener);
    }

    public boolean removeResourceChangeListener(IResourceChangeListener listener) {
        if (this.resourceChangeListeners == null) {
            return false;
        }
        return this.resourceChangeListeners.remove(listener);
    }

    public void broadcastDisposeEvent(DisposeEvent event) {
        if (this.disposeListeners == null || this.disposeListeners.isEmpty()) {
            return;
        }
        ArrayList temp = new ArrayList(this.disposeListeners);
        Iterator iter = temp.iterator();
        while (iter.hasNext()) {
            IDisposeListener listener = (IDisposeListener)iter.next();
            listener.moduleDisposed((ModuleHandle)this.getHandle(this), event);
        }
    }

    public void broadcastResourceChangeEvent(ResourceChangeEvent event) {
        if (this.resourceChangeListeners == null || this.resourceChangeListeners.isEmpty()) {
            return;
        }
        ArrayList temp = new ArrayList(this.resourceChangeListeners);
        Iterator iter = temp.iterator();
        while (iter.hasNext()) {
            IResourceChangeListener listener = (IResourceChangeListener)iter.next();
            listener.resourceChanged((ModuleHandle)this.getHandle(this), event);
        }
    }

    public List getMessageKeys() {
        String baseName;
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        String[] transKeys = this.translations.getResourceKeys();
        if (transKeys != null) {
            for (int i = 0; i < transKeys.length; ++i) {
                keys.add(transKeys[i]);
            }
        }
        if ((baseName = this.getStringProperty(this, "includeResource")) == null) {
            return new ArrayList(keys);
        }
        keys.addAll(BundleHelper.getHelper(this, baseName).getMessageKeys(ThreadResources.getLocale()));
        return new ArrayList(keys);
    }

    public boolean isFileExist(String fileName, int fileType) {
        URL url = this.findResource(fileName, fileType);
        return url != null;
    }

    public List getIncludedLibraries() {
        List libs = (List)this.getLocalProperty(this, "libraries");
        if (libs == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(libs);
    }

    public String getUnits() {
        if (!StringUtil.isBlank(this.units)) {
            return this.units;
        }
        return (String)this.getPropertyDefn("units").getDefault();
    }

    public List getIncludeScripts() {
        return (ArrayList)this.getLocalProperty(this, "includeScripts");
    }

    protected Object getIntrinsicProperty(String propName) {
        if ("units".equals(propName)) {
            return this.units;
        }
        if ("theme".equals(propName)) {
            return this.theme;
        }
        return super.getIntrinsicProperty(propName);
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if ("units".equals(propName)) {
            this.units = (String)value;
        } else if ("theme".equals(propName)) {
            this.updateReference(this.theme, (ElementRefValue)value, this.getPropertyDefn("theme"));
            this.theme = (ElementRefValue)value;
        } else {
            super.setIntrinsicProperty(propName, value);
        }
    }

    public abstract ModuleWriter getWriter();

    public ModuleHandle getModuleHandle() {
        return (ModuleHandle)this.getHandle(this);
    }

    public Exception getFatalException() {
        return this.fatalException;
    }

    protected void setFatalException(Exception fatalException) {
        this.fatalException = fatalException;
    }

    public URL getSystemId() {
        return this.systemId;
    }

    public void setSystemId(URL systemId) {
        this.systemId = systemId;
    }

    public Theme findTheme(String name) {
        ElementRefValue refValue = this.moduleNameSpaces[6].resolve(name, null);
        return (Theme)refValue.getElement();
    }

    public Theme getTheme() {
        if (this.theme == null) {
            return null;
        }
        return (Theme)this.theme.getElement();
    }

    public String getThemeName() {
        if (this.theme == null) {
            return null;
        }
        return this.theme.getName();
    }

    public Theme getTheme(Module module) {
        if (this.theme == null) {
            return null;
        }
        if (this.theme.isResolved()) {
            return (Theme)this.theme.getElement();
        }
        IModuleNameScope resolver = module.getModuleNameSpace(6);
        ElementRefValue refValue = resolver.resolve(ReferenceValueUtil.needTheNamespacePrefix(this.theme, this), null);
        Theme target = null;
        if (refValue.isResolved()) {
            target = (Theme)refValue.getElement();
            this.theme.resolve(target);
            target.addClient(this, "theme");
        }
        return target;
    }

    public void manageId(DesignElement element, boolean isAdd) {
        if (element == null) {
            return;
        }
        if (element.getRoot() != this) {
            return;
        }
        IElementDefn defn = element.getDefn();
        if (isAdd) {
            if (element.getID() <= 0L || this.getElementByID(element.getID()) != null && this.getElementByID(element.getID()) != element) {
                element.setID(this.getNextID());
            }
            if (this.getElementByID(element.getID()) == null) {
                this.addElementID(element);
            }
        } else {
            this.dropElementID(element);
        }
        for (int i = 0; i < defn.getSlotCount(); ++i) {
            ContainerSlot slot = element.getSlot(i);
            if (slot == null) continue;
            for (int pos = 0; pos < slot.getCount(); ++pos) {
                DesignElement innerElement = slot.getContent(pos);
                this.manageId(innerElement, isAdd);
            }
        }
    }

    public String getLocation() {
        if (!$assertionsDisabled && this.systemId == null) {
            throw new AssertionError();
        }
        if (this.fileName == null) {
            return this.systemId.toString();
        }
        return this.systemId + StringUtil.extractFileNameWithSuffix(this.fileName);
    }

    public IncludedLibrary findIncludedLibrary(String namespace) {
        List libs = this.getIncludedLibraries();
        if (libs == null) {
            return null;
        }
        IncludedLibrary includedItem = null;
        for (int i = 0; i < libs.size(); ++i) {
            IncludedLibrary incluedLib = (IncludedLibrary)libs.get(i);
            if (!incluedLib.getNamespace().equalsIgnoreCase(namespace)) continue;
            includedItem = incluedLib;
            break;
        }
        return includedItem;
    }

    public Library getLibraryByLocation(String theLocation) {
        return this.getLibraryByLocation(theLocation, 1);
    }

    public Library getLibraryByLocation(String theLocation, int level) {
        if (StringUtil.isBlank(theLocation)) {
            return null;
        }
        List libraries = this.getLibraries(level);
        for (int i = 0; i < libraries.size(); ++i) {
            Library library = (Library)libraries.get(i);
            if (!theLocation.equalsIgnoreCase(library.getLocation())) continue;
            return library;
        }
        return null;
    }

    public TemplateParameterDefinition findTemplateParameterDefinition(String name) {
        return (TemplateParameterDefinition)this.resolveNativeElement(name, 7);
    }

    public boolean isDuplicateNamespace(String namespaceToCheck) {
        Module rootHost = this;
        while (rootHost instanceof Library && ((Library)rootHost).getHost() != null) {
            rootHost = ((Library)rootHost).getHost();
        }
        List libraries = rootHost.getLibraries(Integer.MAX_VALUE);
        Iterator iter = libraries.iterator();
        while (iter.hasNext()) {
            Library library = (Library)iter.next();
            if (!library.getNamespace().equals(namespaceToCheck)) continue;
            return true;
        }
        return false;
    }

    public PropertyBinding findPropertyBinding(DesignElement element, String propName) {
        if (element == null || propName == null) {
            return null;
        }
        if (element.getPropertyDefn(propName) == null) {
            return null;
        }
        List propertyBindings = this.getListProperty(this, "propertyBindings");
        if (propertyBindings == null) {
            return null;
        }
        for (int i = 0; i < propertyBindings.size(); ++i) {
            PropertyBinding propBinding = (PropertyBinding)propertyBindings.get(i);
            BigDecimal id = propBinding.getID();
            if (id == null || !propName.equalsIgnoreCase(propBinding.getName()) || this.getElementByID(id.longValue()) != element) continue;
            return propBinding;
        }
        return null;
    }

    public List getPropertyBindings(DesignElement element) {
        if (element == null) {
            return Collections.EMPTY_LIST;
        }
        List propertyBindings = this.getListProperty(this, "propertyBindings");
        if (propertyBindings == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PropertyBinding> result = new ArrayList<PropertyBinding>();
        for (int i = 0; i < propertyBindings.size(); ++i) {
            PropertyBinding propBinding = (PropertyBinding)propertyBindings.get(i);
            BigDecimal id = propBinding.getID();
            if (id == null || this.getElementByID(id.longValue()) != element) continue;
            result.add(propBinding);
        }
        return result;
    }

    public void rename(EmbeddedImage image) {
        if (image == null) {
            return;
        }
        if (StringUtil.isBlank(image.getName())) {
            return;
        }
        List images = this.getListProperty(this, "images");
        if (images == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < images.size(); ++i) {
            EmbeddedImage theImage = (EmbeddedImage)images.get(i);
            String name = theImage.getName();
            if (!$assertionsDisabled && names.contains(name)) {
                throw new AssertionError();
            }
            names.add(name);
        }
        if (!names.contains(image.getName())) {
            return;
        }
        int index = 0;
        String name = image.getName();
        String baseName = image.getName();
        while (names.contains(name)) {
            name = baseName + ++index;
        }
        image.setName(name.trim());
    }

    public void rename(DesignElement element) {
        if (element == null) {
            return;
        }
        IElementDefn defn = element.getDefn();
        if (defn.getNameOption() == 2 || element.getRoot() instanceof Library || element.getName() != null) {
            this.makeUniqueName(element);
        }
        for (int i = 0; i < defn.getSlotCount(); ++i) {
            ContainerSlot slot = element.getSlot(i);
            if (slot == null) continue;
            for (int pos = 0; pos < slot.getCount(); ++pos) {
                DesignElement innerElement = slot.getContent(pos);
                this.rename(innerElement);
            }
        }
    }

    public VersionControlMgr getVersionManager() {
        return this.versionMgr;
    }

    public abstract ModuleOption getOptions();

    public void setOptions(ModuleOption options) {
        this.options = options;
    }

    public void setResourceFolder(String resourceFolder) {
        if (this.options == null) {
            this.options = new ModuleOption();
        }
        this.options.setResourceFolder(resourceFolder);
    }

    public String getResourceFolder() {
        ModuleOption effectOptions = this.getOptions();
        if (effectOptions == null) {
            return null;
        }
        return effectOptions.getResourceFolder();
    }

    static {
        $assertionsDisabled = !Module.class.desiredAssertionStatus();
    }
}

