/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.birt.report.model.activity.LayoutRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.UnicodeUtil;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.interfaces.IExtendedItemModel;
import org.eclipse.birt.report.model.elements.interfaces.IOdaExtendableElementModel;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.util.VersionInfo;
import org.eclipse.birt.report.model.util.VersionUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.SAXException;

public class ModelUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void duplicateProperties(DesignElementHandle source, DesignElementHandle destination, boolean onlyFactoryProperty) {
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && destination == null) {
            throw new AssertionError();
        }
        if (!(source instanceof ReportDesignHandle && destination instanceof LibraryHandle || $assertionsDisabled || destination.getDefn().getName().equalsIgnoreCase(source.getDefn().getName()))) {
            throw new AssertionError();
        }
        if (source.getDefn().allowsUserProperties()) {
            PropertyHandle propHandle = source.getPropertyHandle("userProperties");
            List value = source.getElement().getUserProperties();
            Object valueToSet = null;
            if (propHandle != null) {
                valueToSet = ModelUtil.copyValue(propHandle.getDefn(), value);
            }
            if (valueToSet != null) {
                Iterator iter = ((List)valueToSet).iterator();
                while (iter.hasNext()) {
                    UserPropertyDefn userPropDefn = (UserPropertyDefn)iter.next();
                    destination.getElement().addUserPropertyDefn(userPropDefn);
                }
            }
        }
        if (source.getElement() instanceof IExtendableElement) {
            ModelUtil.duplicateExtensionIdentifier(source, destination);
        }
        Iterator iter = source.getPropertyIterator();
        while (iter.hasNext()) {
            ElementPropertyDefn propDefn;
            PropertyHandle propHandle = (PropertyHandle)iter.next();
            String propName = propHandle.getDefn().getName();
            if ("style".equals(propName) || "extends".equals(propName) || "userProperties".equals(propName) || "extensionID".equals(propName) || "extensionName".equals(propName) || "refTemplateParameter".equals(propName) || "viewAction".equals(propName) || (propDefn = destination.getElement().getPropertyDefn(propName)) == null) continue;
            Object value = null;
            if (propHandle.getElement() instanceof GroupElement && ("toc".equals(propName) || "pageBreakAfter".equals(propName) || "pageBreakBefore".equals(propName))) {
                value = propHandle.getElement().getLocalProperty(propHandle.getModule(), propDefn);
            } else if (onlyFactoryProperty) {
                value = propHandle.getElement().getFactoryProperty(propHandle.getModule(), propDefn);
            } else {
                if ("images".equals(propName)) {
                    Iterator images = source.getPropertyHandle("images").iterator();
                    while (images.hasNext()) {
                        StructureHandle image = (StructureHandle)images.next();
                        try {
                            ElementExportUtil.exportStructure(image, (LibraryHandle)destination, false);
                        }
                        catch (SemanticException e) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                        }
                    }
                    continue;
                }
                value = propHandle.getElement().getStrategy().getPropertyExceptRomDefault(propHandle.getModule(), propHandle.getElement(), propDefn);
            }
            Object valueToSet = ModelUtil.copyValue(propHandle.getDefn(), value);
            destination.getElement().setProperty(propName, valueToSet);
        }
    }

    private static void duplicateExtensionIdentifier(DesignElementHandle source, DesignElementHandle destination) {
        if (source.getElement() instanceof IOdaExtendableElementModel) {
            String extensionId = (String)source.getProperty("extensionID");
            destination.getElement().setProperty("extensionID", (Object)extensionId);
        } else if (source.getElement() instanceof IExtendedItemModel) {
            String extensionId = (String)source.getProperty("extensionName");
            destination.getElement().setProperty("extensionName", (Object)extensionId);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private static ArrayList cloneStructList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<IStructure> returnList = new ArrayList<IStructure>();
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            if (item instanceof IStructure) {
                returnList.add(((IStructure)item).copy());
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        return returnList;
    }

    public static Object copyValue(IPropertyDefn propDefn, Object value) {
        if (value == null || propDefn == null) {
            return null;
        }
        switch (propDefn.getTypeCode()) {
            case 16: {
                if (propDefn.isList()) {
                    return ModelUtil.cloneStructList((List)value);
                }
                return ((Structure)value).copy();
            }
            case 15: 
            case 19: {
                ReferenceValue refValue = (ReferenceValue)value;
                return refValue.copy();
            }
            case 20: {
                return ModelUtil.clonePropertyList((List)value);
            }
        }
        return value;
    }

    private static Object clonePropertyList(List value) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> returnList = new ArrayList<Object>();
        for (int i = 0; i < value.size(); ++i) {
            Object item = value.get(i);
            if (item instanceof ElementRefValue) {
                returnList.add(((ElementRefValue)item).copy());
                continue;
            }
            returnList.add(item);
        }
        return returnList;
    }

    public static List filterLayoutTasks(List tasks) {
        ArrayList<RecordTask> retList = new ArrayList<RecordTask>();
        LinkedHashSet<DesignElement> elements = new LinkedHashSet<DesignElement>();
        for (int i = 0; i < tasks.size(); ++i) {
            DesignElement compoundElement;
            RecordTask task = (RecordTask)tasks.get(i);
            if (!(task instanceof LayoutRecordTask) || elements.contains(compoundElement = (DesignElement)((LayoutRecordTask)task).getTarget())) continue;
            retList.add(task);
            elements.add(compoundElement);
        }
        return retList;
    }

    public static Exception getFirstFatalException(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String errorCode;
            XMLParserException parserException;
            Exception ex = (Exception)iter.next();
            if (!(ex instanceof XMLParserException) || !((parserException = (XMLParserException)ex).getException() instanceof LibraryException) || (errorCode = ((LibraryException)((Object)parserException.getException())).getErrorCode()) != "Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY" && errorCode != "Error.LibraryException.DUPLICATE_LIBRARY_NAMESPACE") continue;
            return parserException.getException();
        }
        return null;
    }

    public static String checkUTFSignature(InputStream inputStream, String fileName) throws IOException, SAXException {
        String encoding = UnicodeUtil.checkUTFSignature(inputStream);
        if (encoding != null && !"UTF-8".equals(encoding)) {
            DesignParserException cause = new DesignParserException("Error.DesignParserException.UNSUPPORTED_ENCODING");
            DesignFileException fileException = new DesignFileException(fileName, (Exception)((Object)cause));
            throw new SAXException((Exception)((Object)fileException));
        }
        return encoding;
    }

    public static List sortPropertiesByLocalizedName(List propDefns) {
        ULocale locale = ThreadResources.getLocale();
        Collator collator = Collator.getInstance((ULocale)locale);
        if (Locale.ENGLISH.equals(locale)) {
            collator.setStrength(0);
        }
        final HashMap<PropertyDefn, CollationKey> keysMap = new HashMap<PropertyDefn, CollationKey>();
        for (int i = 0; i < propDefns.size(); ++i) {
            PropertyDefn propDefn = (PropertyDefn)propDefns.get(i);
            CollationKey key = collator.getCollationKey(propDefn.getDisplayName());
            keysMap.put(propDefn, key);
        }
        Collections.sort(propDefns, new Comparator(){

            public int compare(Object o1, Object o2) {
                PropertyDefn p1 = (PropertyDefn)o1;
                PropertyDefn p2 = (PropertyDefn)o2;
                CollationKey key1 = (CollationKey)keysMap.get(p1);
                CollationKey key2 = (CollationKey)keysMap.get(p2);
                return key1.compareTo(key2);
            }
        });
        return propDefns;
    }

    public static List sortElementsByName(List elements) {
        ArrayList temp = new ArrayList(elements);
        Collections.sort(temp, new Comparator(){

            public int compare(Object o1, Object o2) {
                DesignElementHandle handle1 = (DesignElementHandle)o1;
                DesignElementHandle handle2 = (DesignElementHandle)o2;
                String name1 = handle1.getName();
                String name2 = handle2.getName();
                if (null == name1) {
                    if (null == name2) {
                        return 0;
                    }
                    return -1;
                }
                if (null == name2) {
                    return 1;
                }
                return name1.compareTo(name2);
            }
        });
        return temp;
    }

    public static void insertCompatibleThemeToLibrary(Library library, Theme theme) {
        if (!$assertionsDisabled && library == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && theme == null) {
            throw new AssertionError();
        }
        String name = theme.getName();
        if (!($assertionsDisabled || !StringUtil.isBlank(name) && ModelMessages.getMessage("Theme.defaultThemeName").equals(name))) {
            throw new AssertionError();
        }
        NameSpace ns = library.getNameSpace(6);
        if (!$assertionsDisabled && !library.getModuleNameSpace(6).canContain(name)) {
            throw new AssertionError();
        }
        ns.insert(theme);
        library.getSlot(0).add(theme);
        theme.setContainer(library, 0);
    }

    public static void reviseNameSpace(Module module, DesignElement content, String nameSpace) {
        Iterator propNames = content.propertyWithLocalValueIterator();
        IElementDefn defn = content.getDefn();
        while (propNames.hasNext()) {
            String propName = (String)propNames.next();
            ElementPropertyDefn propDefn = (ElementPropertyDefn)defn.getProperty(propName);
            ModelUtil.revisePropertyNameSpace(module, content, propDefn, nameSpace);
        }
        for (int i = 0; i < defn.getSlotCount(); ++i) {
            ContainerSlot slot = content.getSlot(i);
            for (int pos = 0; pos < slot.getCount(); ++pos) {
                ModelUtil.reviseNameSpace(module, slot.getContent(pos), nameSpace);
            }
        }
    }

    public static void revisePropertyNameSpace(Module module, DesignElement content, IElementPropertyDefn propDefn, String nameSpace) {
        if (propDefn.getTypeCode() != 15 && propDefn.getTypeCode() != 17) {
            return;
        }
        Object value = content.getLocalProperty(module, (ElementPropertyDefn)propDefn);
        if (value == null) {
            return;
        }
        ReferenceValue refValue = (ReferenceValue)value;
        refValue.setLibraryNamespace(nameSpace);
    }

    public static boolean containElement(DesignElement element, IElementDefn defn) {
        if (element == null || defn == null) {
            return false;
        }
        int count = element.getDefn().getSlotCount();
        for (int i = 0; i < count; ++i) {
            Iterator iter = element.getSlot(i).iterator();
            while (iter.hasNext()) {
                DesignElement e = (DesignElement)iter.next();
                IElementDefn targetDefn = e.getDefn();
                if (targetDefn.isKindOf(defn)) {
                    return true;
                }
                if (!ModelUtil.containElement(e, defn)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containElement(DesignElement element, String elementName) {
        IElementDefn defn = MetaDataDictionary.getInstance().getElement(elementName);
        return ModelUtil.containElement(element, defn);
    }

    public static DesignElement getCopy(DesignElement element) {
        if (element == null) {
            return null;
        }
        try {
            DesignElement copy = (DesignElement)element.clone();
            if (!$assertionsDisabled && copy == null) {
                throw new AssertionError();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    public static String searchForExternalizedValue(DesignElement element, String propIDName, ULocale locale) {
        if (element == null) {
            return null;
        }
        ElementPropertyDefn defn = element.getPropertyDefn(propIDName);
        if (defn == null) {
            return null;
        }
        String textKey = (String)element.getProperty(element.getRoot(), propIDName);
        if (StringUtil.isBlank(textKey)) {
            return null;
        }
        DesignElement temp = element;
        while (temp != null) {
            String externalizedText = temp.getRoot().getMessage(textKey, locale);
            if (externalizedText != null) {
                return externalizedText;
            }
            if (!defn.canInherit()) {
                return null;
            }
            if (-1L != temp.getBaseId()) {
                temp = temp.getVirtualParent();
                continue;
            }
            temp = temp.getExtendsElement();
        }
        return null;
    }

    public static String getExternalizedValue(DesignElement element, String propIDName, String propName, ULocale locale) {
        if (element == null || element.getPropertyDefn(propName) == null || element.getPropertyDefn(propIDName) == null) {
            return null;
        }
        String textKey = ModelUtil.searchForExternalizedValue(element, propIDName, locale);
        if (!StringUtil.isBlank(textKey)) {
            return textKey;
        }
        return element.getStringProperty(element.getRoot(), propName);
    }

    public static boolean hasLibrary(ReportDesignHandle designToExport, LibraryHandle targetLibraryHandle) {
        String reportLocation = targetLibraryHandle.getModule().getLocation();
        List libList = designToExport.getModule().getAllLibraries();
        Iterator libIter = libList.iterator();
        while (libIter.hasNext()) {
            Library library = (Library)libIter.next();
            String libLocation = library.getRoot().getLocation();
            if (!reportLocation.equals(libLocation)) continue;
            return true;
        }
        return false;
    }

    public static List checkVersion(String version) {
        ArrayList<VersionInfo> rtnList = new ArrayList<VersionInfo>();
        if (VersionUtil.parseVersion(version) <= 3000000) {
            rtnList.add(new VersionInfo(version, 1));
        }
        return rtnList;
    }

    public static boolean isTemplateSupported(DesignElement element) {
        if (element instanceof DataSet) {
            return true;
        }
        if (element instanceof ReportItem) {
            IChoiceSet choiceSet = MetaDataDictionary.getInstance().getChoiceSet("templateElementType");
            if (!$assertionsDisabled && choiceSet == null) {
                throw new AssertionError();
            }
            IChoice[] choices = choiceSet.getChoices();
            for (int i = 0; i < choices.length; ++i) {
                if (!element.getDefn().getName().equalsIgnoreCase(choices[i].getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidReferenceForCompoundElement(Module module, DesignElement element) {
        ElementRefValue refValue = (ElementRefValue)element.getLocalProperty(module, "extends");
        if (refValue == null) {
            return true;
        }
        if (element.getDefn().isContainer() && !refValue.isResolved()) {
            return false;
        }
        for (DesignElement parent = element.getExtendsElement(); parent != null; parent = parent.getExtendsElement()) {
            if (ModelUtil.isValidReferenceForCompoundElement(parent.getRoot(), parent)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidLayout(Module module, DesignElement element) {
        int columnCount;
        if (!(element instanceof ReportItem)) {
            return true;
        }
        if (!element.getDefn().isContainer()) {
            return true;
        }
        if (element instanceof TableItem) {
            return LayoutUtil.isValidLayout((TableItem)element, module);
        }
        return !(element instanceof GridItem) || (columnCount = ((GridItem)element).getColumnCount(module)) != 0;
    }

    public static DesignElement newElement(Module module, String elementTypeName, String name) {
        DesignElement element = ModelUtil.newElement(elementTypeName, name);
        if (element != null && module != null) {
            module.makeUniqueName(element);
        }
        return element;
    }

    public static DesignElement newElement(String elementTypeName, String name) {
        ElementDefn elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(elementTypeName);
        String javaClass = elemDefn.getJavaClass();
        if (javaClass == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(javaClass);
            DesignElement element = null;
            try {
                Constructor<?> constructor = c.getConstructor(String.class);
                element = (DesignElement)constructor.newInstance(name);
                return element;
            }
            catch (NoSuchMethodException e1) {
                element = (DesignElement)c.newInstance();
                return element;
            }
        }
        catch (Exception e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    static {
        $assertionsDisabled = !ModelUtil.class.desiredAssertionStatus();
    }
}

