<!-- ****************************************** {COPYRIGHT-TOP} **
* Aperi Storage Manager
* (C) Copyright Eclipse contributors and others. 2007
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
******************************************* {COPYRIGHT-END} * -->
<script type="text/javascript">
	reportAppConfig.consumers.push(
		function(report) {
			if (report) with (report) {
				document.getElementById('reportFile').value = filename?filename:"";
				document.getElementById('reportDirectory').value = path?path:"";
			}
		}
	);
	reportAppConfig.validators.push(
		function(targetForm) {
			if (targetForm.file.value.length == 0) {
				window.alert("You must enter a file name to upload.");
				targetForm.file.focus();
				return false;
			} else if (!targetForm.file.value.match(/.*\.rptdesign/)) {
				window.alert("You must enter the name of a report design (ends with .rptdesign)");
				targetForm.file.focus();
				return false;
			}
			if (targetForm.path.value.match(/\.\./)) {
				window.alert("No dot dot allowed in path");
				targetForm.directory.focus();
				return false;
			}
			if (targetForm.path.value.match(/\\/)) {
				window.alert("Use forward slashes only in path name");
				targetForm.directory.focus();
				return false;
			}
			return true;
		}
	);
	
</script>
<div class="GroupBox" id="FilesDirectories_Section">
	<span class="Legend">file and directory</span>
	<table>
		<tr>
			<td><span class="LargeLabel"><%=readOnly?"Report Design File":"Local Report Design to Upload"%></span></td>
			<td><input <%=readOnly?"readonly":""%> maxlength=1024 size=50 id="reportFile" name="file" type="<%=(readOnly||filenameOnly)?"text":"file"%>"/></td>
		</tr>
		<tr>
			<td><span class="LargeLabel">Remote Repository Directory</span></td>
			<td><input <%=readOnly?"readonly":""%> type=text maxlength=1024 size=50 id="reportDirectory" name="path" value="<%=request.getParameter("path")%>"></td>
		</tr>
	</table>
<% if (!readOnly) { %>
	<div class="FreeGroup" id="CreateCheckbox_Section">
		<input type="checkbox" name="overwrite"><span class="SmallLabel">Overwrite Existing?</span>
		<input type="checkbox" name="createdirs"><span class="SmallLabel">Create Directories as Needed?</span>
	</div>
<% } %>
</div>
