/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.extension;

import java.util.HashMap;
import java.util.ResourceBundle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.extension.IReportItemFactory;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;

public class ExtendedElementException
extends SemanticException {
    public static final String SUB_EDITOR = "sub_editor";
    public static final String LINE_NUMBER = "lineNo";
    public static final String LOCALIZED_MESSAGE = "localized_message";
    private static final long serialVersionUID = 1L;
    protected HashMap properties = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExtendedElementException(DesignElement element, String pluginId, String errorCode, ResourceBundle bundle) {
        super(pluginId, errorCode, bundle);
        this.element = element;
    }

    public ExtendedElementException(DesignElement element, String pluginId, String errorCode, ResourceBundle bundle, Throwable cause) {
        super(pluginId, errorCode, bundle, cause);
        this.element = element;
    }

    public ExtendedElementException(DesignElement element, String pluginId, String errorCode, Object[] args, ResourceBundle bundle, Throwable cause) {
        super(pluginId, errorCode, args, bundle, cause);
        this.element = element;
    }

    public ExtendedElementException(DesignElement element, String pluginId, String errorCode, Object arg0, ResourceBundle bundle, Throwable cause) {
        super(pluginId, errorCode, arg0, bundle, cause);
        this.element = element;
    }

    public ExtendedElementException(DesignElement element, String pluginId, String errorCode, Object[] args, ResourceBundle bundle) {
        super(pluginId, errorCode, args, bundle);
        this.element = element;
    }

    public ExtendedElementException(DesignElement element, String pluginId, String errorCode, Object arg0, ResourceBundle bundle) {
        super(pluginId, errorCode, arg0, bundle);
        this.element = element;
    }

    public ExtendedElementException(DesignElement element, String pluginId, String errorCode, Object[] args, Throwable cause) {
        super(pluginId, errorCode, args, cause);
        this.element = element;
    }

    public void setProperty(String propName, Object value) {
        if (propName == null) {
            return;
        }
        this.properties.put(propName, value);
    }

    public Object getProperty(String propName) {
        return this.properties.get(propName);
    }

    public String getLocalizedMessage() {
        if (this.getProperty(LOCALIZED_MESSAGE) != null) {
            return (String)this.getProperty(LOCALIZED_MESSAGE);
        }
        if (this.element == null) {
            return this.sResourceKey;
        }
        if (this.element instanceof ExtendedItem) {
            ExtensionElementDefn extDefn = ((ExtendedItem)this.element).getExtDefn();
            if (extDefn == null) {
                return this.sResourceKey;
            }
            PeerExtensionElementDefn peerDefn = (PeerExtensionElementDefn)extDefn;
            IReportItemFactory peerFactory = peerDefn.getReportItemFactory();
            if (!$assertionsDisabled && peerFactory == null) {
                throw new AssertionError();
            }
            String externalizedMessage = this.sResourceKey;
            IMessages msgs = peerFactory.getMessages();
            if (msgs != null) {
                externalizedMessage = msgs.getMessage(this.sResourceKey, ThreadResources.getLocale());
            }
            return externalizedMessage;
        }
        throw new IllegalArgumentException(this.sResourceKey);
    }

    static {
        $assertionsDisabled = !ExtendedElementException.class.desiredAssertionStatus();
    }
}

