/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.css.StyleSheetParserException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.css.CssParser;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssUtil;
import org.eclipse.birt.report.model.css.StyleRule;
import org.eclipse.birt.report.model.css.StyleSheet;
import org.eclipse.birt.report.model.css.property.ParseException;
import org.eclipse.birt.report.model.css.property.PropertyParser;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.CssPropertyUtil;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.flute.parser.selectors.ClassConditionImpl;

public final class StyleSheetLoader {
    private CssParser parser;
    private Module module = null;
    private Reader source = null;
    private final IElementDefn style = MetaDataDictionary.getInstance().getStyle();
    private List warnings = null;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StyleSheetLoader() {
        this.parser = new CssParser();
        this.warnings = new ArrayList();
    }

    public void Reinit() {
        this.parser = new CssParser();
        this.module = null;
        this.source = null;
        this.warnings = new ArrayList();
    }

    public CssStyleSheet load(Module module, String spec) throws StyleSheetException {
        if (!$assertionsDisabled && module == null) {
            throw new AssertionError();
        }
        this.module = module;
        URL url = module.findResource(spec, 3);
        if (url == null) {
            throw new StyleSheetException("Error.StyleSheetException.STYLE_SHEET_NOT_FOUND");
        }
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            throw new StyleSheetException("Error.StyleSheetException.STYLE_SHEET_NOT_FOUND", e);
        }
        return this.load(module, is);
    }

    public CssStyleSheet load(Module module, InputStream is) throws StyleSheetException {
        if (!$assertionsDisabled && module == null) {
            throw new AssertionError();
        }
        this.module = module;
        if (is == null) {
            throw new StyleSheetException("Error.StyleSheetException.STYLE_SHEET_NOT_FOUND");
        }
        this.source = new InputStreamReader(is);
        return this.load(this.source);
    }

    CssStyleSheet load(Reader charStream) throws StyleSheetException {
        StyleSheet ss = null;
        try {
            InputSource is = new InputSource(this.source);
            ss = (StyleSheet)this.parser.parseStyleSheet(is);
        }
        catch (CSSException e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new StyleSheetException("Error.StyleSheetException.SYNTAX_ERROR", e);
        }
        catch (IOException e) {
            throw new StyleSheetException("Error.StyleSheetException.STYLE_SHEET_NOT_FOUND", e);
        }
        finally {
            try {
                this.source.close();
            }
            catch (IOException e) {}
        }
        if (ss == null) {
            return null;
        }
        CssStyleSheet styleSheet = new CssStyleSheet();
        List rules = ss.getRules();
        for (int i = 0; i < rules.size(); ++i) {
            CSSRule rule = (CSSRule)rules.get(i);
            this.loadStyle(styleSheet, rule);
        }
        styleSheet.addWarning(this.warnings);
        styleSheet.setErrorHandler(this.parser.getErrorHandler());
        return styleSheet;
    }

    void loadStyle(CssStyleSheet styleSheet, CSSRule rule) throws StyleSheetException {
        if (rule.getType() == 1) {
            try {
                StyleRule sr = (StyleRule)rule;
                SelectorList selectionList = sr.getSelectorList();
                CSSStyleDeclaration declaration = sr.getStyle();
                LinkedHashMap properties = null;
                ArrayList errors = new ArrayList();
                boolean buildProperties = false;
                for (int i = 0; i < selectionList.getLength(); ++i) {
                    Selector selector = selectionList.item(i);
                    short type = selector.getSelectorType();
                    String name = null;
                    switch (type) {
                        case 4: {
                            ElementSelector elementSelector = (ElementSelector)selector;
                            name = elementSelector.getLocalName();
                            if (name != null) {
                                name = name.toUpperCase();
                                break;
                            }
                            StyleSheetParserException exception = new StyleSheetParserException("*", "Error.StyleSheetParserException.STYLE_NOT_SUPPORTED");
                            this.semanticWarning(exception);
                            styleSheet.addUnsupportedStyle("*", exception);
                            name = null;
                            break;
                        }
                        case 0: {
                            Condition condition = ((ConditionalSelector)selector).getCondition();
                            if (condition.getConditionType() == 9) {
                                name = ((ClassConditionImpl)condition).getValue();
                                if (name == null) break;
                                name = name.toLowerCase();
                                break;
                            }
                            StyleSheetParserException exception = new StyleSheetParserException(CssUtil.toString(selector), "Error.StyleSheetParserException.STYLE_NOT_SUPPORTED");
                            this.semanticWarning(exception);
                            styleSheet.addUnsupportedStyle(CssUtil.toString(selector).toLowerCase(), exception);
                            name = null;
                            break;
                        }
                        default: {
                            StyleSheetParserException exception = new StyleSheetParserException(CssUtil.toString(selector), "Error.StyleSheetParserException.STYLE_NOT_SUPPORTED");
                            this.semanticWarning(exception);
                            styleSheet.addUnsupportedStyle(CssUtil.toString(selector).toLowerCase(), exception);
                            name = null;
                        }
                    }
                    if (name == null) {
                        return;
                    }
                    StyleElement style = styleSheet.findStyle(name);
                    if (style == null) {
                        style = new Style(name);
                    } else {
                        styleSheet.removeStyle(name);
                    }
                    if (!buildProperties) {
                        properties = this.buildProperties(declaration, errors);
                        buildProperties = true;
                    }
                    this.addProperties(style, properties);
                    if (!$assertionsDisabled && styleSheet.findStyle(name) != null) {
                        throw new AssertionError();
                    }
                    List ret = styleSheet.getWarnings(name);
                    if (ret == null) {
                        ArrayList localErrors = new ArrayList();
                        localErrors.addAll(errors);
                        styleSheet.addWarnings(name, localErrors);
                    } else {
                        ret.addAll(errors);
                    }
                    styleSheet.addStyle(style);
                }
            }
            catch (CSSException e) {
                logger.log(Level.SEVERE, e.getMessage());
                throw new StyleSheetException("Error.StyleSheetException.SYNTAX_ERROR", e);
            }
        } else {
            this.semanticWarning(new StyleSheetParserException(rule.toString(), "Error.StyleSheetParserException.RULE_NOT_SUPPORTED"));
        }
    }

    LinkedHashMap buildProperties(CSSStyleDeclaration declaration, List errors) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (int i = 0; i < declaration.getLength(); ++i) {
            String cssName = declaration.item(i);
            String cssValue = declaration.getPropertyValue(cssName);
            if (StringUtil.isBlank(cssName) | StringUtil.isBlank(cssValue)) continue;
            properties.put(cssName, cssValue);
        }
        return this.buildProperties(properties, errors);
    }

    LinkedHashMap buildProperties(LinkedHashMap cssProperties, List errors) {
        if (cssProperties.isEmpty()) {
            return cssProperties;
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        Iterator iter = cssProperties.keySet().iterator();
        while (iter.hasNext()) {
            StyleSheetParserException exception;
            String cssName = (String)iter.next();
            String cssValue = (String)cssProperties.get(cssName);
            if (!$assertionsDisabled && StringUtil.isBlank(cssName)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && StringUtil.isBlank(cssValue)) {
                throw new AssertionError();
            }
            cssName = cssName.toLowerCase();
            try {
                StyleSheetParserException exception2;
                LinkedHashMap shortHand;
                PropertyParser parser;
                if (cssName.equalsIgnoreCase("background-position")) {
                    List ret = this.handleBackgroundPosition(cssValue, properties);
                    if (ret.isEmpty()) continue;
                    errors.add(ret);
                    continue;
                }
                if (cssName.equalsIgnoreCase("text-decoration")) {
                    this.handleTextDecoration(cssValue, properties);
                    continue;
                }
                if (cssName.equalsIgnoreCase("border-bottom")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorderBottom();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    shortHand = this.buildProperties(shortHand, errors);
                    properties.putAll(shortHand);
                    continue;
                }
                if (cssName.equalsIgnoreCase("border-left")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorderLeft();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    shortHand = this.buildProperties(shortHand, errors);
                    properties.putAll(shortHand);
                    continue;
                }
                if (cssName.equalsIgnoreCase("border-right")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorderRight();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    shortHand = this.buildProperties(shortHand, errors);
                    properties.putAll(shortHand);
                    continue;
                }
                if (cssName.equalsIgnoreCase("border-top")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorderTop();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    shortHand = this.buildProperties(shortHand, errors);
                    properties.putAll(shortHand);
                    continue;
                }
                if (cssName.equalsIgnoreCase("border")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorder();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    shortHand = this.buildProperties(shortHand, errors);
                    properties.putAll(shortHand);
                    continue;
                }
                if (cssName.equalsIgnoreCase("border-width")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorderWidth();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    shortHand = this.buildProperties(shortHand, errors);
                    properties.putAll(shortHand);
                    continue;
                }
                if (cssName.equalsIgnoreCase("border-color")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorderColor();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    shortHand = this.buildProperties(shortHand, errors);
                    properties.putAll(shortHand);
                    continue;
                }
                if (cssName.equalsIgnoreCase("border-style")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBorderStyle();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    shortHand = this.buildProperties(shortHand, errors);
                    properties.putAll(shortHand);
                    continue;
                }
                if (cssName.equalsIgnoreCase("font")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseFont();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    shortHand = this.buildProperties(shortHand, errors);
                    properties.putAll(shortHand);
                    continue;
                }
                if (cssName.equalsIgnoreCase("background")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseBackground();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    shortHand = this.buildProperties(shortHand, errors);
                    properties.putAll(shortHand);
                    continue;
                }
                if (cssName.equalsIgnoreCase("margin")) {
                    parser = new PropertyParser(cssValue);
                    parser.parseMargin();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    shortHand = this.buildProperties(shortHand, errors);
                    properties.putAll(shortHand);
                    continue;
                }
                if (cssName.equalsIgnoreCase("padding")) {
                    parser = new PropertyParser(cssValue);
                    parser.parsePadding();
                    shortHand = parser.getCssProperties();
                    shortHand = this.trimProperties(shortHand);
                    shortHand = this.buildProperties(shortHand, errors);
                    properties.putAll(shortHand);
                    continue;
                }
                String name = CssPropertyUtil.getPropertyName(cssName);
                if (name == null) {
                    exception = new StyleSheetParserException("Error.StyleSheetParserException.PROPERTY_NOT_SUPPORTED", cssName, cssValue);
                    this.semanticWarning(exception);
                    errors.add(exception);
                    continue;
                }
                ElementPropertyDefn propDefn = (ElementPropertyDefn)this.style.getProperty(name);
                if (!$assertionsDisabled && propDefn == null) {
                    throw new AssertionError();
                }
                try {
                    String wrongValue = cssValue;
                    if (name.equalsIgnoreCase("backgroundImage")) {
                        cssValue = CssPropertyUtil.getURLValue(cssValue);
                    }
                    if (cssValue.equalsIgnoreCase("URL(-1)")) {
                        exception2 = new StyleSheetParserException("Error.StyleSheetParserException.INVALID_SIMPLE_CSSPROPERTY_VALUE", cssName, wrongValue);
                        this.semanticWarning(exception2);
                        errors.add(exception2);
                    }
                    Object value = propDefn.validateXml(this.module, cssValue);
                    properties.put(name, value);
                }
                catch (PropertyValueException e) {
                    exception2 = new StyleSheetParserException("Error.StyleSheetParserException.INVALID_SIMPLE_CSSPROPERTY_VALUE", cssName, cssValue, (Throwable)((Object)e));
                    this.semanticWarning(exception2);
                    errors.add(exception2);
                }
            }
            catch (ParseException e) {
                exception = new StyleSheetParserException("Error.StyleSheetParserException.INVALID_SHORT_HAND_CSSPROPERTY_VALUE", cssName, cssValue, (Throwable)e);
                this.semanticWarning(exception);
                errors.add(exception);
            }
            catch (CSSException e) {
                exception = new StyleSheetParserException("Error.StyleSheetParserException.INVALID_SHORT_HAND_CSSPROPERTY_VALUE", cssName, cssValue, (Throwable)e);
                this.semanticWarning(exception);
                errors.add(exception);
            }
        }
        return properties;
    }

    List handleBackgroundPosition(String cssValue, LinkedHashMap properties) {
        StyleSheetParserException exception;
        Object value;
        ElementPropertyDefn propDefn;
        if (!$assertionsDisabled && cssValue == null) {
            throw new AssertionError();
        }
        ArrayList<StyleSheetParserException> errors = new ArrayList<StyleSheetParserException>();
        String[] values = cssValue.split("[\\s]");
        String positionX = null;
        String positionY = null;
        switch (values.length) {
            case 0: {
                break;
            }
            case 1: {
                positionX = values[0].trim();
                break;
            }
            case 2: {
                positionX = values[0].trim();
                positionY = values[1].trim();
                break;
            }
            default: {
                StyleSheetParserException exception2 = new StyleSheetParserException("Error.StyleSheetParserException.INVALID_SHORT_HAND_CSSPROPERTY_VALUE", "background-position", cssValue);
                this.semanticWarning(exception2);
                errors.add(exception2);
            }
        }
        if (!StringUtil.isBlank(positionX)) {
            propDefn = (ElementPropertyDefn)this.style.getProperty("backgroundPositionX");
            if (!$assertionsDisabled && propDefn == null) {
                throw new AssertionError();
            }
            try {
                value = propDefn.validateXml(this.module, positionX);
                properties.put("backgroundPositionX", value);
            }
            catch (PropertyValueException e) {
                exception = new StyleSheetParserException("Error.StyleSheetParserException.INVALID_SIMPLE_CSSPROPERTY_VALUE", "background-position", positionX, (Throwable)((Object)e));
                this.semanticWarning(exception);
                errors.add(exception);
            }
        }
        if (!StringUtil.isBlank(positionY)) {
            propDefn = (ElementPropertyDefn)this.style.getProperty("backgroundPositionY");
            if (!$assertionsDisabled && propDefn == null) {
                throw new AssertionError();
            }
            try {
                value = propDefn.validateXml(this.module, positionY);
                properties.put("backgroundPositionY", value);
            }
            catch (PropertyValueException e) {
                exception = new StyleSheetParserException("Error.StyleSheetParserException.INVALID_SIMPLE_CSSPROPERTY_VALUE", "background-position", positionY, (Throwable)((Object)e));
                this.semanticWarning(exception);
                errors.add(exception);
            }
        }
        return errors;
    }

    void handleTextDecoration(String cssValue, LinkedHashMap properties) {
        if (!$assertionsDisabled && cssValue == null) {
            throw new AssertionError();
        }
        cssValue = cssValue.toLowerCase();
        String[] values = cssValue.split("[\\s]");
        for (int i = 0; i < values.length; ++i) {
            String value = values[i].trim();
            if (value.equalsIgnoreCase("line-through")) {
                properties.put("textLineThrough", "line-through");
                continue;
            }
            if (value.equalsIgnoreCase("overline")) {
                properties.put("textOverline", "overline");
                continue;
            }
            if (!value.equalsIgnoreCase("underline")) continue;
            properties.put("textUnderline", "underline");
        }
    }

    void addProperties(DesignElement style, LinkedHashMap properties) {
        Set keys = properties.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Object value = properties.get(name);
            style.setProperty(name, value);
        }
    }

    LinkedHashMap trimProperties(LinkedHashMap properties) {
        if (!$assertionsDisabled && properties == null) {
            throw new AssertionError();
        }
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        Iterator keys = properties.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = (String)properties.get(key);
            if (StringUtil.isBlank(value)) continue;
            ret.put(key, value);
        }
        return ret;
    }

    void semanticWarning(StyleSheetParserException e) {
        this.warnings.add(e);
        logger.log(Level.WARNING, e.getMessage());
    }

    static {
        $assertionsDisabled = !StyleSheetLoader.class.desiredAssertionStatus();
        logger = Logger.getLogger(StyleSheetLoader.class.getName());
    }
}

