/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.rcp.gui;

import java.awt.TextArea;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.rcp.gui.connection.Connection;
import org.eclipse.aperi.rcp.gui.connection.ConnectionPreferencesManager;
import org.eclipse.aperi.rcp.gui.connection.Server;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginDialog
extends Dialog {
    private static final String DEFAULT_SERVER = "localhost";
    private static final String DEFAULT_PORT = "9549";
    private static final String HEADER_LABEL = "Login Information:";
    private static final String SERVER_LABEL = "&Server:";
    private static final String PORT_LABEL = "&Port:";
    private static final String USERID_LABEL = "&User ID:";
    private static final String PASSWORD_LABEL = "&Password:";
    private static final String DELETE_BUTTON_LABEL = "&Delete Connection";
    private static final String LOGIN_BUTTON_LABEL = "&Login";
    private static final String HELP_ID = "fqz0_r_login";
    private Text userIdText;
    private Combo serverCombo;
    private Text portText;
    private Text passwordText;
    private Connection connection;
    private static Server serverToConnect;
    private Hashtable savedConnections;
    private String server;
    private String userId;
    private String password;
    private int port;

    public LoginDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Aperi Storage Manager Login");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(3, 2, false, false);
        GridData gridData2 = new GridData(4, 4, true, false);
        gridData2.widthHint = this.convertHeightInCharsToPixels(27);
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(HEADER_LABEL);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        Label label2 = new Label(composite2, 0);
        label2.setText(SERVER_LABEL);
        label2.setLayoutData((Object)gridData);
        this.serverCombo = new Combo(composite2, 2048);
        this.serverCombo.setLayoutData((Object)gridData2);
        this.serverCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                int n = LoginDialog.this.serverCombo.getSelectionIndex();
                Server server = (Server)LoginDialog.this.serverCombo.getData(String.valueOf(n));
                if (server != null) {
                    LoginDialog.this.portText.setText(server.getPortString());
                    LoginDialog.this.userIdText.setText(server.getUser());
                    LoginDialog.this.passwordText.setText(server.getPassword());
                }
            }
        });
        Label label3 = new Label(composite2, 0);
        label3.setText(PORT_LABEL);
        label3.setLayoutData((Object)gridData);
        this.portText = new Text(composite2, 2048);
        this.portText.setLayoutData((Object)gridData2);
        Label label4 = new Label(composite2, 0);
        label4.setText(USERID_LABEL);
        label4.setLayoutData((Object)gridData);
        this.userIdText = new Text(composite2, 2048);
        this.userIdText.setLayoutData((Object)gridData2);
        Label label5 = new Label(composite2, 0);
        label5.setText(PASSWORD_LABEL);
        label5.setLayoutData((Object)gridData);
        this.passwordText = new Text(composite2, 0x400800);
        this.passwordText.setLayoutData((Object)gridData2);
        this.initializeFields();
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1024, DELETE_BUTTON_LABEL, false);
        this.createButton(composite, 0, LOGIN_BUTTON_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(composite, 17, IDialogConstants.HELP_LABEL, false);
    }

    protected void buttonPressed(int n) {
        this.userId = this.userIdText.getText();
        this.server = this.serverCombo.getText();
        this.password = this.passwordText.getText();
        try {
            this.port = Integer.parseInt(this.portText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.port = -1;
        }
        serverToConnect = new Server(this.server, this.port, this.userId, this.password);
        this.connection = new Connection(serverToConnect);
        if (n == 1024) {
            this.deletePressed();
        } else if (n == 17) {
            this.helpPressed();
        } else {
            super.buttonPressed(n);
        }
    }

    protected void okPressed() {
        if (this.password.equals("")) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Invalid Password", (String)"Password field must not be blank.");
            return;
        }
        if (this.server.equals("")) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Invalid Server", (String)"Server field must not be blank.");
            return;
        }
        if (this.userId.equals("")) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Invalid User id", (String)"User id field must not be blank.");
            return;
        }
        if (this.port <= 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Invalid Port Number", (String)"Port number must be a number greater than zero");
            return;
        }
        super.okPressed();
    }

    protected void deletePressed() {
        this.removeFromPreferences(this.connection);
        this.initializeFields();
    }

    protected void helpPressed() {
        new Help();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray;
                String string = null;
                try {
                    string = UIManager.getSystemLookAndFeelClassName();
                    UIManager.setLookAndFeel(string);
                }
                catch (Exception exception) {
                    Object object;
                    objectArray = new String[]{string};
                    String string2 = "GUI0109M";
                    String string3 = MessageLog.getMessageNoID((String)string2, (Object[])objectArray);
                    if (string3.length() > 100) {
                        object = new TextArea(string3, 1, 100);
                        ((TextArea)object).setEditable(false);
                    } else {
                        object = string3;
                    }
                    JOptionPane.showMessageDialog(null, object, MessageLog.getMessageNoID((String)"GUI0110T", null), 2);
                }
                objectArray = "fqz0_r_login";
                if (!Help.isValidID((String)objectArray)) {
                    objectArray = "welcome_gettingstarted";
                }
                Help.setCurrentID((String)objectArray);
                Help.setDisplayed((boolean)true);
            }
        });
    }

    private void initializeFields() {
        this.clearFields();
        this.savedConnections = ConnectionPreferencesManager.getSavedConnectionDetails((String)"org.eclipse.aperi.rcp.gui");
        if (this.savedConnections == null || this.savedConnections.isEmpty()) {
            this.initializeDefaults();
        } else {
            Enumeration enumeration = this.savedConnections.keys();
            Server server = null;
            int n = 0;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                server = (Server)this.savedConnections.get(string);
                this.serverCombo.setData(String.valueOf(n), (Object)server);
                this.serverCombo.add(server.getHost(), n++);
            }
            this.setLastConnectionData();
        }
    }

    private void initializeDefaults() {
        this.serverCombo.setText(DEFAULT_SERVER);
        this.portText.setText(DEFAULT_PORT);
        this.userIdText.setText("");
        this.passwordText.setText("");
    }

    private void clearFields() {
        this.serverCombo.removeAll();
        this.portText.setText("");
        this.userIdText.setText("");
        this.passwordText.setText("");
    }

    private void setLastConnectionData() {
        Enumeration enumeration;
        String string = ConnectionPreferencesManager.getLastConnectionDetail((String)"org.eclipse.aperi.rcp.gui");
        Server server = (Server)this.savedConnections.get(string);
        if (server == null && (enumeration = this.savedConnections.elements()).hasMoreElements()) {
            server = (Server)enumeration.nextElement();
        }
        if (server != null) {
            this.serverCombo.setText(server.getHost());
            this.portText.setText(server.getPortString());
            this.userIdText.setText(server.getUser());
            this.passwordText.setText(server.getPassword());
        } else {
            this.initializeDefaults();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void removeFromPreferences(Connection connection) {
        ConnectionPreferencesManager.removeConnectionDetail((String)"org.eclipse.aperi.rcp.gui", (String)connection.toString());
    }

    public static void saveToPreferences(Connection connection) {
        String string = connection.toString();
        ConnectionPreferencesManager.saveLastConnectionDetail((String)"org.eclipse.aperi.rcp.gui", (String)string);
        ConnectionPreferencesManager.saveNewConnectionDetail((String)"org.eclipse.aperi.rcp.gui", (String)string, (Server)serverToConnect);
    }
}

