/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.download;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.aperi.download.ConfigurationException;
import org.eclipse.aperi.download.Download;
import org.eclipse.aperi.download.ZipFile;
import org.eclipse.aperi.download.interfaces.IDownloadTarget;
import org.eclipse.aperi.download.interfaces.IZipDownload;
import org.eclipse.aperi.download.interfaces.IZipFile;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipDownload
extends Download
implements IZipDownload {
    public static final String ATTR_ZIP_FILE = "file";
    Vector<IZipFile> _zipFiles = new Vector();

    public ZipDownload(Node node) throws ConfigurationException {
        super(node);
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equals(ATTR_ZIP_FILE)) {
                this._zipFiles.add(new ZipFile(node2));
            }
            ++n;
        }
    }

    @Override
    public Vector<IZipFile> getZipFiles() {
        return this._zipFiles;
    }

    @Override
    public void downloadFile(String string, String string2) throws IOException {
        File[] fileArray;
        URL uRL = new URL(this.getFileUrl());
        URLConnection uRLConnection = uRL.openConnection();
        long l = uRLConnection.getLastModified();
        int n = 0;
        while (n < this._zipFiles.size()) {
            fileArray = this._zipFiles.get(n).getDownloadTargets();
            if (this.prepTargets(l, (Vector<IDownloadTarget>)fileArray, string2)) {
                this._zipFiles.remove(n--);
            } else {
                this.createPlaceholders((Vector<IDownloadTarget>)fileArray, string2);
            }
            ++n;
        }
        InputStream inputStream = uRLConnection.getInputStream();
        fileArray = this.extractSelectedZipEntries(inputStream, this._zipFiles, string);
        int n2 = 0;
        while (n2 < fileArray.length) {
            this.copyToTargets(fileArray[n2], this._zipFiles.get(n2).getDownloadTargets(), string2, l);
            ++n2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File[] extractSelectedZipEntries(InputStream inputStream, Vector<IZipFile> vector, String string) throws IOException {
        File[] fileArray = new File[vector.size()];
        File file = new File(string);
        String string2 = this.createOrRegEx(vector);
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            int n = 0;
            while (n < vector.size()) {
                FileOutputStream fileOutputStream;
                block25: {
                    Object var14_15;
                    fileOutputStream = null;
                    int n2 = -1;
                    try {
                        try {
                            ZipEntry zipEntry = zipInputStream.getNextEntry();
                            if (zipEntry == null) {
                                throw new IOException(new StringBuffer("No files matching the regular expression \"").append(string2).append("\" were found in the zip file.").toString());
                            }
                            String string3 = zipEntry.getName();
                            if (string3.matches(string2)) {
                                ++n;
                                n2 = 0;
                                while (n2 < vector.size() && !string3.equals(vector.get(n2).getInternalPath())) {
                                    ++n2;
                                }
                                String string4 = new File(string3).getName();
                                fileArray[n2] = File.createTempFile(string4, null, file);
                                fileOutputStream = new FileOutputStream(fileArray[n2]);
                                this.streamCopy(zipInputStream, fileOutputStream);
                            }
                        }
                        catch (IOException iOException) {
                            if (n2 == -1) throw iOException;
                            if (!fileArray[n2].exists()) throw iOException;
                            try {
                                fileOutputStream.close();
                            }
                            catch (IOException iOException2) {}
                            fileArray[n2].delete();
                            throw iOException;
                        }
                    }
                    catch (Throwable throwable) {
                        var14_15 = null;
                        if (zipInputStream != null) {
                            try {
                                zipInputStream.closeEntry();
                            }
                            catch (IOException iOException) {}
                        }
                        if (fileOutputStream == null) throw throwable;
                        try {
                            fileOutputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        var14_15 = null;
                        if (zipInputStream == null) break block25;
                    }
                    try {}
                    catch (IOException iOException) {}
                    zipInputStream.closeEntry();
                }
                if (fileOutputStream == null) continue;
                try {}
                catch (IOException iOException) {}
                fileOutputStream.close();
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            try {
                zipInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var16_19 = null;
        }
        try {}
        catch (IOException iOException) {
            return fileArray;
        }
        zipInputStream.close();
        return fileArray;
    }

    private String createOrRegEx(Vector<IZipFile> vector) {
        Iterator<IZipFile> iterator = vector.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().getInternalPath());
            if (iterator.hasNext()) {
                stringBuffer.append(")|(");
                continue;
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

