/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.CreatorNameQueryable;
import org.eclipse.aperi.repository.ExtendedCNQueryable;
import org.eclipse.aperi.repository.RepositoryAccessor;

public class CreatorNameListProxy {
    private GuiListReq requestData;
    private RepositoryAccessor accessor;
    private CreatorNameQueryable castAccessor;
    private ExtendedCNQueryable twiceCast;
    private static final String firstPart = "SELECT creator, name, ";
    private static final String lastPart = " ORDER BY creator, name";

    public CreatorNameListProxy(RepositoryAccessor repositoryAccessor, GuiListReq guiListReq) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.CreatorNameListProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"CreatorNameListProxy", (String)"pAccessor, pRequestData");
        }
        this.requestData = guiListReq;
        this.accessor = repositoryAccessor;
        this.castAccessor = (CreatorNameQueryable)((Object)this.accessor);
        this.twiceCast = this.castAccessor instanceof ExtendedCNQueryable ? (ExtendedCNQueryable)this.castAccessor : null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.CreatorNameListProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"CreatorNameListProxy");
        }
    }

    private NameList fetchOne(StringBuffer stringBuffer) throws GeneralException {
        ResultSet resultSet;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.CreatorNameListProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchOne", (String)"buf");
        }
        NameList nameList = null;
        this.accessor.stmtPhase = 2;
        try {
            resultSet = this.accessor.resultSet;
            if (resultSet.next()) {
                this.accessor.stmtPhase = 1;
                nameList = new NameList();
                this.accessor.colIndex = 1;
                stringBuffer.setLength(0);
                stringBuffer.append(this.accessor.getString(resultSet));
                stringBuffer.append('.');
                stringBuffer.append(this.accessor.getString(resultSet));
                nameList.nlName = stringBuffer.toString();
                nameList.nlID = this.accessor.getInt(resultSet);
                nameList.nlInfo = (short)this.requestData.listRequested;
                if (this.twiceCast != null) {
                    this.twiceCast.retrieveAdditionalColumns(nameList);
                }
                this.castAccessor.addQualifiers(this.requestData, nameList);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.CreatorNameListProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetchOne", (Throwable)sQLException);
            }
            this.accessor.stmtType = 0;
            this.accessor.sqlError(sQLException);
        }
        resultSet = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.CreatorNameListProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchOne", (Object)resultSet);
        }
        return resultSet;
    }

    public NameList select() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.CreatorNameListProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"select", (String)"");
        }
        StringBuffer stringBuffer = new StringBuffer(120);
        stringBuffer.append(firstPart);
        stringBuffer.append(this.castAccessor.getIDColumnName());
        if (this.twiceCast != null) {
            stringBuffer.append(", ");
            stringBuffer.append(this.twiceCast.additionalColumnNames());
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.accessor.tableName);
        this.castAccessor.appendWhereClause(this.requestData, stringBuffer);
        stringBuffer.append(lastPart);
        this.accessor.selectStmt = this.accessor.prepareStmt(stringBuffer.toString());
        NameList nameList = null;
        NameList nameList2 = null;
        try {
            NameList nameList3;
            this.accessor.stmtPhase = 3;
            this.accessor.resultSet = this.accessor.selectStmt.executeQuery();
            while ((nameList3 = this.fetchOne(stringBuffer)) != null) {
                if (nameList2 != null) {
                    nameList2.nlNext = nameList3;
                } else {
                    nameList = nameList3;
                }
                nameList2 = nameList3;
            }
            this.accessor.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.CreatorNameListProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"select", (Throwable)sQLException);
            }
            this.accessor.stmtType = 0;
            this.accessor.sqlError(sQLException);
        }
        NameList nameList4 = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.CreatorNameListProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"select", (Object)nameList4);
        }
        return nameList4;
    }
}

