/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Rename;
import org.eclipse.aperi.common.TimestampedNameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class Renamer
extends RepositoryAccessor {
    private String idColumnName;
    private String objectType;
    private StringBuffer buf;

    public Renamer(Connection connection, String string, String string2, String string3) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.Renamer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"Renamer", (String)"dbc, pTableName, pIDColumnName, pObjectType");
        }
        this.tableName = string;
        this.idColumnName = string2;
        this.objectType = string3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.Renamer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"Renamer");
        }
    }

    private String buildCombinedName(String string, String string2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.Renamer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"buildCombinedName", (String)"creator, name");
        }
        this.buf.setLength(0);
        this.buf.append(string);
        this.buf.append('.');
        this.buf.append(string2);
        String string3 = this.buf.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.Renamer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"buildCombinedName", (Object)string3);
        }
        return string3;
    }

    public TimestampedNameList rename(Rename rename, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.Renamer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"rename", (String)"obj, commit");
        }
        long l = 0L;
        try {
            l = SQLUtil.getTimestamp(this.dbc).getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.Renamer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"rename", (Throwable)exception);
            }
            return null;
        }
        this.buf = new StringBuffer(160);
        this.buf.append("UPDATE ");
        this.buf.append(this.tableName);
        this.buf.append(" SET name = ?, last_modified = ");
        this.buf.append(Long.toString(l));
        this.buf.append(", last_mod_user = '");
        this.buf.append(rename.rnModifyingUser);
        this.buf.append("' WHERE ");
        this.buf.append(this.idColumnName);
        this.buf.append(" = ");
        this.buf.append(Integer.toString(rename.rnID));
        this.updateStmt = this.prepareStmt(this.buf.toString());
        int n = 0;
        try {
            this.colIndex = 1;
            this.stmtPhase = 0;
            this.setString(this.updateStmt, rename.rnNewName);
            n = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.Renamer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"rename", (Throwable)sQLException);
            }
            if (!SQLUtil.isDuplicateKeyViolation(sQLException)) {
                this.sqlError(sQLException);
            }
            String string = this.buildCombinedName(rename.rnCreator, rename.rnNewName);
            Object[] objectArray = new Object[]{this.objectType, string};
            string = MessageLog.getMessage((String)"SRV0096E", (Object[])objectArray);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.Renamer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"rename");
            }
            throw new GeneralException(string);
        }
        this.closeUpdate();
        if (n == 0) {
            block29: {
                try {
                    this.dbc.rollback();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block29;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.Renamer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"rename", (Throwable)sQLException);
                }
            }
            String string = this.buildCombinedName(rename.rnCreator, rename.rnOldName);
            Object[] objectArray = new Object[]{this.objectType, string};
            string = MessageLog.getMessage((String)"SRV0095E", (Object[])objectArray);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.Renamer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"rename");
            }
            throw new GeneralException(string);
        }
        if (bl) {
            this.commit();
        }
        TimestampedNameList timestampedNameList = new TimestampedNameList();
        timestampedNameList.nlName = this.buildCombinedName(rename.rnCreator, rename.rnNewName);
        timestampedNameList.nlID = rename.rnID;
        timestampedNameList.tnlTimestamp = l;
        TimestampedNameList timestampedNameList2 = timestampedNameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.Renamer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"rename", (Object)timestampedNameList2);
        }
        return timestampedNameList2;
    }
}

