/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.Group2ResSqlUtil;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptFsHist;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.xmsg.MessageLog;

public class RptFilesystemSpc
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private StringBuffer buf = new StringBuffer(2000);
    private GuiReportReq grr;
    private static final String NETWORK = MessageLog.getMessageNoID((String)"STG5048L");
    private static final String FS_SELECT = "select f.computer_id, f.filesystem_id, f.mount_point, f.used_inodes, f.free_inodes, f.used_space, f.free_space, f.capacity, f.file_count, f.directory_count, f.logical_disk_id, s.removed_time";
    private static final String FS_VOLGRP_SELECT = "select v.name, l.capacity, l.overhead  from t_res_filesystem f,  t_res_logical_disk l, t_res_volgroup v where f.logical_disk_id = l.logical_disk_id  and l.volgroup_id = v.volgroup_id  and f.filesystem_id = ";
    private static final String FROM_FS = " from t_res_filesystem f";
    private static final String FROM_FS_AND_SHARE = " from t_res_filesystem f, t_res_share s";
    private static final String WHERE_FS_AND_SHARE = " where f.filesystem_id = s.resource_id and f.computer_id = s.computer_id";
    private static final String GROUP_LIST = " g.group_id, g.creator, g.name";
    private static final String SELECT_SUM = ", sum(f.used_inodes), sum(f.free_inodes), sum(f.used_space), sum(f.free_space), sum(f.capacity), sum(f.file_count), sum(f.directory_count)";
    private static final String FS_GROUP_FROM = " from t_res_filesystem f, t_group g, ";
    private static final String FS_GROUP_WHERE = " where f.filesystem_id = gr.resource_id and gr.group_id = g.group_id";
    private static final String COMPUTER_GROUP_FROM = " from t_res_filesystem f, t_group g, t_view_group2res gr ";
    private static final String COMPUTER_GROUP_WHERE = " where f.computer_id = gr.resource_id and gr.group_id = g.group_id";
    private static final String COMPUTER_LIST = " f.computer_id, ' ', '2'";
    private static final String DOMAIN_LIST = " d.domain_id, ' ', d.name";
    private static final String DOMAIN_FROM = " from t_res_filesystem f, t_stat_computer c, t_res_domain d where f.computer_id = c.computer_id and c.domain_id = d.domain_id";
    private static final String GROUP_BY_DOMAIN = " group by d.domain_id, d.name";
    private static final String NETWORK_LIST = " -3, '1', '2'";

    public RptFilesystemSpc(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptFilesystemSpc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"RptFilesystemSpc", (String)"dbc");
        }
        this.tableName = "t_res_filesystem";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptFilesystemSpc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"RptFilesystemSpc");
        }
    }

    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        RespFSspace respFSspace;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptFilesystemSpc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getReportData", (String)"grr");
        }
        this.grr = guiReportReq;
        if (guiReportReq.reportSubtype == 28) {
            guiReportReq.productCode = 1;
            RptFsHist rptFsHist = new RptFsHist(this.dbc);
            Serializable serializable = rptFsHist.getReportData(guiReportReq);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptFilesystemSpc");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)serializable);
            }
            return serializable;
        }
        RespFSspace respFSspace2 = new RespFSspace();
        RespFSspace respFSspace3 = new RespFSspace();
        int n = 0;
        boolean bl = true;
        ReportFilter reportFilter = null;
        if (guiReportReq.columnFilters != null) {
            reportFilter = new ReportFilter(guiReportReq, respFSspace3);
        }
        try {
            switch (guiReportReq.reportSubtype) {
                case 10: {
                    this.buf.append(FS_SELECT);
                    this.buf.append(FROM_FS_AND_SHARE);
                    if (guiReportReq.idSubtype == 11) {
                        this.buf.append(", t_view_group2res gr ");
                    }
                    this.buf.append(WHERE_FS_AND_SHARE);
                    if (guiReportReq.selectedResources == null && guiReportReq.idSubtype != 11) break;
                    this.buf.append(" and ");
                    TResFS.appendInClause(this.buf, "f.filesystem_id", "gr.group_id", guiReportReq, false);
                    if (guiReportReq.idSubtype != 11) break;
                    this.buf.append(" and f.filesystem_id = gr.resource_id");
                    break;
                }
                case 11: {
                    this.buf.append("select distinct");
                    this.buf.append(GROUP_LIST);
                    this.buf.append(SELECT_SUM);
                    this.buf.append(FS_GROUP_FROM);
                    this.buf.append(" t_view_group2res gr ");
                    this.buf.append(FS_GROUP_WHERE);
                    Group2ResSqlUtil.appendG2RWhere(this.buf, guiReportReq.selectedResources, guiReportReq.isResourceInList, true, guiReportReq.reportSubtype, "gr");
                    this.buf.append(" group by");
                    this.buf.append(GROUP_LIST);
                    break;
                }
                case 12: {
                    this.buf.append("select");
                    this.buf.append(COMPUTER_LIST);
                    this.buf.append(SELECT_SUM);
                    this.buf.append(FROM_FS);
                    if (guiReportReq.selectedResources != null) {
                        this.buf.append(" where");
                        SQLUtil.appendInClause(this.buf, "f.computer_id", guiReportReq.selectedResources, guiReportReq.isResourceInList, false);
                    }
                    this.buf.append(" group by f.computer_id");
                    break;
                }
                case 13: 
                case 82: {
                    this.buf.append("select distinct");
                    this.buf.append(GROUP_LIST);
                    this.buf.append(SELECT_SUM);
                    this.buf.append(COMPUTER_GROUP_FROM);
                    this.buf.append(COMPUTER_GROUP_WHERE);
                    if (guiReportReq.reportSubtype == 13) {
                        this.buf.append(" and g.group_type <> 99");
                    } else {
                        this.buf.append(" and g.group_type = 99");
                    }
                    Group2ResSqlUtil.appendG2RWhere(this.buf, guiReportReq.selectedResources, guiReportReq.isResourceInList, true, guiReportReq.reportSubtype, "gr");
                    this.buf.append(" group by");
                    this.buf.append(GROUP_LIST);
                    break;
                }
                case 14: {
                    this.buf.append("select");
                    this.buf.append(DOMAIN_LIST);
                    this.buf.append(SELECT_SUM);
                    this.buf.append(DOMAIN_FROM);
                    SQLUtil.appendInClause(this.buf, "d.domain_id", guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
                    this.buf.append(GROUP_BY_DOMAIN);
                    break;
                }
                case 15: {
                    this.buf.append("select");
                    this.buf.append(NETWORK_LIST);
                    this.buf.append(SELECT_SUM);
                    this.buf.append(FROM_FS);
                    break;
                }
                default: {
                    Object[] objectArray = new Object[]{new Integer(guiReportReq.reportType), new Integer(guiReportReq.reportSubtype)};
                    String string = MessageLog.getMessage((String)"GEN0125E", (Object[])objectArray);
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.report.RptFilesystemSpc");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"getReportData");
                    }
                    throw new GeneralException(string);
                }
            }
            this.selectStmt = this.prepareStmt(this.buf.toString());
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            respFSspace = respFSspace2;
            while (this.nextResult()) {
                this.colIndex = 1;
                if (respFSspace3 == null) {
                    respFSspace3 = new RespFSspace();
                }
                respFSspace3.id = this.getInt(this.resultSet);
                if (guiReportReq.reportSubtype == 10) {
                    respFSspace3.fs_id = this.getInt(this.resultSet);
                    respFSspace3.creator = " ";
                } else {
                    respFSspace3.creator = this.getString(this.resultSet);
                }
                respFSspace3.setName(this.getString(this.resultSet));
                respFSspace3.usedInodes = this.getLong(this.resultSet);
                respFSspace3.freeInodes = this.getLong(this.resultSet);
                respFSspace3.usedSpace = this.getLong(this.resultSet);
                respFSspace3.freeSpace = this.getLong(this.resultSet);
                respFSspace3.capacity = this.getLong(this.resultSet);
                respFSspace3.fileCount = this.getLong(this.resultSet);
                respFSspace3.directoryCount = this.getLong(this.resultSet);
                if (guiReportReq.reportSubtype == 10) {
                    respFSspace3.FSDetectable = Constants.isFSLVDetectable((long)this.getLong(this.resultSet), (long)this.getTimestamp(this.resultSet)) ? "true" : "false";
                    this.getVolGroup(respFSspace3);
                }
                if (reportFilter != null) {
                    RespFSspace respFSspace4 = (RespFSspace)respFSspace3.clone();
                    this.getComputerNames(respFSspace4);
                    bl = reportFilter.isSelected(respFSspace4);
                }
                if (!bl) continue;
                respFSspace.next = respFSspace3;
                respFSspace = respFSspace3;
                respFSspace3 = null;
                ++n;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptFilesystemSpc");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getReportData", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (guiReportReq.isBatchReport) {
            this.getComputerNames(respFSspace2.next);
        }
        respFSspace = RptFilesystemSpc.packItUp(respFSspace2.next, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptFilesystemSpc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)respFSspace);
        }
        return respFSspace;
    }

    private void getVolGroup(RespFSspace respFSspace) throws GeneralException {
        StringBuffer stringBuffer = new StringBuffer(FS_VOLGRP_SELECT.length() + 25);
        respFSspace.serialNumber = new String(MessageLog.getMessageNoID((String)"GEN0185T"));
        try {
            stringBuffer.append(FS_VOLGRP_SELECT);
            stringBuffer.append(respFSspace.fs_id);
            this.updateStmt = this.prepareStmt(stringBuffer.toString());
            this.stmtPhase = 3;
            ResultSet resultSet = this.updateStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.nextResult(resultSet)) {
                long l = 0L;
                long l2 = 0L;
                this.colIndex = 1;
                respFSspace.serialNumber = this.getString(resultSet);
                l = this.getLong(resultSet);
                l2 = this.getLong(resultSet);
                respFSspace.unknown = l + l2;
            }
            this.closeUpdate();
        }
        catch (SQLException sQLException) {
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
    }

    private void getComputerNames(RespFSspace respFSspace) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptFilesystemSpc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getComputerNames", (String)"node");
        }
        AgentManager agentManager = Server.getAgentManager();
        while (respFSspace != null) {
            switch (this.grr.reportSubtype) {
                case 10: {
                    respFSspace.creator = agentManager.getAgentName(respFSspace.id);
                    break;
                }
                case 12: {
                    respFSspace.setName(agentManager.getAgentName(respFSspace.id));
                }
                case 14: {
                    respFSspace.creator = " ";
                    break;
                }
                case 15: {
                    respFSspace.setName(NETWORK);
                    respFSspace.creator = " ";
                }
            }
            respFSspace = respFSspace.next;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptFilesystemSpc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getComputerNames");
        }
    }

    public static RespFSspace[] packItUp(RespFSspace respFSspace, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptFilesystemSpc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"packItUp", (String)"head, totalRows");
        }
        RespFSspace[] respFSspaceArray = new RespFSspace[n];
        n = 0;
        while (respFSspace != null) {
            RespFSspace respFSspace2 = respFSspace.next;
            respFSspace.next = null;
            respFSspaceArray[n] = respFSspace;
            ++n;
            respFSspace = respFSspace2;
        }
        RespFSspace[] respFSspaceArray2 = respFSspaceArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptFilesystemSpc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"packItUp", (Object)respFSspaceArray2);
        }
        return respFSspaceArray2;
    }
}

