/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import java.sql.Connection;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.SchRunNode;

public class ScheduleSubmitted {
    SchRunNode submittedRunHead;
    SchRunNode submittedRunTail;
    SchRunNode runPtr;

    public synchronized void addRunNodes(SchRunNode schRunNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmitted");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addRunNodes", (String)"newRunPtr");
        }
        if (this.submittedRunHead == null) {
            this.submittedRunHead = schRunNode;
        } else {
            this.submittedRunTail.submitNext = schRunNode;
            schRunNode.submitPrev = this.submittedRunTail;
        }
        while (schRunNode.submitNext != null) {
            schRunNode = schRunNode.submitNext;
        }
        this.submittedRunTail = schRunNode;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmitted");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addRunNodes");
        }
    }

    public synchronized SchRunNode getNext(Connection connection) {
        long l = 0L;
        try {
            l = SQLUtil.getTimestamp(connection).getTime() + SchCommon.millisAdvanced;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleSubmitted");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getNext", (Throwable)exception);
            }
            return null;
        }
        SchRunNode schRunNode = this.submittedRunHead;
        while (schRunNode != null && schRunNode.submitMillis > l) {
            schRunNode = schRunNode.submitNext;
        }
        if (schRunNode != null) {
            SchRunNode schRunNode2 = schRunNode.submitPrev;
            SchRunNode schRunNode3 = schRunNode.submitNext;
            if (schRunNode2 == null) {
                this.submittedRunHead = schRunNode3;
            } else {
                schRunNode2.submitNext = schRunNode3;
                schRunNode.submitPrev = null;
            }
            if (schRunNode3 == null) {
                this.submittedRunTail = schRunNode2;
            } else {
                schRunNode3.submitPrev = schRunNode2;
                schRunNode.submitNext = null;
            }
        }
        return schRunNode;
    }
}

