/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;

public class AgentLessManagedNode {
    public int computerID;
    public short osType;
    public String name;
    public String networkAddress;
    public boolean expired = false;

    public AgentLessManagedNode() {
    }

    public AgentLessManagedNode(int n, String string) {
        this(n, 0, string, string, null, null);
    }

    public AgentLessManagedNode(int n, short s, String string, String string2, String string3, String string4) {
        this.computerID = n;
        this.setAttributes(s, string, string2, string3, string4);
    }

    public void setAttributes(short s, String string, String string2, String string3, String string4) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.AgentLessManagedNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setAttributes", (String)"osType, trellisoftName, localHostName, networkName, domainName");
        }
        this.osType = s;
        if (Constants.isDiskArray((short)s)) {
            this.name = string2;
        } else {
            this.name = string;
            if (Constants.isVirtualServer((int)s) && !Util.isEmpty((String)string3)) {
                this.networkAddress = string3;
                if (!Util.isEmpty((String)string4)) {
                    this.networkAddress = String.valueOf(this.networkAddress) + "." + string4;
                }
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.AgentLessManagedNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setAttributes");
        }
    }

    public int hashCode() {
        return this.computerID;
    }

    public boolean equals(Object object) {
        AgentLessManagedNode agentLessManagedNode = (AgentLessManagedNode)object;
        return this.computerID == agentLessManagedNode.computerID;
    }

    public void updateExpiredFlag(boolean bl) {
        this.expired = bl;
    }
}

