/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.PrintWriter;
import org.eclipse.aperi.backend.ThreadDumper;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.StateChangeReq;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.ClientSocket;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServerSocketTransceiver;
import org.eclipse.aperi.server.ServiceManager;
import org.eclipse.aperi.xmsg.MessageLog;

class Router
implements Runnable {
    private static Thread[] routers = null;
    private static final int WAIT_TIME = 75000;
    private static PrintWriter logWriter;

    Router() {
    }

    protected static void startThreads(ThreadGroup threadGroup, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Router");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"startThreads", (String)"serverThreadGroup, threadCount");
        }
        logWriter = MessageLog.getThreadLog();
        routers = new Thread[n];
        int n2 = 0;
        while (n2 < n) {
            Router router = new Router();
            Router.routers[n2] = new Thread(threadGroup, router, "Router-" + n2);
            routers[n2].setDaemon(true);
            routers[n2].start();
            ++n2;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Router");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"startThreads");
        }
    }

    protected static void stopThreads() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Router");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"stopThreads", (String)"");
        }
        if (routers == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Router");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"stopThreads");
            }
            return;
        }
        Server.routerQueue.setActive(false);
        int n = 0;
        while (n < routers.length) {
            routers[n].interrupt();
            ++n;
        }
        n = 0;
        while (n < routers.length) {
            block16: {
                try {
                    routers[n].join(75000L);
                }
                catch (InterruptedException interruptedException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block16;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Router");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"stopThreads", (Throwable)interruptedException);
                }
            }
            ++n;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Router");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"stopThreads");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Router");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"");
        }
        MessageLog.setThreadLog((PrintWriter)logWriter);
        while (true) {
            ClientSocket clientSocket;
            if ((clientSocket = (ClientSocket)Server.routerQueue.get()) == null || clientSocket.socket == null) {
                Class<?> clazz;
                MessageLog.logMessage((String)"SRV0026I");
                if (!TraceLogger.enableTrace) return;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Router");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"run");
                return;
            }
            ServerSocketTransceiver serverSocketTransceiver = ServerSocketTransceiver.getServerSocketTransceiver(clientSocket.socket);
            clientSocket.returnClientSocket();
            clientSocket = null;
            Request request = serverSocketTransceiver.receiveRequest();
            if (request == null) {
                this.discard((Transceiver)serverSocketTransceiver);
                continue;
            }
            if (request.requestData instanceof StateChangeReq) {
                StateChangeReq stateChangeReq = (StateChangeReq)request.requestData;
                if (stateChangeReq.serviceProvider == "org.eclipse.aperi.server.svp.ServerSvp" && (stateChangeReq.newState == 3 || stateChangeReq.newState == 5)) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Server");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    Class<?> clazz2 = clazz;
                    // MONITORENTER : clazz
                    Response response = new Response(0, null);
                    serverSocketTransceiver.transmitResponse(request, response);
                    serverSocketTransceiver.close();
                    MessageLog.logMessage((String)"SRV0012I", (Object)Constants.shutdownType[stateChangeReq.newState]);
                    if (stateChangeReq.newState == 5) {
                        ThreadDumper.abort();
                    } else {
                        System.exit(0);
                    }
                    // MONITOREXIT : clazz2
                    MessageLog.logMessage((String)"SRV0203E");
                    continue;
                }
            }
            if (Server.terminate != 0) {
                this.discard((Transceiver)serverSocketTransceiver);
                continue;
            }
            if ((request.flags & 4) == 0 && Server.connectionCount > Server.maxConnections) {
                ServiceManager.routingError(request, (Transceiver)serverSocketTransceiver, "SRV0025E", (short)8);
                continue;
            }
            Server.serviceMgr.routeRequest(request, (Transceiver)serverSocketTransceiver);
        }
    }

    private void discard(Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Router");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"discard", (String)"transceiver");
        }
        transceiver.close();
        transceiver.returnTransceiver();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Router");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"discard");
        }
    }
}

