/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.aperi.agent.req.AgentRequestData;
import org.eclipse.aperi.agent.req.AgentStatusReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.identity.SingleInstance;
import org.eclipse.aperi.identity.SuperUser;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.logging.NativeLogManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.logging.TraceLoggerFactory;
import org.eclipse.aperi.repository.ConnectionPool;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TConfigSettings;
import org.eclipse.aperi.repository.table.TServer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.ConfigParser;
import org.eclipse.aperi.server.DeviceServerManager;
import org.eclipse.aperi.server.Listener;
import org.eclipse.aperi.server.Router;
import org.eclipse.aperi.server.ServerThreadGroup;
import org.eclipse.aperi.server.ServiceManager;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.xmsg.CurtailedWriter;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class Server {
    private static final String LOG_DIR = "log";
    public static boolean enableTrace = true;
    public static final ServiceManager serviceMgr = new ServiceManager();
    public static final AgentManager agentMgr = new AgentManager();
    public static DeviceServerManager devMgr;
    public static final String TEMP_DIR;
    public static final ServiceQueue routerQueue;
    public static Properties repositoryProperties;
    public static ConnectionPool connectionPool;
    public static ServerThreadGroup serverThreadGroup;
    private static PrintWriter logWriter;
    public static TServer serverIdentity;
    public static ServerSocket listenerSocket;
    public static Lock connectionCountLock;
    public static byte terminate;
    public static Thread thread;
    public static Date startTime;
    public static int connectionCount;
    public static Throwable fatalError;
    public static String name;
    public static String hostAlias;
    public static String repositoryDriver;
    public static String repositoryURL;
    public static HardwareID hardwareID;
    public static int connectionPoolSize;
    private static int listenerPort;
    public static int agentErrorLimit;
    public static int messagesPerLog;
    public static int logsKept;
    public static short maxConnections;
    public static short routerThreads;
    public static short serviceThreads;
    public static String adminGroup;
    public static int adminGID;
    public static boolean multipleMaintenance;
    public static String dupCompInfo;
    public static int instanceID;
    private static Thread listener;
    private static ConfigSettings settings;
    private static long uniqueTimestamp;
    private static String homeDirectory;
    private static final int CONNECTION_ATTEMPTS = 11;
    public static final String COMPUTER_LOCK_TYPE = "Computer";
    private static final int LOGFILE_ERROR = 8;
    private static final int CONFIGFILE_ERROR = 12;
    private static final int SERVICEMGR_ERROR = 16;
    private static final int LISTENER_ERROR = 20;
    private static final int AGENTMGR_ERROR = 24;
    private static final int REPOSITORY_ERROR = 28;
    public static final int REGISTRATION_ERROR = 32;
    private static final int CONFIG_ERROR = 36;
    private static final int LICENSEMGR_ERROR = 40;
    private static final int SERVER_DUP_ERROR = 44;
    private static final int AUTHORIZATION_ERROR = 48;
    private static final int NO_WORKING_DIRECTORY = 52;
    public static final int DB_CONNECTION_ERROR = 56;
    private static final String[] ERROR_MSGIDS;
    private static final String[] EMAIL_NOTIFICATION;
    public static GUID guidO;

    static {
        TEMP_DIR = "tmp" + File.separator;
        routerQueue = new ServiceQueue();
        connectionCountLock = new Lock();
        terminate = 0;
        thread = Thread.currentThread();
        startTime = new Date();
        connectionCount = 0;
        connectionPoolSize = 5;
        listenerPort = 3123;
        agentErrorLimit = 0;
        messagesPerLog = 1000000;
        logsKept = 5;
        maxConnections = (short)200;
        routerThreads = 1;
        serviceThreads = (short)2;
        adminGroup = null;
        adminGID = 4;
        multipleMaintenance = false;
        dupCompInfo = "";
        uniqueTimestamp = System.currentTimeMillis();
        String[] stringArray = new String[14];
        stringArray[13] = "SRV0177E";
        ERROR_MSGIDS = stringArray;
        String[] stringArray2 = new String[14];
        stringArray2[2] = "SRV0181M";
        stringArray2[3] = "SRV0181M";
        stringArray2[4] = "SRV0181M";
        stringArray2[5] = "SRV0181M";
        stringArray2[6] = "SRV0181M";
        stringArray2[7] = "SRV0181M";
        stringArray2[8] = "SRV0181M";
        stringArray2[9] = "SRV0181M";
        stringArray2[11] = "SRV0181M";
        stringArray2[12] = "SRV0181M";
        stringArray2[13] = "SRV0182M";
        EMAIL_NOTIFICATION = stringArray2;
        guidO = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Exception {
        Object object;
        String string;
        block35: {
            Object object2;
            Variables.whoAmI = 1;
            try {
                logWriter = Server.initMessageLog("org.eclipse.aperi.server.svp.ServerSvp", true);
            }
            catch (Exception exception) {
                MessageLog.logException((String)"SRV0001E", (Exception)exception, (Object)Server.getLogFileName("org.eclipse.aperi.server.svp.ServerSvp"));
                Server.shutdown(8);
            }
            homeDirectory = System.getProperty("user.dir");
            if (homeDirectory == null) {
                MessageLog.logMessage((String)"GEN0041E", (Object)"user.dir");
                System.exit(52);
            }
            System.setProperty("data.baseDir", homeDirectory);
            try {
                object2 = TConfigSettings.getSmtpSettings();
                if (object2 != null) {
                    settings = new ConfigSettings();
                    Server.settings.csSmtp = object2;
                }
            }
            catch (GeneralException generalException) {}
            object2 = String.valueOf(homeDirectory) + File.separator + "configuration" + File.separator + "ServerTraceLog.config";
            String string2 = LOG_DIR + File.separator + "ServerTrace.log";
            String string3 = LOG_DIR + File.separator + "AuditTrace.log";
            TraceLoggerFactory.initializeTraceLogger((String)object2, (String)string2, (String)string3);
            TSThread.setServiceID((String)"org.eclipse.aperi.server.svp.ServerSvp");
            TraceLoggerFactory.startLogger((String)"ITSRM.logger.trace.Server", (String)"org.eclipse.aperi.server.svp.ServerSvp");
            TraceLoggerFactory.startLogger((String)"ITSRM.logger.audit", (String)"org.eclipse.aperi.common.svp.AuditSvp");
            try {
                NativeLogManager.initServerTraceLogger();
            }
            catch (LocalizableException localizableException) {
                localizableException.print();
            }
            MessageLog.initNative();
            System.loadLibrary("DataServer");
            if (!SuperUser.check()) {
                Server.shutdown(48);
            }
            try {
                string = Server.getInstanceFile();
                if (string == null) break block35;
                try {
                    instanceID = Integer.parseInt(string.substring(8, string.length() - 4));
                }
                catch (NumberFormatException numberFormatException) {}
                int n = SingleInstance.check((String)string, (int)0);
                if (n != 0) {
                    object = "";
                    if (n > 0) {
                        object = MessageLog.getMessageNoID((String)"SRV0116E", (Object)String.valueOf(n));
                    }
                    MessageLog.logMessage((String)"SRV0115E", (Object)object);
                    Server.shutdown(44);
                }
            }
            catch (LocalizableException localizableException) {
                localizableException.print();
                Server.shutdown(44);
            }
        }
        Server.cleanupTempDir();
        new File(TEMP_DIR).mkdir();
        String string4 = stringArray.length > 0 ? stringArray[0] : "server.config";
        string = "configuration" + File.separator + "repository.config";
        MessageLog.logMessage((String)"SRV0011I", (Object)string4);
        SingleInstance.logPID();
        ConfigParser configParser = new ConfigParser("configuration" + File.separator + string4, string);
        if (!configParser.parse()) {
            Server.shutdown(12);
        }
        name = configParser.name;
        hostAlias = configParser.hostAlias;
        repositoryDriver = configParser.repositoryDriver;
        repositoryURL = configParser.repositoryURL;
        hardwareID = configParser.hardwareID;
        connectionPoolSize = configParser.connectionPoolSize;
        listenerPort = configParser.listenerPort;
        agentErrorLimit = configParser.agentErrorLimit;
        messagesPerLog = configParser.messagesPerLog;
        logsKept = configParser.logsKept;
        maxConnections = configParser.maxConnections;
        routerThreads = configParser.routerThreads;
        serviceThreads = configParser.serviceThreads;
        adminGroup = configParser.adminGroup;
        repositoryProperties = configParser.repositoryProperties;
        multipleMaintenance = configParser.multipleMaintenance;
        dupCompInfo = configParser.dupCompInfo;
        Variables.server = "localhost";
        Variables.port = listenerPort;
        string = null;
        SQLUtil.setRepositoryType(repositoryDriver);
        if (SQLUtil.isSybase()) {
            repositoryProperties.put("charset", "iso_1");
        }
        configParser = null;
        if (SQLUtil.isCloudscape()) {
            System.setProperty("db2j.system.home", String.valueOf(System.getProperty("user.dir", ".")) + File.separatorChar + "cloudscape");
            System.setProperty("db2j.storage.pageCacheSize", "160");
            System.setProperty("db2j.language.spsCacheSize", "50");
            System.setProperty("db2j.language.stalePlanCheckInterval", "5");
        }
        try {
            connectionPool = new ConnectionPool(repositoryDriver, repositoryURL, repositoryProperties, connectionPoolSize);
        }
        catch (SQLException sQLException) {
            SQLUtil.logSQLException("SRV0048E", sQLException, new Object[]{repositoryURL});
            Server.shutdown(28);
        }
        catch (Exception exception) {
            MessageLog.logException((String)"SRV0047E", (Exception)exception, (Object)repositoryDriver);
            Server.shutdown(28);
        }
        guidO = GUID.readGUID();
        if (!Server.isRepositoryAvailable()) {
            Server.shutdown(56);
        }
        Server.initDBHelper();
        try {
            object = guidO != null ? guidO.toNoDotString() : null;
            serverIdentity = new TServer(hostAlias, listenerPort, name, hardwareID, (String)object);
        }
        catch (GeneralException generalException) {
            Server.shutdown(32);
        }
        if (!serverIdentity.registerServer()) {
            Server.shutdown(32);
        }
        if (SQLUtil.isMSSQL()) {
            object = Server.getConnection();
            try {
                SQLUtil.handleMSSQL((Connection)object);
            }
            catch (Throwable throwable) {
                Object var8_16 = null;
                Server.returnConnection((Connection)object);
                throw throwable;
            }
            {
                Object var8_17 = null;
            }
            Server.returnConnection((Connection)object);
        }
        Server.initIDs();
        devMgr = DeviceServerManager.getDeviceServerManager();
        if (!agentMgr.init()) {
            Server.shutdown(24);
        }
        Server.broadcastLocation(false);
        serverThreadGroup = new ServerThreadGroup("Server");
        try {
            settings = Server.fetchSettings();
        }
        catch (GeneralException generalException) {
            MessageLog.getThreadLog().println(generalException.getMessage());
            Server.shutdown(36);
        }
        Alerter.startThreads(serverThreadGroup);
        if (!serviceMgr.initialize()) {
            Server.shutdown(16);
        }
        Router.startThreads(serverThreadGroup, routerThreads);
        listener = new Listener(serverThreadGroup);
        try {
            listener.join(0L);
        }
        catch (InterruptedException interruptedException) {}
        Server.shutdown(terminate > 0 ? 0 : 20);
    }

    private static void initDBHelper() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initDBHelper", (String)"");
        }
        String string = repositoryProperties.getProperty("schema");
        String string2 = repositoryProperties.getProperty("user");
        String string3 = repositoryProperties.getProperty("password");
        String string4 = repositoryProperties.getProperty("connectionpool");
        if (repositoryDriver == null || repositoryURL == null || string == null || string2 == null || string3 == null || string4 == null) {
            GeneralException generalException = new GeneralException(MessageLog.getMessage((String)"DBA0043E"));
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                Class<?> clazz2;
                String string5 = "\n\t trepositoryDrive = " + repositoryDriver + "\n\t repositoryURL = " + repositoryURL + "\n\t dbSchema = " + string + "\n\t user = " + string2 + "\n\t password = " + string3 != null ? "xxx" : null + "\n\t connPool = " + string4;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.server.Server");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"initDBHelper()", (String)string5);
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Server");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"initDBHelper", (Object)"");
            }
            throw generalException;
        }
        int n = new Integer(string4);
        DBConnPoolDataSource.initialize((String)repositoryDriver, (String)repositoryURL, (String)string, (String)string2, (String)string3, (int)n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isRepositoryAvailable() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isRepositoryAvailable", (String)"");
        }
        Connection connection = null;
        int n = 0;
        boolean bl = false;
        try {
            do {
                if (n <= 0) continue;
                try {
                    MessageLog.logMessage((String)"SRV0178I");
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Server");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"registerServer", (Throwable)interruptedException);
                }
            } while ((connection = Server.getConnection()) == null && ++n < 11);
            bl = connection != null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Server.returnConnection(connection);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        Server.returnConnection(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"registerServer", (boolean)bl);
        }
        return bl;
    }

    public static int broadcastLocation(boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"broadcastLocation", (String)"force");
        }
        if (!Server.serverIdentity.serverRelocated && !bl) {
            int n = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Server");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"broadcastLocation", (int)n);
            }
            return n;
        }
        MessageLog.logMessage((String)"SRV0062I");
        int n = 0;
        Response response = Response.getResponse((short)0, null);
        Request request = new Request();
        Server.setAgentRequest(request, "org.eclipse.aperi.agent.handler.status.StatusHandler");
        request.requestData = new AgentStatusReq(false);
        AgentManager.AgentAddress agentAddress = new AgentManager.AgentAddress();
        Iterator iterator = agentMgr.listAgents(agentAddress);
        while (iterator.hasNext()) {
            byte by;
            agentAddress = (AgentManager.AgentAddress)iterator.next();
            if (agentAddress.computerID < 1 || agentAddress.state == 2) continue;
            Response response2 = agentMgr.transmitToAgent(request, null, agentAddress.computerID, true);
            if (response2 == null || response2.status == 12) {
                ++n;
                by = 0;
            } else {
                if (response2.status == 16) {
                    ++n;
                    continue;
                }
                by = 1;
            }
            if (by == agentAddress.state) continue;
            agentMgr.setState(agentAddress.computerID, by);
        }
        MessageLog.logMessage((String)"SRV0063I");
        response.returnResponse();
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"broadcastLocation", (int)n2);
        }
        return n2;
    }

    protected static void setAgentRequest(Request request, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setAgentRequest", (String)"request, subType");
        }
        AgentRequestData agentRequestData = new AgentRequestData();
        request.typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
        request.subType = string;
        request.machineName = Server.serverIdentity.computer.tsName;
        request.requestData = agentRequestData;
        agentRequestData.setServerPort(Server.serverIdentity.serverPort);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setAgentRequest");
        }
    }

    protected static AgentRequestData setAgentRequestData(AgentRequestData agentRequestData, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setAgentRequestData", (String)"data, computerID");
        }
        agentRequestData.setServerPort(Server.serverIdentity.serverPort);
        agentRequestData.setServerToken(Server.serverIdentity.serverToken);
        agentRequestData.setComputerID(n);
        AgentRequestData agentRequestData2 = agentRequestData;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setAgentRequestData", (Object)agentRequestData2);
        }
        return agentRequestData2;
    }

    public static PrintWriter initMessageLog(String string) throws IOException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initMessageLog", (String)"requestTypeCode");
        }
        PrintWriter printWriter = Server.initMessageLog(string, false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initMessageLog", (Object)printWriter);
        }
        return printWriter;
    }

    private static PrintWriter initMessageLog(String string, boolean bl) throws IOException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initMessageLog", (String)"requestTypeCode, redirectErrOut");
        }
        String string2 = Server.getLogFileName(string);
        CurtailedWriter curtailedWriter = null;
        curtailedWriter = new CurtailedWriter(string2, 0, 0, bl);
        curtailedWriter.setParms(logsKept, messagesPerLog);
        if (bl) {
            MessageLog.logMessage((String)"GEN0198I", (Object)"Server");
        }
        MessageLog.setThreadLog((PrintWriter)curtailedWriter);
        CurtailedWriter curtailedWriter2 = curtailedWriter;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initMessageLog", (Object)curtailedWriter2);
        }
        return curtailedWriter2;
    }

    public static String getLogFileName(String string) {
        return LOG_DIR + File.separator + RequestTypeManager.getLogPrefix((String)string);
    }

    public static String getLogDir() {
        return LOG_DIR;
    }

    public static short getOSType() {
        return Server.serverIdentity.computer.hwID.osType;
    }

    public static ServerThreadGroup getServerTG() {
        return serverThreadGroup;
    }

    private static ConfigSettings fetchSettings() throws GeneralException {
        ConfigSettings configSettings;
        Connection connection;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchSettings", (String)"");
        }
        if ((connection = Server.getConnection()) == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Server");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fetchSettings");
            }
            throw new GeneralException();
        }
        try {
            TConfigSettings tConfigSettings = new TConfigSettings(connection);
            ConfigSettings configSettings2 = tConfigSettings.getConfigSettings();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Server");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fetchSettings", (Object)configSettings2);
            }
            configSettings = configSettings2;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            Server.returnConnection(connection);
            throw throwable;
        }
        Server.returnConnection(connection);
        return configSettings;
    }

    public static ConfigSettings getSettings() {
        return settings;
    }

    public static void updateSettings(ConfigSettings configSettings) {
        settings = configSettings;
    }

    private static void shutdown(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"shutdown", (String)"status");
        }
        if (terminate == 0) {
            terminate = 1;
        }
        if (n == 0) {
            MessageLog.logMessage((String)"SRV0012I", (Object)Constants.shutdownType[terminate]);
        } else {
            Object[] objectArray;
            MessageLog.logMessage((String)"SRV0014E", (Object)new Integer(n));
            int n2 = (n >> 2) - 1;
            if (n2 < ERROR_MSGIDS.length) {
                objectArray = null;
                if (ERROR_MSGIDS[n2] != null) {
                    objectArray = ERROR_MSGIDS[n2];
                    MessageLog.logMessage((String)objectArray);
                }
            }
            if (n2 < EMAIL_NOTIFICATION.length && EMAIL_NOTIFICATION[n2] != null) {
                objectArray = new Object[]{((CurtailedWriter)logWriter).getCurrentFileName(), homeDirectory, new Date()};
                Alerter.shutdownNotification("SRV0180M", EMAIL_NOTIFICATION[n2], objectArray);
            }
        }
        serviceMgr.terminate(terminate);
        Alerter.stopThreads(terminate);
        Router.stopThreads();
        if (connectionPool != null) {
            connectionPool.freePool();
        }
        Server.cleanupTempDir();
        if (fatalError != null) {
            Object[] objectArray = new Object[]{((CurtailedWriter)logWriter).getCurrentFileName(), homeDirectory, new Date()};
            Alerter.shutdownNotification("SRV0180M", "SRV0181M", objectArray);
            if (fatalError instanceof OutOfMemoryError) {
                MessageLog.logMessage((String)"SRV0179E");
            }
        }
        MessageLog.logMessage((String)"SRV0013I");
        if (logWriter != null) {
            logWriter.close();
        }
        TraceLoggerFactory.stopLogger((String)"org.eclipse.aperi.server.svp.ServerSvp");
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void bumpConnectionCount(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"bumpConnectionCount", (String)"i");
        }
        Lock lock = connectionCountLock;
        synchronized (lock) {
            connectionCount += n;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"bumpConnectionCount");
        }
    }

    public static Connection getConnection() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getConnection", (String)"");
        }
        Connection connection = connectionPool.getConnection(true);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getConnection", (Object)connection);
        }
        return connection;
    }

    public static Connection getConnection(boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getConnection", (String)"messageWanted");
        }
        Connection connection = connectionPool.getConnection(bl);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getConnection", (Object)connection);
        }
        return connection;
    }

    public static void returnConnection(Connection connection) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"returnConnection", (String)"dbConnection");
        }
        connectionPool.returnConnection(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"returnConnection");
        }
    }

    public static String getUdbSchema() {
        return Server.connectionPool.udbSqlid;
    }

    public static int getServerID() {
        return Server.serverIdentity.serverID;
    }

    public static int getServerComputerID() {
        return Server.serverIdentity.computer.computerID;
    }

    public static long getServerToken() {
        return Server.serverIdentity.serverToken;
    }

    public static String getServerName() {
        return Server.serverIdentity.serverName;
    }

    public static String getServerHostName() {
        return Server.serverIdentity.computer.hwID.hostName;
    }

    public static boolean isWindows() {
        return Constants.isWindows((short)Server.serverIdentity.computer.hwID.osType);
    }

    private static native void initIDs();

    public static AgentManager getAgentManager() {
        return agentMgr;
    }

    public static DeviceServerManager getDeviceServerManager() {
        return devMgr;
    }

    public static ServiceManager getServiceManager() {
        return serviceMgr;
    }

    public static String getHomeDirectory() {
        return homeDirectory;
    }

    public static PrintWriter getLogWriter() {
        return logWriter;
    }

    public static int getListenerPort() {
        return listenerPort;
    }

    public static void setResponseWarning(Response response, Exception exception) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setResponseWarning", (String)"response, e");
        }
        response.status = (short)4;
        if (exception instanceof StorageException) {
            response.setException((StorageException)exception);
        } else {
            response.errorMessage = exception.getMessage();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setResponseWarning");
        }
    }

    public static void setResponseWarning(Response response, String string, Object[] objectArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setResponseWarning", (String)"response, msgID, args");
        }
        response.status = (short)4;
        response.errorMessage = MessageLog.getMessage((String)string, (Object[])objectArray);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setResponseWarning");
        }
    }

    public static void setResponseWarning(Response response, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setResponseWarning", (String)"response, msgID");
        }
        Server.setResponseWarning(response, string, null);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setResponseWarning");
        }
    }

    public static void setResponseWarning(Response response, String string, Object object) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setResponseWarning", (String)"response, msgID, parm1");
        }
        Object[] objectArray = new Object[]{object};
        Server.setResponseWarning(response, string, objectArray);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setResponseWarning");
        }
    }

    public static void setResponseWarning(Response response, String string, Object object, Object object2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setResponseWarning", (String)"response, msgID, parm1, parm2");
        }
        Object[] objectArray = new Object[]{object, object2};
        Server.setResponseWarning(response, string, objectArray);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setResponseWarning");
        }
    }

    public static void setResponseError(Response response, Exception exception) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setResponseError", (String)"response, e");
        }
        response.status = (short)12;
        if (exception instanceof StorageException) {
            response.setException((StorageException)exception);
        } else {
            response.errorMessage = exception.getMessage();
        }
        response.responseData = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setResponseError");
        }
    }

    public static void setResponseError(Response response, String string, Object[] objectArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setResponseError", (String)"response, msgID, args");
        }
        response.status = (short)12;
        response.errorMessage = MessageLog.getMessage((String)string, (Object[])objectArray);
        response.responseData = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setResponseError");
        }
    }

    public static void setResponseError(Response response, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setResponseError", (String)"response, msgID");
        }
        Server.setResponseError(response, string, null);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setResponseError");
        }
    }

    public static void setResponseError(Response response, String string, Object object) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setResponseError", (String)"response, msgID, parm1");
        }
        Object[] objectArray = new Object[]{object};
        Server.setResponseError(response, string, objectArray);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setResponseError");
        }
    }

    public static void setResponseError(Response response, String string, Object object, Object object2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setResponseError", (String)"response, msgID, parm1, parm2");
        }
        Object[] objectArray = new Object[]{object, object2};
        Server.setResponseError(response, string, objectArray);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setResponseError");
        }
    }

    private static void cleanupTempDir() {
        File[] fileArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"cleanupTempDir", (String)"");
        }
        if ((fileArray = new File(TEMP_DIR).listFiles()) != null) {
            int n = 0;
            while (n < fileArray.length) {
                fileArray[n].delete();
                ++n;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cleanupTempDir");
        }
    }

    public static synchronized long getUniqueTimestamp() {
        long l;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getUniqueTimestamp", (String)"");
        }
        uniqueTimestamp = (l = System.currentTimeMillis()) == uniqueTimestamp ? ++uniqueTimestamp : l;
        long l2 = uniqueTimestamp;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getUniqueTimestamp", (long)l2);
        }
        return l2;
    }

    protected static String getInstanceFile() {
        File file;
        String[] stringArray;
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getInstanceFile", (String)"");
        }
        String string2 = string = (stringArray = (file = new File(System.getProperty("user.dir", "."))).list(new InstanceFileFilter())) != null && stringArray.length > 0 ? stringArray[0] : null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getInstanceFile", (Object)string);
        }
        return string;
    }

    public static String getDupCompInfo() {
        return dupCompInfo;
    }

    private static class Lock {
        private Lock() {
        }
    }

    private static class InstanceFileFilter
    implements FilenameFilter {
        private InstanceFileFilter() {
        }

        public boolean accept(File file, String string) {
            return string.startsWith("INSTANCE") && string.endsWith(".DAT");
        }
    }
}

