/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAgent;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.xmsg.MessageLog;

public class UninstallAgentDriver
extends TSThread {
    private int computerID;
    private byte productCode;

    public UninstallAgentDriver(int n, byte by) {
        this.computerID = n;
        this.productCode = by;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Connection connection;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.UninstallAgentDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"");
        }
        if ((connection = Server.getConnection()) == null) {
            Object[] objectArray = new Object[]{"UninstallAgentDriver.run"};
            MessageLog.logMessage((String)"SRV0102E", (Object[])objectArray);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.UninstallAgentDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"run");
            }
            return;
        }
        try {
            UninstallAgentDriver.lockAndRemove(this.computerID, true, this.productCode, connection, true);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Server.returnConnection(connection);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        Server.returnConnection(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.UninstallAgentDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean lockAndRemove(int n, boolean bl, byte by, Connection connection, boolean bl2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.UninstallAgentDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"lockAndRemove", (String)"computerID, deleteTResComputer, productCode, connection, removeAgent");
        }
        boolean bl3 = false;
        try {
            LockManager.lock((short)2, (String)"Computer", (String)Integer.toString(n), (byte)1, (boolean)true);
            bl3 = UninstallAgentDriver.remove(n, bl, by, connection, bl2);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            LockManager.unLock((short)2, (String)"Computer", (String)Integer.toString(n));
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        LockManager.unLock((short)2, (String)"Computer", (String)Integer.toString(n));
        boolean bl4 = bl3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.UninstallAgentDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"lockAndRemove", (boolean)bl4);
        }
        return bl4;
    }

    public static boolean remove(int n, boolean bl, byte by, Connection connection, boolean bl2) {
        boolean bl3;
        block31: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.UninstallAgentDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"remove", (String)"computerID, deleteTResComputer, productCode, connection, removeAgent");
            }
            bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            if (by == 0 || by == 1) {
                bl4 = true;
            }
            if (by == -1) {
                bl5 = true;
            }
            if (Server.agentMgr.get(n) == null) {
                bl6 = true;
            }
            try {
                Object object;
                RepositoryAccessor repositoryAccessor;
                TStatComputer tStatComputer = new TStatComputer(connection);
                bl8 = tStatComputer.isVirtualServer(n);
                if (bl4 && !bl6 && !bl8) {
                    bl7 = true;
                }
                if (!bl3 || !bl3) break block31;
                if (bl4 || by == 4) {
                    repositoryAccessor = new TAlertLog(connection);
                    ((TAlertLog)repositoryAccessor).deleteByComputer(n);
                }
                if (by == 9) {
                    repositoryAccessor = new TAlertLog(connection);
                    ((TAlertLog)repositoryAccessor).deleteByDiskArray(n);
                }
                repositoryAccessor = new TResAttr(connection);
                if (bl4 || by == 4 || by == 9) {
                    ((TResAttr)repositoryAccessor).deleteByID(n);
                } else if (bl5) {
                    object = new int[ResourceAttribute.DOWNGRADE_TYPES.length];
                    System.arraycopy(ResourceAttribute.DOWNGRADE_TYPES, 0, object, 0, ResourceAttribute.DOWNGRADE_TYPES.length);
                    ((TResAttr)repositoryAccessor).deleteByTypes(n, (int[])object);
                }
                if (bl4 || by == 4 || by == 9) {
                    String string;
                    String string2;
                    object = new StorageRepositoryAccessor(connection);
                    if (by == 9) {
                        string2 = "t_res_storage_subsystem";
                        string = "subsystem_id";
                    } else {
                        string2 = "t_stat_computer";
                        string = "computer_id";
                    }
                    ((StorageRepositoryAccessor)object).deleteByIdColumn(string2, string, n);
                    if (bl && n != Server.getServerComputerID()) {
                        try {
                            boolean bl9 = UninstallAgentDriver.isDeviceAgentInstalled(n);
                            if (!bl9) {
                                TResComputer tResComputer = new TResComputer(connection);
                                tResComputer.deleteByID(n, false);
                            }
                        }
                        catch (SQLException sQLException) {
                            MessageLog.logException((String)"SRV0120E", (Exception)sQLException);
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.server.UninstallAgentDriver");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exception((String)clazz.getName(), (String)"remove", (Throwable)sQLException);
                            }
                            bl3 = false;
                        }
                    }
                }
                if (bl7) {
                    object = new TAgent();
                    TAgent.deleteAgent(n, connection);
                    Server.agentMgr.delete(n);
                }
                object = new TResCluster(connection);
                ((TResCluster)object).cleanupClusters();
                new ViewReportTablesUpdater().deleteDependentViews("host", String.valueOf(n));
                ScheduleQueue.routine.rebuild();
            }
            catch (GeneralException generalException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.UninstallAgentDriver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"remove", (Throwable)generalException);
                }
                MessageLog.logException((String)"SRV0120E", (Exception)((Object)generalException));
                bl3 = false;
            }
        }
        boolean bl10 = bl3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.UninstallAgentDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"remove", (boolean)bl10);
        }
        return bl10;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isDeviceAgentInstalled(int n) throws SQLException {
        boolean bl;
        DBConnection dBConnection;
        block23: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.UninstallAgentDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"isDeviceAgentInstalled", (String)"computerID");
            }
            dBConnection = null;
            DeviceAgent.DeviceAgentCursor deviceAgentCursor = null;
            bl = false;
            try {
                try {
                    DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
                    dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
                    deviceAgentCursor = DeviceAgent.getCursor((DBConnection)dBConnection, null, null);
                    if (deviceAgentCursor != null) {
                        while (deviceAgentCursor.next()) {
                            DeviceAgent deviceAgent = deviceAgentCursor.getObject();
                            if (n != deviceAgent.getHostId()) continue;
                            bl = true;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.UninstallAgentDriver");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"isDeviceAgentInstalled", (Object)sQLException);
                    }
                    throw sQLException;
                }
                catch (NullPointerException nullPointerException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.UninstallAgentDriver");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"isDeviceAgentInstalled", (Object)nullPointerException);
                    }
                    SQLException sQLException = new SQLException(nullPointerException.getMessage());
                    throw sQLException;
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (deviceAgentCursor != null) {
                    deviceAgentCursor.close();
                }
                if (dBConnection != null) {
                    dBConnection.close();
                }
                throw throwable;
            }
            {
                Object var6_11 = null;
                if (deviceAgentCursor == null) break block23;
            }
            deviceAgentCursor.close();
        }
        if (dBConnection != null) {
            dBConnection.close();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.UninstallAgentDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isDeviceAgentInstalled", (boolean)bl);
        }
        return bl;
    }
}

