/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListSaver;
import org.eclipse.aperi.repository.RaceConditionChecker;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.server.handler.gui.AlertDefChangeDetectThread;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertDefHndlr
implements RequestHandler,
ThrowAway {
    private AlertHeader alertHeader;
    private Response response;
    private Connection dbc;
    private short attributeType;
    private static final String RESOURCE_TYPE = "ALERT";
    private static final String OBJECT_TYPE_LABEL = MessageLog.getMessageNoID((String)"STS0109L");
    private static String USER;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response handle(Request request, Transceiver transceiver) {
        block29: {
            Class<?> clazz;
            if (TraceLogger.enableTrace) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, transceiver");
            }
            USER = request.userName;
            this.response = Response.getResponse((short)0, null);
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.common.AlertHeader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)this.response)) {
                Response response = this.response;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz3.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            this.alertHeader = (AlertHeader)request.requestData;
            this.dbc = Server.getConnection();
            if (this.dbc == null) {
                Server.setResponseError(this.response, "GEN0050E");
                Response response = this.response;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz4.getName(), (String)"handle", (Object)response);
                }
                return response;
            }
            boolean bl = this.alertHeader.alert == null && this.alertHeader.alertElements == null && this.alertHeader.alertGroups == null && this.alertHeader.alertGroups2 == null && this.alertHeader.alertElements2 == null && this.alertHeader.alertGroups3 == null && this.alertHeader.alertElements3 == null && this.alertHeader.alertClusters == null && !this.alertHeader.allObjects && !this.alertHeader.allElements1 && !this.alertHeader.allElements2 && this.alertHeader.paDevicesInAlertDef == null;
            String string = null;
            if (this.alertHeader.ID > 0) {
                string = Integer.toString(this.alertHeader.ID);
                byte by = bl ? (byte)2 : 1;
                LockManager.lock((short)0, (String)RESOURCE_TYPE, (String)string, (byte)by, (boolean)true);
            }
            try {
                try {
                    if (bl) {
                        this.retrieve();
                    } else {
                        this.save();
                    }
                    this.response.responseData = this.alertHeader;
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz5;
                        try {
                            clazz5 = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz5.getName(), (String)"handle", (Throwable)generalException);
                    }
                    if (this.response.status <= 4) {
                        this.response.status = (short)12;
                    }
                    this.response.errorMessage = generalException.getMessage();
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                if (string != null) {
                    LockManager.unLock((short)0, (String)RESOURCE_TYPE, (String)string);
                }
                Server.returnConnection(this.dbc);
                throw throwable;
            }
            {
                Object var6_12 = null;
                if (string == null) break block29;
            }
            LockManager.unLock((short)0, (String)RESOURCE_TYPE, (String)string);
        }
        Server.returnConnection(this.dbc);
        Response response = this.response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
        }
        return response;
    }

    private void retrieve() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"retrieve", (String)"");
        }
        TAlertDefinition tAlertDefinition = new TAlertDefinition(this.dbc);
        tAlertDefinition.getByID(this.alertHeader);
        AlertDefinition alertDefinition = this.alertHeader.alert;
        this.setAttributeType(alertDefinition);
        short s = 0;
        TResAttr tResAttr = new TResAttr(this.dbc);
        if (alertDefinition.aldType == 7) {
            s = 2;
            TResFS tResFS = new TResFS(this.dbc);
            this.alertHeader.alertElements = tResFS.queryDependents(this.alertHeader.ID);
            this.alertHeader.alertElements2 = this.getDependentComputers();
            this.alertHeader.alertGroups2 = tResAttr.queryDependents("t_group", "group_id", this.alertHeader.ID, (short)0);
            this.alertHeader.alertClusters = tResAttr.queryDependents("t_group", "group_id", this.alertHeader.ID, (short)99);
        } else if (alertDefinition.aldType == 6) {
            s = 0;
            this.alertHeader.alertElements = this.getDependentComputers();
            this.alertHeader.alertClusters = tResAttr.queryDependents("t_group", "group_id", this.alertHeader.ID, (short)99);
        } else if (alertDefinition.aldType == 20) {
            s = 77;
            TResDiskArray tResDiskArray = new TResDiskArray(this.dbc);
            this.alertHeader.alertElements = tResDiskArray.queryDependents(this.alertHeader.ID);
        } else if (alertDefinition.aldType == 30) {
            this.alertHeader.alertElements = FabricDbAccess.getFabricsForAlert((int)this.alertHeader.ID);
            this.alertHeader.alertElements2 = FabricDbAccess.getZonesForAlert((int)this.alertHeader.ID);
            this.alertHeader.alertElements3 = FabricDbAccess.getZoneSetsForAlert((int)this.alertHeader.ID);
            this.alertHeader.allObjects = FabricDbAccess.verifyAllResourcesSelected((int)this.alertHeader.ID, (short)114);
            this.alertHeader.allElements1 = FabricDbAccess.verifyAllResourcesSelected((int)this.alertHeader.ID, (short)127);
            this.alertHeader.allElements2 = FabricDbAccess.verifyAllResourcesSelected((int)this.alertHeader.ID, (short)126);
        } else if (alertDefinition.aldType == 31) {
            this.alertHeader.alertElements = FabricDbAccess.getSwitchesForAlert((int)this.alertHeader.ID);
            this.alertHeader.alertGroups = FabricDbAccess.getFabricsForAlert((int)this.alertHeader.ID);
            this.alertHeader.allObjects = FabricDbAccess.verifyAllResourcesSelected((int)this.alertHeader.ID, (short)121);
        } else if (alertDefinition.aldType == 32) {
            this.alertHeader.alertElements = this.getEndpoints(this.alertHeader.ID);
            this.alertHeader.alertGroups = FabricDbAccess.getFabricsForAlert((int)this.alertHeader.ID);
            this.alertHeader.allObjects = FabricDbAccess.verifyAllResourcesSelected((int)this.alertHeader.ID, (short)129);
        }
        if (alertDefinition.aldType != 30 && alertDefinition.aldType != 31 && alertDefinition.aldType != 32) {
            this.alertHeader.alertGroups = tResAttr.queryDependents("t_group", "group_id", this.alertHeader.ID, s);
            this.alertHeader.allObjects = NameListSaver.allObjectsSelected(tResAttr, this.alertHeader.ID, this.attributeType);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"retrieve");
        }
    }

    private NameList getEndpoints(int n) {
        NameList nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getEndpoints", (String)"alert");
        }
        NameList nameList2 = null;
        NameList nameList3 = null;
        NameList nameList4 = null;
        NameList nameList5 = null;
        NameList nameList6 = null;
        NameList nameList7 = null;
        NameList nameList8 = null;
        NameList nameList9 = null;
        nameList4 = FabricDbAccess.getPeripheralEntitiesForAlert((int)n);
        if (nameList4 != null) {
            nameList = nameList4;
            nameList5 = nameList4;
            while (nameList.nlNext != null) {
                nameList = nameList.nlNext;
                if (nameList == null) continue;
                nameList5 = nameList;
            }
        }
        if (nameList4 != null) {
            nameList2 = nameList4;
            nameList3 = nameList5;
        }
        if ((nameList6 = FabricDbAccess.getPortsForAlert((int)n)) != null) {
            nameList = nameList6;
            nameList7 = nameList6;
            while (nameList.nlNext != null) {
                nameList = nameList.nlNext;
                if (nameList == null) continue;
                nameList7 = nameList;
            }
        }
        if ((nameList8 = FabricDbAccess.getNodesForAlert((int)n)) != null) {
            nameList = nameList8;
            nameList9 = nameList8;
            while (nameList.nlNext != null) {
                nameList = nameList.nlNext;
                if (nameList == null) continue;
                nameList9 = nameList;
            }
        }
        if (nameList6 != null) {
            if (nameList3 != null) {
                nameList3.nlNext = nameList6;
            } else {
                nameList2 = nameList6;
            }
            nameList3 = nameList7;
        }
        if (nameList8 != null) {
            if (nameList3 != null) {
                nameList3.nlNext = nameList8;
            } else {
                nameList2 = nameList8;
            }
            nameList3 = nameList9;
        }
        return nameList2;
    }

    private void setAttributeType(AlertDefinition alertDefinition) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setAttributeType", (String)"alert");
        }
        switch (alertDefinition.aldType) {
            case 7: {
                if (alertDefinition.aldCondition == 12) {
                    this.attributeType = (short)29;
                    break;
                }
                this.attributeType = (short)27;
                break;
            }
            case 6: {
                this.attributeType = (short)26;
                break;
            }
            case 20: {
                if (alertDefinition.aldCondition == 65) {
                    this.attributeType = (short)82;
                    break;
                }
                this.attributeType = (short)81;
                break;
            }
            case 31: {
                this.attributeType = (short)121;
                break;
            }
            case 30: {
                this.attributeType = (short)114;
                break;
            }
            case 32: {
                this.attributeType = (short)129;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setAttributeType");
        }
    }

    private NameList getDependentComputers() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDependentComputers", (String)"");
        }
        TResComputer tResComputer = new TResComputer(this.dbc);
        NameList nameList = tResComputer.queryDependents(this.alertHeader.ID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getDependentComputers", (Object)nameList);
        }
        return nameList;
    }

    private void save() throws GeneralException {
        Object object;
        NameList[] nameListArray;
        NameList[] nameListArray2;
        RepositoryAccessor repositoryAccessor;
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"save", (String)"");
        }
        if (TraceLogger.enableAudit) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz.getName(), (String)"save", (String)USER);
        }
        String string = null;
        AlertHeader alertHeader = new AlertHeader();
        NameListSaver nameListSaver = new NameListSaver(this.dbc, this.response);
        this.setAttributeType(this.alertHeader.alert);
        if (this.alertHeader.ID <= 0) {
            this.alertHeader.ID = StorageRepositoryAccessor.getIdentifier(1, 1, this.dbc);
            bl = false;
        } else {
            repositoryAccessor = new RaceConditionChecker(this.dbc, "t_alert_definition", "alert_id", (CreateHeader)this.alertHeader, OBJECT_TYPE_LABEL);
            ((RaceConditionChecker)repositoryAccessor).check();
            string = ((RaceConditionChecker)repositoryAccessor).message;
            bl = !((RaceConditionChecker)repositoryAccessor).wasDeleted;
            repositoryAccessor = null;
            if (bl) {
                nameListArray2 = new TResAttr(this.dbc);
                nameListArray2.prepQueryByAttr();
                nameListArray = new ResourceAttribute();
                nameListArray.raAttributeID = this.alertHeader.ID;
                nameListArray.raAttributeType = this.attributeType;
                object = this.alertHeader.alert;
                if (object.aldType == 7) {
                    this.getFSAlertRes((TResAttr)nameListArray2, (ResourceAttribute)nameListArray, (AlertDefinition)object, alertHeader);
                } else if (object.aldType == 6) {
                    this.getCompAlertRes((TResAttr)nameListArray2, (ResourceAttribute)nameListArray, (AlertDefinition)object, alertHeader);
                } else if (object.aldType == 20) {
                    this.getArrayAlertRes((TResAttr)nameListArray2, (ResourceAttribute)nameListArray, (AlertDefinition)object, alertHeader);
                } else if (object.aldType == 31) {
                    nameListSaver.deleteObject(this.alertHeader.ID, this.attributeType, (short)121, -1);
                    this.getSwitchAlertRes((TResAttr)nameListArray2, (ResourceAttribute)nameListArray, (AlertDefinition)object, alertHeader);
                } else if (object.aldType == 30) {
                    nameListSaver.deleteObject(this.alertHeader.ID, this.attributeType, (short)114, -1);
                    nameListSaver.deleteObject(this.alertHeader.ID, this.attributeType, (short)127, -1);
                    nameListSaver.deleteObject(this.alertHeader.ID, this.attributeType, (short)126, -1);
                    this.getFabricAlertRes((TResAttr)nameListArray2, (ResourceAttribute)nameListArray, (AlertDefinition)object, alertHeader);
                } else if (object.aldType == 32) {
                    nameListSaver.deleteObject(this.alertHeader.ID, this.attributeType, (short)129, -1);
                    this.getEndpointAlertRes((TResAttr)nameListArray2, (ResourceAttribute)nameListArray, (AlertDefinition)object, alertHeader);
                }
                alertHeader.allObjects = NameListSaver.allObjectsSelected((TResAttr)nameListArray2, this.alertHeader.ID, this.attributeType);
                nameListArray2.closeSelect();
            }
        }
        repositoryAccessor = new TAlertDefinition(this.dbc);
        if (bl) {
            ((TAlertDefinition)repositoryAccessor).deleteByID(this.alertHeader.ID);
        }
        ((TAlertDefinition)repositoryAccessor).insert((CreateHeader)this.alertHeader, this.alertHeader.alert);
        if (this.alertHeader.alert.aldType == 30) {
            if (this.alertHeader.allObjects) {
                nameListSaver.saveAllObjectsSelected(this.alertHeader.allObjects, this.alertHeader.ID, this.attributeType, (short)114, true);
            }
            if (this.alertHeader.allElements1) {
                nameListSaver.saveAllObjectsSelected(this.alertHeader.allElements1, this.alertHeader.ID, this.attributeType, (short)127, true);
            }
            if (this.alertHeader.allElements2) {
                nameListSaver.saveAllObjectsSelected(this.alertHeader.allElements2, this.alertHeader.ID, this.attributeType, (short)126, true);
            }
        } else if (this.alertHeader.alert.aldType == 31) {
            if (this.alertHeader.allObjects) {
                nameListSaver.saveAllObjectsSelected(this.alertHeader.allObjects, this.alertHeader.ID, this.attributeType, (short)121, true);
            }
        } else if (this.alertHeader.alert.aldType == 32) {
            if (this.alertHeader.allObjects) {
                nameListSaver.saveAllObjectsSelected(this.alertHeader.allObjects, this.alertHeader.ID, this.attributeType, (short)129, true);
            }
        } else {
            nameListSaver.saveAllObjectsSelected(this.alertHeader.allObjects, this.alertHeader.ID, this.attributeType);
        }
        nameListArray2 = new NameList[6];
        if (this.alertHeader.alert.aldType != 30) {
            nameListArray2[0] = this.alertHeader.alertElements;
            nameListArray2[1] = this.alertHeader.alertElements2;
            nameListArray2[2] = this.alertHeader.alertElements3;
            nameListArray2[3] = this.alertHeader.alertGroups;
            nameListArray2[4] = this.alertHeader.alertGroups2;
            nameListArray2[5] = this.alertHeader.alertClusters;
        } else {
            nameListArray2[0] = this.alertHeader.alertElements;
            this.removeFabricInfo(this.alertHeader.alertElements2);
            nameListArray2[1] = this.alertHeader.alertElements2;
            this.removeFabricInfo(this.alertHeader.alertElements3);
            nameListArray2[2] = this.alertHeader.alertElements3;
            nameListArray2[3] = this.alertHeader.alertGroups;
            nameListArray2[4] = this.alertHeader.alertGroups2;
            nameListArray2[5] = this.alertHeader.alertClusters;
        }
        nameListArray = new NameList[]{alertHeader.alertElements, alertHeader.alertElements2, alertHeader.alertElements3, alertHeader.alertGroups, alertHeader.alertGroups2, alertHeader.alertClusters};
        nameListSaver.save((CreateHeader)this.alertHeader, OBJECT_TYPE_LABEL, this.attributeType, this.alertHeader.ID, nameListArray2, nameListArray, this.createTablesMap(), bl);
        object = new AlertDefChangeDetectThread();
        Thread thread = new Thread((Runnable)object, this.getClass().getName());
        thread.start();
        if (string != null) {
            this.response.status = (short)4;
            this.response.errorMessage = string;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"save");
        }
    }

    private NameList removeFabricInfo(NameList nameList) {
        NameList nameList2 = nameList;
        NameList nameList3 = new NameList();
        NameList nameList4 = new NameList();
        boolean bl = true;
        while (nameList2 != null) {
            NameList nameList5 = new NameList();
            nameList5.nlID = nameList2.nlID;
            nameList5.nlInfo = nameList2.nlInfo;
            nameList5.nlName = nameList2.nlName.substring(0, nameList2.nlName.lastIndexOf(40));
            if (bl) {
                nameList3 = nameList5;
            } else {
                nameList4.nlNext = nameList5;
            }
            nameList4 = nameList5;
            nameList2 = nameList2.nlNext;
            bl = false;
        }
        return nameList3;
    }

    private void getFSAlertRes(TResAttr tResAttr, ResourceAttribute resourceAttribute, AlertDefinition alertDefinition, AlertHeader alertHeader) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getFSAlertRes", (String)"accessor, resAttr, alert, currentDefinition");
        }
        resourceAttribute.raResourceType = (short)3;
        alertHeader.alertElements = tResAttr.getResAttr(resourceAttribute);
        resourceAttribute.raResourceType = (short)2;
        alertHeader.alertGroups = tResAttr.getResAttr(resourceAttribute);
        resourceAttribute.raResourceType = 1;
        alertHeader.alertElements2 = tResAttr.getResAttr(resourceAttribute);
        resourceAttribute.raResourceType = 0;
        alertHeader.alertGroups2 = tResAttr.getResAttr(resourceAttribute);
        resourceAttribute.raResourceType = (short)99;
        alertHeader.alertClusters = tResAttr.getResAttr(resourceAttribute);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getFSAlertRes");
        }
    }

    private void getCompAlertRes(TResAttr tResAttr, ResourceAttribute resourceAttribute, AlertDefinition alertDefinition, AlertHeader alertHeader) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getCompAlertRes", (String)"accessor, resAttr, alert, currentDefinition");
        }
        resourceAttribute.raResourceType = 1;
        alertHeader.alertElements = tResAttr.getResAttr(resourceAttribute);
        resourceAttribute.raResourceType = 0;
        alertHeader.alertGroups = tResAttr.getResAttr(resourceAttribute);
        resourceAttribute.raResourceType = (short)99;
        alertHeader.alertClusters = tResAttr.getResAttr(resourceAttribute);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getCompAlertRes");
        }
    }

    private void getArrayAlertRes(TResAttr tResAttr, ResourceAttribute resourceAttribute, AlertDefinition alertDefinition, AlertHeader alertHeader) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getArrayAlertRes", (String)"accessor, resAttr, alert, currentDefinition");
        }
        resourceAttribute.raResourceType = (short)78;
        alertHeader.alertElements = tResAttr.getResAttr(resourceAttribute);
        resourceAttribute.raResourceType = (short)77;
        alertHeader.alertGroups = tResAttr.getResAttr(resourceAttribute);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getArrayAlertRes");
        }
    }

    private void getSwitchAlertRes(TResAttr tResAttr, ResourceAttribute resourceAttribute, AlertDefinition alertDefinition, AlertHeader alertHeader) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getCompAlertRes", (String)"accessor, resAttr, alert, currentDefinition");
        }
        resourceAttribute.raResourceType = (short)121;
        alertHeader.alertElements = tResAttr.getResAttr(resourceAttribute);
        resourceAttribute.raResourceType = (short)114;
        alertHeader.alertGroups = tResAttr.getResAttr(resourceAttribute);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getSwitchAlertRes");
        }
    }

    private void getFabricAlertRes(TResAttr tResAttr, ResourceAttribute resourceAttribute, AlertDefinition alertDefinition, AlertHeader alertHeader) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getFabricAlertRes", (String)"accessor, resAttr, alert, currentDefinition");
        }
        resourceAttribute.raResourceType = (short)114;
        alertHeader.alertElements = tResAttr.getResAttr(resourceAttribute);
        resourceAttribute.raResourceType = (short)127;
        alertHeader.alertElements2 = tResAttr.getResAttr(resourceAttribute);
        resourceAttribute.raResourceType = (short)126;
        alertHeader.alertElements3 = tResAttr.getResAttr(resourceAttribute);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getFabricAlertRes");
        }
    }

    private void getEndpointAlertRes(TResAttr tResAttr, ResourceAttribute resourceAttribute, AlertDefinition alertDefinition, AlertHeader alertHeader) throws GeneralException {
        NameList nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getEndpointAlertRes", (String)"accessor, resAttr, alert, currentDefinition");
        }
        resourceAttribute.raResourceType = (short)139;
        alertHeader.alertElements = tResAttr.getResAttr(resourceAttribute);
        if (alertHeader.alertElements != null) {
            resourceAttribute.raResourceType = (short)137;
            nameList = this.getTail(alertHeader.alertElements);
            nameList.nlNext = tResAttr.getResAttr(resourceAttribute);
        } else {
            alertHeader.alertElements = tResAttr.getResAttr(resourceAttribute);
        }
        resourceAttribute.raResourceType = (short)138;
        if (alertHeader.alertElements != null) {
            nameList = this.getTail(alertHeader.alertElements);
            nameList.nlNext = tResAttr.getResAttr(resourceAttribute);
        } else {
            alertHeader.alertElements = tResAttr.getResAttr(resourceAttribute);
        }
        resourceAttribute.raResourceType = (short)114;
        alertHeader.alertGroups = tResAttr.getResAttr(resourceAttribute);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getEndpointAlertRes");
        }
    }

    private NameList getTail(NameList nameList) {
        NameList nameList2 = null;
        NameList nameList3 = nameList;
        while (nameList3.nlNext != null) {
            nameList3 = nameList2 = nameList3.nlNext;
        }
        if (nameList2 != null) {
            return nameList2;
        }
        return nameList;
    }

    private Map createTablesMap() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"createTablesMap", (String)"");
        }
        HashMap hashMap = new HashMap();
        AlertDefinition alertDefinition = this.alertHeader.alert;
        if (alertDefinition.aldType == 7) {
            this.addCompToMap(hashMap);
            this.addToMap(hashMap, (short)2, "t_group", "group_id");
            this.addToMap(hashMap, (short)3, "t_res_filesystem", "filesystem_id");
            this.addToMap(hashMap, (short)99, "t_group", "group_id");
        } else if (alertDefinition.aldType == 6) {
            this.addCompToMap(hashMap);
            this.addToMap(hashMap, (short)99, "t_group", "group_id");
        } else if (alertDefinition.aldType == 20) {
            this.addToMap(hashMap, (short)77, "t_group", "group_id");
            this.addToMap(hashMap, (short)78, "t_res_storage_subsystem", "subsystem_id");
        } else if (alertDefinition.aldType == 31) {
            this.addToMap(hashMap, (short)121, "t_res_switch", "SWITCH_ID");
            this.addToMap(hashMap, (short)114, "t_res_fabric", "FABRIC_ID");
        } else if (alertDefinition.aldType == 30) {
            this.addToMap(hashMap, (short)114, "t_res_fabric", "FABRIC_ID");
            this.addToMap(hashMap, (short)127, "t_res_zone", "ZONE_ID");
            this.addToMap(hashMap, (short)126, "t_res_zset", "ZSET_ID");
        } else if (alertDefinition.aldType == 32) {
            this.addToMap(hashMap, (short)139, "t_res_phy_pe", "PHY_PE_ID");
            this.addToMap(hashMap, (short)137, "t_res_port", "PORT_ID");
            this.addToMap(hashMap, (short)138, "t_res_node", "NODE_ID");
            this.addToMap(hashMap, (short)114, "t_res_fabric", "FABRIC_ID");
        }
        HashMap hashMap2 = hashMap;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"createTablesMap", hashMap2);
        }
        return hashMap2;
    }

    private void addCompToMap(Map map) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addCompToMap", (String)"map");
        }
        this.addToMap(map, (short)0, "t_group", "group_id");
        this.addToMap(map, (short)1, "t_stat_computer", "computer_id");
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addCompToMap");
        }
    }

    private void addToMap(Map map, short s, String string, String string2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addToMap", (String)"map, resourceType, tableName, idColumnName");
        }
        MutableInteger mutableInteger = new MutableInteger((int)s);
        String[] stringArray = new String[]{string, string2};
        map.put(mutableInteger, stringArray);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.AlertDefHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addToMap");
        }
    }
}

