/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.lang.reflect.UndeclaredThrowableException;
import org.apache.soap.SOAPException;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.SRMException;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;

public abstract class GuiDeviceRequestHndlr
extends DeviceRequestHndlr
implements ThreadSafe {
    private static final String SOAP_PROTOCOL = "SOAP-ENV:Protocol";
    private static final String SOAP_CLIENT = "SOAP-ENV:Client";

    private final String asString(Object object) {
        if (object == null) {
            return "Null ";
        }
        try {
            return object.toString();
        }
        catch (Exception exception) {
            return object.getClass().getName();
        }
    }

    protected final void logEnter(String string, Object object) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)this.getClass().getName(), (String)string, (String)this.asString(object));
        }
    }

    protected final void logEnter(String string, Object object, Object object2) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)this.getClass().getName(), (String)string, (String)(String.valueOf(this.asString(object)) + this.asString(object2)));
        }
    }

    protected final void logEnter(String string, Object object, Object object2, Object object3) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)this.getClass().getName(), (String)string, (String)(String.valueOf(this.asString(object)) + this.asString(object2) + this.asString(object3)));
        }
    }

    protected final void logExit(String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)this.getClass().getName(), (String)string);
        }
    }

    protected final void logExit(String string, Object object) {
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)this.getClass().getName(), (String)string, (Object)this.asString(object));
        }
    }

    protected final void logMessage(String string, Object object) {
        if (TraceLogger.enableTrace) {
            TraceLogger.traceMessage((int)1, (String)this.getClass().getName(), (String)string, (String)this.asString(object));
        }
    }

    protected final void logMessage(String string, Object object, Object object2) {
        if (TraceLogger.enableTrace) {
            TraceLogger.traceMessage((int)1, (String)this.getClass().getName(), (String)string, (String)(String.valueOf(this.asString(object)) + this.asString(object2)));
        }
    }

    protected final void logException(String string, Exception exception) {
        if (TraceLogger.enableTrace) {
            TraceLogger.exception((String)this.getClass().getName(), (String)string, (Throwable)exception);
        }
    }

    public int deviceAPI(DeviceRequest deviceRequest, Response response) {
        String string = "deviceAPI";
        this.logEnter(string, deviceRequest, response);
        try {
            this.processRequest(deviceRequest, response);
        }
        catch (Exception exception) {
            this.logException(string, exception);
            this.setResponseErrorFromException(response, exception);
        }
        this.logExit(string);
        return 0;
    }

    protected abstract void processRequest(DeviceRequest var1, Response var2) throws RemoteException;

    protected void setResponseErrorFromException(Response response, Throwable throwable) {
        SOAPException sOAPException;
        String string = null;
        Object[] objectArray = null;
        if (throwable instanceof UndeclaredThrowableException) {
            throwable = ((UndeclaredThrowableException)throwable).getUndeclaredThrowable();
        }
        if (throwable instanceof SRMException || throwable instanceof SRMRuntimeException) {
            SRMMessage sRMMessage = throwable instanceof SRMException ? ((SRMException)throwable).getSRMMessage() : ((SRMRuntimeException)throwable).getSRMMessage();
            string = sRMMessage.getMsgId();
            objectArray = sRMMessage.getMsgInserts();
        } else if (throwable instanceof SOAPException && ((sOAPException = (SOAPException)throwable).getFaultCode().equals(SOAP_CLIENT) || sOAPException.getFaultCode().equals(SOAP_PROTOCOL))) {
            string = "GUI8223E";
            objectArray = null;
        }
        if (string == null) {
            string = "GUI8224E";
            objectArray = new String[]{throwable.toString()};
        }
        Server.setResponseError(response, string, objectArray);
    }
}

