/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.TStorm.server.guireq.GuiInfoReq;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TGroup;
import org.eclipse.aperi.repository.table.TResChunk;
import org.eclipse.aperi.repository.table.TResChunkCollection;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDevAccess;
import org.eclipse.aperi.repository.table.TResDevice;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.repository.table.TResLogicalDisk;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.repository.table.TResVolGroup;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.repository.table.TStatDisk;
import org.eclipse.aperi.repository.table.TStatDiskHist;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.handler.agent.BatchReportHndlr;

public class GuiInfoHndlr
implements RequestHandler,
ThreadSafe {
    public Response handle(Request request, Transceiver transceiver) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, transceiver");
        }
        Response response = Response.getResponse((short)0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.TStorm.server.guireq.GuiInfoReq");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
            Response response2 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"handle", (Object)response2);
            }
            return response2;
        }
        GuiInfoReq guiInfoReq = (GuiInfoReq)request.requestData;
        Connection connection = Server.getConnection();
        if (connection == null) {
            Server.setResponseError(response, "GEN0050E");
            Response response3 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz4.getName(), (String)"handle", (Object)response3);
            }
            return response3;
        }
        switch (guiInfoReq.objectType) {
            case 1: {
                boolean bl = guiInfoReq.objectID == -2;
                boolean bl2 = !bl && guiInfoReq.computerID == -1;
                try {
                    TStatComputer tStatComputer = new TStatComputer(connection);
                    Computer computer = new Computer();
                    computer.cmpID = guiInfoReq.objectID;
                    if (tStatComputer.getGuiComputerStats(computer)) {
                        response.responseData = computer;
                        if (bl) {
                            response.responseData = (Serializable)BatchReportHndlr.packComps(computer);
                        }
                        if (bl || bl2) break;
                        computer.cmpDomain = new Domain();
                        computer.cmpDomain.domID = computer.cmpDomainID;
                        new TResDomain(connection).getName(computer.cmpDomain);
                        computer.cmpGroup = new TGroup(connection).selectByID(computer.cmpGroupID);
                        break;
                    }
                    if (bl2) break;
                    Server.setResponseError(response, "STS0092E", "Computer", new Integer(guiInfoReq.objectID));
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz5;
                        try {
                            clazz5 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz5.getName(), (String)"handle", (Throwable)generalException);
                    }
                    Server.setResponseError(response, (Exception)((Object)generalException));
                }
                break;
            }
            case 2: {
                try {
                    StorageRepositoryAccessor storageRepositoryAccessor;
                    StorageRepositoryAccessor storageRepositoryAccessor2;
                    TResDevice tResDevice = new TResDevice(connection);
                    boolean bl = tResDevice.isStorageSubsystemDisk(guiInfoReq.objectID);
                    boolean bl3 = tResDevice.isSVCMDisk(guiInfoReq.objectID);
                    DevAccess devAccess = null;
                    Disk disk = null;
                    if (!bl && !bl3) {
                        storageRepositoryAccessor2 = new TResDevAccess(connection);
                        ((TResDevAccess)storageRepositoryAccessor2).prepSelectByDevice();
                        devAccess = ((TResDevAccess)storageRepositoryAccessor2).getDevAccess(guiInfoReq.objectID);
                        storageRepositoryAccessor2.closeSelect();
                    } else {
                        devAccess = new DevAccess();
                    }
                    if (devAccess != null) {
                        devAccess.daNextDevice = null;
                        response.responseData = devAccess;
                        storageRepositoryAccessor2 = new TResDevice(connection);
                        ((TResDevice)storageRepositoryAccessor2).prepGetDevByID(bl3);
                        devAccess.daDevice = ((TResDevice)storageRepositoryAccessor2).getDevByID(guiInfoReq.objectID);
                        storageRepositoryAccessor2.closeSelect();
                        if (devAccess.daDevice == null) {
                            Server.setResponseError(response, "STS0092E", "Device", new Integer(guiInfoReq.objectID));
                        } else if (devAccess.daDevice instanceof Disk) {
                            if (!bl) {
                                storageRepositoryAccessor = new TStatDisk(connection);
                                ((TStatDisk)storageRepositoryAccessor).getLogicalDiskID((Disk)devAccess.daDevice);
                                storageRepositoryAccessor = null;
                            }
                            storageRepositoryAccessor = new TResChunk(connection);
                            ((TResChunk)storageRepositoryAccessor).prepSelectByDiskID();
                            disk = (Disk)devAccess.daDevice;
                            disk.dskChunk = ((TResChunk)storageRepositoryAccessor).getChunksByDiskID(guiInfoReq.objectID);
                            disk.dskPackedChunks = Chunk.packByCollection((Chunk)disk.dskChunk);
                            storageRepositoryAccessor.closeSelect();
                        }
                    } else {
                        Server.setResponseError(response, "STS0092E", "Dev Access", new Integer(guiInfoReq.objectID));
                    }
                    if (disk == null) break;
                    storageRepositoryAccessor2 = new Share();
                    storageRepositoryAccessor = new TStatDisk(connection);
                    storageRepositoryAccessor2 = ((TStatDisk)storageRepositoryAccessor).selectHostPaths(disk.devID, bl, bl3);
                    if (bl || bl3) {
                        devAccess.daPath = ((Share)storageRepositoryAccessor2).shPath;
                        devAccess.daDevice.devSerialNumber = TResDevice.getGeneratedSerialNumber((Disk)devAccess.daDevice, (Share)storageRepositoryAccessor2);
                    }
                    disk.dskHostPaths = (Share[])Packer.pack((Packable)storageRepositoryAccessor2);
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz6;
                        try {
                            clazz6 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz6.getName(), (String)"handle", (Throwable)generalException);
                    }
                    Server.setResponseError(response, (Exception)((Object)generalException));
                }
                break;
            }
            case 3: {
                try {
                    TStatDisk tStatDisk = new TStatDisk(connection);
                    Disk disk = new Disk();
                    disk.devID = guiInfoReq.objectID;
                    disk.devType = 0;
                    disk.devNext = null;
                    disk = (Disk)tStatDisk.getDiskByID((Device)disk);
                    if (disk != null) {
                        response.responseData = disk;
                        TStatDiskHist tStatDiskHist = new TStatDiskHist(connection);
                        tStatDiskHist.prepFetchMostRecentByDiskID();
                        disk.dskHistory = tStatDiskHist.fetchByDiskID(guiInfoReq.objectID);
                        tStatDiskHist.closeSelect();
                        if (disk.dskHistory != null) break;
                        Server.setResponseError(response, "STS0092E", "Latest Disk History", new Integer(guiInfoReq.objectID));
                        break;
                    }
                    Server.setResponseError(response, "STS0092E", "Disk", new Integer(guiInfoReq.objectID));
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz7;
                        try {
                            clazz7 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz7.getName(), (String)"handle", (Throwable)generalException);
                    }
                    Server.setResponseError(response, (Exception)((Object)generalException));
                }
                break;
            }
            case 4: {
                try {
                    TStatDiskHist tStatDiskHist = new TStatDiskHist(connection);
                    tStatDiskHist.prepFetchAllByDiskID();
                    DiskHistory diskHistory = tStatDiskHist.fetchByDiskID(guiInfoReq.objectID);
                    tStatDiskHist.closeSelect();
                    if (diskHistory != null) {
                        response.responseData = (DiskHistory[])Packer.pack((Packable)diskHistory);
                        break;
                    }
                    Server.setResponseError(response, "STS0092E", "Disk History", new Integer(guiInfoReq.objectID));
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz8;
                        try {
                            clazz8 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz8.getName(), (String)"handle", (Throwable)generalException);
                    }
                    Server.setResponseError(response, (Exception)((Object)generalException));
                }
                break;
            }
            case 5: {
                try {
                    LogicalDisk logicalDisk = new LogicalDisk();
                    logicalDisk.ldID = guiInfoReq.objectID;
                    if (this.getLogicalDisk(logicalDisk, connection, response, guiInfoReq.computerID)) {
                        Share share = new Share();
                        response.responseData = share;
                        share.shResource = logicalDisk;
                        share.shComputerID = guiInfoReq.computerID;
                        share.shResourceID = guiInfoReq.objectID;
                        TResFS tResFS = new TResFS(connection);
                        tResFS.prepSelectByLogicalDisk();
                        Filesystem filesystem = tResFS.getByLogicalDisk(guiInfoReq.objectID);
                        tResFS.closeSelect();
                        logicalDisk.ldFilesystem = filesystem != null && filesystem.fsComputerID == guiInfoReq.computerID ? filesystem : null;
                        TResShare tResShare = new TResShare(connection);
                        tResShare.prepGetUniqueShare();
                        tResShare.getUniqueShare(share);
                        logicalDisk.ldPath = share.shPath;
                        tResShare.closeSelect();
                        break;
                    }
                    Server.setResponseError(response, "STS0092E", "Logical Disk", new Integer(guiInfoReq.objectID));
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz9;
                        try {
                            clazz9 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz9.getName(), (String)"handle", (Throwable)generalException);
                    }
                    Server.setResponseError(response, (Exception)((Object)generalException));
                }
                break;
            }
            case 18: {
                this.getLunInfo(guiInfoReq.objectID, connection, response);
                break;
            }
            case 7: {
                try {
                    TResFS tResFS = new TResFS(connection);
                    tResFS.prepSelectByID();
                    Filesystem filesystem = tResFS.getByID(guiInfoReq.objectID);
                    tResFS.closeSelect();
                    if (filesystem != null) {
                        Share share = new Share();
                        share.shResource = filesystem;
                        share.shComputerID = filesystem.fsComputerID;
                        share.shResourceID = filesystem.fsID;
                        share.shScanTime = 0L;
                        share.shRemovedTime = 0L;
                        TResShare tResShare = new TResShare(connection);
                        tResShare.prepGetUniqueShare();
                        tResShare.getUniqueShare(share);
                        tResShare.closeSelect();
                        response.responseData = share;
                        break;
                    }
                    Server.setResponseError(response, "STS0092E", "Filesystem", new Integer(guiInfoReq.objectID));
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz10;
                        try {
                            clazz10 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz10.getName(), (String)"handle", (Throwable)generalException);
                    }
                    Server.setResponseError(response, (Exception)((Object)generalException));
                }
                break;
            }
            case 19: {
                try {
                    TResDiskArray tResDiskArray = new TResDiskArray(connection);
                    NasFiler nasFiler = tResDiskArray.getDiskArrays(guiInfoReq.objectID);
                    GuiInfoHndlr.selectGroupNames(connection, nasFiler);
                    response.responseData = (Serializable)Packer.pack((Packable)nasFiler);
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz11;
                        try {
                            clazz11 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz11.getName(), (String)"handle", (Throwable)generalException);
                    }
                    Server.setResponseError(response, (Exception)((Object)generalException));
                }
                break;
            }
            case 21: {
                try {
                    TResVolGroup tResVolGroup = new TResVolGroup(connection);
                    VolGroup volGroup = tResVolGroup.getVolGroupByID(guiInfoReq.objectID, guiInfoReq.computerID);
                    response.responseData = volGroup;
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz12;
                        try {
                            clazz12 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz12.getName(), (String)"handle", (Throwable)generalException);
                    }
                    Server.setResponseError(response, (Exception)((Object)generalException));
                }
                break;
            }
            case 20: {
                try {
                    LogicalDisk logicalDisk = new LogicalDisk();
                    logicalDisk.ldID = guiInfoReq.objectID;
                    if (this.getLogicalDisk(logicalDisk, connection, response, guiInfoReq.computerID)) {
                        response.responseData = logicalDisk;
                        break;
                    }
                    Server.setResponseError(response, "STS0092E", "Logical Unit", new Integer(guiInfoReq.objectID));
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz13;
                        try {
                            clazz13 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz13.getName(), (String)"handle", (Throwable)generalException);
                    }
                    Server.setResponseError(response, (Exception)((Object)generalException));
                }
                break;
            }
            case 22: {
                try {
                    TResCluster tResCluster = new TResCluster(connection);
                    Cluster cluster = tResCluster.getClusterByID(guiInfoReq.objectID);
                    response.responseData = cluster;
                    break;
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz14;
                        try {
                            clazz14 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz14.getName(), (String)"handle", (Throwable)generalException);
                    }
                    Server.setResponseError(response, (Exception)((Object)generalException));
                }
            }
        }
        Server.returnConnection(connection);
        Response response4 = response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz15;
            try {
                clazz15 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz15.getName(), (String)"handle", (Object)response4);
        }
        return response4;
    }

    private static void selectGroupNames(Connection connection, NasFiler nasFiler) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectGroupNames", (String)"dbc, filerList");
        }
        TGroup tGroup = new TGroup(connection);
        tGroup.prepSelectNameByID();
        while (nasFiler != null) {
            LdapTree ldapTree = new LdapTree();
            ldapTree.setLtName(tGroup.fetchNameByID(nasFiler.nfComputer.cmpGroupID));
            nasFiler.nfLdapTree = ldapTree;
            nasFiler = nasFiler.nfNext;
        }
        tGroup.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectGroupNames");
        }
    }

    private boolean getLogicalDisk(LogicalDisk logicalDisk, Connection connection, Response response, int n) throws GeneralException {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getLogicalDisk", (String)"ld, dbc, response");
        }
        TResLogicalDisk tResLogicalDisk = new TResLogicalDisk(connection);
        TResComputer tResComputer = new TResComputer(connection);
        int n2 = -1;
        boolean bl2 = false;
        n2 = n > 0 ? (int)tResComputer.getStorageSubsystemType(n) : (int)tResLogicalDisk.getSSTypeForLogicalDisk(logicalDisk.ldID);
        bl2 = n2 > -1;
        boolean bl3 = bl = n2 == 21;
        if (bl2) {
            tResLogicalDisk.prepSelectBySVID();
        } else {
            tResLogicalDisk.prepSelectByID();
        }
        boolean bl4 = tResLogicalDisk.getLogicalDisk(logicalDisk, bl2);
        if (bl4) {
            ChunkCollection chunkCollection;
            Object object;
            if (bl2) {
                object = tResLogicalDisk.selectHostPaths(logicalDisk);
                logicalDisk.ldHostPaths = (Share[])Packer.pack((Packable)object);
            }
            object = new TResChunkCollection(connection);
            if (logicalDisk.ldType != 12) {
                ((TResChunkCollection)object).prepSelectByLogicalDisk();
            } else {
                ((TResChunkCollection)object).prepSelectByFlexibleLogicalDisk();
            }
            logicalDisk.ldCollectionList = chunkCollection = ((TResChunkCollection)object).getCollections(logicalDisk);
            TResChunk tResChunk = new TResChunk(connection);
            tResChunk.prepSelectByCollection();
            TResDevAccess tResDevAccess = new TResDevAccess(connection);
            tResDevAccess.prepSelectByDevice();
            TResDevice tResDevice = new TResDevice(connection);
            tResDevice.prepGetDevByID(bl);
            TResShare tResShare = new TResShare(connection);
            tResShare.prepGetUniqueShare();
            HashMap hashMap = new HashMap();
            this.getChunkInfo(chunkCollection, tResDevice, tResDevAccess, tResChunk, hashMap);
            if (logicalDisk.ldMirrorCount > 0) {
                tResLogicalDisk.getMirrors(logicalDisk, bl2);
                byte by = 0;
                LogicalDisk logicalDisk2 = logicalDisk.ldNextMirror;
                Share share = new Share();
                share.shComputerID = n;
                while (logicalDisk2 != null) {
                    ++by;
                    logicalDisk2.ldCollectionList = chunkCollection = ((TResChunkCollection)object).getCollections(logicalDisk2);
                    this.getChunkInfo(chunkCollection, tResDevice, tResDevAccess, tResChunk, hashMap);
                    share.shResourceID = logicalDisk2.ldID;
                    share.shPath = null;
                    tResShare.getUniqueShare(share);
                    logicalDisk2.ldPath = share.shPath;
                    logicalDisk2 = logicalDisk2.ldNextMirror;
                }
                tResLogicalDisk.closeSelect();
                if (by != logicalDisk.ldMirrorCount) {
                    Server.setResponseWarning(response, "STS0091W", new Integer(logicalDisk.ldID));
                }
            }
            logicalDisk.pack();
            tResLogicalDisk.closeSelect();
            tResDevice.closeSelect();
            ((RepositoryAccessor)object).closeSelect();
            tResChunk.closeSelect();
            tResDevAccess.closeSelect();
            tResShare.closeSelect();
        }
        boolean bl5 = bl4;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getLogicalDisk", (boolean)bl5);
        }
        return bl5;
    }

    private void getChunkInfo(ChunkCollection chunkCollection, TResDevice tResDevice, TResDevAccess tResDevAccess, TResChunk tResChunk, Map map) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getChunkInfo", (String)"ccList, accessorDV, accessorDA, accessorCHK, diskMap");
        }
        MutableInteger mutableInteger = new MutableInteger();
        DevAccess devAccess = null;
        Disk disk = null;
        while (chunkCollection != null) {
            Chunk chunk;
            chunkCollection.ccChunkList = chunk = tResChunk.getChunksByCollection(chunkCollection);
            while (chunk != null) {
                mutableInteger.value = chunk.chkDiskID;
                disk = (Disk)map.get(mutableInteger);
                if (disk == null) {
                    disk = (Disk)tResDevice.getDevByID(mutableInteger.value);
                    if (disk == null) {
                        disk = new Disk();
                    }
                    map.put(mutableInteger, disk);
                    devAccess = tResDevAccess.getDevAccess(chunk.chkDiskID);
                    disk.devManufacturer = devAccess != null ? devAccess.daPath : disk.devName;
                }
                chunk.chkDisk = disk;
                chunk = chunk.chkNextInCollection;
            }
            chunkCollection = chunkCollection.ccNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getChunkInfo");
        }
    }

    private void getLunInfo(int n, Connection connection, Response response) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getLunInfo", (String)"logicalDiskID, dbc, response");
        }
        try {
            TResDiskArray tResDiskArray = new TResDiskArray(connection);
            Lun lun = tResDiskArray.getLunByID(n);
            if (lun == null) {
                Server.setResponseError(response, "STS0092E", "LUN", new Integer(n));
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getLunInfo");
                }
                return;
            }
            LogicalDisk logicalDisk = new LogicalDisk();
            logicalDisk.ldID = n;
            if (this.getLogicalDisk(logicalDisk, connection, response, -1)) {
                lun.lunLogicalDisk = logicalDisk;
                response.responseData = lun;
            } else {
                Server.setResponseError(response, "STS0092E", "Logical Disk", new Integer(n));
            }
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getLunInfo", (Throwable)generalException);
            }
            Server.setResponseError(response, (Exception)((Object)generalException));
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getLunInfo");
        }
    }
}

