/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.sql.Connection;
import java.util.Iterator;
import org.eclipse.aperi.backend.DaemonLogFileReader;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.fabric.api.SNMPAgent;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TComputer;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.guireq.AgentInfo;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.server.handler.gui.fabric.GUIDeviceAccessor;
import org.eclipse.aperi.server.req.GuiInfoReq;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiHndlr
implements RequestHandler,
ThreadSafe {
    private DaemonLogFileReader logReader = new DaemonLogFileReader(Server.getLogDir());

    public Response handle(Request request, Transceiver transceiver) {
        Object object;
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.server.GuiHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, transceiver");
        }
        Response response = Response.getResponse((short)0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.server.req.GuiInfoReq");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
            Response response2 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.server.handler.server.GuiHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"handle", (Object)response2);
            }
            return response2;
        }
        GuiInfoReq guiInfoReq = (GuiInfoReq)request.requestData;
        if (guiInfoReq.dataRequested == GuiInfoReq.COMPUTER) {
            GComputer gComputer;
            GComputer gComputer2;
            object = Server.getConnection();
            if (object == null) {
                Server.setResponseError(response, "GEN0050E");
                Response response3 = response;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("org.eclipse.aperi.server.handler.server.GuiHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz4.getName(), (String)"handle", (Object)response3);
                }
                return response3;
            }
            GComputer gComputer3 = gComputer2 = new GComputer();
            TResCluster tResCluster = new TResCluster((Connection)object);
            try {
                TComputer tComputer = TComputer.getComputer(null, null, guiInfoReq.dataFor, null, (Connection)object);
                tResCluster.prepGetClusterDetailsGC();
                while (tComputer != null) {
                    boolean bl;
                    gComputer = new GComputer();
                    gComputer.gcComputerID = tComputer.computerID;
                    gComputer.gcIpAddress = tComputer.ipAddress;
                    gComputer.gcNetworkName = tComputer.networkName;
                    gComputer.gcDomainName = tComputer.domainName;
                    gComputer.gcTimezoneID = tComputer.timezoneID;
                    gComputer.gcOsType = tComputer.hwID.osType;
                    gComputer.gcManufacturer = tComputer.hwID.manufacturer;
                    if (tComputer.hwID.manufacturer.toLowerCase().equals("unknown")) {
                        gComputer.gcManufacturer = MessageLog.getMessageNoID((String)"GEN0183T");
                    }
                    if (!(bl = Constants.isDiskArray((short)gComputer.gcOsType))) {
                        gComputer.gcHardwareID = tComputer.hwID.hardwareID;
                        gComputer.gcCPUArchitecture = tComputer.hwID.cpuArchitecture;
                        gComputer.gcTSName = tComputer.tsName;
                        gComputer.gcHostName = tComputer.hwID.hostName;
                    } else {
                        gComputer.gcTSName = tComputer.hwID.hostName;
                        gComputer.gcHostName = tComputer.tsName;
                    }
                    if (Constants.hasClusterSupport((short)gComputer.gcOsType)) {
                        tResCluster.getClusterDetailsGC(gComputer);
                    }
                    gComputer3.gcNext = gComputer;
                    gComputer3 = gComputer;
                    tComputer = tComputer.next;
                }
                tResCluster.closeSelect();
            }
            catch (Exception exception) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz5;
                    try {
                        clazz5 = Class.forName("org.eclipse.aperi.server.handler.server.GuiHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz5.getName(), (String)"handle", (Throwable)exception);
                }
                response.status = (short)12;
                response.errorMessage = exception.getMessage();
                gComputer2.gcNext = null;
            }
            Server.returnConnection((Connection)object);
            response.responseData = GComputer.packList((GComputer)gComputer2.gcNext);
            gComputer2 = null;
            gComputer3 = null;
            gComputer = null;
        } else if (guiInfoReq.dataRequested == 2) {
            NameList nameList;
            object = new NameList();
            Connection connection = object;
            Iterator iterator = Server.agentMgr.listAgents();
            while (iterator.hasNext()) {
                AgentManager.AgentAddress agentAddress = (AgentManager.AgentAddress)iterator.next();
                if (agentAddress.computerID <= 0) continue;
                nameList = new NameList();
                nameList.nlID = agentAddress.computerID;
                nameList.nlState = agentAddress.state;
                nameList.nlState = GuiHndlr.getAgentStateForGui(agentAddress);
                ((NameList)connection).nlNext = nameList;
                connection = nameList;
            }
            response.responseData = ((NameList)object).nlNext;
            object = null;
            connection = null;
            nameList = null;
        } else if (guiInfoReq.dataRequested == 8) {
            response.responseData = object = FabricDbAccess.getInbandAgents();
        } else if (guiInfoReq.dataRequested == 7) {
            NameList nameList;
            object = new NameList();
            Connection connection = object;
            SNMPAgent[] sNMPAgentArray = GUIDeviceAccessor.getSNMPAgents();
            if (sNMPAgentArray != null) {
                int n = 0;
                while (n < sNMPAgentArray.length) {
                    nameList = new NameList();
                    nameList.nlID = 0;
                    nameList.nlName = sNMPAgentArray[n].getDnsName();
                    nameList.nlName2 = sNMPAgentArray[n].getIpAddress();
                    int n2 = sNMPAgentArray[n].getEnabled();
                    nameList.nlState = n2 == 1 ? (byte)1 : 0;
                    ((NameList)connection).nlNext = nameList;
                    connection = nameList;
                    ++n;
                }
            }
            response.responseData = ((NameList)object).nlNext;
            object = null;
            connection = null;
            nameList = null;
        } else if (guiInfoReq.dataRequested == GuiInfoReq.AGENT_DETAIL) {
            object = null;
            Iterator iterator = Server.agentMgr.listAgents();
            while (iterator.hasNext()) {
                AgentManager.AgentAddress agentAddress = (AgentManager.AgentAddress)iterator.next();
                if (agentAddress.computerID != guiInfoReq.dataFor) continue;
                object = new AgentInfo();
                ((AgentInfo)object).computerID = agentAddress.computerID;
                ((AgentInfo)object).listenerPort = agentAddress.listenerPort;
                ((AgentInfo)object).connectionErrors = agentAddress.connectionErrors;
                ((AgentInfo)object).consecutiveErrors = agentAddress.consecutiveErrors;
                ((AgentInfo)object).state = agentAddress.state;
                ((AgentInfo)object).hostAddress = agentAddress.hostAddress;
                ((AgentInfo)object).timestamp = agentAddress.timestamp;
                ((AgentInfo)object).timezone = agentAddress.timezone;
                ((AgentInfo)object).upgradeRequired = agentAddress.upgradeRequired != 0;
                break;
            }
            response.responseData = object;
        } else if (guiInfoReq.dataRequested == GuiInfoReq.READ_LOG) {
            response.status = (short)12;
            request.requestData = guiInfoReq.rlRequest;
            this.logReader.handle(request, response);
            request.requestData = guiInfoReq;
        } else if (guiInfoReq.dataRequested == GuiInfoReq.SERVER_PRODUCT_VERSION) {
            object = "5.0.0";
            if (((String)object).equalsIgnoreCase(guiInfoReq.productVersion)) {
                response.status = 0;
            } else {
                response.status = (short)97;
                response.errorMessage = MessageLog.getMessage((String)"GEN2020E", (Object)guiInfoReq.productVersion, (Object)object);
                response.responseData = object;
            }
        }
        object = response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz6;
            try {
                clazz6 = Class.forName("org.eclipse.aperi.server.handler.server.GuiHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz6.getName(), (String)"handle", (Object)object);
        }
        return object;
    }

    protected static Byte getAgentStateForGui(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.GuiHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getAgentStateForGui", (String)"computerID");
        }
        Byte by = null;
        AgentManager.AgentAddress agentAddress = Server.agentMgr.get(n);
        if (agentAddress != null) {
            by = new Byte(GuiHndlr.getAgentStateForGui(agentAddress));
        }
        Byte by2 = by;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.GuiHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getAgentStateForGui", (Object)by2);
        }
        return by2;
    }

    protected static byte getAgentStateForGui(AgentManager.AgentAddress agentAddress) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.GuiHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getAgentStateForGui", (String)"agent");
        }
        int n = agentAddress.state;
        if (agentAddress.state == 1) {
            if (agentAddress.consecutiveErrors > 0) {
                n = 4;
            } else if (agentAddress.upgradeRequired > 0) {
                n = 5;
            }
        }
        byte by = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.GuiHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getAgentStateForGui", (byte)by);
        }
        return by;
    }
}

