/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import java.util.HashMap;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.server.jobs.Aggregation;
import org.eclipse.aperi.server.jobs.AggregationMap;

public class OSAggregationMap
extends AggregationMap {
    private HashMap fsToParent = new HashMap();
    private HashMap dirToDirGroup = new HashMap();
    private HashMap dirParents = new HashMap();

    OSAggregationMap(Connection connection) {
        super(connection);
    }

    protected void initMaps(Aggregation aggregation) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.OSAggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initMaps", (String)"aggregationFactory");
        }
        this.factory = aggregation;
        this.networkAggregation = this.factory.newAggregation(-3);
        int n = Integer.MIN_VALUE;
        Aggregation aggregation2 = null;
        int n2 = 0;
        TResFS tResFS = new TResFS(this.dbc);
        tResFS.prepSelectParentIDs("select distinct f.filesystem_id, gr.group_id from t_res_filesystem f, t_view_group2res gr where gr.res_type = 3 and f.filesystem_id = gr.resource_id union  select f.filesystem_id, f.computer_id from t_res_filesystem f union  select f.filesystem_id, c.domain_id from t_res_filesystem f, t_stat_computer c where f.computer_id = c.computer_id union select distinct f.filesystem_id, gr.group_id from t_res_filesystem f, t_view_group2res gr where f.computer_id = gr.resource_id order by 1");
        int[] nArray = new int[2];
        while (tResFS.selectParentIDs(nArray)) {
            Aggregation aggregation3 = this.getAggregation(this.parents, nArray[1]);
            int n3 = nArray[0];
            if (n == n3) {
                aggregation3.agNext = aggregation2;
                aggregation2 = aggregation3;
                ++n2;
                continue;
            }
            this.addAggregationToMap(this.fsToParent, aggregation2, n2, n);
            aggregation2 = aggregation3;
            n2 = 1;
            n = n3;
        }
        this.addAggregationToMap(this.fsToParent, aggregation2, n2, n);
        tResFS.closeSelect();
        tResFS = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.OSAggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initMaps");
        }
    }

    protected void aggregate(Aggregation aggregation) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.OSAggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"aggregate", (String)"additive");
        }
        this.hashKey.value = aggregation.agResourceID;
        Object v = this.fsToParent.get(this.hashKey);
        if (v == null) {
            this.aggregateArrayMap(aggregation, this.hashKey, this.dirToDirGroup);
        } else {
            this.addTo(this.networkAggregation, aggregation);
            this.aggregateArrayMap(aggregation, this.hashKey, this.fsToParent);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.OSAggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"aggregate");
        }
    }

    protected void replaceAggregationBuckets(Aggregation aggregation) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.OSAggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"replaceAggregationBuckets", (String)"a");
        }
        this.factory = aggregation;
        this.networkAggregation = aggregation.newAggregation(-3);
        this.parents.clear();
        this.dirParents.clear();
        this.replaceMapValues(this.fsToParent, this.parents);
        this.replaceMapValues(this.dirToDirGroup, this.dirParents);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.OSAggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"replaceAggregationBuckets");
        }
    }
}

